import { Monad, FantasyMonad } from './Monad';
export declare const URI = "Reader";
export declare type URI = typeof URI;
/**
 * @data
 * @constructor Reader
 */
export declare class Reader<E, A> implements FantasyMonad<URI, A> {
    readonly run: (e: E) => A;
    readonly _L: E;
    readonly _A: A;
    readonly _URI: URI;
    constructor(run: (e: E) => A);
    map<B>(f: (a: A) => B): Reader<E, B>;
    ap<B>(fab: Reader<E, (a: A) => B>): Reader<E, B>;
    chain<B>(f: (a: A) => Reader<E, B>): Reader<E, B>;
}
/** @function */
export declare const map: <E, A, B>(f: (a: A) => B, fa: Reader<E, A>) => Reader<E, B>;
/** @function */
export declare const of: <E, A>(a: A) => Reader<E, A>;
/** @function */
export declare const ap: <E, A, B>(fab: Reader<E, (a: A) => B>, fa: Reader<E, A>) => Reader<E, B>;
/** @function */
export declare const chain: <E, A, B>(f: (a: A) => Reader<E, B>, fa: Reader<E, A>) => Reader<E, B>;
/**
 * reads the current context
 * @function
 */
export declare const ask: <E>() => Reader<E, E>;
/**
 * Projects a value from the global context in a Reader
 * @function
 */
export declare const asks: <E, A>(f: (e: E) => A) => Reader<E, A>;
/**
 * changes the value of the local context during the execution of the action `fa`
 * @function
 */
export declare const local: <E>(f: (e: E) => E) => <A>(fa: Reader<E, A>) => Reader<E, A>;
/** @instance */
export declare const reader: Monad<URI>;
