"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Semiring_1 = require("./Semiring");
/** @function */
exports.getFunctionRing = function (ring) {
    return __assign({}, Semiring_1.getFunctionSemiring(ring), { sub: function (f) { return function (g) { return function (x) { return ring.sub(f(x))(g(x)); }; }; } });
};
/**
 * `negate x` can be used as a shorthand for `zero - x`
 * @function
 */
exports.negate = function (ring) { return function (a) {
    return ring.sub(ring.zero())(a);
}; };
//# sourceMappingURL=Ring.js.map