import { Ord } from './Ord';
/** @typeclass */
export interface Semigroup<A> {
    concat: (x: A) => (y: A) => A;
}
/** @function */
export declare const fold: <A>(S: Semigroup<A>) => (a: A) => (as: A[]) => A;
/** @function */
export declare const getFirstSemigroup: <A>() => Semigroup<A>;
/** @function */
export declare const getLastSemigroup: <A>() => Semigroup<A>;
/** @function */
export declare const getProductSemigroup: <A, B>(SA: Semigroup<A>, SB: Semigroup<B>) => Semigroup<[A, B]>;
/** @function */
export declare const getDualSemigroup: <A>(S: Semigroup<A>) => Semigroup<A>;
/** @function */
export declare const getRecordSemigroup: <O extends {
    [key: string]: any;
}>(semigroups: {
    [K in keyof O]: Semigroup<O[K]>;
}) => Semigroup<{
    [K in keyof O]: O[K];
}>;
/** @function */
export declare const getMeetSemigroup: <A>(O: Ord<A>) => Semigroup<A>;
/** @function */
export declare const getJoinSemigroup: <A>(O: Ord<A>) => Semigroup<A>;
