"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Ord_1 = require("./Ord");
/** @function */
exports.fold = function (S) { return function (a) { return function (as) {
    return as.reduce(function (acc, a) { return S.concat(acc)(a); }, a);
}; }; };
/** @function */
exports.getFirstSemigroup = function () {
    return { concat: function (x) { return function (y) { return x; }; } };
};
/** @function */
exports.getLastSemigroup = function () {
    return { concat: function (x) { return function (y) { return y; }; } };
};
/** @function */
exports.getProductSemigroup = function (SA, SB) {
    return {
        concat: function (_a) {
            var xa = _a[0], xb = _a[1];
            return function (_a) {
                var ya = _a[0], yb = _a[1];
                return [SA.concat(xa)(ya), SB.concat(xb)(yb)];
            };
        }
    };
};
/** @function */
exports.getDualSemigroup = function (S) {
    return {
        concat: function (x) { return function (y) { return S.concat(y)(x); }; }
    };
};
/** @function */
exports.getRecordSemigroup = function (semigroups) {
    return {
        concat: function (x) { return function (y) {
            var r = {};
            for (var k in semigroups) {
                r[k] = semigroups[k].concat(x[k])(y[k]);
            }
            return r;
        }; }
    };
};
/** @function */
exports.getMeetSemigroup = function (O) {
    return {
        concat: Ord_1.min(O)
    };
};
/** @function */
exports.getJoinSemigroup = function (O) {
    return {
        concat: Ord_1.max(O)
    };
};
//# sourceMappingURL=Semigroup.js.map