import { Monad, FantasyMonad } from './Monad';
declare module './HKT' {
    interface URI2HKT2<L, A> {
        State: State<L, A>;
    }
}
export declare const URI = "State";
export declare type URI = typeof URI;
/**
 * @data
 * @constructor State
 */
export declare class State<S, A> implements FantasyMonad<URI, A> {
    readonly run: (s: S) => [A, S];
    readonly _A: A;
    readonly _L: S;
    readonly _URI: URI;
    constructor(run: (s: S) => [A, S]);
    eval(s: S): A;
    exec(s: S): S;
    map<B>(f: (a: A) => B): State<S, B>;
    ap<B>(fab: State<S, (a: A) => B>): State<S, B>;
    chain<B>(f: (a: A) => State<S, B>): State<S, B>;
}
/** @function */
export declare const map: <S, A, B>(f: (a: A) => B, fa: State<S, A>) => State<S, B>;
/** @function */
export declare const of: <S, A>(a: A) => State<S, A>;
/** @function */
export declare const ap: <S, A, B>(fab: State<S, (a: A) => B>, fa: State<S, A>) => State<S, B>;
/** @function */
export declare const chain: <S, A, B>(f: (a: A) => State<S, B>, fa: State<S, A>) => State<S, B>;
/** @function */
export declare const get: <S>() => State<S, S>;
/** @function */
export declare const put: <S>(s: S) => State<S, undefined>;
/** @function */
export declare const modify: <S>(f: (s: S) => S) => State<S, undefined>;
/** @function */
export declare const gets: <S, A>(f: (s: S) => A) => State<S, A>;
/** @instance */
export declare const state: Monad<URI>;
