import { HKT, HKTS, HKT2S, HKTAs, HKT2As } from './HKT';
import { Functor } from './Functor';
import { Applicative } from './Applicative';
import { Chain } from './Chain';
import { Monad } from './Monad';
import { Endomorphism } from './function';
export interface StateT<M> {
    map<S, A, B>(f: (a: A) => B, fa: (s: S) => HKT<M, [A, S]>): (s: S) => HKT<M, [B, S]>;
    of<S, A>(a: A): (s: S) => HKT<M, [A, S]>;
    ap<S, A, B>(fab: (s: S) => HKT<M, [(a: A) => B, S]>, fa: (s: S) => HKT<M, [A, S]>): (s: S) => HKT<M, [B, S]>;
    chain<S, A, B>(f: (a: A) => (s: S) => HKT<M, [B, S]>, fa: (s: S) => HKT<M, [A, S]>): (s: S) => HKT<M, [B, S]>;
}
export interface StateT1<M extends HKTS> {
    map<S, A, B>(f: (a: A) => B, fa: (s: S) => HKTAs<M, [A, S]>): (s: S) => HKTAs<M, [B, S]>;
    of<S, A>(a: A): (s: S) => HKTAs<M, [A, S]>;
    ap<S, A, B>(fab: (s: S) => HKTAs<M, [(a: A) => B, S]>, fa: (s: S) => HKTAs<M, [A, S]>): (s: S) => HKTAs<M, [B, S]>;
    chain<S, A, B>(f: (a: A) => (s: S) => HKTAs<M, [B, S]>, fa: (s: S) => HKTAs<M, [A, S]>): (s: S) => HKTAs<M, [B, S]>;
}
export interface StateT2<M extends HKT2S> {
    map<L, S, A, B>(f: (a: A) => B, fa: (s: S) => HKT2As<M, L, [A, S]>): (s: S) => HKT2As<M, L, [B, S]>;
    of<L, S, A>(a: A): (s: S) => HKT2As<M, L, [A, S]>;
    ap<L, S, A, B>(fab: (s: S) => HKT2As<M, L, [(a: A) => B, S]>, fa: (s: S) => HKT2As<M, L, [A, S]>): (s: S) => HKT2As<M, L, [B, S]>;
    chain<L, S, A, B>(f: (a: A) => (s: S) => HKT2As<M, L, [B, S]>, fa: (s: S) => HKT2As<M, L, [A, S]>): (s: S) => HKT2As<M, L, [B, S]>;
}
export declare function map<F extends HKT2S>(F: Functor<F>): <L, S, A, B>(f: (a: A) => B, fa: (s: S) => HKT2As<F, L, [A, S]>) => (s: S) => HKT2As<F, L, [B, S]>;
export declare function map<F extends HKTS>(F: Functor<F>): <S, A, B>(f: (a: A) => B, fa: (s: S) => HKTAs<F, [A, S]>) => (s: S) => HKTAs<F, [B, S]>;
export declare function map<F>(F: Functor<F>): <S, A, B>(f: (a: A) => B, fa: (s: S) => HKT<F, [A, S]>) => (s: S) => HKT<F, [B, S]>;
export declare function of<F extends HKT2S>(F: Applicative<F>): <L, S, A>(a: A) => (s: S) => HKT2As<F, L, [A, S]>;
export declare function of<F extends HKTS>(F: Applicative<F>): <S, A>(a: A) => (s: S) => HKTAs<F, [A, S]>;
export declare function of<F>(F: Applicative<F>): <S, A>(a: A) => (s: S) => HKT<F, [A, S]>;
export declare function ap<F extends HKT2S>(F: Chain<F>): <L, S, A, B>(fab: (s: S) => HKT2As<F, L, [(a: A) => B, S]>, fa: (s: S) => HKT2As<F, L, [A, S]>) => (s: S) => HKT2As<F, L, [B, S]>;
export declare function ap<F extends HKTS>(F: Chain<F>): <S, A, B>(fab: (s: S) => HKTAs<F, [(a: A) => B, S]>, fa: (s: S) => HKTAs<F, [A, S]>) => (s: S) => HKTAs<F, [B, S]>;
export declare function ap<F>(F: Chain<F>): <S, A, B>(fab: (s: S) => HKT<F, [(a: A) => B, S]>, fa: (s: S) => HKT<F, [A, S]>) => (s: S) => HKT<F, [B, S]>;
export declare function chain<F extends HKT2S>(F: Chain<F>): <L, S, A, B>(f: (a: A) => (s: S) => HKT2As<F, L, [B, S]>, fa: (s: S) => HKT2As<F, L, [A, S]>) => (s: S) => HKT2As<F, L, [B, S]>;
export declare function chain<F extends HKTS>(F: Chain<F>): <S, A, B>(f: (a: A) => (s: S) => HKTAs<F, [B, S]>, fa: (s: S) => HKTAs<F, [A, S]>) => (s: S) => HKTAs<F, [B, S]>;
export declare function chain<F>(F: Chain<F>): <S, A, B>(f: (a: A) => (s: S) => HKT<F, [B, S]>, fa: (s: S) => HKT<F, [A, S]>) => (s: S) => HKT<F, [B, S]>;
export declare function get<F extends HKT2S>(F: Applicative<F>): <S>() => <L>(s: S) => HKT2As<F, L, [S, S]>;
export declare function get<F extends HKTS>(F: Applicative<F>): <S>() => (s: S) => HKTAs<F, [S, S]>;
export declare function get<F>(F: Applicative<F>): <S>() => (s: S) => HKT<F, [S, S]>;
export declare function put<F extends HKT2S>(F: Applicative<F>): <S>(s: S) => <L>() => HKT2As<F, L, [void, S]>;
export declare function put<F extends HKTS>(F: Applicative<F>): <S>(s: S) => () => HKTAs<F, [void, S]>;
export declare function put<F>(F: Applicative<F>): <S>(s: S) => () => HKT<F, [void, S]>;
export declare function modify<F extends HKT2S>(F: Applicative<F>): <S>(f: Endomorphism<S>) => <L>(s: S) => HKT2As<F, L, [void, S]>;
export declare function modify<F extends HKTS>(F: Applicative<F>): <S>(f: Endomorphism<S>) => (s: S) => HKTAs<F, [void, S]>;
export declare function modify<F>(F: Applicative<F>): <S>(f: Endomorphism<S>) => (s: S) => HKT<F, [void, S]>;
export declare function gets<F extends HKT2S>(F: Applicative<F>): <S, A>(f: (s: S) => A) => <L>(s: S) => HKT2As<F, L, [A, S]>;
export declare function gets<F extends HKTS>(F: Applicative<F>): <S, A>(f: (s: S) => A) => (s: S) => HKTAs<F, [A, S]>;
export declare function gets<F>(F: Applicative<F>): <S, A>(f: (s: S) => A) => (s: S) => HKT<F, [A, S]>;
export declare function getStateT<M extends HKT2S>(M: Monad<M>): StateT2<M>;
export declare function getStateT<M extends HKTS>(M: Monad<M>): StateT1<M>;
export declare function getStateT<M>(M: Monad<M>): StateT<M>;
