import { HKT, HKTS, HKT2S, HKTAs, HKT2As, HKT3S, HKT3As } from './HKT';
import { Comonad, FantasyComonad } from './Comonad';
import { Functor } from './Functor';
import { Endomorphism } from './function';
declare module './HKT' {
    interface URI2HKT2<L, A> {
        Store: Store<L, A>;
    }
}
export declare const URI = "Store";
export declare type URI = typeof URI;
/**
 * @data
 * @constructor Store
 */
export declare class Store<S, A> implements FantasyComonad<URI, A> {
    readonly peek: (s: S) => A;
    readonly pos: S;
    readonly _A: A;
    readonly _L: S;
    readonly _URI: URI;
    constructor(peek: (s: S) => A, pos: S);
    /** Reposition the focus at the specified position */
    seek(s: S): Store<S, A>;
    map<B>(f: (a: A) => B): Store<S, B>;
    extract(): A;
    extend<B>(f: (sa: Store<S, A>) => B): Store<S, B>;
    inspect(): string;
    toString(): string;
}
/** @function */
export declare const map: <S, A, B>(f: (a: A) => B, sa: Store<S, A>) => Store<S, B>;
/** @function */
export declare const extract: <S, A>(sa: Store<S, A>) => A;
/** @function */
export declare const extend: <S, A, B>(f: (sa: Store<S, A>) => B, sa: Store<S, A>) => Store<S, B>;
/**
 * Reads the value at the specified position in the specified context
 * @function
 */
export declare const peek: <S, A>(sa: Store<S, A>) => (s: S) => A;
/**
 * Extract a value from a position which depends on the current position
 * @function
 */
export declare const peeks: <S>(f: Endomorphism<S>) => <A>(sa: Store<S, A>) => (s: S) => A;
/**
 * Reposition the focus at the specified position
 * @function
 */
export declare const seek: <S>(s: S) => <A>(sa: Store<S, A>) => Store<S, A>;
/**
 * Reposition the focus at the specified position, which depends on the current position
 * @function
 */
export declare const seeks: <S>(f: Endomorphism<S>) => <A>(sa: Store<S, A>) => Store<S, A>;
/** Extract a collection of values from positions which depend on the current position */
export declare function experiment<F extends HKT3S>(F: Functor<F>): <U, L, S>(f: (s: S) => HKT3As<F, U, L, S>) => <A>(sa: Store<S, A>) => HKT3As<F, U, L, A>;
export declare function experiment<F extends HKT2S>(F: Functor<F>): <L, S>(f: (s: S) => HKT2As<F, L, S>) => <A>(sa: Store<S, A>) => HKT2As<F, L, A>;
export declare function experiment<F extends HKTS>(F: Functor<F>): <S>(f: (s: S) => HKTAs<F, S>) => <A>(sa: Store<S, A>) => HKTAs<F, A>;
export declare function experiment<F>(F: Functor<F>): <S>(f: (s: S) => HKT<F, S>) => <A>(sa: Store<S, A>) => HKT<F, A>;
/** @instance */
export declare const store: Comonad<URI>;
