import { HKT, HKTS, HKT2S, HKTAs, HKT2As } from './HKT';
import { Monoid } from './Monoid';
import { Functor, FantasyFunctor } from './Functor';
import { Applicative } from './Applicative';
import { Foldable, FantasyFoldable } from './Foldable';
import { Traversable, FantasyTraversable } from './Traversable';
import { Setoid } from './Setoid';
import { Option } from './Option';
import { Unfoldable } from './Unfoldable';
declare module './HKT' {
    interface URI2HKT<A> {
        StrMap: StrMap<A>;
    }
}
export declare const URI = "StrMap";
export declare type URI = typeof URI;
/**
 * @data
 * @constructor StrMap
 */
export declare class StrMap<A> implements FantasyFunctor<URI, A>, FantasyFoldable<A>, FantasyTraversable<URI, A> {
    readonly value: {
        [key: string]: A;
    };
    readonly _A: A;
    readonly _URI: URI;
    constructor(value: {
        [key: string]: A;
    });
    mapWithKey<B>(f: (k: string, a: A) => B): StrMap<B>;
    map<B>(f: (a: A) => B): StrMap<B>;
    reduce<B>(f: (b: B, a: A) => B, b: B): B;
    traverseWithKey<F extends HKT2S>(F: Applicative<F>): <L, B>(f: (k: string, a: A) => HKT2As<F, L, B>) => HKT2As<F, L, StrMap<B>>;
    traverseWithKey<F extends HKTS>(F: Applicative<F>): <B>(f: (k: string, a: A) => HKTAs<F, B>) => HKTAs<F, StrMap<B>>;
    traverseWithKey<F>(F: Applicative<F>): <B>(f: (k: string, a: A) => HKT<F, B>) => HKT<F, StrMap<B>>;
    traverse<F extends HKT2S>(F: Applicative<F>): <L, B>(f: (a: A) => HKT2As<F, L, B>) => HKT2As<F, L, StrMap<B>>;
    traverse<F extends HKTS>(F: Applicative<F>): <B>(f: (a: A) => HKTAs<F, B>) => HKTAs<F, StrMap<B>>;
    traverse<F>(F: Applicative<F>): <B>(f: (a: A) => HKT<F, B>) => HKT<F, StrMap<B>>;
}
/** @function */
export declare const empty: <A>() => StrMap<A>;
/** @function */
export declare const concat: <A>(x: StrMap<A>) => (y: StrMap<A>) => StrMap<A>;
/** @function */
export declare const map: <A, B>(f: (a: A) => B, fa: StrMap<A>) => StrMap<B>;
/** @function */
export declare const reduce: <A, B>(f: (b: B, a: A) => B, b: B, fa: StrMap<A>) => B;
export declare function traverseWithKey<F extends HKT2S>(F: Applicative<F>): <L, A, B>(f: (k: string, a: A) => HKT2As<F, L, B>, ta: StrMap<A>) => HKT2As<F, L, StrMap<B>>;
export declare function traverseWithKey<F extends HKTS>(F: Applicative<F>): <A, B>(f: (k: string, a: A) => HKTAs<F, B>, ta: StrMap<A>) => HKTAs<F, StrMap<B>>;
export declare function traverseWithKey<F>(F: Applicative<F>): <A, B>(f: (k: string, a: A) => HKT<F, B>, ta: StrMap<A>) => HKT<F, StrMap<B>>;
export declare function traverse<F extends HKT2S>(F: Applicative<F>): <L, A, B>(f: (a: A) => HKT2As<F, L, B>, ta: StrMap<A>) => HKT2As<F, L, StrMap<B>>;
export declare function traverse<F extends HKTS>(F: Applicative<F>): <A, B>(f: (a: A) => HKTAs<F, B>, ta: StrMap<A>) => HKTAs<F, StrMap<B>>;
export declare function traverse<F>(F: Applicative<F>): <A, B>(f: (a: A) => HKT<F, B>, ta: HKT<URI, A>) => HKT<F, StrMap<B>>;
/**
 * Test whether one dictionary contains all of the keys and values contained in another dictionary
 * @function
 */
export declare const isSubdictionary: <A>(setoid: Setoid<A>) => (d1: StrMap<A>) => (d2: StrMap<A>) => boolean;
/**
 * Calculate the number of key/value pairs in a dictionary
 * @function
 */
export declare const size: <A>(d: StrMap<A>) => number;
/**
 * Test whether a dictionary is empty
 * @function
 */
export declare const isEmpty: <A>(d: StrMap<A>) => boolean;
/** @function */
export declare const getSetoid: <A>(setoid: Setoid<A>) => Setoid<StrMap<A>>;
/**
 * Create a dictionary with one key/value pair
 * @function
 */
export declare const singleton: (k: string) => <A>(a: A) => StrMap<A>;
/**
 * Lookup the value for a key in a dictionary
 * @function
 */
export declare const lookup: (k: string) => <A>(d: StrMap<A>) => Option<A>;
/**
 * Create a dictionary from a foldable collection of key/value pairs, using the
 * specified function to combine values for duplicate keys.
 * @function
 */
export declare const fromFoldable: <F>(F: Foldable<F>) => <A>(f: (existing: A) => (a: A) => A) => (ta: HKT<F, [string, A]>) => StrMap<A>;
/** @function */
export declare const collect: <A, B>(f: (k: string, a: A) => B) => (d: StrMap<A>) => B[];
/** @function */
export declare const toArray: <A>(d: StrMap<A>) => [string, A][];
/**
 * Unfolds a dictionary into a list of key/value pairs
 * @function
 */
export declare const toUnfoldable: <F extends string>(unfoldable: Unfoldable<F>) => <A>(d: StrMap<A>) => HKT<F, [string, A]>;
/**
 * Apply a function of two arguments to each key/value pair, producing a new dictionary
 * @function
 */
export declare const mapWithKey: <A, B>(f: (k: string, a: A) => B, fa: StrMap<A>) => StrMap<B>;
/**
 * Insert or replace a key/value pair in a map
 * @function
 */
export declare const insert: (k: string) => <A>(a: A) => (d: StrMap<A>) => StrMap<A>;
/**
 * Delete a key and value from a map
 * @function
 */
export declare const remove: (k: string) => <A>(d: StrMap<A>) => StrMap<A>;
/**
 * Delete a key and value from a map, returning the value as well as the subsequent map
 * @function
 */
export declare const pop: (k: string) => <A>(d: StrMap<A>) => Option<[A, StrMap<A>]>;
/** @instance */
export declare const strmap: Monoid<StrMap<any>> & Functor<URI> & Foldable<URI> & Traversable<URI>;
