"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var function_1 = require("./function");
var Apply_1 = require("./Apply");
var Option_1 = require("./Option");
var Array_1 = require("./Array");
exports.URI = 'StrMap';
/**
 * @data
 * @constructor StrMap
 */
var StrMap = /** @class */ (function () {
    function StrMap(value) {
        this.value = value;
    }
    StrMap.prototype.mapWithKey = function (f) {
        var fb = {};
        for (var k in this.value) {
            fb[k] = f(k, this.value[k]);
        }
        return new StrMap(fb);
    };
    StrMap.prototype.map = function (f) {
        return this.mapWithKey(function (_, a) { return f(a); });
    };
    StrMap.prototype.reduce = function (f, b) {
        var out = b;
        for (var k in this.value) {
            out = f(out, this.value[k]);
        }
        return out;
    };
    StrMap.prototype.traverseWithKey = function (F) {
        var _this = this;
        var concatA2 = Apply_1.liftA2(F)(exports.concat);
        return function (f) {
            var out = F.of(exports.empty());
            var _loop_1 = function (k) {
                out = concatA2(out)(F.map(function (b) { return exports.singleton(k)(b); }, f(k, _this.value[k])));
            };
            for (var k in _this.value) {
                _loop_1(k);
            }
            return out;
        };
    };
    StrMap.prototype.traverse = function (F) {
        var _this = this;
        return function (f) { return _this.traverseWithKey(F)(function (_, a) { return f(a); }); };
    };
    return StrMap;
}());
exports.StrMap = StrMap;
/** @function */
exports.empty = function () {
    return new StrMap({});
};
/** @function */
exports.concat = function (x) { return function (y) {
    return new StrMap(Object.assign({}, x.value, y.value));
}; };
/** @function */
exports.map = function (f, fa) {
    return fa.map(f);
};
/** @function */
exports.reduce = function (f, b, fa) {
    return fa.reduce(f, b);
};
/** @function */
function traverseWithKey(F) {
    return function (f, ta) { return ta.traverseWithKey(F)(f); };
}
exports.traverseWithKey = traverseWithKey;
/** @function */
function traverse(F) {
    return function (f, ta) { return ta.traverse(F)(f); };
}
exports.traverse = traverse;
/**
 * Test whether one dictionary contains all of the keys and values contained in another dictionary
 * @function
 */
exports.isSubdictionary = function (setoid) { return function (d1) { return function (d2) {
    for (var k in d1.value) {
        if (!d2.value.hasOwnProperty(k) || !setoid.equals(d1.value[k])(d2.value[k])) {
            return false;
        }
    }
    return true;
}; }; };
/**
 * Calculate the number of key/value pairs in a dictionary
 * @function
 */
exports.size = function (d) {
    return Object.keys(d.value).length;
};
/**
 * Test whether a dictionary is empty
 * @function
 */
exports.isEmpty = function (d) {
    for (var k in d.value) {
        return k === null;
    }
    return true;
};
/** @function */
exports.getSetoid = function (setoid) {
    return {
        equals: function (x) { return function (y) { return exports.isSubdictionary(setoid)(x)(y) && exports.isSubdictionary(setoid)(y)(x); }; }
    };
};
/**
 * Create a dictionary with one key/value pair
 * @function
 */
exports.singleton = function (k) { return function (a) {
    return new StrMap((_a = {}, _a[k] = a, _a));
    var _a;
}; };
/**
 * Lookup the value for a key in a dictionary
 * @function
 */
exports.lookup = function (k) { return function (d) {
    return d.value.hasOwnProperty(k) ? Option_1.some(d.value[k]) : Option_1.none;
}; };
/**
 * Create a dictionary from a foldable collection of key/value pairs, using the
 * specified function to combine values for duplicate keys.
 * @function
 */
exports.fromFoldable = function (F) { return function (f) { return function (ta) {
    return F.reduce(function (b, a) {
        var k = a[0];
        b.value[k] = b.value.hasOwnProperty(k) ? f(b.value[k])(a[1]) : a[1];
        return b;
    }, new StrMap({}), ta);
}; }; };
/** @function */
exports.collect = function (f) { return function (d) {
    var out = [];
    for (var k in d.value) {
        out.push(f(k, d.value[k]));
    }
    return out;
}; };
/** @function */
exports.toArray = function (d) {
    return exports.collect(function (k, a) { return function_1.tuple(k, a); })(d);
};
/**
 * Unfolds a dictionary into a list of key/value pairs
 * @function
 */
exports.toUnfoldable = function (unfoldable) { return function (d) {
    var arr = exports.toArray(d);
    if (unfoldable.URI === Array_1.URI) {
        return arr;
    }
    var len = arr.length;
    return unfoldable.unfoldr(function (b) { return (b < len ? Option_1.some(function_1.tuple(arr[b], b + 1)) : Option_1.none); }, 0);
}; };
/**
 * Apply a function of two arguments to each key/value pair, producing a new dictionary
 * @function
 */
exports.mapWithKey = function (f, fa) {
    return fa.mapWithKey(f);
};
/**
 * Insert or replace a key/value pair in a map
 * @function
 */
exports.insert = function (k) { return function (a) { return function (d) {
    var copy = Object.assign({}, d.value);
    copy[k] = a;
    return new StrMap(copy);
}; }; };
/**
 * Delete a key and value from a map
 * @function
 */
exports.remove = function (k) { return function (d) {
    var copy = Object.assign({}, d.value);
    delete copy[k];
    return new StrMap(copy);
}; };
/**
 * Delete a key and value from a map, returning the value as well as the subsequent map
 * @function
 */
exports.pop = function (k) { return function (d) {
    return exports.lookup(k)(d).fold(function () { return Option_1.none; }, function (a) { return Option_1.some(function_1.tuple(a, exports.remove(k)(d))); });
}; };
/** @instance */
exports.strmap = {
    URI: exports.URI,
    concat: exports.concat,
    empty: exports.empty,
    map: exports.map,
    reduce: exports.reduce,
    traverse: traverse
};
//# sourceMappingURL=StrMap.js.map