import { Monoid } from './Monoid';
import { Monad, FantasyMonad } from './Monad';
import { Lazy } from './function';
import { Either } from './Either';
import { IO } from './IO';
declare module './HKT' {
    interface URI2HKT<A> {
        Task: Task<A>;
    }
}
export declare const URI = "Task";
export declare type URI = typeof URI;
/**
 * @data
 * @constructor Task
 */
export declare class Task<A> implements FantasyMonad<URI, A> {
    readonly run: Lazy<Promise<A>>;
    readonly _A: A;
    readonly _URI: URI;
    constructor(run: Lazy<Promise<A>>);
    map<B>(f: (a: A) => B): Task<B>;
    ap<B>(fab: Task<(a: A) => B>): Task<B>;
    ap_<B, C>(this: Task<(a: B) => C>, fb: Task<B>): Task<C>;
    chain<B>(f: (a: A) => Task<B>): Task<B>;
    /** Selects the earlier of two Tasks */
    concat(fy: Task<A>): Task<A>;
    inspect(): string;
    toString(): string;
}
/** @function */
export declare const map: <A, B>(f: (a: A) => B, fa: Task<A>) => Task<B>;
/** @function */
export declare const of: <A>(a: A) => Task<A>;
/** @function */
export declare const ap: <A, B>(fab: Task<(a: A) => B>, fa: Task<A>) => Task<B>;
/** @function */
export declare const chain: <A, B>(f: (a: A) => Task<B>, fa: Task<A>) => Task<B>;
/**
 * Returns a task that never completes
 * @function
 */
export declare const empty: <A>() => Task<A>;
/**
 * Selects the earlier of two Tasks
 * @function
 */
export declare const concat: <A>(fx: Task<A>) => (fy: Task<A>) => Task<A>;
/** @function */
export declare const tryCatch: <A>(f: Lazy<Promise<A>>) => <L>(onrejected: (reason: {}) => L) => Task<Either<L, A>>;
/**
 * Lifts an IO action into a Task
 * @function
 */
export declare const fromIO: <A>(io: IO<A>) => Task<A>;
/** @instance */
export declare const task: Monad<URI> & Monoid<Task<any>>;
