"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var function_1 = require("./function");
var Either_1 = require("./Either");
exports.URI = 'Task';
/**
 * @data
 * @constructor Task
 */
var Task = /** @class */ (function () {
    function Task(run) {
        this.run = run;
    }
    Task.prototype.map = function (f) {
        var _this = this;
        return new Task(function () { return _this.run().then(f); });
    };
    Task.prototype.ap = function (fab) {
        var _this = this;
        return new Task(function () { return Promise.all([fab.run(), _this.run()]).then(function (_a) {
            var f = _a[0], a = _a[1];
            return f(a);
        }); });
    };
    Task.prototype.ap_ = function (fb) {
        return fb.ap(this);
    };
    Task.prototype.chain = function (f) {
        var _this = this;
        return new Task(function () { return _this.run().then(function (a) { return f(a).run(); }); });
    };
    /** Selects the earlier of two Tasks */
    Task.prototype.concat = function (fy) {
        var _this = this;
        return new Task(function () {
            return new Promise(function (r) {
                var running = true;
                var resolve = function (a) {
                    if (running) {
                        running = false;
                        r(a);
                    }
                };
                _this.run().then(resolve);
                fy.run().then(resolve);
            });
        });
    };
    Task.prototype.inspect = function () {
        return this.toString();
    };
    Task.prototype.toString = function () {
        return "new Task(" + function_1.toString(this.run) + ")";
    };
    return Task;
}());
exports.Task = Task;
/** @function */
exports.map = function (f, fa) {
    return fa.map(f);
};
/** @function */
exports.of = function (a) {
    return new Task(function () { return Promise.resolve(a); });
};
/** @function */
exports.ap = function (fab, fa) {
    return fa.ap(fab);
};
/** @function */
exports.chain = function (f, fa) {
    return fa.chain(f);
};
/**
 * Returns a task that never completes
 * @function
 */
exports.empty = function () {
    return never;
};
/**
 * Selects the earlier of two Tasks
 * @function
 */
exports.concat = function (fx) { return function (fy) {
    return fx.concat(fy);
}; };
var neverPromise = new Promise(function (resolve) { return undefined; });
var neverLazyPromise = function () { return neverPromise; };
var never = new Task(neverLazyPromise);
/** @function */
exports.tryCatch = function (f) { return function (onrejected) {
    return new Task(function () { return f().then(function (a) { return Either_1.right(a); }, function (reason) { return Either_1.left(onrejected(reason)); }); });
}; };
/**
 * Lifts an IO action into a Task
 * @function
 */
exports.fromIO = function (io) {
    return new Task(function () { return Promise.resolve(io.run()); });
};
/** @instance */
exports.task = {
    URI: exports.URI,
    map: exports.map,
    of: exports.of,
    ap: exports.ap,
    chain: exports.chain,
    concat: exports.concat,
    empty: exports.empty
};
//# sourceMappingURL=Task.js.map