"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var eitherT = require("./EitherT");
var task = require("./Task");
var eitherTTask = eitherT.getEitherT(task);
exports.URI = 'TaskEither';
var eitherTfold = eitherT.fold(task);
var eitherTmapLeft = eitherT.mapLeft(task);
var eitherTtoOption = eitherT.toOption(task);
/**
 * @data
 * @constructor TaskEither
 */
var TaskEither = /** @class */ (function () {
    function TaskEither(value) {
        this.value = value;
    }
    /** Runs the inner task */
    TaskEither.prototype.run = function () {
        return this.value.run();
    };
    TaskEither.prototype.map = function (f) {
        return new TaskEither(eitherTTask.map(f, this.value));
    };
    TaskEither.prototype.ap = function (fab) {
        return new TaskEither(eitherTTask.ap(fab.value, this.value));
    };
    TaskEither.prototype.ap_ = function (fb) {
        return fb.ap(this);
    };
    TaskEither.prototype.chain = function (f) {
        return new TaskEither(eitherTTask.chain(function (a) { return f(a).value; }, this.value));
    };
    TaskEither.prototype.fold = function (left, right) {
        return eitherTfold(left, right, this.value);
    };
    TaskEither.prototype.mapLeft = function (f) {
        return new TaskEither(eitherTmapLeft(f)(this.value));
    };
    TaskEither.prototype.toOption = function () {
        return eitherTtoOption(this.value);
    };
    /** Transforms the failure value of the `TaskEither` into a new `TaskEither` */
    TaskEither.prototype.orElse = function (f) {
        return new TaskEither(this.value.chain(function (e) { return e.fold(function (l) { return f(l).value; }, function (a) { return eitherTTask.of(a); }); }));
    };
    return TaskEither;
}());
exports.TaskEither = TaskEither;
/** @function */
exports.map = function (f, fa) {
    return fa.map(f);
};
/** @function */
exports.of = function (a) {
    return new TaskEither(eitherTTask.of(a));
};
/** @function */
exports.ap = function (fab, fa) {
    return fa.ap(fab);
};
/** @function */
exports.chain = function (f, fa) {
    return fa.chain(f);
};
var eitherTright = eitherT.right(task);
/** @function */
exports.right = function (fa) {
    return new TaskEither(eitherTright(fa));
};
var eitherTleft = eitherT.left(task);
/** @function */
exports.left = function (fa) {
    return new TaskEither(eitherTleft(fa));
};
var eitherTfromEither = eitherT.fromEither(task);
/** @function */
exports.fromEither = function (fa) {
    return new TaskEither(eitherTfromEither(fa));
};
/** @function */
exports.tryCatch = function (f, onrejected) {
    return new TaskEither(task.tryCatch(f)(onrejected));
};
/**
 * Transforms the failure value of the `TaskEither` into a new `TaskEither`
 * @function
 */
exports.orElse = function (f) { return function (fa) {
    return fa.orElse(f);
}; };
/** @instance */
exports.taskEither = {
    URI: exports.URI,
    map: exports.map,
    of: exports.of,
    ap: exports.ap,
    chain: exports.chain
};
//# sourceMappingURL=TaskEither.js.map