import { HKT, HKTS, HKT2S, HKTAs, HKT2As } from './HKT';
import { Applicative } from './Applicative';
import { Functor, FantasyFunctor } from './Functor';
import { Bifunctor, FantasyBifunctor } from './Bifunctor';
import { Foldable, FantasyFoldable } from './Foldable';
import { Traversable, FantasyTraversable } from './Traversable';
import { Option } from './Option';
import { Setoid } from './Setoid';
import { Semigroup } from './Semigroup';
import { Monad } from './Monad';
declare module './HKT' {
    interface URI2HKT2<L, A> {
        These: These<L, A>;
    }
}
export declare const URI = "These";
export declare type URI = typeof URI;
/**
 * @data
 * @constructor This
 * @constructor That
 * @constructor Both
 */
export declare type These<L, A> = This<L, A> | That<L, A> | Both<L, A>;
export declare class This<L, A> implements FantasyFunctor<URI, A>, FantasyBifunctor<URI, L, A>, FantasyFoldable<A>, FantasyTraversable<URI, A> {
    readonly value: L;
    readonly _tag: 'This';
    readonly _A: A;
    readonly _L: L;
    readonly _URI: URI;
    constructor(value: L);
    map<B>(f: (a: A) => B): These<L, B>;
    bimap<M, B>(f: (l: L) => M, g: (a: A) => B): These<M, B>;
    reduce<B>(f: (b: B, a: A) => B, b: B): B;
    traverse<F extends HKT2S>(F: Applicative<F>): <M, B>(f: (a: A) => HKT2As<F, M, B>) => HKT2As<F, M, These<L, B>>;
    traverse<F extends HKTS>(F: Applicative<F>): <B>(f: (a: A) => HKTAs<F, B>) => HKTAs<F, These<L, B>>;
    traverse<F>(F: Applicative<F>): <B>(f: (a: A) => HKT<F, B>) => HKT<F, These<L, B>>;
    fold<B>(this_: (l: L) => B, that: (a: A) => B, both: (l: L, a: A) => B): B;
    inspect(): string;
    toString(): string;
}
export declare class That<L, A> implements FantasyFunctor<URI, A>, FantasyBifunctor<URI, L, A>, FantasyFoldable<A>, FantasyTraversable<URI, A> {
    readonly value: A;
    readonly _tag: 'That';
    readonly _A: A;
    readonly _L: L;
    readonly _URI: URI;
    constructor(value: A);
    map<B>(f: (a: A) => B): These<L, B>;
    bimap<M, B>(f: (l: L) => M, g: (a: A) => B): These<M, B>;
    reduce<B>(f: (b: B, a: A) => B, b: B): B;
    traverse<F extends HKT2S>(F: Applicative<F>): <M, B>(f: (a: A) => HKT2As<F, M, B>) => HKT2As<F, M, These<L, B>>;
    traverse<F extends HKTS>(F: Applicative<F>): <B>(f: (a: A) => HKTAs<F, B>) => HKTAs<F, These<L, B>>;
    traverse<F>(F: Applicative<F>): <B>(f: (a: A) => HKT<F, B>) => HKT<F, These<L, B>>;
    fold<B>(this_: (l: L) => B, that: (a: A) => B, both: (l: L, a: A) => B): B;
    inspect(): string;
    toString(): string;
}
export declare class Both<L, A> implements FantasyFunctor<URI, A>, FantasyBifunctor<URI, L, A>, FantasyFoldable<A>, FantasyTraversable<URI, A> {
    readonly l: L;
    readonly a: A;
    readonly _tag: 'Both';
    readonly _A: A;
    readonly _L: L;
    readonly _URI: URI;
    constructor(l: L, a: A);
    map<B>(f: (a: A) => B): These<L, B>;
    bimap<M, B>(f: (l: L) => M, g: (a: A) => B): These<M, B>;
    reduce<B>(f: (b: B, a: A) => B, b: B): B;
    traverse<F extends HKT2S>(F: Applicative<F>): <M, B>(f: (a: A) => HKT2As<F, M, B>) => HKT2As<F, M, These<L, B>>;
    traverse<F extends HKTS>(F: Applicative<F>): <B>(f: (a: A) => HKTAs<F, B>) => HKTAs<F, These<L, B>>;
    traverse<F>(F: Applicative<F>): <B>(f: (a: A) => HKT<F, B>) => HKT<F, These<L, B>>;
    fold<B>(this_: (l: L) => B, that: (a: A) => B, both: (l: L, a: A) => B): B;
    inspect(): string;
    toString(): string;
}
/** @function */
export declare const fold: <L, A, B>(this_: (l: L) => B, that: (a: A) => B, both: (l: L, a: A) => B) => (fa: These<L, A>) => B;
/** @function */
export declare const getSetoid: <L, A>(SL: Setoid<L>, SA: Setoid<A>) => Setoid<These<L, A>>;
/** @function */
export declare const getSemigroup: <L, A>(SL: Semigroup<L>, SA: Semigroup<A>) => Semigroup<These<L, A>>;
/** @function */
export declare const map: <L, A, B>(f: (a: A) => B, fa: These<L, A>) => These<L, B>;
/** @function */
export declare const of: <L, A>(a: A) => These<L, A>;
/** @function */
export declare const ap: <L>(S: Semigroup<L>) => <A, B>(fab: These<L, (a: A) => B>, fa: These<L, A>) => These<L, B>;
/** @function */
export declare const chain: <L>(S: Semigroup<L>) => <A, B>(f: (a: A) => These<L, B>, fa: These<L, A>) => These<L, B>;
/** @function */
export declare const getMonad: <L>(S: Semigroup<L>) => Monad<"These">;
/** @function */
export declare const bimap: <L, M, A, B>(f: (l: L) => M, g: (a: A) => B, fla: These<L, A>) => These<M, B>;
/** @function */
export declare const reduce: <L, A, B>(f: (b: B, a: A) => B, b: B, fa: These<L, A>) => B;
export declare function traverse<F extends HKT2S>(F: Applicative<F>): <M, L, A, B>(f: (a: A) => HKT2As<F, M, B>, ta: These<L, A>) => HKT2As<F, M, These<L, B>>;
export declare function traverse<F extends HKTS>(F: Applicative<F>): <L, A, B>(f: (a: A) => HKTAs<F, B>, ta: These<L, A>) => HKTAs<F, These<L, B>>;
export declare function traverse<F>(F: Applicative<F>): <L, A, B>(f: (a: A) => HKT<F, B>, ta: HKT<URI, A>) => HKT<F, These<L, B>>;
/** @function */
export declare const isThis: <L, A>(fa: These<L, A>) => fa is This<L, A>;
/** @function */
export declare const isThat: <L, A>(fa: These<L, A>) => fa is That<L, A>;
/** @function */
export declare const isBoth: <L, A>(fa: These<L, A>) => fa is Both<L, A>;
/** @function */
export declare const this_: <L, A>(l: L) => These<L, A>;
/**
 * @function
 * @alias of
 */
export declare const that: <L, A>(a: A) => These<L, A>;
/** @function */
export declare const both: <L, A>(l: L, a: A) => These<L, A>;
/** @function */
export declare const fromThese: <L, A>(defaultThis: L, defaultThat: A) => (fa: These<L, A>) => [L, A];
/** @function */
export declare const theseLeft: <L, A>(fa: These<L, A>) => Option<L>;
/** @function */
export declare const theseRight: <L, A>(fa: These<L, A>) => Option<A>;
/** @instance */
export declare const these: Functor<URI> & Bifunctor<URI> & Foldable<URI> & Traversable<URI>;
