"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Option_1 = require("./Option");
var function_1 = require("./function");
exports.URI = 'These';
var This = /** @class */ (function () {
    function This(value) {
        this.value = value;
        this._tag = 'This';
    }
    This.prototype.map = function (f) {
        return this;
    };
    This.prototype.bimap = function (f, g) {
        return exports.this_(f(this.value));
    };
    This.prototype.reduce = function (f, b) {
        return b;
    };
    This.prototype.traverse = function (F) {
        var _this = this;
        return function (f) { return F.of(_this); };
    };
    This.prototype.fold = function (this_, that, both) {
        return this_(this.value);
    };
    This.prototype.inspect = function () {
        return this.toString();
    };
    This.prototype.toString = function () {
        return "this_(" + function_1.toString(this.value) + ")";
    };
    return This;
}());
exports.This = This;
var That = /** @class */ (function () {
    function That(value) {
        this.value = value;
        this._tag = 'That';
    }
    That.prototype.map = function (f) {
        return new That(f(this.value));
    };
    That.prototype.bimap = function (f, g) {
        return exports.that(g(this.value));
    };
    That.prototype.reduce = function (f, b) {
        return f(b, this.value);
    };
    That.prototype.traverse = function (F) {
        var _this = this;
        return function (f) { return F.map(function (b) { return exports.that(b); }, f(_this.value)); };
    };
    That.prototype.fold = function (this_, that, both) {
        return that(this.value);
    };
    That.prototype.inspect = function () {
        return this.toString();
    };
    That.prototype.toString = function () {
        return "that(" + function_1.toString(this.value) + ")";
    };
    return That;
}());
exports.That = That;
var Both = /** @class */ (function () {
    function Both(l, a) {
        this.l = l;
        this.a = a;
        this._tag = 'Both';
    }
    Both.prototype.map = function (f) {
        return new Both(this.l, f(this.a));
    };
    Both.prototype.bimap = function (f, g) {
        return exports.both(f(this.l), g(this.a));
    };
    Both.prototype.reduce = function (f, b) {
        return f(b, this.a);
    };
    Both.prototype.traverse = function (F) {
        var _this = this;
        return function (f) { return F.map(function (b) { return exports.both(_this.l, b); }, f(_this.a)); };
    };
    Both.prototype.fold = function (this_, that, both) {
        return both(this.l, this.a);
    };
    Both.prototype.inspect = function () {
        return this.toString();
    };
    Both.prototype.toString = function () {
        return "both(" + function_1.toString(this.l) + ", " + function_1.toString(this.a) + ")";
    };
    return Both;
}());
exports.Both = Both;
/** @function */
exports.fold = function (this_, that, both) { return function (fa) {
    return fa.fold(this_, that, both);
}; };
/** @function */
exports.getSetoid = function (SL, SA) {
    return {
        equals: function (x) { return function (y) {
            return x.fold(function (lx) { return y.fold(function (ly) { return SL.equals(lx)(ly); }, function_1.constFalse, function_1.constFalse); }, function (ax) { return y.fold(function_1.constFalse, function (ay) { return SA.equals(ax)(ay); }, function_1.constFalse); }, function (lx, ax) { return y.fold(function_1.constFalse, function_1.constFalse, function (ly, ay) { return SL.equals(lx)(ly) && SA.equals(ax)(ay); }); });
        }; }
    };
};
/** @function */
exports.getSemigroup = function (SL, SA) {
    return {
        concat: function (x) { return function (y) {
            return x.fold(function (lx) { return y.fold(function (ly) { return exports.this_(SL.concat(lx)(ly)); }, function (ay) { return exports.both(lx, ay); }, function (ly, ay) { return exports.both(SL.concat(lx)(ly), ay); }); }, function (ax) { return y.fold(function (lx) { return exports.both(lx, ax); }, function (ay) { return exports.that(SA.concat(ax)(ay)); }, function (ly, ay) { return exports.both(ly, SA.concat(ax)(ay)); }); }, function (lx, ax) {
                return y.fold(function (ly) { return exports.both(SL.concat(lx)(ly), ax); }, function (ay) { return exports.both(lx, SA.concat(ax)(ay)); }, function (ly, ay) { return exports.both(SL.concat(lx)(ly), SA.concat(ax)(ay)); });
            });
        }; }
    };
};
/** @function */
exports.map = function (f, fa) {
    return fa.map(f);
};
/** @function */
exports.of = function (a) {
    return new That(a);
};
/** @function */
exports.ap = function (S) { return function (fab, fa) {
    return exports.chain(S)(function (f) { return exports.map(f, fa); }, fab);
}; };
/** @function */
exports.chain = function (S) { return function (f, fa) {
    return fa.fold(function () { return fa; }, function (a) { return f(a); }, function (l1, a) { return f(a).fold(function (l2) { return exports.this_(S.concat(l1)(l2)); }, function (b) { return exports.both(l1, b); }, function (l2, b) { return exports.both(S.concat(l1)(l2), b); }); });
}; };
/** @function */
exports.getMonad = function (S) {
    return {
        URI: exports.URI,
        map: exports.map,
        of: exports.of,
        ap: exports.ap(S),
        chain: exports.chain(S)
    };
};
/** @function */
exports.bimap = function (f, g, fla) {
    return fla.bimap(f, g);
};
/** @function */
exports.reduce = function (f, b, fa) {
    return fa.reduce(f, b);
};
/** @function */
function traverse(F) {
    return function (f, ta) { return ta.traverse(F)(f); };
}
exports.traverse = traverse;
/** @function */
exports.isThis = function (fa) {
    return fa._tag === 'This';
};
/** @function */
exports.isThat = function (fa) {
    return fa._tag === 'That';
};
/** @function */
exports.isBoth = function (fa) {
    return fa._tag === 'Both';
};
/** @function */
exports.this_ = function (l) {
    return new This(l);
};
/**
 * @function
 * @alias of
 */
exports.that = exports.of;
/** @function */
exports.both = function (l, a) {
    return new Both(l, a);
};
/** @function */
exports.fromThese = function (defaultThis, defaultThat) { return function (fa) {
    return fa.fold(function (l) { return [l, defaultThat]; }, function (a) { return [defaultThis, a]; }, function (l, a) { return [l, a]; });
}; };
/** @function */
exports.theseLeft = function (fa) {
    return fa.fold(function (l) { return Option_1.some(l); }, function () { return Option_1.none; }, function (l, _) { return Option_1.some(l); });
};
/** @function */
exports.theseRight = function (fa) {
    return fa.fold(function () { return Option_1.none; }, function (a) { return Option_1.some(a); }, function (_, a) { return Option_1.some(a); });
};
/** @instance */
exports.these = {
    URI: exports.URI,
    map: exports.map,
    bimap: exports.bimap,
    reduce: exports.reduce,
    traverse: traverse
};
//# sourceMappingURL=These.js.map