import { HKT, HKTS, HKT2S, HKTAs, HKT2As } from './HKT';
import { Setoid } from './Setoid';
import { Ord } from './Ord';
import { Semigroup } from './Semigroup';
import { Monoid } from './Monoid';
import { Bifunctor, FantasyBifunctor } from './Bifunctor';
import { Comonad, FantasyComonad } from './Comonad';
import { Apply } from './Apply';
import { Monad } from './Monad';
import { Foldable, FantasyFoldable } from './Foldable';
import { Applicative } from './Applicative';
import { Traversable, FantasyTraversable } from './Traversable';
import { Semigroupoid, FantasySemigroupoid } from './Semigroupoid';
import { ChainRec } from './ChainRec';
import { Chain } from './Chain';
import { Either } from './Either';
declare module './HKT' {
    interface URI2HKT2<L, A> {
        Tuple: Tuple<L, A>;
    }
}
export declare const URI = "Tuple";
export declare type URI = typeof URI;
/**
 * @data
 * @constructor Tuple
 */
export declare class Tuple<L, A> implements FantasySemigroupoid<URI, L, A>, FantasyBifunctor<URI, L, A>, FantasyComonad<URI, A>, FantasyFoldable<A>, FantasyTraversable<URI, A> {
    readonly value: [L, A];
    readonly _A: A;
    readonly _L: L;
    readonly _URI: URI;
    constructor(value: [L, A]);
    fst(): L;
    snd(): A;
    compose<B>(ab: Tuple<A, B>): Tuple<L, B>;
    map<B>(f: (a: A) => B): Tuple<L, B>;
    bimap<M, B>(f: (l: L) => M, g: (a: A) => B): Tuple<M, B>;
    extract(): A;
    extend<B>(f: (fa: Tuple<L, A>) => B): Tuple<L, B>;
    reduce<B>(f: (c: B, b: A) => B, c: B): B;
    traverse<F>(F: Applicative<F>): <B>(f: (a: A) => HKT<F, B>) => HKT<F, Tuple<L, B>>;
    inspect(): string;
    toString(): string;
}
/**
 * Returns the first component of a tuple.
 * @function
 */
export declare const fst: <L, A>(fa: Tuple<L, A>) => L;
/**
 * Returns the second component of a tuple.
 * @function
 */
export declare const snd: <L, A>(fa: Tuple<L, A>) => A;
/** @function */
export declare const compose: <L, A, B>(bc: Tuple<A, B>, fa: Tuple<L, A>) => Tuple<L, B>;
/** @function */
export declare const map: <L, A, B>(f: (b: A) => B, fa: Tuple<L, A>) => Tuple<L, B>;
/** @function */
export declare const bimap: <L, A, M, B>(f: (l: L) => M, g: (a: A) => B, fla: Tuple<L, A>) => Tuple<M, B>;
/**
 * @function
 * @alias snd
 */
export declare const extract: <L, A>(fa: Tuple<L, A>) => A;
/** @function */
export declare const extend: <L, A, B>(f: (fa: Tuple<L, A>) => B, fa: Tuple<L, A>) => Tuple<L, B>;
/** @function */
export declare const reduce: <L, A, B>(f: (c: B, b: A) => B, c: B, fa: Tuple<L, A>) => B;
/** @function */
export declare const getSetoid: <L, A>(SA: Setoid<L>, SB: Setoid<A>) => Setoid<Tuple<L, A>>;
/**
 * To obtain the result, the `fst`s are `compare`d, and if they are `EQ`ual, the
 * `snd`s are `compare`d.
 * @function
 */
export declare const getOrd: <L, A>(OL: Ord<L>, OA: Ord<A>) => Ord<Tuple<L, A>>;
/** @function */
export declare const getSemigroup: <L, A>(SL: Semigroup<L>, SA: Semigroup<A>) => Semigroup<Tuple<L, A>>;
/** @function */
export declare const getMonoid: <L, A>(ML: Monoid<L>, MA: Monoid<A>) => Monoid<Tuple<L, A>>;
/** @function */
export declare const ap: <L>(S: Semigroup<L>) => <A, B>(fab: Tuple<L, (b: A) => B>, fa: Tuple<L, A>) => Tuple<L, B>;
/** @function */
export declare const getApply: <L>(S: Semigroup<L>) => Apply<"Tuple">;
/** @function */
export declare const of: <L>(M: Monoid<L>) => <A>(a: A) => Tuple<L, A>;
/** @function */
export declare const getApplicative: <L>(M: Monoid<L>) => Applicative<"Tuple">;
/** @function */
export declare const chain: <L>(M: Monoid<L>) => <A, B>(f: (b: A) => Tuple<L, B>, fa: Tuple<L, A>) => Tuple<L, B>;
/** @function */
export declare const getChain: <L>(M: Monoid<L>) => Chain<"Tuple">;
/** @function */
export declare const getMonad: <L>(M: Monoid<L>) => Monad<"Tuple">;
/** @function */
export declare const chainRec: <L>(M: Monoid<L>) => <A, B>(f: (a: A) => Tuple<L, Either<A, B>>, a: A) => Tuple<L, B>;
/** @function */
export declare const getChainRec: <L>(M: Monoid<L>) => ChainRec<"Tuple">;
export declare function traverse<F extends HKT2S>(F: Applicative<F>): <M, L, A, B>(f: (a: A) => HKT2As<F, M, B>, ta: Tuple<L, A>) => HKT2As<F, M, Tuple<L, B>>;
export declare function traverse<F extends HKTS>(F: Applicative<F>): <L, A, B>(f: (a: A) => HKTAs<F, B>, ta: Tuple<L, A>) => HKTAs<F, Tuple<L, B>>;
export declare function traverse<F>(F: Applicative<F>): <L, A, B>(f: (a: A) => HKT<F, B>, ta: HKT<URI, A>) => HKT<F, Tuple<L, B>>;
/**
 * Exchange the first and second components of a tuple.
 * @function
 */
export declare const swap: <L, A>(fa: Tuple<L, A>) => Tuple<A, L>;
/** @instance */
export declare const tuple: Semigroupoid<URI> & Bifunctor<URI> & Comonad<URI> & Foldable<URI> & Traversable<URI>;
