"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Ord_1 = require("./Ord");
var function_1 = require("./function");
var Either_1 = require("./Either");
exports.URI = 'Tuple';
/**
 * @data
 * @constructor Tuple
 */
var Tuple = /** @class */ (function () {
    function Tuple(value) {
        this.value = value;
    }
    Tuple.prototype.fst = function () {
        return this.value[0];
    };
    Tuple.prototype.snd = function () {
        return this.value[1];
    };
    Tuple.prototype.compose = function (ab) {
        return new Tuple([this.fst(), ab.snd()]);
    };
    Tuple.prototype.map = function (f) {
        return new Tuple([this.fst(), f(this.snd())]);
    };
    Tuple.prototype.bimap = function (f, g) {
        return new Tuple([f(this.fst()), g(this.snd())]);
    };
    Tuple.prototype.extract = function () {
        return this.snd();
    };
    Tuple.prototype.extend = function (f) {
        return new Tuple([this.fst(), f(this)]);
    };
    Tuple.prototype.reduce = function (f, c) {
        return f(c, this.snd());
    };
    Tuple.prototype.traverse = function (F) {
        var _this = this;
        return function (f) { return F.map(function (b) { return new Tuple([_this.fst(), b]); }, f(_this.snd())); };
    };
    Tuple.prototype.inspect = function () {
        return this.toString();
    };
    Tuple.prototype.toString = function () {
        return "new Tuple(" + function_1.toString(this.value) + ")";
    };
    return Tuple;
}());
exports.Tuple = Tuple;
/**
 * Returns the first component of a tuple.
 * @function
 */
exports.fst = function (fa) {
    return fa.fst();
};
/**
 * Returns the second component of a tuple.
 * @function
 */
exports.snd = function (fa) {
    return fa.snd();
};
/** @function */
exports.compose = function (bc, fa) {
    return fa.compose(bc);
};
/** @function */
exports.map = function (f, fa) {
    return fa.map(f);
};
/** @function */
exports.bimap = function (f, g, fla) {
    return fla.bimap(f, g);
};
/**
 * @function
 * @alias snd
 */
exports.extract = exports.snd;
/** @function */
exports.extend = function (f, fa) {
    return fa.extend(f);
};
/** @function */
exports.reduce = function (f, c, fa) {
    return fa.reduce(f, c);
};
/** @function */
exports.getSetoid = function (SA, SB) {
    return {
        equals: function (x) { return function (y) {
            var _a = x.value, xa = _a[0], xb = _a[1];
            var _b = y.value, ya = _b[0], yb = _b[1];
            return SA.equals(xa)(ya) && SB.equals(xb)(yb);
        }; }
    };
};
/**
 * To obtain the result, the `fst`s are `compare`d, and if they are `EQ`ual, the
 * `snd`s are `compare`d.
 * @function
 */
exports.getOrd = function (OL, OA) {
    return Ord_1.getSemigroup().concat(Ord_1.contramap(exports.fst, OL))(Ord_1.contramap(exports.snd, OA));
};
/** @function */
exports.getSemigroup = function (SL, SA) {
    return {
        concat: function (x) { return function (y) {
            var _a = x.value, xa = _a[0], xb = _a[1];
            var _b = y.value, ya = _b[0], yb = _b[1];
            return new Tuple([SL.concat(xa)(ya), SA.concat(xb)(yb)]);
        }; }
    };
};
/** @function */
exports.getMonoid = function (ML, MA) {
    var empty = new Tuple([ML.empty(), MA.empty()]);
    return __assign({}, exports.getSemigroup(ML, MA), { empty: function () { return empty; } });
};
/** @function */
exports.ap = function (S) { return function (fab, fa) {
    return new Tuple([S.concat(fa.fst())(fab.fst()), fab.snd()(fa.snd())]);
}; };
/** @function */
exports.getApply = function (S) {
    return {
        URI: exports.URI,
        map: exports.map,
        ap: exports.ap(S)
    };
};
/** @function */
exports.of = function (M) { return function (a) {
    return new Tuple([M.empty(), a]);
}; };
/** @function */
exports.getApplicative = function (M) {
    return __assign({}, exports.getApply(M), { of: exports.of(M) });
};
/** @function */
exports.chain = function (M) { return function (f, fa) {
    var lb = f(fa.snd());
    return new Tuple([M.concat(fa.fst())(lb.fst()), lb.snd()]);
}; };
/** @function */
exports.getChain = function (M) {
    return __assign({}, exports.getApply(M), { chain: exports.chain(M) });
};
/** @function */
exports.getMonad = function (M) {
    return __assign({}, exports.getChain(M), { of: exports.of(M) });
};
/** @function */
exports.chainRec = function (M) { return function (f, a) {
    var result = f(a);
    var acc = M.empty();
    while (Either_1.isLeft(result.snd())) {
        acc = M.concat(acc)(result.fst());
        result = f(result.snd().value);
    }
    return new Tuple([M.concat(acc)(result.fst()), result.snd().value]);
}; };
/** @function */
exports.getChainRec = function (M) {
    return __assign({}, exports.getChain(M), { chainRec: exports.chainRec(M) });
};
/** @function */
function traverse(F) {
    return function (f, ta) { return ta.traverse(F)(f); };
}
exports.traverse = traverse;
/**
 * Exchange the first and second components of a tuple.
 * @function
 */
exports.swap = function (fa) {
    return new Tuple([fa.snd(), fa.fst()]);
};
/** @instance */
exports.tuple = {
    URI: exports.URI,
    compose: exports.compose,
    map: exports.map,
    bimap: exports.bimap,
    extract: exports.extract,
    extend: exports.extend,
    reduce: exports.reduce,
    traverse: traverse
};
//# sourceMappingURL=Tuple.js.map