"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var option = require("./Option");
var Traversable_1 = require("./Traversable");
var function_1 = require("./function");
/**
 * Replicate a value some natural number of times.
 * @function
 */
exports.replicate = function (unfoldable) { return function (n) { return function (a) {
    function step(n) {
        return n <= 0 ? option.none : option.of(function_1.tuple(a, n - 1));
    }
    return unfoldable.unfoldr(step, n);
}; }; };
/**
 * The container with no elements - unfolded with zero iterations.
 * @function
 */
exports.none = function (unfoldable) {
    return unfoldable.unfoldr(function_1.constant(option.none), undefined);
};
/** @function */
exports.singleton = function (unfoldable) { return function (a) {
    return exports.replicate(unfoldable)(1)(a);
}; };
/**
 * Perform an Applicative action `n` times, and accumulate all the results
 * @function
 */
function replicateA(applicative, unfoldableTraversable) {
    return function (n) { return function (ma) { return Traversable_1.sequence(applicative, unfoldableTraversable)(exports.replicate(unfoldableTraversable)(n)(ma)); }; };
}
exports.replicateA = replicateA;
//# sourceMappingURL=Unfoldable.js.map