import { HKT, HKTS, HKT2S, HKTAs, HKT2As } from './HKT';
import { Functor } from './Functor';
import { Applicative } from './Applicative';
import { Semigroup } from './Semigroup';
import { FantasyApply } from './Apply';
import { Foldable, FantasyFoldable } from './Foldable';
import { Setoid } from './Setoid';
import { Traversable, FantasyTraversable } from './Traversable';
import { Alt, FantasyAlt } from './Alt';
import { Predicate } from './function';
import { Option } from './Option';
import { Either } from './Either';
declare module './HKT' {
    interface URI2HKT2<L, A> {
        Validation: Validation<L, A>;
    }
}
export declare const URI = "Validation";
export declare type URI = typeof URI;
/**
 * A data-type like Either but with an accumulating `Applicative`
 * @data
 * @constructor Failure
 * @constructor Success
 */
export declare type Validation<L, A> = Failure<L, A> | Success<L, A>;
export declare class Failure<L, A> implements FantasyApply<URI, A>, FantasyFoldable<A>, FantasyTraversable<URI, A>, FantasyAlt<URI, A> {
    readonly semigroup: Semigroup<L>;
    readonly value: L;
    readonly _tag: 'Failure';
    readonly _L: L;
    readonly _A: A;
    readonly _URI: URI;
    constructor(semigroup: Semigroup<L>, value: L);
    map<B>(f: (a: A) => B): Validation<L, B>;
    ap<B>(fab: Validation<L, (a: A) => B>): Validation<L, B>;
    ap_<B, C>(this: Validation<L, (a: B) => C>, fb: Validation<L, B>): Validation<L, C>;
    bimap<M>(S: Semigroup<M>): <B>(f: (l: L) => M, g: (a: A) => B) => Validation<M, B>;
    alt(fy: Validation<L, A>): Validation<L, A>;
    reduce<B>(f: (b: B, a: A) => B, b: B): B;
    traverse<F extends HKT2S>(F: Applicative<F>): <M, B>(f: (a: A) => HKT2As<F, M, B>) => HKT2As<F, M, Validation<L, B>>;
    traverse<F extends HKTS>(F: Applicative<F>): <B>(f: (a: A) => HKTAs<F, B>) => HKTAs<F, Validation<L, B>>;
    traverse<F>(F: Applicative<F>): <B>(f: (a: A) => HKT<F, B>) => HKT<F, Validation<L, B>>;
    fold<B>(failure: (l: L) => B, success: (a: A) => B): B;
    equals(SL: Setoid<L>, SA: Setoid<A>): (fy: Validation<L, A>) => boolean;
    concat(fy: Validation<L, A>): Validation<L, A>;
    mapFailure<M>(S: Semigroup<M>): (f: (l: L) => M) => Validation<M, A>;
    swap(S: Semigroup<A>): Validation<A, L>;
    toOption(): Option<A>;
    toEither(): Either<L, A>;
    inspect(): string;
    toString(): string;
    /** Returns `true` if the validation is an instance of `Failure`, `false` otherwise */
    isFailure(): boolean;
    /** Returns `true` if the validation is an instance of `Success`, `false` otherwise */
    isSuccess(): boolean;
}
export declare class Success<L, A> implements FantasyApply<URI, A>, FantasyFoldable<A>, FantasyTraversable<URI, A>, FantasyAlt<URI, A> {
    readonly value: A;
    readonly _tag: 'Success';
    readonly _L: L;
    readonly _A: A;
    readonly _URI: URI;
    constructor(value: A);
    map<B>(f: (a: A) => B): Validation<L, B>;
    ap<B>(fab: Validation<L, (a: A) => B>): Validation<L, B>;
    ap_<B, C>(this: Validation<L, (a: B) => C>, fb: Validation<L, B>): Validation<L, C>;
    bimap<M>(S: Semigroup<M>): <B>(f: (l: L) => M, g: (a: A) => B) => Validation<M, B>;
    alt(fy: Validation<L, A>): Validation<L, A>;
    reduce<B>(f: (b: B, a: A) => B, b: B): B;
    traverse<F extends HKT2S>(F: Applicative<F>): <M, B>(f: (a: A) => HKT2As<F, M, B>) => HKT2As<F, M, Validation<L, B>>;
    traverse<F extends HKTS>(F: Applicative<F>): <B>(f: (a: A) => HKTAs<F, B>) => HKTAs<F, Validation<L, B>>;
    traverse<F>(F: Applicative<F>): <B>(f: (a: A) => HKT<F, B>) => HKT<F, Validation<L, B>>;
    fold<B>(failure: (l: L) => B, success: (a: A) => B): B;
    equals(SL: Setoid<L>, SA: Setoid<A>): (fy: Validation<L, A>) => boolean;
    concat(fy: Validation<L, A>): Validation<L, A>;
    mapFailure<M>(S: Semigroup<M>): (f: (l: L) => M) => Validation<M, A>;
    swap(S: Semigroup<A>): Validation<A, L>;
    toOption(): Option<A>;
    toEither(): Either<L, A>;
    inspect(): string;
    toString(): string;
    isFailure(): boolean;
    isSuccess(): boolean;
}
/** @function */
export declare const fold: <L, A, B>(failure: (l: L) => B, success: (a: A) => B) => (fa: Validation<L, A>) => B;
/** @function */
export declare const getSetoid: <L, A>(SL: Setoid<L>, SA: Setoid<A>) => Setoid<Validation<L, A>>;
/** @function */
export declare const map: <L, A, B>(f: (a: A) => B, fa: Validation<L, A>) => Validation<L, B>;
/** @function */
export declare const of: <L, A>(a: A) => Validation<L, A>;
/** @function */
export declare const ap: <L, A, B>(fab: Validation<L, (a: A) => B>, fa: Validation<L, A>) => Validation<L, B>;
/** @function */
export declare const bimap: <M>(S: Semigroup<M>) => <L, A, B>(f: (l: L) => M, g: (a: A) => B) => (fa: Validation<L, A>) => Validation<M, B>;
/** @function */
export declare const alt: <L, A>(fx: Validation<L, A>, fy: Validation<L, A>) => Validation<L, A>;
/** @function */
export declare const reduce: <L, A, B>(f: (b: B, a: A) => B, b: B, fa: Validation<L, A>) => B;
export declare function traverse<F extends HKT2S>(F: Applicative<F>): <M, L, A, B>(f: (a: A) => HKT2As<F, M, B>, ta: Validation<L, A>) => HKT2As<F, M, Validation<L, B>>;
export declare function traverse<F extends HKTS>(F: Applicative<F>): <L, A, B>(f: (a: A) => HKTAs<F, B>, ta: Validation<L, A>) => HKTAs<F, Validation<L, B>>;
export declare function traverse<F>(F: Applicative<F>): <L, A, B>(f: (a: A) => HKT<F, B>, ta: HKT<URI, A>) => HKT<F, Validation<L, B>>;
/**
 * Returns `true` if the validation is an instance of `Failure`, `false` otherwise
 * @function
 */
export declare const isFailure: <L, A>(fa: Validation<L, A>) => fa is Failure<L, A>;
/**
 * Returns `true` if the validation is an instance of `Success`, `false` otherwise
 * @function
 */
export declare const isSuccess: <L, A>(fa: Validation<L, A>) => fa is Success<L, A>;
/** @function */
export declare const failure: <L>(L: Semigroup<L>) => <A>(l: L) => Validation<L, A>;
/**
 * @function
 * @alias of
 */
export declare const success: <L, A>(a: A) => Validation<L, A>;
/** @function */
export declare const fromPredicate: <L>(S: Semigroup<L>) => <A>(predicate: Predicate<A>, f: (a: A) => L) => (a: A) => Validation<L, A>;
/** @function */
export declare const fromEither: <L>(S: Semigroup<L>) => <A>(e: Either<L, A>) => Validation<L, A>;
/** @function */
export declare const concat: <L, A>(fx: Validation<L, A>) => (fy: Validation<L, A>) => Validation<L, A>;
/** @function */
export declare const mapFailure: <M>(S: Semigroup<M>) => <L>(f: (l: L) => M) => <A>(fa: Validation<L, A>) => Validation<M, A>;
/** @function */
export declare const swap: <L, A>(S: Semigroup<A>) => (fa: Validation<L, A>) => Validation<A, L>;
/** @function */
export declare const toOption: <L, A>(fa: Validation<L, A>) => Option<A>;
/** @function */
export declare const toEither: <L, A>(fa: Validation<L, A>) => Either<L, A>;
/** @instance */
export declare const validation: Semigroup<Validation<any, any>> & Functor<URI> & Applicative<URI> & Foldable<URI> & Traversable<URI> & Alt<URI>;
