"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var function_1 = require("./function");
var Option_1 = require("./Option");
var Either_1 = require("./Either");
exports.URI = 'Validation';
var Failure = /** @class */ (function () {
    function Failure(semigroup, value) {
        this.semigroup = semigroup;
        this.value = value;
        this._tag = 'Failure';
    }
    Failure.prototype.map = function (f) {
        return this;
    };
    Failure.prototype.ap = function (fab) {
        if (exports.isFailure(fab)) {
            return exports.failure(this.semigroup)(this.semigroup.concat(fab.value)(this.value));
        }
        return this;
    };
    Failure.prototype.ap_ = function (fb) {
        return fb.ap(this);
    };
    Failure.prototype.bimap = function (S) {
        var _this = this;
        return function (f, g) { return exports.failure(S)(f(_this.value)); };
    };
    Failure.prototype.alt = function (fy) {
        return fy;
    };
    Failure.prototype.reduce = function (f, b) {
        return b;
    };
    Failure.prototype.traverse = function (F) {
        var _this = this;
        return function (f) { return F.of(_this); };
    };
    Failure.prototype.fold = function (failure, success) {
        return failure(this.value);
    };
    Failure.prototype.equals = function (SL, SA) {
        var _this = this;
        return function (fy) { return fy.fold(SL.equals(_this.value), function_1.constFalse); };
    };
    Failure.prototype.concat = function (fy) {
        var _this = this;
        return fy.fold(function (l) { return exports.failure(_this.semigroup)(_this.semigroup.concat(l)(_this.value)); }, function () { return _this; });
    };
    Failure.prototype.mapFailure = function (S) {
        var _this = this;
        return function (f) { return exports.failure(S)(f(_this.value)); };
    };
    Failure.prototype.swap = function (S) {
        return exports.success(this.value);
    };
    Failure.prototype.toOption = function () {
        return Option_1.none;
    };
    Failure.prototype.toEither = function () {
        return Either_1.left(this.value);
    };
    Failure.prototype.inspect = function () {
        return this.toString();
    };
    Failure.prototype.toString = function () {
        return "failure(" + function_1.toString(this.value) + ")";
    };
    /** Returns `true` if the validation is an instance of `Failure`, `false` otherwise */
    Failure.prototype.isFailure = function () {
        return true;
    };
    /** Returns `true` if the validation is an instance of `Success`, `false` otherwise */
    Failure.prototype.isSuccess = function () {
        return false;
    };
    return Failure;
}());
exports.Failure = Failure;
var Success = /** @class */ (function () {
    function Success(value) {
        this.value = value;
        this._tag = 'Success';
    }
    Success.prototype.map = function (f) {
        return new Success(f(this.value));
    };
    Success.prototype.ap = function (fab) {
        if (exports.isSuccess(fab)) {
            return this.map(fab.value);
        }
        return fab;
    };
    Success.prototype.ap_ = function (fb) {
        return fb.ap(this);
    };
    Success.prototype.bimap = function (S) {
        var _this = this;
        return function (f, g) { return exports.success(g(_this.value)); };
    };
    Success.prototype.alt = function (fy) {
        return this;
    };
    Success.prototype.reduce = function (f, b) {
        return f(b, this.value);
    };
    Success.prototype.traverse = function (F) {
        var _this = this;
        return function (f) { return F.map(function (b) { return exports.of(b); }, f(_this.value)); };
    };
    Success.prototype.fold = function (failure, success) {
        return success(this.value);
    };
    Success.prototype.equals = function (SL, SA) {
        var _this = this;
        return function (fy) { return fy.fold(function_1.constFalse, function (y) { return SA.equals(_this.value)(y); }); };
    };
    Success.prototype.concat = function (fy) {
        return this;
    };
    Success.prototype.mapFailure = function (S) {
        var _this = this;
        return function (f) { return _this; };
    };
    Success.prototype.swap = function (S) {
        return exports.failure(S)(this.value);
    };
    Success.prototype.toOption = function () {
        return Option_1.some(this.value);
    };
    Success.prototype.toEither = function () {
        return Either_1.right(this.value);
    };
    Success.prototype.inspect = function () {
        return this.toString();
    };
    Success.prototype.toString = function () {
        return "success(" + function_1.toString(this.value) + ")";
    };
    Success.prototype.isFailure = function () {
        return false;
    };
    Success.prototype.isSuccess = function () {
        return true;
    };
    return Success;
}());
exports.Success = Success;
/** @function */
exports.fold = function (failure, success) { return function (fa) {
    return fa.fold(failure, success);
}; };
/** @function */
exports.getSetoid = function (SL, SA) {
    return {
        equals: function (x) { return function (y) {
            return x.fold(function (lx) { return y.fold(function (ly) { return SL.equals(lx)(ly); }, function_1.constFalse); }, function (ax) { return y.fold(function_1.constFalse, function (ay) { return SA.equals(ax)(ay); }); });
        }; }
    };
};
/** @function */
exports.map = function (f, fa) {
    return fa.map(f);
};
/** @function */
exports.of = function (a) {
    return new Success(a);
};
/** @function */
exports.ap = function (fab, fa) {
    return fa.ap(fab);
};
/** @function */
exports.bimap = function (S) { return function (f, g) { return function (fa) {
    return fa.bimap(S)(f, g);
}; }; };
/** @function */
exports.alt = function (fx, fy) {
    return fx.alt(fy);
};
/** @function */
exports.reduce = function (f, b, fa) {
    return fa.reduce(f, b);
};
/** @function */
function traverse(F) {
    return function (f, ta) { return ta.traverse(F)(f); };
}
exports.traverse = traverse;
/**
 * Returns `true` if the validation is an instance of `Failure`, `false` otherwise
 * @function
 */
exports.isFailure = function (fa) {
    return fa.isFailure();
};
/**
 * Returns `true` if the validation is an instance of `Success`, `false` otherwise
 * @function
 */
exports.isSuccess = function (fa) {
    return fa.isSuccess();
};
/** @function */
exports.failure = function (L) { return function (l) {
    return new Failure(L, l);
}; };
/**
 * @function
 * @alias of
 */
exports.success = exports.of;
/** @function */
exports.fromPredicate = function (S) { return function (predicate, f) { return function (a) {
    return predicate(a) ? exports.success(a) : exports.failure(S)(f(a));
}; }; };
/** @function */
exports.fromEither = function (S) {
    var f = exports.failure(S);
    return function (e) { return e.fold(function (l) { return f(l); }, function (a) { return exports.success(a); }); };
};
/** @function */
exports.concat = function (fx) { return function (fy) {
    return fx.concat(fy);
}; };
/** @function */
exports.mapFailure = function (S) { return function (f) { return function (fa) {
    return fa.mapFailure(S)(f);
}; }; };
/** @function */
exports.swap = function (S) { return function (fa) {
    return fa.swap(S);
}; };
/** @function */
exports.toOption = function (fa) {
    return fa.toOption();
};
/** @function */
exports.toEither = function (fa) {
    return fa.toEither();
};
/** @instance */
exports.validation = {
    URI: exports.URI,
    ap: exports.ap,
    map: exports.map,
    of: exports.of,
    concat: exports.concat,
    reduce: exports.reduce,
    traverse: traverse,
    alt: exports.alt
};
//# sourceMappingURL=Validation.js.map