import { Monoid } from './Monoid';
import { Functor } from './Functor';
import { Monad, FantasyMonad } from './Monad';
import { Lazy } from './function';
declare module './HKT' {
    interface URI2HKT2<L, A> {
        Writer: Writer<L, A>;
    }
}
export declare const URI = "Writer";
export declare type URI = typeof URI;
/**
 * @data
 * @constructor Writer
 */
export declare class Writer<W, A> implements FantasyMonad<URI, A> {
    readonly monoid: Monoid<W>;
    readonly run: Lazy<[A, W]>;
    readonly _L: W;
    readonly _A: A;
    readonly _URI: URI;
    constructor(monoid: Monoid<W>, run: Lazy<[A, W]>);
    eval(): A;
    exec(): W;
    map<B>(f: (a: A) => B): Writer<W, B>;
    ap<B>(fab: Writer<W, (a: A) => B>): Writer<W, B>;
    chain<B>(f: (a: A) => Writer<W, B>): Writer<W, B>;
}
/** @function */
export declare const map: <W, A, B>(f: (a: A) => B, fa: Writer<W, A>) => Writer<W, B>;
/** @function */
export declare const of: <W>(M: Monoid<W>) => <A>(a: A) => Writer<W, A>;
/** @function */
export declare const ap: <W, A, B>(fab: Writer<W, (a: A) => B>, fa: Writer<W, A>) => Writer<W, B>;
/** @function */
export declare const chain: <W, A, B>(f: (a: A) => Writer<W, B>, fa: Writer<W, A>) => Writer<W, B>;
/** @function */
export declare const tell: <W>(M: Monoid<W>) => (w: W) => Writer<W, void>;
/** @function */
export declare const getMonad: <W>(monoid: Monoid<W>) => Monad<"Writer">;
/** @instance */
export declare const writer: Functor<URI>;
