"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.URI = 'Writer';
/**
 * @data
 * @constructor Writer
 */
var Writer = /** @class */ (function () {
    function Writer(monoid, run) {
        this.monoid = monoid;
        this.run = run;
    }
    Writer.prototype.eval = function () {
        return this.run()[0];
    };
    Writer.prototype.exec = function () {
        return this.run()[1];
    };
    Writer.prototype.map = function (f) {
        var _a = this.run(), a = _a[0], w = _a[1];
        return new Writer(this.monoid, function () { return [f(a), w]; });
    };
    Writer.prototype.ap = function (fab) {
        var _this = this;
        return fab.chain(function (f) { return _this.map(f); });
    };
    Writer.prototype.chain = function (f) {
        var _this = this;
        return new Writer(this.monoid, function () {
            var _a = _this.run(), a = _a[0], w1 = _a[1];
            var _b = f(a).run(), b = _b[0], w2 = _b[1];
            return [b, _this.monoid.concat(w1)(w2)];
        });
    };
    return Writer;
}());
exports.Writer = Writer;
/** @function */
exports.map = function (f, fa) {
    return fa.map(f);
};
/** @function */
exports.of = function (M) { return function (a) {
    return new Writer(M, function () { return [a, M.empty()]; });
}; };
/** @function */
exports.ap = function (fab, fa) {
    return fa.ap(fab);
};
/** @function */
exports.chain = function (f, fa) {
    return fa.chain(f);
};
/** @function */
exports.tell = function (M) { return function (w) {
    return new Writer(M, function () { return [undefined, w]; });
}; };
/** @function */
exports.getMonad = function (monoid) {
    return {
        URI: exports.URI,
        map: exports.map,
        of: exports.of(monoid),
        ap: exports.ap,
        chain: exports.chain
    };
};
/** @instance */
exports.writer = {
    URI: exports.URI,
    map: exports.map
};
//# sourceMappingURL=Writer.js.map