declare const _default: {
    '.uk-input, .uk-select, .uk-textarea, .uk-radio, .uk-checkbox': {
        boxSizing: string;
        margin: string;
        borderRadius: string;
        font: string;
    };
    '.uk-input': {
        overflow: string;
    };
    '.uk-select': {
        textTransform: string;
    };
    '.uk-select optgroup': {
        font: string;
        fontWeight: string;
    };
    '.uk-textarea': {
        overflow: string;
    };
    '.uk-input[type="search"]::-webkit-search-cancel-button, .uk-input[type="search"]::-webkit-search-decoration': {
        WebkitAppearance: string;
    };
    '.uk-input[type="number"]::-webkit-inner-spin-button, .uk-input[type="number"]::-webkit-outer-spin-button': {
        height: string;
    };
    '.uk-input::-moz-placeholder, .uk-textarea::-moz-placeholder': {
        opacity: string;
    };
    '.uk-radio:not(:disabled), .uk-checkbox:not(:disabled)': {
        cursor: string;
    };
    '.uk-fieldset': {
        border: string;
        margin: string;
        padding: string;
        minWidth: string;
    };
    '.uk-input, .uk-textarea': {
        WebkitAppearance: string;
    };
    '.uk-input, .uk-select, .uk-textarea, .uk-input-fake': {
        maxWidth: string;
        width: string;
        borderRadius: string;
        boxShadow: string;
        padding: string;
        fontSize: string;
        lineHeight: string;
        '@apply border border-input bg-transparent text-foreground': {};
    };
    '.uk-input, .uk-select:not([multiple]):not([size])': {
        verticalAlign: string;
        display: string;
        height: string;
    };
    '.uk-select[multiple], .uk-select[size], .uk-textarea': {
        verticalAlign: string;
        minHeight: string;
        '@apply py-2.5': {};
    };
    '.uk-select[multiple], .uk-select[size]': {
        resize: string;
    };
    '.uk-input:focus, .uk-select:focus, .uk-textarea:focus, .uk-input-fake:focus': {
        outline: string;
        '@apply outline-none ring-1 ring-ring': {};
    };
    '.uk-input:disabled, .uk-select:disabled, .uk-textarea:disabled, .uk-input-fake:disabled': {
        '@apply opacity-50': {};
    };
    '.uk-input::placeholder': {
        '@apply text-muted-foreground': {};
    };
    '.uk-textarea::placeholder': {
        '@apply text-muted-foreground': {};
    };
    '.uk-form-destructive, .uk-form-destructive:focus': {
        '@apply ring-destructive': {};
    };
    '.uk-form-blank': {
        background: string;
        borderColor: string;
        '@apply shadow-none': {};
    };
    '.uk-form-blank:focus': {
        '@apply ring-0': {};
    };
    '.uk-select:not([multiple]):not([size])': {
        WebkitAppearance: string;
        MozAppearance: string;
        backgroundImage: string;
        backgroundRepeat: string;
        backgroundPosition: string;
        '@apply pr-6': {};
    };
    '.uk-select:not([multiple]):not([size]) option': {
        color: string;
    };
    '.uk-input[list]': {
        paddingRight: string;
        backgroundRepeat: string;
        backgroundPosition: string;
    };
    '.uk-input[list]:hover, .uk-input[list]:focus': {
        backgroundImage: string;
    };
    '.uk-input[list]::-webkit-calendar-picker-indicator': {
        display: string;
    };
    '.uk-radio, .uk-checkbox': {
        display: string;
        height: string;
        width: string;
        overflow: string;
        marginTop: string;
        verticalAlign: string;
        WebkitAppearance: string;
        MozAppearance: string;
        backgroundRepeat: string;
        backgroundPosition: string;
        borderRadius: string;
        boxShadow: string;
        '@apply border border-primary': {};
    };
    '.uk-radio': {
        borderRadius: string;
    };
    '.uk-radio:focus, .uk-checkbox:focus': {
        outline: string;
        '@apply outline-none ring-1 ring-ring': {};
    };
    '.uk-radio:checked:focus, .uk-checkbox:checked:focus, .uk-checkbox:indeterminate:focus': {
        '@apply outline-none ring-1 ring-ring': {};
    };
    '.uk-radio:checked': {
        backgroundImage: string;
    };
    '.uk-checkbox:checked': {
        backgroundImage: string;
    };
    '.uk-checkbox:indeterminate': {
        backgroundImage: string;
    };
    '.uk-form-label': {
        '@apply text-sm font-medium leading-none': {};
    };
    '.uk-form-label-required::after': {
        content: string;
        '@apply text-destructive': {};
    };
    '.uk-form-stacked .uk-form-label': {
        display: string;
        marginBottom: string;
    };
    '.uk-form-icon': {
        position: string;
        top: string;
        bottom: string;
        left: string;
        width: string;
        display: string;
        justifyContent: string;
        alignItems: string;
    };
    '.uk-form-icon:not(a):not(button):not(input)': {
        pointerEvents: string;
    };
    '.uk-form-icon:not(.uk-form-icon-flip) ~ .uk-input': {
        paddingLeft: string;
    };
    '.uk-form-icon-flip': {
        right: string;
        left: string;
    };
    '.uk-form-icon-flip ~ .uk-input': {
        paddingRight: string;
    };
    '.uk-toggle-switch': {
        WebkitAppearance: string;
        MozAppearance: string;
        appearance: string;
        position: string;
        boxSizing: string;
        borderRadius: string;
        boxShadow: string;
        '@apply h-5 w-9 bg-input focus-visible:outline-dotted focus-visible:outline-ring': {};
    };
    '.uk-toggle-switch::before': {
        content: string;
        position: string;
        top: string;
        left: string;
        transform: string;
        boxSizing: string;
        borderRadius: string;
        transitionProperty: string;
        transitionDuration: string;
        transitionTimingFunction: string;
        marginLeft: string;
        '@apply h-4 w-4 bg-background': {};
    };
    '.uk-toggle-switch:checked::before': {
        '@apply left-4': {};
    };
    '.uk-toggle-switch:disabled': {
        opacity: string;
    };
    '.uk-toggle-switch-primary:checked': {
        '@apply bg-primary': {};
    };
    '.uk-toggle-switch-destructive:checked': {
        '@apply bg-destructive': {};
    };
    '.uk-form-help': {
        fontSize: string;
        '@apply font-medium': {};
    };
    "[class*='uk-inline']": {
        display: string;
        position: string;
        maxWidth: string;
        verticalAlign: string;
        WebkitBackfaceVisibility: string;
    };
    '.uk-input-pin': {
        borderRadius: string;
        boxShadow: string;
        '@apply inline-flex items-center': {};
    };
    '.uk-input-pin input': {
        height: string;
        width: string;
        fontSize: string;
        lineHeight: string;
        '@apply relative -mr-[1px] flex border border-input bg-transparent text-center placeholder-muted-foreground focus:z-10 focus:outline-none focus:ring-1 focus:ring-ring': {};
    };
    '.uk-input-pin.uk-form-destructive input': {
        '@apply ring-destructive': {};
    };
    '.uk-input-pin input:focus': {
        '@apply placeholder:text-background': {};
    };
    '.uk-input-pin.uk-disabled input, .uk-input-pin input:disabled': {
        '@apply opacity-50': {};
    };
    '.uk-input-pin input:first-child': {
        borderTopLeftRadius: string;
        borderBottomLeftRadius: string;
    };
    '.uk-input-pin input:last-child': {
        borderTopRightRadius: string;
        borderBottomRightRadius: string;
    };
    '.uk-input-pin.uk-input-pin-separated': {
        '@apply gap-2 shadow-none': {};
    };
    '.uk-input-pin.uk-input-pin-separated input': {
        borderRadius: string;
        boxShadow: string;
        '@apply -mr-0': {};
    };
    '.uk-input-tag': {
        boxShadow: string;
        borderRadius: string;
        '@apply border-input bg-transparent has-[input:focus]:ring-ring flex min-h-10 flex-wrap items-center gap-1 border p-2 has-[input:focus]:ring-1': {};
    };
    '.uk-input-tag.uk-disabled': {
        '@apply opacity-50': {};
    };
    '.uk-input-tag input': {
        '@apply placeholder-muted-foreground text-foreground min-h-7 flex-1 bg-transparent px-1 focus:outline-none': {};
    };
    '.uk-input-tag.uk-form-destructive': {
        '@apply has-[input:focus]:ring-destructive': {};
    };
    '.uk-cs-search': {
        '@apply flex items-center px-3': {};
    };
    '.uk-cs-search svg': {
        '@apply mr-2 opacity-50': {};
    };
    '.uk-cs-search input': {
        '@apply placeholder-muted-foreground w-full bg-transparent py-3 focus:outline-none': {};
    };
    '.uk-cs-options': {
        '@apply max-h-40': {};
    };
    '.uk-cs-item-wrapper': {
        '@apply flex flex-1 items-center': {};
    };
    '.uk-cs-item-icon': {
        '@apply mr-2 flex-none': {};
    };
    '.uk-cs-item-text': {
        '@apply flex-1': {};
    };
    '.uk-cs-check': {
        '@apply ml-2 flex-none': {};
    };
    '.uk-input-fake': {
        height: string;
        '@apply flex items-center': {};
    };
    '.uk-form-custom': {
        display: string;
        position: string;
        maxWidth: string;
        verticalAlign: string;
    };
    '.uk-form-custom select, .uk-form-custom input[type="file"]': {
        position: string;
        top: string;
        zIndex: string;
        width: string;
        height: string;
        left: string;
        WebkitAppearance: string;
        opacity: string;
        cursor: string;
    };
    '.uk-form-custom input[type="file"]': {
        fontSize: string;
        overflow: string;
    };
};
export default _default;
