import plugin from 'tailwindcss/plugin.js';
import { theme, base, palettes, components } from './context.js';
import merger from './merger.js';
export const variables = {
    '.uk-theme-zinc': {
        '--background': '0 0% 100%',
        '--foreground': '240 10% 3.9%',
        '--muted': '240 4.8% 95.9%',
        '--muted-foreground': '240 3.8% 46.1%',
        '--popover': '0 0% 100%',
        '--popover-foreground': '240 10% 3.9%',
        '--card': '0 0% 100%',
        '--card-foreground': '240 10% 3.9%',
        '--border': '240 5.9% 90%',
        '--input': '240 5.9% 90%',
        '--primary': '240 5.9% 10%',
        '--primary-foreground': '0 0% 98%',
        '--secondary': '240 4.8% 95.9%',
        '--secondary-foreground': '240 5.9% 10%',
        '--accent': '240 4.8% 95.9%',
        '--accent-foreground': '240 5.9% 10%',
        '--destructive': '0 84.2% 60.2%',
        '--destructive-foreground': '0 0% 98%',
        '--ring': '240 5.9% 10%'
    },
    '.dark.uk-theme-zinc': {
        '--background': '240 10% 3.9%',
        '--foreground': '0 0% 98%',
        '--muted': '240 3.7% 15.9%',
        '--muted-foreground': '240 5% 64.9%',
        '--popover': '240 10% 3.9%',
        '--popover-foreground': '0 0% 98%',
        '--card': '240 10% 3.9%',
        '--card-foreground': '0 0% 98%',
        '--border': '240 3.7% 15.9%',
        '--input': '240 3.7% 15.9%',
        '--primary': '0 0% 98%',
        '--primary-foreground': '240 5.9% 10%',
        '--secondary': '240 3.7% 15.9%',
        '--secondary-foreground': '0 0% 98%',
        '--accent': '240 3.7% 15.9%',
        '--accent-foreground': '0 0% 98%',
        '--destructive': '0 62.8% 30.6%',
        '--destructive-foreground': '0 0% 98%',
        '--ring': '240 4.9% 83.9%',
        '--destructive-alpha': '1',
        '--border-alpha': '1',
        '--input-alpha': '1'
    },
    '.uk-theme-slate': {
        '--background': '0 0% 100%',
        '--foreground': '222.2 84% 4.9%',
        '--muted': '210 40% 96.1%',
        '--muted-foreground': '215.4 16.3% 46.9%',
        '--popover': '0 0% 100%',
        '--popover-foreground': '222.2 84% 4.9%',
        '--card': '0 0% 100%',
        '--card-foreground': '222.2 84% 4.9%',
        '--border': '214.3 31.8% 91.4%',
        '--input': '214.3 31.8% 91.4%',
        '--primary': '222.2 47.4% 11.2%',
        '--primary-foreground': '210 40% 98%',
        '--secondary': '210 40% 96.1%',
        '--secondary-foreground': '222.2 47.4% 11.2%',
        '--accent': '210 40% 96.1%',
        '--accent-foreground': '222.2 47.4% 11.2%',
        '--destructive': '0 84.2% 60.2%',
        '--destructive-foreground': '210 40% 98%',
        '--ring': '222.2 84% 4.9%'
    },
    '.dark.uk-theme-slate': {
        '--background': '222.2 84% 4.9%',
        '--foreground': '210 40% 98%',
        '--muted': '217.2 32.6% 17.5%',
        '--muted-foreground': '215 20.2% 65.1%',
        '--popover': '222.2 84% 4.9%',
        '--popover-foreground': '210 40% 98%',
        '--card': '222.2 84% 4.9%',
        '--card-foreground': '210 40% 98%',
        '--border': '217.2 32.6% 17.5%',
        '--input': '217.2 32.6% 17.5%',
        '--primary': '210 40% 98%',
        '--primary-foreground': '222.2 47.4% 11.2%',
        '--secondary': '217.2 32.6% 17.5%',
        '--secondary-foreground': '210 40% 98%',
        '--accent': '217.2 32.6% 17.5%',
        '--accent-foreground': '210 40% 98%',
        '--destructive': '0 62.8% 30.6%',
        '--destructive-foreground': '210 40% 98%',
        '--ring': '212.7 26.8% 83.9',
        '--destructive-alpha': '1',
        '--border-alpha': '1',
        '--input-alpha': '1'
    },
    '.uk-theme-stone': {
        '--background': '0 0% 100%',
        '--foreground': '0 0% 4%',
        '--muted': '0 0% 96%',
        '--muted-foreground': '0 0% 45%',
        '--popover': '0 0% 100%',
        '--popover-foreground': '0 0% 4%',
        '--card': '0 0% 100%',
        '--card-foreground': '0 0% 4%',
        '--border': '0 0% 90%',
        '--input': '0 0% 90%',
        '--primary': '33.3 5.5% 32.4%',
        '--primary-foreground': '60 9.1% 97.8%',
        '--secondary': '0 0% 96%',
        '--secondary-foreground': '0 0% 9%',
        '--accent': '0 0% 96%',
        '--accent-foreground': '0 0% 9%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '24 5.4% 63.9%'
    },
    '.dark.uk-theme-stone': {
        '--background': '0 0% 4%',
        '--foreground': '0 0% 98%',
        '--muted': '0 0% 15%',
        '--muted-foreground': '0 0% 63%',
        '--popover': '0 0% 15%',
        '--popover-foreground': '0 0% 98%',
        '--card': '0 0% 9%',
        '--card-foreground': '0 0% 98%',
        '--border': '0 0% 100%',
        '--input': '0 0% 100%',
        '--primary': '25 5.3% 44.7%',
        '--primary-foreground': '60 9.1% 97.8%',
        '--secondary': '0 0% 15%',
        '--secondary-foreground': '0 0% 98%',
        '--accent': '0 0% 25%',
        '--accent-foreground': '0 0% 98%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '24 9.8% 10%'
    },
    '.uk-theme-gray': {
        '--background': '0 0% 100%',
        '--foreground': '224 71.4% 4.1%',
        '--muted': '220 14.3% 95.9%',
        '--muted-foreground': '220 8.9% 46.1%',
        '--popover': '0 0% 100%',
        '--popover-foreground': '224 71.4% 4.1%',
        '--card': '0 0% 100%',
        '--card-foreground': '224 71.4% 4.1%',
        '--border': '220 13% 91%',
        '--input': '220 13% 91%',
        '--primary': '220.9 39.3% 11%',
        '--primary-foreground': '210 20% 98%',
        '--secondary': '220 14.3% 95.9%',
        '--secondary-foreground': '220.9 39.3% 11%',
        '--accent': '220 14.3% 95.9%',
        '--accent-foreground': '220.9 39.3% 11%',
        '--destructive': '0 84.2% 60.2%',
        '--destructive-foreground': '210 20% 98%',
        '--ring': '224 71.4% 4.1%'
    },
    '.dark.uk-theme-gray': {
        '--background': '224 71.4% 4.1%',
        '--foreground': '210 20% 98%',
        '--muted': '215 27.9% 16.9%',
        '--muted-foreground': '217.9 10.6% 64.9%',
        '--popover': '224 71.4% 4.1%',
        '--popover-foreground': '210 20% 98%',
        '--card': '224 71.4% 4.1%',
        '--card-foreground': '210 20% 98%',
        '--border': '215 27.9% 16.9%',
        '--input': '215 27.9% 16.9%',
        '--primary': '210 20% 98%',
        '--primary-foreground': '220.9 39.3% 11%',
        '--secondary': '215 27.9% 16.9%',
        '--secondary-foreground': '210 20% 98%',
        '--accent': '215 27.9% 16.9%',
        '--accent-foreground': '210 20% 98%',
        '--destructive': '0 62.8% 30.6%',
        '--destructive-foreground': '210 20% 98%',
        '--ring': '216 12.2% 83.9%',
        '--destructive-alpha': '1',
        '--border-alpha': '1',
        '--input-alpha': '1'
    },
    '.uk-theme-neutral': {
        '--background': '0 0% 100%',
        '--foreground': '0 0% 4%',
        '--card': '0 0% 100%',
        '--card-foreground': '0 0% 4%',
        '--popover': '0 0% 100%',
        '--popover-foreground': '0 0% 4%',
        '--primary': '0 0% 9%',
        '--primary-foreground': '0 0% 98%',
        '--secondary': '0 0% 96%',
        '--secondary-foreground': '0 0% 9%',
        '--muted': '0 0% 96%',
        '--muted-foreground': '0 0% 45%',
        '--accent': '0 0% 96%',
        '--accent-foreground': '0 0% 9%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--border': '0 0% 90%',
        '--input': '0 0% 90%',
        '--ring': '0 0% 63%'
    },
    '.dark.uk-theme-neutral': {
        '--background': '0 0% 4%',
        '--foreground': '0 0% 98%',
        '--card': '0 0% 9%',
        '--card-foreground': '0 0% 98%',
        '--popover': '0 0% 15%',
        '--popover-foreground': '0 0% 98%',
        '--primary': '0 0% 90%',
        '--primary-foreground': '0 0% 9%',
        '--secondary': '0 0% 15%',
        '--secondary-foreground': '0 0% 98%',
        '--muted': '0 0% 15%',
        '--muted-foreground': '0 0% 63%',
        '--accent': '0 0% 25%',
        '--accent-foreground': '0 0% 98%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--border': '0 0% 100%',
        '--input': '0 0% 100%',
        '--ring': '0 0% 45%'
    },
    '.uk-theme-red': {
        '--background': '0 0% 100%',
        '--foreground': '0 0% 4%',
        '--muted': '0 0% 96%',
        '--muted-foreground': '0 0% 45%',
        '--popover': '0 0% 100%',
        '--popover-foreground': '0 0% 4%',
        '--card': '0 0% 100%',
        '--card-foreground': '0 0% 4%',
        '--border': '0 0% 90%',
        '--input': '0 0% 90%',
        '--primary': '0 72.2% 50.6%',
        '--primary-foreground': '0 85.7% 97.3%',
        '--secondary': '0 0% 96%',
        '--secondary-foreground': '0 0% 9%',
        '--accent': '0 0% 96%',
        '--accent-foreground': '0 0% 9%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '0 90.6% 70.8%'
    },
    '.dark.uk-theme-red': {
        '--background': '0 0% 4%',
        '--foreground': '0 0% 98%',
        '--muted': '0 0% 15%',
        '--muted-foreground': '0 0% 63%',
        '--popover': '0 0% 15%',
        '--popover-foreground': '0 0% 98%',
        '--card': '0 0% 9%',
        '--card-foreground': '0 0% 98%',
        '--border': '0 0% 100%',
        '--input': '0 0% 100%',
        '--primary': '0 84.2% 60.2%',
        '--primary-foreground': '0 85.7% 97.3%',
        '--secondary': '0 0% 15%',
        '--secondary-foreground': '0 0% 98%',
        '--accent': '0 0% 25%',
        '--accent-foreground': '0 0% 98%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '0 62.8% 30.6%'
    },
    '.uk-theme-rose': {
        '--background': '0 0% 100%',
        '--foreground': '0 0% 4%',
        '--muted': '0 0% 96%',
        '--muted-foreground': '0 0% 45%',
        '--popover': '0 0% 100%',
        '--popover-foreground': '0 0% 4%',
        '--card': '0 0% 100%',
        '--card-foreground': '0 0% 4%',
        '--border': '0 0% 90%',
        '--input': '0 0% 90%',
        '--primary': '346.8 77.2% 49.8%',
        '--primary-foreground': '355.7 100% 97.3%',
        '--secondary': '0 0% 96%',
        '--secondary-foreground': '0 0% 9%',
        '--accent': '0 0% 96%',
        '--accent-foreground': '0 0% 9%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '351.3 94.5% 71.4%'
    },
    '.dark.uk-theme-rose': {
        '--background': '0 0% 4%',
        '--foreground': '0 0% 98%',
        '--muted': '0 0% 15%',
        '--muted-foreground': '0 0% 63%',
        '--popover': '0 0% 15%',
        '--popover-foreground': '0 0% 98%',
        '--card': '0 0% 9%',
        '--card-foreground': '0 0% 98%',
        '--border': '0 0% 100%',
        '--input': '0 0% 100%',
        '--primary': '349.7 89.2% 60.2%',
        '--primary-foreground': '355.7 100% 97.3%',
        '--secondary': '0 0% 15%',
        '--secondary-foreground': '0 0% 98%',
        '--accent': '0 0% 25%',
        '--accent-foreground': '0 0% 98%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '341.5 75.5% 30.4%'
    },
    '.uk-theme-orange': {
        '--background': '0 0% 100%',
        '--foreground': '0 0% 4%',
        '--muted': '0 0% 96%',
        '--muted-foreground': '0 0% 45%',
        '--popover': '0 0% 100%',
        '--popover-foreground': '0 0% 4%',
        '--card': '0 0% 100%',
        '--card-foreground': '0 0% 4%',
        '--border': '0 0% 90%',
        '--input': '0 0% 90%',
        '--primary': '20.5 90.2% 48.2%',
        '--primary-foreground': '33.3 100% 96.5%',
        '--secondary': '0 0% 96%',
        '--secondary-foreground': '0 0% 9%',
        '--accent': '0 0% 96%',
        '--accent-foreground': '0 0% 9%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '27 96% 61%'
    },
    '.dark.uk-theme-orange': {
        '--background': '0 0% 4%',
        '--foreground': '0 0% 98%',
        '--muted': '0 0% 15%',
        '--muted-foreground': '0 0% 63%',
        '--popover': '0 0% 15%',
        '--popover-foreground': '0 0% 98%',
        '--card': '0 0% 9%',
        '--card-foreground': '0 0% 98%',
        '--border': '0 0% 100%',
        '--input': '0 0% 100%',
        '--primary': '24.6 95% 53.1%',
        '--primary-foreground': '33.3 100% 96.5%',
        '--secondary': '0 0% 15%',
        '--secondary-foreground': '0 0% 98%',
        '--accent': '0 0% 25%',
        '--accent-foreground': '0 0% 98%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '15.3 74.6% 27.8%'
    },
    '.uk-theme-green': {
        '--background': '0 0% 100%',
        '--foreground': '0 0% 4%',
        '--muted': '0 0% 96%',
        '--muted-foreground': '0 0% 45%',
        '--popover': '0 0% 100%',
        '--popover-foreground': '0 0% 4%',
        '--card': '0 0% 100%',
        '--card-foreground': '0 0% 4%',
        '--border': '0 0% 90%',
        '--input': '0 0% 90%',
        '--primary': '84.8 85.2% 34.5%',
        '--primary-foreground': '78.3 92% 95.1%',
        '--secondary': '0 0% 96%',
        '--secondary-foreground': '0 0% 9%',
        '--accent': '0 0% 96%',
        '--accent-foreground': '0 0% 9%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '82.7 78% 55.5%'
    },
    '.dark.uk-theme-green': {
        '--background': '0 0% 4%',
        '--foreground': '0 0% 98%',
        '--muted': '0 0% 15%',
        '--muted-foreground': '0 0% 63%',
        '--popover': '0 0% 15%',
        '--popover-foreground': '0 0% 98%',
        '--card': '0 0% 9%',
        '--card-foreground': '0 0% 98%',
        '--border': '0 0% 100%',
        '--input': '0 0% 100%',
        '--primary': '84.8 85.2% 34.5%',
        '--primary-foreground': '78.3 92% 95.1%',
        '--secondary': '0 0% 15%',
        '--secondary-foreground': '0 0% 98%',
        '--accent': '0 0% 25%',
        '--accent-foreground': '0 0% 98%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '87.6 61.2% 20.2%'
    },
    '.uk-theme-blue': {
        '--background': '0 0% 100%',
        '--foreground': '0 0% 4%',
        '--muted': '0 0% 96%',
        '--muted-foreground': '0 0% 45%',
        '--popover': '0 0% 100%',
        '--popover-foreground': '0 0% 4%',
        '--card': '0 0% 100%',
        '--card-foreground': '0 0% 4%',
        '--border': '0 0% 90%',
        '--input': '0 0% 90%',
        '--primary': '221.2 83.2% 53.3%',
        '--primary-foreground': '213.8 100% 96.9%',
        '--secondary': '0 0% 96%',
        '--secondary-foreground': '0 0% 9%',
        '--accent': '0 0% 96%',
        '--accent-foreground': '0 0% 9%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '213.1 93.9% 67.8%'
    },
    '.dark.uk-theme-blue': {
        '--background': '0 0% 4%',
        '--foreground': '0 0% 98%',
        '--muted': '0 0% 15%',
        '--muted-foreground': '0 0% 63%',
        '--popover': '0 0% 15%',
        '--popover-foreground': '0 0% 98%',
        '--card': '0 0% 9%',
        '--card-foreground': '0 0% 98%',
        '--border': '0 0% 100%',
        '--input': '0 0% 100%',
        '--primary': '217.2 91.2% 59.8%',
        '--primary-foreground': '213.8 100% 96.9%',
        '--secondary': '0 0% 15%',
        '--secondary-foreground': '0 0% 98%',
        '--accent': '0 0% 25%',
        '--accent-foreground': '0 0% 98%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '224.4 64.3% 32.9%'
    },
    '.uk-theme-yellow': {
        '--background': '0 0% 100%',
        '--foreground': '0 0% 4%',
        '--muted': '0 0% 96%',
        '--muted-foreground': '0 0% 45%',
        '--popover': '0 0% 100%',
        '--popover-foreground': '0 0% 4%',
        '--card': '0 0% 100%',
        '--card-foreground': '0 0% 4%',
        '--border': '0 0% 90%',
        '--input': '0 0% 90%',
        '--primary': '47.9 95.8% 53.1%',
        '--primary-foreground': '28.4 72.5% 25.7%',
        '--secondary': '0 0% 96%',
        '--secondary-foreground': '0 0% 9%',
        '--accent': '0 0% 96%',
        '--accent-foreground': '0 0% 9%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '47.9 95.8% 53.1%'
    },
    '.dark.uk-theme-yellow': {
        '--background': '0 0% 4%',
        '--foreground': '0 0% 98%',
        '--muted': '0 0% 15%',
        '--muted-foreground': '0 0% 63%',
        '--popover': '0 0% 15%',
        '--popover-foreground': '0 0% 98%',
        '--card': '0 0% 9%',
        '--card-foreground': '0 0% 98%',
        '--border': '0 0% 100%',
        '--input': '0 0% 100%',
        '--primary': '45.4 93.4% 47.5%',
        '--primary-foreground': '28.4 72.5% 25.7%',
        '--secondary': '0 0% 15%',
        '--secondary-foreground': '0 0% 98%',
        '--accent': '0 0% 25%',
        '--accent-foreground': '0 0% 98%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '28.4 72.5% 25.7%'
    },
    '.uk-theme-violet': {
        '--background': '0 0% 100%',
        '--foreground': '0 0% 4%',
        '--muted': '0 0% 96%',
        '--muted-foreground': '0 0% 45%',
        '--popover': '0 0% 100%',
        '--popover-foreground': '0 0% 4%',
        '--card': '0 0% 100%',
        '--card-foreground': '0 0% 4%',
        '--border': '0 0% 90%',
        '--input': '0 0% 90%',
        '--primary': '262.1 83.3% 57.8%',
        '--primary-foreground': '250 100% 97.6%',
        '--secondary': '0 0% 96%',
        '--secondary-foreground': '0 0% 9%',
        '--accent': '0 0% 96%',
        '--accent-foreground': '0 0% 9%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '255.1 91.7% 76.3%'
    },
    '.dark.uk-theme-violet': {
        '--background': '0 0% 4%',
        '--foreground': '0 0% 98%',
        '--muted': '0 0% 15%',
        '--muted-foreground': '0 0% 63%',
        '--popover': '0 0% 15%',
        '--popover-foreground': '0 0% 98%',
        '--card': '0 0% 9%',
        '--card-foreground': '0 0% 98%',
        '--border': '0 0% 100%',
        '--input': '0 0% 100%',
        '--primary': '258.3 89.5% 66.3%',
        '--primary-foreground': '250 100% 97.6%',
        '--secondary': '0 0% 15%',
        '--secondary-foreground': '0 0% 98%',
        '--accent': '0 0% 25%',
        '--accent-foreground': '0 0% 98%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '263.5 67.4% 34.9%'
    },
    '.uk-theme-amber': {
        '--background': '0 0% 100%',
        '--foreground': '0 0% 4%',
        '--muted': '0 0% 96%',
        '--muted-foreground': '0 0% 45%',
        '--popover': '0 0% 100%',
        '--popover-foreground': '0 0% 4%',
        '--card': '0 0% 100%',
        '--card-foreground': '0 0% 4%',
        '--border': '0 0% 90%',
        '--input': '0 0% 90%',
        '--primary': '32.1 94.6% 43.7%',
        '--primary-foreground': '48 100% 96.1%',
        '--secondary': '0 0% 96%',
        '--secondary-foreground': '0 0% 9%',
        '--accent': '0 0% 96%',
        '--accent-foreground': '0 0% 9%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '43.3 96.4% 56.3%'
    },
    '.dark.uk-theme-amber': {
        '--background': '0 0% 4%',
        '--foreground': '0 0% 98%',
        '--muted': '0 0% 15%',
        '--muted-foreground': '0 0% 63%',
        '--popover': '0 0% 15%',
        '--popover-foreground': '0 0% 98%',
        '--card': '0 0% 9%',
        '--card-foreground': '0 0% 98%',
        '--border': '0 0% 100%',
        '--input': '0 0% 100%',
        '--primary': '37.7 92.1% 50.2%',
        '--primary-foreground': '48 100% 96.1%',
        '--secondary': '0 0% 15%',
        '--secondary-foreground': '0 0% 98%',
        '--accent': '0 0% 25%',
        '--accent-foreground': '0 0% 98%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '21.7 77.8% 26.5%'
    },
    '.uk-theme-purple': {
        '--background': '0 0% 100%',
        '--foreground': '0 0% 4%',
        '--muted': '0 0% 96%',
        '--muted-foreground': '0 0% 45%',
        '--popover': '0 0% 100%',
        '--popover-foreground': '0 0% 4%',
        '--card': '0 0% 100%',
        '--card-foreground': '0 0% 4%',
        '--border': '0 0% 90%',
        '--input': '0 0% 90%',
        '--primary': '271.5 81.3% 55.9%',
        '--primary-foreground': '270 100% 98%',
        '--secondary': '0 0% 96%',
        '--secondary-foreground': '0 0% 9%',
        '--accent': '0 0% 96%',
        '--accent-foreground': '0 0% 9%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '270 95.2% 75.3%'
    },
    '.dark.uk-theme-purple': {
        '--background': '0 0% 4%',
        '--foreground': '0 0% 98%',
        '--muted': '0 0% 15%',
        '--muted-foreground': '0 0% 63%',
        '--popover': '0 0% 15%',
        '--popover-foreground': '0 0% 98%',
        '--card': '0 0% 9%',
        '--card-foreground': '0 0% 98%',
        '--border': '0 0% 100%',
        '--input': '0 0% 100%',
        '--primary': '270.7 91% 65.1%',
        '--primary-foreground': '270 100% 98%',
        '--secondary': '0 0% 15%',
        '--secondary-foreground': '0 0% 98%',
        '--accent': '0 0% 25%',
        '--accent-foreground': '0 0% 98%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '273.6 65.6% 32%'
    },
    '.uk-theme-teal': {
        '--background': '0 0% 100%',
        '--foreground': '0 0% 4%',
        '--muted': '0 0% 96%',
        '--muted-foreground': '0 0% 45%',
        '--popover': '0 0% 100%',
        '--popover-foreground': '0 0% 4%',
        '--card': '0 0% 100%',
        '--card-foreground': '0 0% 4%',
        '--border': '0 0% 90%',
        '--input': '0 0% 90%',
        '--primary': '174.7 83.9% 31.6%',
        '--primary-foreground': '166.2 76.5% 96.7%',
        '--secondary': '0 0% 96%',
        '--secondary-foreground': '0 0% 9%',
        '--accent': '0 0% 96%',
        '--accent-foreground': '0 0% 9%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '172.5 66% 50.4%'
    },
    '.dark.uk-theme-teal': {
        '--background': '0 0% 4%',
        '--foreground': '0 0% 98%',
        '--muted': '0 0% 15%',
        '--muted-foreground': '0 0% 63%',
        '--popover': '0 0% 15%',
        '--popover-foreground': '0 0% 98%',
        '--card': '0 0% 9%',
        '--card-foreground': '0 0% 98%',
        '--border': '0 0% 100%',
        '--input': '0 0% 100%',
        '--primary': '173.4 80.4% 40%',
        '--primary-foreground': '166.2 76.5% 96.7%',
        '--secondary': '0 0% 15%',
        '--secondary-foreground': '0 0% 98%',
        '--accent': '0 0% 25%',
        '--accent-foreground': '0 0% 98%',
        '--destructive': '357 100% 45%',
        '--destructive-foreground': '0 0% 100%',
        '--ring': '175.9 60.8% 19%'
    }
};
export default plugin.withOptions((options = {}) => {
    return async ({ addBase, addComponents }) => {
        let context = {
            theme,
            base,
            palettes: palettes(options),
            components
        };
        if (options.extensions) {
            for (const [plugin, config] of options.extensions) {
                context = plugin(context, config);
            }
        }
        addBase({ ...theme, ...base });
        const rules = merger({
            palettes: context.palettes,
            components: context.components
        });
        addComponents(rules);
    };
});
