/**
 * @license jQuery UI Multiselect
 *
 * Authors:
 *  Michael Aufreiter (quasipartikel.at)
 *  Yanick Rochon (yanick.rochon[at]gmail[dot]com)
 * 
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 * 
 * http://www.quasipartikel.at/multiselect/
 *
 * UPDATED by Oleg Kiriljuk (oleg.kiriljuk@ok-soft-gmbh.com) to support jQuery 1.6 and hight
 * (the usage of jQuery.attr and jQuery.removeAttr is replaced to the usage of jQuery.prop
 *  in case of working with selected options of select)
 * 
 * Depends:
 *	ui.core.js
 *	ui.sortable.js
 *
 * Optional:
 * localization (http://plugins.jquery.com/project/localisation)
 * scrollTo (http://plugins.jquery.com/project/ScrollTo)
 * 
 * Todo:
 *  Make batch actions faster
 *  Implement dynamic insertion through remote calls
 */
!function(a){"use strict";"function"==typeof define&&define.amd?define(["jquery","jquery-ui/sortable"],a):"object"==typeof module&&module.exports?module.exports=function(b,c){return void 0===c&&(c="undefined"!=typeof window?require("jquery"):require("jquery")(b||window)),require("jquery-ui/sortable"),a(c),c}:a(jQuery)}(function(a){a.widget("ui.multiselect",{options:{sortable:!0,searchable:!0,doubleClickable:!0,animated:"fast",show:"slideDown",hide:"slideUp",dividerLocation:.6,availableFirst:!1,nodeComparator:function(a,b){var c=a.text(),d=b.text();return c==d?0:c<d?-1:1}},_create:function(){this.element.hide(),this.id=this.element.attr("id"),this.container=a('<div class="ui-multiselect ui-helper-clearfix ui-widget"></div>').insertAfter(this.element),this.count=0,this.selectedContainer=a('<div class="selected"></div>').appendTo(this.container),this.availableContainer=a('<div class="available"></div>')[this.options.availableFirst?"prependTo":"appendTo"](this.container),this.selectedActions=a('<div class="actions ui-widget-header ui-helper-clearfix"><span class="count">0 '+a.ui.multiselect.locale.itemsCount+'</span><a href="#" class="remove-all">'+a.ui.multiselect.locale.removeAll+"</a></div>").appendTo(this.selectedContainer),this.availableActions=a('<div class="actions ui-widget-header ui-helper-clearfix"><input type="text" class="search empty ui-widget-content ui-corner-all"/><a href="#" class="add-all">'+a.ui.multiselect.locale.addAll+"</a></div>").appendTo(this.availableContainer),this.selectedList=a('<ul class="selected connected-list"><li class="ui-helper-hidden-accessible"></li></ul>').bind("selectstart",function(){return!1}).appendTo(this.selectedContainer),this.availableList=a('<ul class="available connected-list"><li class="ui-helper-hidden-accessible"></li></ul>').bind("selectstart",function(){return!1}).appendTo(this.availableContainer);var b=this;this.container.width(this.element.width()+1),this.selectedContainer.width(Math.floor(this.element.width()*this.options.dividerLocation)),this.availableContainer.width(Math.floor(this.element.width()*(1-this.options.dividerLocation))),this.selectedList.height(Math.max(this.element.height()-this.selectedActions.height(),1)),this.availableList.height(Math.max(this.element.height()-this.availableActions.height(),1)),this.options.animated||(this.options.show="show",this.options.hide="hide"),this._populateLists(this.element.find("option")),this.options.sortable&&this.selectedList.sortable({placeholder:"ui-state-highlight",axis:"y",update:function(c,d){b.selectedList.find("li").each(function(){a(this).data("optionLink")&&a(this).data("optionLink").remove().appendTo(b.element)})},receive:function(c,d){d.item.data("optionLink").prop("selected",!0),b.count+=1,b._updateCount(),b.selectedList.children(".ui-draggable").each(function(){a(this).removeClass("ui-draggable"),a(this).data("optionLink",d.item.data("optionLink")),a(this).data("idx",d.item.data("idx")),b._applyItemState(a(this),!0)}),setTimeout(function(){d.item.remove()},1)}}),this.options.searchable?this._registerSearchEvents(this.availableContainer.find("input.search")):a(".search").hide(),this.container.find(".remove-all").click(function(){return b._populateLists(b.element.find("option").prop("selected",!1)),!1}),this.container.find(".add-all").click(function(){var c=b.element.find("option").not(":selected");return b.availableList.children("li:hidden").length>1?b.availableList.children("li").each(function(b){a(this).is(":visible")&&a(c[b-1]).prop("selected",!0)}):c.prop("selected",!0),b._populateLists(b.element.find("option")),!1})},destroy:function(){this.element.show(),this.container.remove(),a.Widget.prototype.destroy.apply(this,arguments)},_populateLists:function(b){this.selectedList.children(".ui-element").remove(),this.availableList.children(".ui-element").remove(),this.count=0;var c=this;a(b.map(function(b){var d=a(this).is(":selected"),e=c._getOptionNode(this).appendTo(d?c.selectedList:c.availableList).show();return d&&(c.count+=1),c._applyItemState(e,d),e.data("idx",b),e[0]}));this._updateCount(),c._filter.apply(this.availableContainer.find("input.search"),[c.availableList])},_updateCount:function(){this.element.trigger("change"),this.selectedContainer.find("span.count").text(this.count+" "+a.ui.multiselect.locale.itemsCount)},_getOptionNode:function(b){b=a(b);var c=a('<li class="ui-state-default ui-element" title="'+(b.attr("title")||b.text())+'"><span class="ui-icon"/>'+b.text()+'<a href="#" class="action"><span class="ui-corner-all ui-icon"/></a></li>').hide();return c.data("optionLink",b),c},_cloneWithData:function(a){var b=a.clone(!1,!1);return b.data("optionLink",a.data("optionLink")),b.data("idx",a.data("idx")),b},_setSelected:function(b,c){if(b.data("optionLink").prop("selected",c),c){var d=this._cloneWithData(b);return b[this.options.hide](this.options.animated,function(){a(this).remove()}),d.appendTo(this.selectedList).hide()[this.options.show](this.options.animated),this._applyItemState(d,!0),d}var e=this.availableList.find("li"),f=this.options.nodeComparator,g=null,h=b.data("idx"),i=f(b,a(e[h]));if(i){for(;h>=0&&h<e.length;)if(i>0?h++:h--,i!=f(b,a(e[h]))){g=e[i>0?h:h+1];break}}else g=e[h];var j=this._cloneWithData(b);return g?j.insertBefore(a(g)):j.appendTo(this.availableList),b[this.options.hide](this.options.animated,function(){a(this).remove()}),j.hide()[this.options.show](this.options.animated),this._applyItemState(j,!1),j},_applyItemState:function(a,b){b?(this.options.sortable?a.children("span").addClass("ui-icon-arrowthick-2-n-s").removeClass("ui-helper-hidden").addClass("ui-icon"):a.children("span").removeClass("ui-icon-arrowthick-2-n-s").addClass("ui-helper-hidden").removeClass("ui-icon"),a.find("a.action span").addClass("ui-icon-minus").removeClass("ui-icon-plus"),this._registerRemoveEvents(a.find("a.action"))):(a.children("span").removeClass("ui-icon-arrowthick-2-n-s").addClass("ui-helper-hidden").removeClass("ui-icon"),a.find("a.action span").addClass("ui-icon-plus").removeClass("ui-icon-minus"),this._registerAddEvents(a.find("a.action"))),this._registerDoubleClickEvents(a),this._registerHoverEvents(a)},_filter:function(b){var c=a(this),d=b.children("li"),e=d.map(function(){return a(this).text().toLowerCase()}),f=a.trim(c.val().toLowerCase()),g=[];f?(d.hide(),e.each(function(a){this.indexOf(f)>-1&&g.push(a)}),a.each(g,function(){a(d[this]).show()})):d.show()},_registerDoubleClickEvents:function(b){this.options.doubleClickable&&b.dblclick(function(c){0===a(c.target).closest(".action").length&&b.find("a.action").click()})},_registerHoverEvents:function(b){b.removeClass("ui-state-hover"),b.mouseover(function(){a(this).addClass("ui-state-hover")}),b.mouseout(function(){a(this).removeClass("ui-state-hover")})},_registerAddEvents:function(b){var c=this;b.click(function(){c._setSelected(a(this).parent(),!0);return c.count+=1,c._updateCount(),!1}),this.options.sortable&&b.each(function(){a(this).parent().draggable({connectToSortable:c.selectedList,helper:function(){var b=c._cloneWithData(a(this)).width(a(this).width()-50);return b.width(a(this).width()),b},appendTo:c.container,containment:c.container,revert:"invalid"})})},_registerRemoveEvents:function(b){var c=this;b.click(function(){return c._setSelected(a(this).parent(),!1),c.count-=1,c._updateCount(),!1})},_registerSearchEvents:function(b){var c=this;b.focus(function(){a(this).addClass("ui-state-active")}).blur(function(){a(this).removeClass("ui-state-active")}).keypress(function(a){if(13==a.keyCode)return!1}).keyup(function(){c._filter.apply(this,[c.availableList])})}}),a.extend(a.ui.multiselect,{locale:{addAll:"Add all",removeAll:"Remove all",itemsCount:"items selected"}})});
//# sourceMappingURL=ui.multiselect.js.map