'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var index_cjs = require('@fullcalendar/core/index.cjs');
var premiumCommonPlugin = require('@fullcalendar/premium-common/index.cjs');
var resourcePlugin = require('@fullcalendar/resource/index.cjs');
var timeGridPlugin = require('@fullcalendar/timegrid/index.cjs');
var internalCommon = require('./internal.cjs');
require('@fullcalendar/core/internal.cjs');
require('@fullcalendar/core/preact.cjs');
require('@fullcalendar/timegrid/internal.cjs');
require('@fullcalendar/resource/internal.cjs');
require('@fullcalendar/resource-daygrid/internal.cjs');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var premiumCommonPlugin__default = /*#__PURE__*/_interopDefaultLegacy(premiumCommonPlugin);
var resourcePlugin__default = /*#__PURE__*/_interopDefaultLegacy(resourcePlugin);
var timeGridPlugin__default = /*#__PURE__*/_interopDefaultLegacy(timeGridPlugin);

var index = index_cjs.createPlugin({
    name: '@fullcalendar/resource-timegrid',
    premiumReleaseDate: '2023-09-21',
    deps: [
        premiumCommonPlugin__default["default"],
        resourcePlugin__default["default"],
        timeGridPlugin__default["default"],
    ],
    initialView: 'resourceTimeGridDay',
    views: {
        resourceTimeGrid: {
            type: 'timeGrid',
            component: internalCommon.ResourceDayTimeColsView,
            needsResourceData: true,
        },
        resourceTimeGridDay: {
            type: 'resourceTimeGrid',
            duration: { days: 1 },
        },
        resourceTimeGridWeek: {
            type: 'resourceTimeGrid',
            duration: { weeks: 1 },
        },
    },
});

exports["default"] = index;
