Functionally - A utility belt for functional JavaScript

# Install

```sh
$ npm install functionally
```

# Usage

```js
var F = require('functionally')

function log(msg){
    console.log(msg)
}

function greet(name){
    return 'Hello ' + name + '!'
}

var logGreeting = F.compose(log, greet)

logGreeting('Bob') //console.log('Hello Bob!')

```

# API

## find(fn, target)

Returns the first object in target for which fn returns a truthy value.

Example

```js
F.find(function(obj){
    return obj.name == 'js'
}, [
    {name: 'ruby'},
    {name: 'js'},
    {name: 'php'},
    {name: 'erlang'}
])
//returns the second object in the array
```

The ```find``` function is curried, so you can do
```js
var findFirst = F.find(function(value, index, target){
    if (index === 0){
        return value
    }
})

findFirst([4,5,6]) == 4
```

## once(fn)

Returns a function that calls fn just once.

Example

```js
var counter = 0

var inc = F.once(function(){
    counter++
})

inc()
counter == 1

inc()
inc()

counter == 1
```

The function returned by once returns the result of the original function. On subsequent calls, returns the same result.

## maxArgs(fn, count)

If you use parseInt as the parameter to array.map, you get an undesired result
```js
['1','2','3'].map(parseInt)
//[1, NaN, NaN]
```
But if you use maxArgs:

```js
var parseInt = F.maxArgs(parseInt, 1)
['1','2','3'].map(parseInt)
//you get [1,2,3], the expected result
```

## newify(fn, [...args...])

Creates a new curried function that calls the given fn with the new operator. Expected args are the fn to use for calling new and an array of args to be used (they will be spread on the new call).

Example:
```js
function Developer(name, language){
    this.name = name
    this.lang = language
}

var newDev = newify(Developer)

var dev = newDev(['bob', 'js'])
var dev2 = newify(Developer, ['john', 'c#'])

dev instanceof Developer === true
dev2 instanceof Developer === true
```
