
/**
 * Fundamental Vue
 * Version: 0.18.1-rc.0,
 * (c) SAP SE, 2019
 * LICENCE: Apache-2.0
 * https://github.com/SAP/fundamental-vue
*/
'use strict';

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var Vue$1 = _interopDefault(require('vue'));

function _typeof(obj) {
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function (obj) {
      return typeof obj;
    };
  } else {
    _typeof = function (obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
  }

  return _typeof(obj);
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);

  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    if (enumerableOnly) symbols = symbols.filter(function (sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    });
    keys.push.apply(keys, symbols);
  }

  return keys;
}

function _objectSpread2(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};

    if (i % 2) {
      ownKeys(source, true).forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    } else if (Object.getOwnPropertyDescriptors) {
      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
    } else {
      ownKeys(source).forEach(function (key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }
  }

  return target;
}

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

function _objectWithoutProperties(source, excluded) {
  if (source == null) return {};

  var target = _objectWithoutPropertiesLoose(source, excluded);

  var key, i;

  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

    for (i = 0; i < sourceSymbolKeys.length; i++) {
      key = sourceSymbolKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }

  return target;
}

function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
}

function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
}

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  }
}

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

function _iterableToArray(iter) {
  if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
}

function _iterableToArrayLimit(arr, i) {
  var _arr = [];
  var _n = true;
  var _d = false;
  var _e = undefined;

  try {
    for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance");
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance");
}

//
// Thanks @LinusBorg
var isBrowser = typeof window !== "undefined" && (typeof document === "undefined" ? "undefined" : _typeof(document)) !== undefined;

var getRootEl = function getRootEl() {
  return document.documentElement;
};

var CLICK_OUTSIDE_EVENT = "do"; // Our awesome click outside-component comes with a few nice enhancements.
// You use this component in order to detect clicks outside of a component/element.
// For example:
// ```markup
// <fd-on-click-outside @do="handleClickOutside" :active="true" >
//   hello world
// </fd-on-click-outside>
// ```
// This detects all clicks outside of fd-on-click-outside.
// By default fd-on-click-outside is rendering it's default slot

var script = {
  name: "fd-on-click-outside",
  props: {
    ignoredElements: {
      type: Function,
      default: function _default() {
        return [];
      }
    },
    active: {
      type: Boolean,
      default: false
    }
  },
  render: function render() {
    return this.$scopedSlots.default();
  },
  beforeDestroy: function beforeDestroy() {
    if (!isBrowser) {
      return;
    } // We have to remove ourselves as a listener but only if we are indeed active (=listening) and
    // there is a documentElement.


    if (this.active) {
      getRootEl().removeEventListener("click", this.click, false);
    }
  },
  methods: {
    click: function click(event) {
      var target = event.target;

      if (target == null) {
        return;
      }

      var targetNode = target;
      var isClickOnSelf = this.$el.contains(targetNode);

      if (isClickOnSelf) {
        return;
      } // We now have to check the ignored elements


      var ignoredElements = this.ignoredElements();
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = ignoredElements[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var ignoredElement = _step.value;

          if (ignoredElement.contains(targetNode)) {
            return;
          }
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return != null) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      this.$emit(CLICK_OUTSIDE_EVENT, event);
    },
    activeDidChange: function activeDidChange(isActive, wasActive) {
      if (!isBrowser) {
        return;
      } // We are listening for clicks on the documentElement.


      var root = getRootEl();

      if (isActive && !wasActive) {
        root.addEventListener("click", this.click, false);
      }

      if (!isActive && wasActive) {
        root.removeEventListener("click", this.click, false);
      }
    }
  },
  watch: {
    active: {
      immediate: true,
      handler: function handler(isActive, wasActive) {
        var _this = this;

        setTimeout(function () {
          _this.activeDidChange(isActive, wasActive);
        });
      }
    }
  }
};

function normalizeComponent(template, style, script, scopeId, isFunctionalTemplate, moduleIdentifier
/* server only */
, shadowMode, createInjector, createInjectorSSR, createInjectorShadow) {
  if (typeof shadowMode !== 'boolean') {
    createInjectorSSR = createInjector;
    createInjector = shadowMode;
    shadowMode = false;
  } // Vue.extend constructor export interop.


  var options = typeof script === 'function' ? script.options : script; // render functions

  if (template && template.render) {
    options.render = template.render;
    options.staticRenderFns = template.staticRenderFns;
    options._compiled = true; // functional template

    if (isFunctionalTemplate) {
      options.functional = true;
    }
  } // scopedId


  if (scopeId) {
    options._scopeId = scopeId;
  }

  var hook;

  if (moduleIdentifier) {
    // server build
    hook = function hook(context) {
      // 2.3 injection
      context = context || // cached call
      this.$vnode && this.$vnode.ssrContext || // stateful
      this.parent && this.parent.$vnode && this.parent.$vnode.ssrContext; // functional
      // 2.2 with runInNewContext: true

      if (!context && typeof __VUE_SSR_CONTEXT__ !== 'undefined') {
        context = __VUE_SSR_CONTEXT__;
      } // inject component styles


      if (style) {
        style.call(this, createInjectorSSR(context));
      } // register component module identifier for async chunk inference


      if (context && context._registeredComponents) {
        context._registeredComponents.add(moduleIdentifier);
      }
    }; // used by ssr in case component is cached and beforeCreate
    // never gets called


    options._ssrRegister = hook;
  } else if (style) {
    hook = shadowMode ? function () {
      style.call(this, createInjectorShadow(this.$root.$options.shadowRoot));
    } : function (context) {
      style.call(this, createInjector(context));
    };
  }

  if (hook) {
    if (options.functional) {
      // register for functional component in vue file
      var originalRender = options.render;

      options.render = function renderWithStyleInjection(h, context) {
        hook.call(context);
        return originalRender(h, context);
      };
    } else {
      // inject component registration as beforeCreate hook
      var existing = options.beforeCreate;
      options.beforeCreate = existing ? [].concat(existing, hook) : [hook];
    }
  }

  return script;
}

var normalizeComponent_1 = normalizeComponent;

/* script */
var __vue_script__ = script;
/* template */

/* style */

var __vue_inject_styles__ = undefined;
/* scoped */

var __vue_scope_id__ = undefined;
/* module identifier */

var __vue_module_identifier__ = undefined;
/* functional template */

var __vue_is_functional_template__ = undefined;
/* style inject */

/* style inject SSR */

var FdOnClickOutside = normalizeComponent_1({}, __vue_inject_styles__, __vue_script__, __vue_scope_id__, __vue_is_functional_template__, __vue_module_identifier__, undefined, undefined);

// poor mans Object.values because of IE.
var objectValues = (function (object) {
  var result = [];

  for (var key in object) {
    result.push(object[key]);
  }

  return result;
});

var log = function log(message) {
  var _console;

  for (var _len = arguments.length, params = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    params[_key - 1] = arguments[_key];
  }

  return (_console = console).log.apply(_console, [message].concat(params));
}; // eslint-disable-line no-console

var warn = function warn(message) {
  var _console2;

  for (var _len2 = arguments.length, params = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
    params[_key2 - 1] = arguments[_key2];
  }

  return (_console2 = console).warn.apply(_console2, [message].concat(params));
}; // eslint-disable-line no-console

var makeDefaultOptions = function makeDefaultOptions() {
  return {
    log: {
      welcome: false,
      registerComponent: false
    },
    defaultPortalId: "fd-portal-container"
  };
};

var normalizedPluginOptions = function normalizedPluginOptions() {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : makeDefaultOptions();
  var _options$log = options.log,
      log = _options$log === void 0 ? {} : _options$log,
      _options$defaultPorta = options.defaultPortalId,
      defaultPortalId = _options$defaultPorta === void 0 ? "fd-portal-container" : _options$defaultPorta;
  var defaultLog = makeDefaultOptions().log;
  return {
    defaultPortalId: defaultPortalId,
    log: _objectSpread2({}, defaultLog, {}, log)
  };
};

var getComponentName = function getComponentName(component) {
  if (typeof component === "function") {
    var prototype = component.prototype;
    return prototype.constructor.extendOptions.name;
  }

  return component.name;
}; // This function turns any constructor into a Vue plugin.
// If you have a components that depends on other components to be globally
// installed pass them as the seoncond parameter.


var pluginify = (function () {
  for (var _len = arguments.length, dependencies = new Array(_len), _key = 0; _key < _len; _key++) {
    dependencies[_key] = arguments[_key];
  }

  var install = function install(vue, options) {
    var registerComponent = normalizedPluginOptions(options).log.registerComponent;
    dependencies.forEach(function (component) {
      var componentName = getComponentName(component);

      if (componentName == null) {
        throw Error("\n            Unable to determine component name. Component: ".concat(component, ". Did you forget to add a 'name' attribute?\n                "));
      }

      if (registerComponent) {
        log("Register component ".concat(componentName));
      }

      vue.component(componentName, component);
    });
  };

  var component = dependencies[0];
  component.install = install;
  return component;
});

var withoutDuplicates = (function (values) {
  var result = [];
  values.forEach(function (value) {
    if (result.indexOf(value) >= 0) {
      return;
    }

    result.push(value);
  });
  return result;
});

var noop = function noop() {
  /* empty */
};

var $Support = pluginify(FdOnClickOutside);

//
//
//
//
//
//
//
//
//
// The header of an `fd-action-bar`. Use `fd-action-bar-title` to add an title to the header.
var script$1 = {
  name: "FdActionBarHeader"
};

/* script */
var __vue_script__$1 = script$1;
/* template */

var __vue_render__ = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-action-bar__header"
  }, [_vm._t("title"), _vm._v(" "), _vm._t("description")], 2);
};

var __vue_staticRenderFns__ = [];
/* style */

var __vue_inject_styles__$1 = undefined;
/* scoped */

var __vue_scope_id__$1 = undefined;
/* module identifier */

var __vue_module_identifier__$1 = undefined;
/* functional template */

var __vue_is_functional_template__$1 = false;
/* style inject */

/* style inject SSR */

var ActionBarHeader = normalizeComponent_1({
  render: __vue_render__,
  staticRenderFns: __vue_staticRenderFns__
}, __vue_inject_styles__$1, __vue_script__$1, __vue_scope_id__$1, __vue_is_functional_template__$1, __vue_module_identifier__$1, undefined, undefined);

//
//
//
//
//
//
//
// You can add an `fd-button` to this component in order to display a back-button within an `fd-action-bar`.
var script$2 = {
  name: "FdActionBarBack"
};

/* script */
var __vue_script__$2 = script$2;
/* template */

var __vue_render__$1 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-action-bar__back"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1 = [];
/* style */

var __vue_inject_styles__$2 = undefined;
/* scoped */

var __vue_scope_id__$2 = undefined;
/* module identifier */

var __vue_module_identifier__$2 = undefined;
/* functional template */

var __vue_is_functional_template__$2 = false;
/* style inject */

/* style inject SSR */

var ActionBarBack = normalizeComponent_1({
  render: __vue_render__$1,
  staticRenderFns: __vue_staticRenderFns__$1
}, __vue_inject_styles__$2, __vue_script__$2, __vue_scope_id__$2, __vue_is_functional_template__$2, __vue_module_identifier__$2, undefined, undefined);

//

var script$3 = {
  name: "FdActionBar",
  components: {
    FdActionBarHeader: ActionBarHeader,
    FdActionBarBack: ActionBarBack
  }
};

/* script */
var __vue_script__$3 = script$3;
/* template */

var __vue_render__$2 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-action-bar"
  }, [_vm._t("back", [_c('fd-action-bar-back', [_vm._t("back-button")], 2)]), _vm._v(" "), _vm._t("header", [_c('fd-action-bar-header', {
    scopedSlots: _vm._u([{
      key: "title",
      fn: function fn() {
        return [_vm._t("header-title")];
      },
      proxy: true
    }, {
      key: "description",
      fn: function fn() {
        return [_vm._t("header-description")];
      },
      proxy: true
    }], null, true)
  })]), _vm._v(" "), _vm._t("actions")], 2);
};

var __vue_staticRenderFns__$2 = [];
/* style */

var __vue_inject_styles__$3 = undefined;
/* scoped */

var __vue_scope_id__$3 = undefined;
/* module identifier */

var __vue_module_identifier__$3 = undefined;
/* functional template */

var __vue_is_functional_template__$3 = false;
/* style inject */

/* style inject SSR */

var ActionBar = normalizeComponent_1({
  render: __vue_render__$2,
  staticRenderFns: __vue_staticRenderFns__$2
}, __vue_inject_styles__$3, __vue_script__$3, __vue_scope_id__$3, __vue_is_functional_template__$3, __vue_module_identifier__$3, undefined, undefined);

var script$4 = {
  name: "FdActionBarTitle",
  props: {
    // Name of a tag that will be used to wrap the title/default slot.
    tag: {
      type: String,
      // `h3` – by default the title will be wrapped inside an `h3`-element.
      default: "h3"
    }
  },
  render: function render(h) {
    var data = {
      class: "fd-action-bar__title"
    };
    return h(this.tag, data, this.$slots.default);
  }
};

/* script */
var __vue_script__$4 = script$4;
/* template */

/* style */

var __vue_inject_styles__$4 = undefined;
/* scoped */

var __vue_scope_id__$4 = undefined;
/* module identifier */

var __vue_module_identifier__$4 = undefined;
/* functional template */

var __vue_is_functional_template__$4 = undefined;
/* style inject */

/* style inject SSR */

var ActionBarTitle = normalizeComponent_1({}, __vue_inject_styles__$4, __vue_script__$4, __vue_scope_id__$4, __vue_is_functional_template__$4, __vue_module_identifier__$4, undefined, undefined);

//
//
//
//
//
//
//
// The actions area of an `fd-action-bar`. Add `fd-buttons` as children of the actions area in order to add actions to the enclosing action bar.
var script$5 = {
  name: "FdActionBarActions"
};

/* script */
var __vue_script__$5 = script$5;
/* template */

var __vue_render__$3 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-action-bar__actions"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$3 = [];
/* style */

var __vue_inject_styles__$5 = undefined;
/* scoped */

var __vue_scope_id__$5 = undefined;
/* module identifier */

var __vue_module_identifier__$5 = undefined;
/* functional template */

var __vue_is_functional_template__$5 = false;
/* style inject */

/* style inject SSR */

var ActionBarActions = normalizeComponent_1({
  render: __vue_render__$3,
  staticRenderFns: __vue_staticRenderFns__$3
}, __vue_inject_styles__$5, __vue_script__$5, __vue_scope_id__$5, __vue_is_functional_template__$5, __vue_module_identifier__$5, undefined, undefined);

// Description of an `fd-action-bar`.
var script$6 = {
  name: "FdActionBarDescription",
  props: {
    // Name of a tag that will be used to wrap the title/default slot.
    tag: {
      type: String,
      // `p` – by default the description will be wrapped inside a `p`-element.
      default: "p"
    }
  },
  render: function render(h) {
    var data = {
      class: "fd-action-bar__description"
    };
    return h(this.tag, data, this.$slots.default);
  }
};

/* script */
var __vue_script__$6 = script$6;
/* template */

/* style */

var __vue_inject_styles__$6 = undefined;
/* scoped */

var __vue_scope_id__$6 = undefined;
/* module identifier */

var __vue_module_identifier__$6 = undefined;
/* functional template */

var __vue_is_functional_template__$6 = undefined;
/* style inject */

/* style inject SSR */

var ActionBarDescription = normalizeComponent_1({}, __vue_inject_styles__$6, __vue_script__$6, __vue_scope_id__$6, __vue_is_functional_template__$6, __vue_module_identifier__$6, undefined, undefined);

var ActionBar$1 = pluginify(ActionBar, ActionBarTitle, ActionBarHeader, ActionBarActions, ActionBarBack, ActionBarDescription);

var backgroundColorClassName = function backgroundColorClassName(color) {
  return color == null ? "" : "fd-has-background-color-".concat(color);
};
var backgroundColorClasses = function backgroundColorClasses(color) {
  return color ? [backgroundColorClassName(color)] : [];
};

var shortUuid = function shortUuid() {
  var text = "";
  var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

  for (var i = 0; i < 5; i++) {
    text += possible.charAt(Math.floor(Math.random() * possible.length));
  }

  return text;
};

// @ts-check
/**
 * @param {string | null} icon
 * @param {("s" | "m" | "l" | "xl")=} size
 */

var iconClasses = function iconClasses(icon, size) {
  if (icon == null) {
    return [];
  }

  var classes = ["sap-icon--".concat(icon)];

  if (size != null) {
    classes.push("sap-icon--".concat(size));
  }

  return classes;
};

var Uid = {
  props: {
    uid: {
      type: String,
      default: shortUuid
    }
  }
};

var IconMixin = {
  props: {
    icon: {
      type: String,
      default: null
    },
    iconSize: {
      type: String,
      default: null,
      validator: function validator(size) {
        return ["s", "m", "l", "xl"].indexOf(size) >= 0;
      }
    }
  },
  computed: {
    // We are always returning an array of class names.
    // This is done because of the following reasons:
    // - By returning an array we can return an empty array in case icon is null.
    //   This makes it easier for consumers to use this mixin.
    iconClasses: function iconClasses$1() {
      return iconClasses(this.icon, this.iconSize);
    }
  }
};

var withTargetLocation = (function () {
  var defaultTo = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  return {
    props: {
      to: {
        type: [String, Object],
        default: defaultTo
      }
    },
    methods: {
      pushLocationIfPossible: function pushLocationIfPossible(event) {
        var onComplete = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : noop;

        if (this.to == null || this.$router == null) {
          return;
        }

        this.pushLocation(event, onComplete);
      },
      pushLocation: function pushLocation(event) {
        var onComplete = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : noop;

        if (event) {
          event.preventDefault();
          event.stopPropagation();
        }

        var to = this.to,
            $router = this.$router;

        if (to == null) {
          warn("Tried to navigate to push location but no location was provided.");
          return;
        }

        if ($router == null) {
          warn("Tried to navigate to ".concat(to, " but $router not found."));
          return;
        }

        $router.push(to, onComplete);

        if (event != null) {
          this.$emit("click", event);
        } else {
          this.$emit("click");
        }
      }
    }
  };
});

var Compactable = {
  inject: {
    $_FdCompactMixin: {
      default: null
    }
  },
  props: {
    compact: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    finalCompact: function finalCompact() {
      return this.compact || this.$_FdCompactMixin && this.$_FdCompactMixin.data.value;
    }
  }
};

var CompactableContainer = {
  provide: function provide() {
    return {
      $_FdCompactMixin: {
        data: this.injectedCompactData
      }
    };
  },
  props: {
    compact: {
      type: Boolean,
      default: false
    }
  },
  data: function data() {
    return {
      injectedCompactData: {
        value: this.compact
      }
    };
  },
  watch: {
    compact: function compact(value, oldValue) {
      if (value !== oldValue) {
        this.injectedCompactData.value = value;
      }
    }
  }
};

var candidateSelectors = [
  'input',
  'select',
  'textarea',
  'a[href]',
  'button',
  '[tabindex]',
  'audio[controls]',
  'video[controls]',
  '[contenteditable]:not([contenteditable="false"])',
];
var candidateSelector = candidateSelectors.join(',');

var matches = typeof Element === 'undefined'
  ? function () {}
  : Element.prototype.matches || Element.prototype.msMatchesSelector || Element.prototype.webkitMatchesSelector;

function tabbable(el, options) {
  options = options || {};

  var regularTabbables = [];
  var orderedTabbables = [];

  var candidates = el.querySelectorAll(candidateSelector);

  if (options.includeContainer) {
    if (matches.call(el, candidateSelector)) {
      candidates = Array.prototype.slice.apply(candidates);
      candidates.unshift(el);
    }
  }

  var i, candidate, candidateTabindex;
  for (i = 0; i < candidates.length; i++) {
    candidate = candidates[i];

    if (!isNodeMatchingSelectorTabbable(candidate)) continue;

    candidateTabindex = getTabindex(candidate);
    if (candidateTabindex === 0) {
      regularTabbables.push(candidate);
    } else {
      orderedTabbables.push({
        documentOrder: i,
        tabIndex: candidateTabindex,
        node: candidate,
      });
    }
  }

  var tabbableNodes = orderedTabbables
    .sort(sortOrderedTabbables)
    .map(function(a) { return a.node })
    .concat(regularTabbables);

  return tabbableNodes;
}

tabbable.isTabbable = isTabbable;
tabbable.isFocusable = isFocusable;

function isNodeMatchingSelectorTabbable(node) {
  if (
    !isNodeMatchingSelectorFocusable(node)
    || isNonTabbableRadio(node)
    || getTabindex(node) < 0
  ) {
    return false;
  }
  return true;
}

function isTabbable(node) {
  if (!node) throw new Error('No node provided');
  if (matches.call(node, candidateSelector) === false) return false;
  return isNodeMatchingSelectorTabbable(node);
}

function isNodeMatchingSelectorFocusable(node) {
  if (
    node.disabled
    || isHiddenInput(node)
    || isHidden(node)
  ) {
    return false;
  }
  return true;
}

var focusableCandidateSelector = candidateSelectors.concat('iframe').join(',');
function isFocusable(node) {
  if (!node) throw new Error('No node provided');
  if (matches.call(node, focusableCandidateSelector) === false) return false;
  return isNodeMatchingSelectorFocusable(node);
}

function getTabindex(node) {
  var tabindexAttr = parseInt(node.getAttribute('tabindex'), 10);
  if (!isNaN(tabindexAttr)) return tabindexAttr;
  // Browsers do not return `tabIndex` correctly for contentEditable nodes;
  // so if they don't have a tabindex attribute specifically set, assume it's 0.
  if (isContentEditable(node)) return 0;
  return node.tabIndex;
}

function sortOrderedTabbables(a, b) {
  return a.tabIndex === b.tabIndex ? a.documentOrder - b.documentOrder : a.tabIndex - b.tabIndex;
}

function isContentEditable(node) {
  return node.contentEditable === 'true';
}

function isInput(node) {
  return node.tagName === 'INPUT';
}

function isHiddenInput(node) {
  return isInput(node) && node.type === 'hidden';
}

function isRadio(node) {
  return isInput(node) && node.type === 'radio';
}

function isNonTabbableRadio(node) {
  return isRadio(node) && !isTabbableRadio(node);
}

function getCheckedRadio(nodes) {
  for (var i = 0; i < nodes.length; i++) {
    if (nodes[i].checked) {
      return nodes[i];
    }
  }
}

function isTabbableRadio(node) {
  if (!node.name) return true;
  // This won't account for the edge case where you have radio groups with the same
  // in separate forms on the same page.
  var radioSet = node.ownerDocument.querySelectorAll('input[type="radio"][name="' + node.name + '"]');
  var checked = getCheckedRadio(radioSet);
  return !checked || checked === node;
}

function isHidden(node) {
  // offsetParent being null will allow detecting cases where an element is invisible or inside an invisible element,
  // as long as the element does not use position: fixed. For them, their visibility has to be checked directly as well.
  return node.offsetParent === null || getComputedStyle(node).visibility === 'hidden';
}

var tabbable_1 = tabbable;

var immutable = extend;

var hasOwnProperty = Object.prototype.hasOwnProperty;

function extend() {
    var target = {};

    for (var i = 0; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
            if (hasOwnProperty.call(source, key)) {
                target[key] = source[key];
            }
        }
    }

    return target
}

var activeFocusDelay;

var activeFocusTraps = (function() {
  var trapQueue = [];
  return {
    activateTrap: function(trap) {
      if (trapQueue.length > 0) {
        var activeTrap = trapQueue[trapQueue.length - 1];
        if (activeTrap !== trap) {
          activeTrap.pause();
        }
      }

      var trapIndex = trapQueue.indexOf(trap);
      if (trapIndex === -1) {
        trapQueue.push(trap);
      } else {
        // move this existing trap to the front of the queue
        trapQueue.splice(trapIndex, 1);
        trapQueue.push(trap);
      }
    },

    deactivateTrap: function(trap) {
      var trapIndex = trapQueue.indexOf(trap);
      if (trapIndex !== -1) {
        trapQueue.splice(trapIndex, 1);
      }

      if (trapQueue.length > 0) {
        trapQueue[trapQueue.length - 1].unpause();
      }
    }
  };
})();

function focusTrap(element, userOptions) {
  var doc = document;
  var container =
    typeof element === 'string' ? doc.querySelector(element) : element;

  var config = immutable(
    {
      returnFocusOnDeactivate: true,
      escapeDeactivates: true
    },
    userOptions
  );

  var state = {
    firstTabbableNode: null,
    lastTabbableNode: null,
    nodeFocusedBeforeActivation: null,
    mostRecentlyFocusedNode: null,
    active: false,
    paused: false
  };

  var trap = {
    activate: activate,
    deactivate: deactivate,
    pause: pause,
    unpause: unpause
  };

  return trap;

  function activate(activateOptions) {
    if (state.active) return;

    updateTabbableNodes();

    state.active = true;
    state.paused = false;
    state.nodeFocusedBeforeActivation = doc.activeElement;

    var onActivate =
      activateOptions && activateOptions.onActivate
        ? activateOptions.onActivate
        : config.onActivate;
    if (onActivate) {
      onActivate();
    }

    addListeners();
    return trap;
  }

  function deactivate(deactivateOptions) {
    if (!state.active) return;

    clearTimeout(activeFocusDelay);

    removeListeners();
    state.active = false;
    state.paused = false;

    activeFocusTraps.deactivateTrap(trap);

    var onDeactivate =
      deactivateOptions && deactivateOptions.onDeactivate !== undefined
        ? deactivateOptions.onDeactivate
        : config.onDeactivate;
    if (onDeactivate) {
      onDeactivate();
    }

    var returnFocus =
      deactivateOptions && deactivateOptions.returnFocus !== undefined
        ? deactivateOptions.returnFocus
        : config.returnFocusOnDeactivate;
    if (returnFocus) {
      delay(function() {
        tryFocus(state.nodeFocusedBeforeActivation);
      });
    }

    return trap;
  }

  function pause() {
    if (state.paused || !state.active) return;
    state.paused = true;
    removeListeners();
  }

  function unpause() {
    if (!state.paused || !state.active) return;
    state.paused = false;
    updateTabbableNodes();
    addListeners();
  }

  function addListeners() {
    if (!state.active) return;

    // There can be only one listening focus trap at a time
    activeFocusTraps.activateTrap(trap);

    // Delay ensures that the focused element doesn't capture the event
    // that caused the focus trap activation.
    activeFocusDelay = delay(function() {
      tryFocus(getInitialFocusNode());
    });

    doc.addEventListener('focusin', checkFocusIn, true);
    doc.addEventListener('mousedown', checkPointerDown, {
      capture: true,
      passive: false
    });
    doc.addEventListener('touchstart', checkPointerDown, {
      capture: true,
      passive: false
    });
    doc.addEventListener('click', checkClick, {
      capture: true,
      passive: false
    });
    doc.addEventListener('keydown', checkKey, {
      capture: true,
      passive: false
    });

    return trap;
  }

  function removeListeners() {
    if (!state.active) return;

    doc.removeEventListener('focusin', checkFocusIn, true);
    doc.removeEventListener('mousedown', checkPointerDown, true);
    doc.removeEventListener('touchstart', checkPointerDown, true);
    doc.removeEventListener('click', checkClick, true);
    doc.removeEventListener('keydown', checkKey, true);

    return trap;
  }

  function getNodeForOption(optionName) {
    var optionValue = config[optionName];
    var node = optionValue;
    if (!optionValue) {
      return null;
    }
    if (typeof optionValue === 'string') {
      node = doc.querySelector(optionValue);
      if (!node) {
        throw new Error('`' + optionName + '` refers to no known node');
      }
    }
    if (typeof optionValue === 'function') {
      node = optionValue();
      if (!node) {
        throw new Error('`' + optionName + '` did not return a node');
      }
    }
    return node;
  }

  function getInitialFocusNode() {
    var node;
    if (getNodeForOption('initialFocus') !== null) {
      node = getNodeForOption('initialFocus');
    } else if (container.contains(doc.activeElement)) {
      node = doc.activeElement;
    } else {
      node = state.firstTabbableNode || getNodeForOption('fallbackFocus');
    }

    if (!node) {
      throw new Error(
        "You can't have a focus-trap without at least one focusable element"
      );
    }

    return node;
  }

  // This needs to be done on mousedown and touchstart instead of click
  // so that it precedes the focus event.
  function checkPointerDown(e) {
    if (container.contains(e.target)) return;
    if (config.clickOutsideDeactivates) {
      deactivate({
        returnFocus: !tabbable_1.isFocusable(e.target)
      });
      return;
    }
    // This is needed for mobile devices.
    // (If we'll only let `click` events through,
    // then on mobile they will be blocked anyways if `touchstart` is blocked.)
    if (config.allowOutsideClick && config.allowOutsideClick(e)) {
      return;
    }
    e.preventDefault();
  }

  // In case focus escapes the trap for some strange reason, pull it back in.
  function checkFocusIn(e) {
    // In Firefox when you Tab out of an iframe the Document is briefly focused.
    if (container.contains(e.target) || e.target instanceof Document) {
      return;
    }
    e.stopImmediatePropagation();
    tryFocus(state.mostRecentlyFocusedNode || getInitialFocusNode());
  }

  function checkKey(e) {
    if (config.escapeDeactivates !== false && isEscapeEvent(e)) {
      e.preventDefault();
      deactivate();
      return;
    }
    if (isTabEvent(e)) {
      checkTab(e);
      return;
    }
  }

  // Hijack Tab events on the first and last focusable nodes of the trap,
  // in order to prevent focus from escaping. If it escapes for even a
  // moment it can end up scrolling the page and causing confusion so we
  // kind of need to capture the action at the keydown phase.
  function checkTab(e) {
    updateTabbableNodes();
    if (e.shiftKey && e.target === state.firstTabbableNode) {
      e.preventDefault();
      tryFocus(state.lastTabbableNode);
      return;
    }
    if (!e.shiftKey && e.target === state.lastTabbableNode) {
      e.preventDefault();
      tryFocus(state.firstTabbableNode);
      return;
    }
  }

  function checkClick(e) {
    if (config.clickOutsideDeactivates) return;
    if (container.contains(e.target)) return;
    if (config.allowOutsideClick && config.allowOutsideClick(e)) {
      return;
    }
    e.preventDefault();
    e.stopImmediatePropagation();
  }

  function updateTabbableNodes() {
    var tabbableNodes = tabbable_1(container);
    state.firstTabbableNode = tabbableNodes[0] || getInitialFocusNode();
    state.lastTabbableNode =
      tabbableNodes[tabbableNodes.length - 1] || getInitialFocusNode();
  }

  function tryFocus(node) {
    if (node === doc.activeElement) return;
    if (!node || !node.focus) {
      tryFocus(getInitialFocusNode());
      return;
    }

    node.focus();
    state.mostRecentlyFocusedNode = node;
    if (isSelectableInput(node)) {
      node.select();
    }
  }
}

function isSelectableInput(node) {
  return (
    node.tagName &&
    node.tagName.toLowerCase() === 'input' &&
    typeof node.select === 'function'
  );
}

function isEscapeEvent(e) {
  return e.key === 'Escape' || e.key === 'Esc' || e.keyCode === 27;
}

function isTabEvent(e) {
  return e.key === 'Tab' || e.keyCode === 9;
}

function delay(fn) {
  return setTimeout(fn, 0);
}

var focusTrap_1 = focusTrap;

var FocusTrap = {
  data: function data() {
    return {
      fdFocusTrap: undefined
    };
  },
  methods: {
    pauseFocusTrap: function pauseFocusTrap() {
      this.fdFocusTrap.pause();
    },
    unpauseFocusTrap: function unpauseFocusTrap() {
      this.fdFocusTrap.unpause();
    },
    initializeFocusTrap: function initializeFocusTrap(element, options) {
      this.fdFocusTrap = focusTrap_1(element, options);
    },
    activateFocusTrap: function activateFocusTrap() {
      if (typeof this.fdFocusTrap === "undefined") return;
      this.fdFocusTrap.activate();
    },
    deactivateFocusTrap: function deactivateFocusTrap() {
      if (typeof this.fdFocusTrap === "undefined") return;
      this.fdFocusTrap.deactivate();
    }
  }
};

//

var script$7 = {
  name: "FdAlert",
  model: {
    prop: "visible",
    event: "visible"
  },
  mixins: [Uid],
  watch: {
    visible: {
      immediate: true,
      handler: function handler(visible) {
        this.currentVisible = visible; // Fire when the visibility of the alert changed.
        // @arg `true` if the alert becamse visible – otherwise `false`.

        this.$emit("visible", this.currentVisible);
      }
    }
  },
  props: {
    // If `true`, a close button is rendered that closes the alert.
    dismissible: {
      type: Boolean,
      default: true
    },
    // If `true` the alert is displayed.
    visible: {
      type: Boolean,
      default: true
    },
    // Type of the alert.
    type: {
      // `default` / `warning` / `error` / `information` / `success`
      type: String,
      default: "default",
      validator: function validator(value) {
        return ["default", "warning", "error", "information", "success"].indexOf(value) >= 0;
      }
    }
  },
  methods: {
    // @vuese
    // Used to manually dismiss the alert.
    dismiss: function dismiss() {
      this.currentVisible = false; // Fired once the alert has been dismissed.

      this.$emit("dismiss");
    }
  },
  computed: {
    classes: function classes() {
      var type = this.type === "default" ? [] : ["fd-alert--".concat(this.type)];
      var dismissible = this.dismissible ? [] : ["fd-alert--dismissible"];
      return ["fd-alert"].concat(type, dismissible);
    }
  },
  data: function data() {
    return {
      currentVisible: this.visible
    };
  }
};

/* script */
var __vue_script__$7 = script$7;
/* template */

var __vue_render__$4 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('transition', {
    attrs: {
      "name": "fade"
    }
  }, [_c('div', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.currentVisible,
      expression: "currentVisible"
    }],
    class: _vm.classes,
    attrs: {
      "id": _vm.uid,
      "role": "alert"
    }
  }, [_vm.dismissible ? _c('button', {
    staticClass: "fd-alert__close",
    attrs: {
      "aria-controls": _vm.uid,
      "aria-label": "Close"
    },
    on: {
      "click": _vm.dismiss
    }
  }) : _vm._e(), _vm._v(" "), _vm._t("default")], 2)]);
};

var __vue_staticRenderFns__$4 = [];
/* style */

var __vue_inject_styles__$7 = undefined;
/* scoped */

var __vue_scope_id__$7 = undefined;
/* module identifier */

var __vue_module_identifier__$7 = undefined;
/* functional template */

var __vue_is_functional_template__$7 = false;
/* style inject */

/* style inject SSR */

var Alert = normalizeComponent_1({
  render: __vue_render__$4,
  staticRenderFns: __vue_staticRenderFns__$4
}, __vue_inject_styles__$7, __vue_script__$7, __vue_scope_id__$7, __vue_is_functional_template__$7, __vue_module_identifier__$7, undefined, undefined);

var Alert$1 = pluginify(Alert);

//
//
//
//
//
//
//
var BadgeTypes = ["warning", "error", "success"];

var BadgeTypeIsValid = function BadgeTypeIsValid(value) {
  return BadgeTypes.indexOf(value) >= 0;
}; // Easily highlight the state of an object using a badge.


var script$8 = {
  name: "FdBadge",
  props: {
    // If `true` the badge will be rendered with a more prominent background color.
    filled: {
      type: Boolean,
      default: false
    },
    // If `true` the badge will be rendered with the maximum amount of roundness – will look just like a pill.
    pill: {
      type: Boolean,
      default: false
    },
    // Type of badge to display.
    type: {
      // `warning` / `error` / `success`
      type: String,
      // `null` – by default a neutral badge is rendered.
      default: null,
      validator: BadgeTypeIsValid
    }
  },
  computed: {
    classes: function classes() {
      var type = this.type == null ? {} : _defineProperty({}, "fd-badge--".concat(this.type), true);
      return _objectSpread2({
        "fd-badge": true,
        "fd-badge--filled": this.filled,
        "fd-badge--pill": this.pill
      }, type);
    }
  }
};

/* script */
var __vue_script__$8 = script$8;
/* template */

var __vue_render__$5 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('span', {
    class: _vm.classes
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$5 = [];
/* style */

var __vue_inject_styles__$8 = undefined;
/* scoped */

var __vue_scope_id__$8 = undefined;
/* module identifier */

var __vue_module_identifier__$8 = undefined;
/* functional template */

var __vue_is_functional_template__$8 = false;
/* style inject */

/* style inject SSR */

var Badge = normalizeComponent_1({
  render: __vue_render__$5,
  staticRenderFns: __vue_staticRenderFns__$5
}, __vue_inject_styles__$8, __vue_script__$8, __vue_scope_id__$8, __vue_is_functional_template__$8, __vue_module_identifier__$8, undefined, undefined);

var Badge$1 = pluginify(Badge);

//
//
//
//
//
//
//
// The breadcrumb allows users to see the current page and navigation path to that page.
var script$9 = {
  name: "FdBreadcrumb"
};

/* script */
var __vue_script__$9 = script$9;
/* template */

var __vue_render__$6 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('ul', {
    staticClass: "fd-breadcrumb"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$6 = [];
/* style */

var __vue_inject_styles__$9 = undefined;
/* scoped */

var __vue_scope_id__$9 = undefined;
/* module identifier */

var __vue_module_identifier__$9 = undefined;
/* functional template */

var __vue_is_functional_template__$9 = false;
/* style inject */

/* style inject SSR */

var Breadcrumb = normalizeComponent_1({
  render: __vue_render__$6,
  staticRenderFns: __vue_staticRenderFns__$6
}, __vue_inject_styles__$9, __vue_script__$9, __vue_scope_id__$9, __vue_is_functional_template__$9, __vue_module_identifier__$9, undefined, undefined);

var Breadcrumb$1 = pluginify(Breadcrumb);

var script$a = {
  name: "FdBreadcrumbItem",
  inheritAttrs: false,
  mixins: [withTargetLocation()],
  computed: {
    attrs: function attrs() {
      return _objectSpread2({
        href: "#"
      }, this.$attrs);
    }
  }
};

/* script */
var __vue_script__$a = script$a;
/* template */

var __vue_render__$7 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('li', {
    staticClass: "fd-breadcrumb__item"
  }, [_c('a', _vm._g(_vm._b({
    staticClass: "fd-breadcrumb__link",
    on: {
      "click": _vm.pushLocationIfPossible
    }
  }, 'a', _vm.attrs, false), _vm.$listeners), [_vm._t("default")], 2)]);
};

var __vue_staticRenderFns__$7 = [];
/* style */

var __vue_inject_styles__$a = undefined;
/* scoped */

var __vue_scope_id__$a = undefined;
/* module identifier */

var __vue_module_identifier__$a = undefined;
/* functional template */

var __vue_is_functional_template__$a = false;
/* style inject */

/* style inject SSR */

var BreadcrumbItem = normalizeComponent_1({
  render: __vue_render__$7,
  staticRenderFns: __vue_staticRenderFns__$7
}, __vue_inject_styles__$a, __vue_script__$a, __vue_scope_id__$a, __vue_is_functional_template__$a, __vue_module_identifier__$a, undefined, undefined);

var BreadcrumbItem$1 = pluginify(BreadcrumbItem);

var ButtonTypes = ["standard", "positive", "medium", "negative"];

var script$b = {
  name: "FdButton",
  mixins: [IconMixin, Uid],
  props: {
    // Whether or not the button is compactable. A compactable button can become less tall on desktop if the view port is getting smaller.
    compact: Boolean,
    styling: {
      // `emphasized` / `light`
      type: String,
      default: null,
      validator: function validator(value) {
        return ["emphasized", "light"].indexOf(value) >= 0;
      }
    },
    // Type of the button
    type: {
      // `standard` / `positive` / `medium` / `negative`
      type: String,
      // `null` by default – renders a default button with no special meaning/semantics.
      default: null,
      validator: function validator(value) {
        return ButtonTypes.indexOf(value) >= 0;
      }
    },
    // State of the button – usually not of really useful but used in combination with `fd-button-group`.
    state: {
      // `normal` / `selected` / `disabled`
      type: String,
      // `normal` – no special state.
      default: "normal",
      validator: function validator(value) {
        return ["normal", "selected", "disabled"].indexOf(value) >= 0;
      }
    }
  },
  methods: {
    click: function click(event) {
      if (this.state === "disabled") {
        event.stopImmediatePropagation();
        return;
      } // Fired when the button has been clicked.
      // @arg the `Event` that triggered the click.


      this.$emit("click", event);
    }
  },
  computed: {
    disabled: function disabled() {
      return this.state === "disabled";
    },
    classes: function classes() {
      return [this.styling ? "" : "fd-button", this.compact ? "fd-button--compact" : "", this.styling ? "fd-button--".concat(this.styling) : "", this.type ? "fd-button--".concat(this.type) : "", this.state !== "normal" ? "is-".concat(this.state) : ""].concat(_toConsumableArray(this.iconClasses));
    }
  }
};

/* script */
var __vue_script__$b = script$b;
/* template */

var __vue_render__$8 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('button', {
    class: _vm.classes,
    attrs: {
      "disabled": _vm.disabled
    },
    on: {
      "click": _vm.click
    }
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$8 = [];
/* style */

var __vue_inject_styles__$b = undefined;
/* scoped */

var __vue_scope_id__$b = undefined;
/* module identifier */

var __vue_module_identifier__$b = undefined;
/* functional template */

var __vue_is_functional_template__$b = false;
/* style inject */

/* style inject SSR */

var Button = normalizeComponent_1({
  render: __vue_render__$8,
  staticRenderFns: __vue_staticRenderFns__$8
}, __vue_inject_styles__$b, __vue_script__$b, __vue_scope_id__$b, __vue_is_functional_template__$b, __vue_module_identifier__$b, undefined, undefined);

var Button$1 = pluginify(Button);

var SingleSelectionMode = (function (selection, value) {
  var isSelected = selection.indexOf(value) >= 0;
  return isSelected ? [] : [value];
});

var MultipleSelectionMode = (function (selection, value) {
  var newSelection = _toConsumableArray(selection);

  var index = selection.indexOf(value);

  if (index > -1) {
    newSelection.splice(index);
  } else {
    newSelection.push(value);
  }

  return newSelection;
});

//

var script$c = {
  name: "FdButtonGroup",
  mixins: [CompactableContainer],
  props: {
    // The values of all selected buttons inside this group.
    value: {
      type: Array,
      // `[]`
      default: function _default() {
        return [];
      }
    },
    // A custom selection mode
    selectionMode: {
      // Either a string (`single`: only one button can be selected; `multiple`: multiple buttons can be selected) or a selection-mode-function: `selectionMode(value: any[], clickedButtonValue: any): any[]`
      type: [String, Function],
      // `single`
      default: "single",
      validate: function validate(value) {
        if (value == null) {
          return false;
        }

        if (typeof value === "string") {
          return value === "single" || value === "multiple";
        }

        return true;
      }
    }
  },
  provide: function provide() {
    return {
      group: this
    };
  },
  computed: {
    selectionHandler: function selectionHandler() {
      var selectionMode = this.selectionMode;

      if (typeof selectionMode === "function") {
        return selectionMode;
      }

      switch (selectionMode) {
        case "single":
          {
            return SingleSelectionMode;
          }

        case "multiple":
          {
            return MultipleSelectionMode;
          }

        default:
          return SingleSelectionMode;
      }
    }
  },
  methods: {
    didClickButton: function didClickButton(buttonValue) {
      var newValue = this.selectionHandler(this.value, buttonValue); // Fired when the value changes
      // @arg new values (array of button values)

      this.$emit("input", newValue);
    }
  }
};

/* script */
var __vue_script__$c = script$c;
/* template */

var __vue_render__$9 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-button-group",
    attrs: {
      "role": "group"
    }
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$9 = [];
/* style */

var __vue_inject_styles__$c = undefined;
/* scoped */

var __vue_scope_id__$c = undefined;
/* module identifier */

var __vue_module_identifier__$c = undefined;
/* functional template */

var __vue_is_functional_template__$c = false;
/* style inject */

/* style inject SSR */

var ButtonGroup = normalizeComponent_1({
  render: __vue_render__$9,
  staticRenderFns: __vue_staticRenderFns__$9
}, __vue_inject_styles__$c, __vue_script__$c, __vue_scope_id__$c, __vue_is_functional_template__$c, __vue_module_identifier__$c, undefined, undefined);

//

var script$d = {
  name: "FdButtonGroupButton",
  components: {
    FdButton: Button
  },
  mixins: [Compactable],
  inject: ["group"],
  props: {
    // The value associated with this button when selected.
    value: {
      type: [String, Number, Boolean],
      // a unique but short id (for convenience)
      default: shortUuid
    }
  },
  methods: {
    toggle: function toggle() {
      return this.group.didClickButton(this.value);
    }
  },
  computed: {
    groupValue: function groupValue() {
      return this.group.value;
    },
    pressed: function pressed() {
      return this.groupValue.indexOf(this.value) >= 0;
    }
  }
};

/* script */
var __vue_script__$d = script$d;
/* template */

var __vue_render__$a = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('FdButton', _vm._g(_vm._b({
    attrs: {
      "aria-pressed": String(_vm.pressed),
      "compact": _vm.finalCompact
    },
    on: {
      "click": _vm.toggle
    }
  }, 'FdButton', _vm.$attrs, false), _vm.$listeners), [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$a = [];
/* style */

var __vue_inject_styles__$d = undefined;
/* scoped */

var __vue_scope_id__$d = undefined;
/* module identifier */

var __vue_module_identifier__$d = undefined;
/* functional template */

var __vue_is_functional_template__$d = false;
/* style inject */

/* style inject SSR */

var ButtonGroupButton = normalizeComponent_1({
  render: __vue_render__$a,
  staticRenderFns: __vue_staticRenderFns__$a
}, __vue_inject_styles__$d, __vue_script__$d, __vue_scope_id__$d, __vue_is_functional_template__$d, __vue_module_identifier__$d, undefined, undefined);

var ButtonGroup$1 = pluginify(ButtonGroup, ButtonGroupButton);

// @ts-check

/**
 * @param {Date} lhs
 * @param {Date} rhs
 * @returns {Date}
 */
var earlierDate = function earlierDate(lhs, rhs) {
  return lhs.getTime() < rhs.getTime() ? lhs : rhs;
};

// @ts-check

/**
 * @param {Date} lhs
 * @param {Date} rhs
 * @returns {Date}
 */
var laterDate = function laterDate(lhs, rhs) {
  return lhs.getTime() < rhs.getTime() ? rhs : lhs;
};

var createNullDate = (function () {
  return {
    from: null,
    to: null
  };
});

/**
 * @typedef {object} DateObject
 * @prop {Date=} from
 * @prop {Date=} to
 */

var NormalizedDate =
/*#__PURE__*/
function () {
  _createClass(NormalizedDate, null, [{
    key: "from",

    /** @param {DateObject=} rawDate */
    value: function from(rawDate) {
      return new NormalizedDate(rawDate);
    }
    /** @param {DateObject=} raw */

  }]);

  function NormalizedDate(rawDate) {
    _classCallCheck(this, NormalizedDate);

    this.raw = rawDate != null ? rawDate : createNullDate();
  }

  _createClass(NormalizedDate, [{
    key: "asStartEndValue",
    value: function asStartEndValue() {
      return {
        start: this.start,
        end: this.end
      };
    }
  }, {
    key: "asFromToValue",
    value: function asFromToValue() {
      return {
        from: this.from,
        to: this.to
      };
    }
  }, {
    key: "contains",
    value: function contains(date) {
      var start = this.start,
          end = this.end;

      if (start == null || end == null) {
        return false;
      }

      var startDate = start.getTime();
      var endDate = end.getTime();
      var time = date.getTime();
      return time >= startDate && time <= endDate;
    }
  }, {
    key: "containsYear",
    value: function containsYear(year) {
      var start = this.start,
          end = this.end;

      if (start == null && end == null) {
        return false;
      }

      if (start != null && end != null) {
        return year >= start.getFullYear() && year <= end.getFullYear();
      }

      if (start != null) {
        return start.getFullYear() === year;
      }

      if (end != null) {
        return end.getFullYear() === year;
      }

      return false;
    }
  }, {
    key: "containsMonth",
    value: function containsMonth(month) {
      var start = this.start,
          end = this.end;

      if (start == null && end == null) {
        return false;
      }

      if (start != null && end != null) {
        return month >= start.getMonth() && month <= end.getMonth();
      }

      if (start != null) {
        return start.getMonth() === month;
      }

      if (end != null) {
        return end.getMonth() === month;
      }

      return false;
    }
  }, {
    key: "from",
    get: function get() {
      return this.raw.from;
    }
  }, {
    key: "to",
    get: function get() {
      return this.raw.to;
    }
  }, {
    key: "isComplete",
    get: function get() {
      return this.from != null && this.to != null;
    }
  }, {
    key: "start",
    get: function get() {
      if (this.to != null && this.from != null) {
        return earlierDate(this.from, this.to);
      }

      if (this.to == null && this.from == null) {
        return null;
      }

      if (this.from != null) {
        return this.from;
      }

      return null;
    }
  }, {
    key: "end",
    get: function get() {
      if (this.to != null && this.from != null) {
        return laterDate(this.from, this.to);
      }

      if (this.to == null && this.from == null) {
        return null;
      }

      if (this.to != null) {
        return this.to;
      }

      return null;
    }
  }]);

  return NormalizedDate;
}();
/** @param {DateObject=} selection */

var createNormalizedDate = function createNormalizedDate(selection) {
  return NormalizedDate.from(selection);
};

// @ts-check

/**
 *
 * @param {Date} lhs
 * @param {Date} rhs
 */
var sameYear = function sameYear(lhs, rhs) {
  return lhs.getFullYear() === rhs.getFullYear();
};

// @ts-check
/**
 * @param {Date} lhs
 * @param {Date} rhs
 * @returns {Boolean}
 */

var sameMonth = function sameMonth(lhs, rhs) {
  return sameYear(lhs, rhs) && lhs.getMonth() === rhs.getMonth();
};

// @ts-check
/**
 * @param {Date} lhs
 * @param {Date} rhs
 * @returns {Boolean}
 */

var sameDay = function sameDay(lhs, rhs) {
  return sameMonth(lhs, rhs) && lhs.getDate() === rhs.getDate();
};

// @ts-check
var weekFromDate = function weekFromDate(date) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
    firstDayOfWeek: 0
  },
      firstDayOfWeek = _ref.firstDayOfWeek;

  var startOfWeek = new Date(date.valueOf());
  startOfWeek.setDate(date.getDate() - date.getDay() + firstDayOfWeek);
  var endOfWeek = new Date(date.valueOf());
  endOfWeek.setDate(date.getDate() + (7 - firstDayOfWeek - date.getDay()));
  var days = [];
  var dayOfWeek = 0;

  while (dayOfWeek < 7) {
    var dayInWeek = new Date(startOfWeek.valueOf());
    dayInWeek.setDate(dayInWeek.getDate() + dayOfWeek);
    days.push(dayInWeek);
    dayOfWeek++;
  }

  return days;
};
var monthFromDate = function monthFromDate(referenceDate) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
    firstDayOfWeek: 0
  };
  var month = referenceDate.getMonth();
  var result = [];
  var firstDayOfMonth = new Date(referenceDate.getFullYear(), month, 1);
  var firstWeek = weekFromDate(firstDayOfMonth, options);

  var _firstWeek = _slicedToArray(firstWeek, 1),
      startingDate = _firstWeek[0];

  var currentMonth = month;

  while (currentMonth === month) {
    var week = weekFromDate(startingDate, options);
    result.push(week);
    startingDate.setDate(startingDate.getDate() + 7);
    currentMonth = startingDate.getMonth();
  }

  return result;
};

var defaultDayNames = ["Su", "M", "Tu", "W", "Th", "F", "S"];
var defaultMonthNames = ["Jan.", "Feb.", "Mar.", "Apr.", "May", "Jun.", "Jul", "Aug.", "Sep.", "Oct.", "Nov.", "Dec."];
var DisplayedDateMixin = {
  props: {
    defaultValue: {
      type: [Date, String, Number],
      default: Date.now()
    },
    firstDayOfWeek: {
      type: Number,
      default: 0
    },
    dayNames: {
      type: Array,
      default: function _default() {
        return defaultDayNames;
      }
    },
    monthNames: {
      type: Array,
      default: function _default() {
        return defaultMonthNames;
      }
    }
  },
  data: function data() {
    return {
      displayedDate: typeof this.defaultValue === "string" || typeof this.defaultValue === "number" ? new Date(this.defaultValue) : this.defaultValue
    };
  },
  computed: {
    month: function month() {
      var date = this.displayedDate;
      return monthFromDate(date, {
        firstDayOfWeek: this.firstDayOfWeek
      });
    },
    adjustedDayNames: function adjustedDayNames() {
      return this.dayNames.concat(this.dayNames).slice(this.firstDayOfWeek, this.firstDayOfWeek + 7);
    },
    displayedYear: {
      get: function get() {
        return this.displayedDate.getFullYear();
      },
      set: function set(year) {
        var copy = new Date(this.displayedDate);
        copy.setFullYear(year);
        this.displayedDate = copy;
      }
    },
    displayedMonth: {
      set: function set(month) {
        var copy = new Date(this.displayedDate);
        copy.setMonth(month);
        this.displayedDate = copy;
      },
      get: function get() {
        var date = this.displayedDate;
        return date.getMonth();
      }
    }
  }
};

//
var script$e = {
  name: "FdCalendarAction",
  components: {
    FdButton: Button
  },
  props: {
    title: String,
    icon: String,
    disabled: {
      type: Boolean,
      default: false
    },
    type: {
      type: String,
      default: null,
      validator: function validator(value) {
        return ButtonTypes.indexOf(value) >= 0;
      }
    }
  },
  computed: {
    state: function state() {
      return this.disabled ? "disabled" : "normal";
    }
  }
};

/* script */
var __vue_script__$e = script$e;
/* template */

var __vue_render__$b = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-calendar__action"
  }, [_c('FdButton', {
    attrs: {
      "compact": "",
      "styling": "light",
      "type": _vm.type,
      "state": _vm.state,
      "icon": _vm.icon
    },
    on: {
      "click": function click($event) {
        return _vm.$emit('click');
      }
    }
  }, [_vm._v("\n    " + _vm._s(_vm.title) + "\n  ")])], 1);
};

var __vue_staticRenderFns__$b = [];
/* style */

var __vue_inject_styles__$e = undefined;
/* scoped */

var __vue_scope_id__$e = undefined;
/* module identifier */

var __vue_module_identifier__$e = undefined;
/* functional template */

var __vue_is_functional_template__$e = false;
/* style inject */

/* style inject SSR */

var CalendarAction = normalizeComponent_1({
  render: __vue_render__$b,
  staticRenderFns: __vue_staticRenderFns__$b
}, __vue_inject_styles__$e, __vue_script__$e, __vue_scope_id__$e, __vue_is_functional_template__$e, __vue_module_identifier__$e, undefined, undefined);

//
var script$f = {
  name: "FdCalendarHeader",
  components: {
    CalendarAction: CalendarAction
  },
  props: {
    month: String,
    year: Number,
    hasPrevious: {
      type: Function,
      default: function _default() {
        return true;
      }
    },
    hasNext: {
      type: Function,
      default: function _default() {
        return true;
      }
    }
  }
};

/* script */
var __vue_script__$f = script$f;
/* template */

var __vue_render__$c = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('header', {
    staticClass: "fd-calendar__header"
  }, [_c('div', {
    staticClass: "fd-calendar__navigation"
  }, [_c('CalendarAction', {
    attrs: {
      "icon": "slim-arrow-left",
      "type": "standard",
      "disabled": !_vm.hasPrevious
    },
    on: {
      "click": function click($event) {
        return _vm.$emit('previous');
      }
    }
  }), _vm._v(" "), _c('CalendarAction', {
    attrs: {
      "title": _vm.month
    },
    on: {
      "click": function click($event) {
        return _vm.$emit('month');
      }
    }
  }), _vm._v(" "), _c('CalendarAction', {
    attrs: {
      "title": String(this.year)
    },
    on: {
      "click": function click($event) {
        return _vm.$emit('year');
      }
    }
  }), _vm._v(" "), _c('CalendarAction', {
    attrs: {
      "type": "standard",
      "icon": "slim-arrow-right",
      "disabled": !_vm.hasNext()
    },
    on: {
      "click": function click($event) {
        return _vm.$emit('next');
      }
    }
  })], 1)]);
};

var __vue_staticRenderFns__$c = [];
/* style */

var __vue_inject_styles__$f = undefined;
/* scoped */

var __vue_scope_id__$f = undefined;
/* module identifier */

var __vue_module_identifier__$f = undefined;
/* functional template */

var __vue_is_functional_template__$f = false;
/* style inject */

/* style inject SSR */

var CalendarHeader = normalizeComponent_1({
  render: __vue_render__$c,
  staticRenderFns: __vue_staticRenderFns__$c
}, __vue_inject_styles__$f, __vue_script__$f, __vue_scope_id__$f, __vue_is_functional_template__$f, __vue_module_identifier__$f, undefined, undefined);

// @ts-check
var single = "single";
var range = "range";
var all = [single, range];

var validator = function validator(mode) {
  return all.indexOf(mode) >= 0;
};

var defaultValue = single;
var Mode = {
  all: all,
  single: single,
  range: range,
  validator: validator,
  default: defaultValue,
  prop: {
    mode: {
      type: String,
      validator: validator,
      default: defaultValue
    }
  }
};

var calendarItemModifierMapping = {
  // Apply to dates outside the current month
  otherMonth: "fd-calendar__item--other-month",
  // Apply to the current today, this month, this year'
  current: "fd-calendar__item--current",
  // Cannot be selected, usually applied to a large range of past or future dates
  disabled: "fd-calendar__item--disabled" // Cannot be selected, usually applied to blackout or booked dates mixed in with available dates
  // blocked: 'fd-calendar__item--blocked',

};
var CalendarItemModifiers = Object.keys(calendarItemModifierMapping);

var CalendarItemModifierValidator = function CalendarItemModifierValidator(value) {
  return value === null || CalendarItemModifiers.indexOf(value) >= 0;
}; // Map modifier to CSS class name


var calendarItemStateMapping = {
  disabled: "is-disabled",
  blocked: "is-blocked",
  // Currently selected date AND the first and last dates in a range
  selected: "is-selected",
  // A date in the range between the first and last selected dates
  selectedRange: "is-selected-range",
  // The first date in a selected range
  selectedRangeFirst: "is-selected-range-first",
  // The last date in a selected range
  selectedRangeLast: "is-selected-range-last"
};
var CalendarItemStates = Object.keys(calendarItemStateMapping);

var CalendarItemStatesValidator = function CalendarItemStatesValidator(value) {
  return value === null || CalendarItemStates.indexOf(value) >= 0;
};

var script$g = {
  name: "FdCalendarItem",
  props: _objectSpread2({}, Mode.prop, {
    tag: {
      type: String,
      default: "td"
    },
    text: {
      type: String,
      default: ""
    },
    modifier: {
      type: String,
      validator: CalendarItemModifierValidator,
      default: null
    },
    state: {
      type: String,
      validator: CalendarItemStatesValidator,
      default: null
    }
  }),
  computed: {
    classes: function classes() {
      var state = this.state;
      var isFirstOrLast = state === "selectedRangeFirst" || state === "selectedRangeLast";
      var stateClasses = [].concat(_toConsumableArray(isFirstOrLast ? [calendarItemStateMapping.selected] : []), _toConsumableArray(state != null ? [calendarItemStateMapping[state]] : []));
      var modifier = this.modifier;
      return stateClasses.concat(modifier == null ? [] : calendarItemModifierMapping[modifier]);
    }
  },
  render: function render(h) {
    var vm = this;
    return h(this.tag, {
      on: {
        click: function click(event) {
          // We don't want to emit a click if the item is disabled or blocked.
          var state = vm.state || "";

          if (["disabled", "blocked"].indexOf(state) >= 0) {
            event.stopImmediatePropagation();
            return;
          }

          vm.$emit("click");
        }
      },
      staticClass: "fd-calendar__item",
      class: vm.classes
    }, [h("span", {
      staticClass: "fd-calendar__text"
    }, this.text) // render item text
    ]);
  }
};

/* script */
var __vue_script__$g = script$g;
/* template */

/* style */

var __vue_inject_styles__$g = undefined;
/* scoped */

var __vue_scope_id__$g = undefined;
/* module identifier */

var __vue_module_identifier__$g = undefined;
/* functional template */

var __vue_is_functional_template__$g = undefined;
/* style inject */

/* style inject SSR */

var CalendarItem = normalizeComponent_1({}, __vue_inject_styles__$g, __vue_script__$g, __vue_scope_id__$g, __vue_is_functional_template__$g, __vue_module_identifier__$g, undefined, undefined);

var script$h = {
  components: {
    CalendarItem: CalendarItem
  },
  props: _objectSpread2({}, Mode.prop, {
    dayNames: {
      type: Array,
      required: true
    },
    month: {
      type: Array,
      default: function _default() {
        return [];
      }
    },
    isPresent: {
      type: Function,
      default: function _default() {
        return false;
      }
    },
    selectionEnd: {
      type: Date,
      default: null
    },
    selectionStart: {
      type: Date,
      default: null
    },
    displayedMonth: {
      type: Number,
      default: 1
    },
    disabledDate: {
      type: Function,
      default: function _default() {
        return false;
      }
    },
    blockedDate: {
      type: Function,
      default: function _default() {
        return false;
      }
    },
    selectionContainsDate: {
      type: Function,
      default: function _default() {
        return false;
      }
    }
  }),
  methods: {
    state: function state(date) {
      if (this.disabledDate(date)) {
        return "disabled";
      }

      if (this.blockedDate(date)) {
        return "blocked";
      }

      var selectionStart = this.selectionStart,
          selectionEnd = this.selectionEnd;
      var isFirst = selectionStart != null ? sameDay(date, selectionStart) : false;
      var isLast = selectionEnd != null ? sameDay(date, selectionEnd) : false;
      var isFirstAndLast = isFirst && (isLast || this.mode === Mode.single);

      if (isFirstAndLast) {
        return "selected";
      }

      if (isFirst) {
        return "selectedRangeFirst";
      }

      if (isLast) {
        return "selectedRangeLast";
      }

      if (this.selectionContainsDate(date)) {
        return "selectedRange";
      }

      return null;
    },
    modifier: function modifier(date) {
      var isOtherMonth = this.displayedMonth !== date.getMonth();
      var isPresent = this.isPresent(date);

      if (isOtherMonth) {
        return "otherMonth";
      }

      if (isPresent) {
        return "current";
      }

      return null;
    }
  }
};

/* script */
var __vue_script__$h = script$h;
/* template */

var __vue_render__$d = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-calendar__dates",
    attrs: {
      "aria-hidden": "false"
    }
  }, [_c('table', {
    staticClass: "fd-calendar__table",
    attrs: {
      "role": "grid"
    }
  }, [_c('thead', {
    staticClass: "fd-calendar__group"
  }, [_c('tr', {
    staticClass: "fd-calendar__row"
  }, _vm._l(_vm.dayNames, function (dayName) {
    return _c('th', {
      key: dayName,
      staticClass: "fd-calendar__column-header"
    }, [_c('span', {
      staticClass: "fd-calendar__day-of-week"
    }, [_vm._v(_vm._s(dayName))])]);
  }), 0)]), _vm._v(" "), _c('tbody', {
    staticClass: "fd-calendar__group"
  }, _vm._l(_vm.month, function (week, index) {
    return _c('tr', {
      key: String('week-' + index),
      staticClass: "fd-calendar__row"
    }, _vm._l(week, function (date) {
      return _c('CalendarItem', {
        key: date.toString(),
        attrs: {
          "text": String(date.getDate()),
          "modifier": _vm.modifier(date),
          "mode": _vm.mode,
          "state": _vm.state(date)
        },
        on: {
          "click": function click($event) {
            return _vm.$emit('select', date);
          }
        }
      });
    }), 1);
  }), 0)])]);
};

var __vue_staticRenderFns__$d = [];
/* style */

var __vue_inject_styles__$h = undefined;
/* scoped */

var __vue_scope_id__$h = undefined;
/* module identifier */

var __vue_module_identifier__$h = undefined;
/* functional template */

var __vue_is_functional_template__$h = false;
/* style inject */

/* style inject SSR */

var DayPicker = normalizeComponent_1({
  render: __vue_render__$d,
  staticRenderFns: __vue_staticRenderFns__$d
}, __vue_inject_styles__$h, __vue_script__$h, __vue_scope_id__$h, __vue_is_functional_template__$h, __vue_module_identifier__$h, undefined, undefined);

//
var script$i = {
  components: {
    CalendarItem: CalendarItem
  },
  props: {
    maxDate: Date,
    minDate: Date,
    years: {
      type: Array,
      default: function _default() {
        return [];
      }
    },
    presentYear: {
      type: Number,
      default: 0
    },
    selectionContainsYear: {
      type: Function,
      default: function _default() {
        return false;
      }
    }
  },
  methods: {
    isValidYear: function isValidYear(year) {
      var maxYear = this.maxDate.getFullYear();
      var minYear = this.minDate.getFullYear();
      return year <= maxYear && year >= minYear;
    },
    stateForYear: function stateForYear(year) {
      if (this.isValidYear(year) === false) {
        return "disabled";
      }

      return this.selectionContainsYear(year) ? "selected" : null;
    }
  }
};

/* script */
var __vue_script__$i = script$i;
/* template */

var __vue_render__$e = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-calendar__years",
    attrs: {
      "aria-hidden": "{false}"
    }
  }, [_c('ul', {
    staticClass: "fd-calendar__list"
  }, _vm._l(_vm.years, function (year) {
    return _c('CalendarItem', {
      key: String(year),
      attrs: {
        "tag": "li",
        "text": String(year),
        "state": _vm.stateForYear(year),
        "modifier": _vm.presentYear === year ? 'current' : null
      },
      on: {
        "click": function click($event) {
          return _vm.$emit('select', year);
        }
      }
    });
  }), 1)]);
};

var __vue_staticRenderFns__$e = [];
/* style */

var __vue_inject_styles__$i = undefined;
/* scoped */

var __vue_scope_id__$i = undefined;
/* module identifier */

var __vue_module_identifier__$i = undefined;
/* functional template */

var __vue_is_functional_template__$i = false;
/* style inject */

/* style inject SSR */

var YearPicker = normalizeComponent_1({
  render: __vue_render__$e,
  staticRenderFns: __vue_staticRenderFns__$e
}, __vue_inject_styles__$i, __vue_script__$i, __vue_scope_id__$i, __vue_is_functional_template__$i, __vue_module_identifier__$i, undefined, undefined);

//
var script$j = {
  components: {
    CalendarItem: CalendarItem
  },
  props: {
    monthNames: Array,
    presentMonth: {
      type: Number,
      default: 0
    },
    selectionContainsMonth: {
      type: Function,
      default: function _default() {
        return false;
      }
    }
  }
};

/* script */
var __vue_script__$j = script$j;
/* template */

var __vue_render__$f = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-calendar__months",
    attrs: {
      "aria-hidden": "{false}"
    }
  }, [_c('ul', {
    staticClass: "fd-calendar__list"
  }, _vm._l(_vm.monthNames, function (month, index) {
    return _c('CalendarItem', {
      key: month,
      attrs: {
        "tag": "li",
        "text": month,
        "state": _vm.selectionContainsMonth(index) ? 'selected' : null,
        "modifier": _vm.presentMonth === index ? 'current' : null
      },
      on: {
        "click": function click($event) {
          return _vm.$emit('select', index);
        }
      }
    });
  }), 1)]);
};

var __vue_staticRenderFns__$f = [];
/* style */

var __vue_inject_styles__$j = undefined;
/* scoped */

var __vue_scope_id__$j = undefined;
/* module identifier */

var __vue_module_identifier__$j = undefined;
/* functional template */

var __vue_is_functional_template__$j = false;
/* style inject */

/* style inject SSR */

var MonthPicker = normalizeComponent_1({
  render: __vue_render__$f,
  staticRenderFns: __vue_staticRenderFns__$f
}, __vue_inject_styles__$j, __vue_script__$j, __vue_scope_id__$j, __vue_is_functional_template__$j, __vue_module_identifier__$j, undefined, undefined);

var PickerType = {
  year: "year",
  month: "month"
};

var dateWithYearsFromNow = function dateWithYearsFromNow(numberOfYears) {
  var date = new Date(Date.now());
  date.setFullYear(date.getFullYear() + numberOfYears);
  return date;
};

var createToday = function createToday() {
  return new Date(Date.now());
}; // Calendar component – usualy not used on it's own but in combination with `fd-date-picker`.


var script$k = {
  name: "FdCalendar",
  mixins: [DisplayedDateMixin],
  components: {
    DayPicker: DayPicker,
    MonthPicker: MonthPicker,
    YearPicker: YearPicker,
    CalendarHeader: CalendarHeader
  },
  watch: {
    value: {
      deep: true,
      immediate: true,
      handler: function handler(value) {
        this.normalizedDate.from = value.from;
        this.normalizedDate.to = value.to;
      }
    }
  },
  props: _objectSpread2({}, Mode.prop, {
    // Date value that represents today.
    today: {
      type: Date,
      // `new Date(Date.now())` – today
      default: createToday
    },
    // Normalized value that is currently selected.
    value: {
      // `{ from: null, to: null }`
      type: Object,
      // `{ from: null, to: null }` – the `null`-date.
      default: function _default() {
        return {
          from: null,
          to: null
        };
      }
    },
    // Whether or not the header is visible
    headerVisible: {
      type: Boolean,
      default: true
    },
    // Maximum date handled by the calendar.
    maxDate: {
      type: Date,
      // 10 years from today
      default: function _default() {
        return dateWithYearsFromNow(10);
      }
    },
    // Minimum date handled by the calendar.
    minDate: {
      type: Date,
      // -10 years from today
      default: function _default() {
        return dateWithYearsFromNow(-10);
      }
    },
    // Allows you to disable specific dates
    disabledDate: {
      // `disabledDate(date: Date): boolean` – return `true` for the corresponding date to disable it.
      type: Function,
      // `() => false` – by default no date is disabled.
      default: function _default() {
        return false;
      }
    },
    // Allows you to block specific dates
    blockedDate: {
      // `blockedDate(date: Date): boolean` – return `true` for the corresponding date to block it.
      type: Function,
      // `() => false` – by default no date is blocked.
      default: function _default() {
        return false;
      }
    },
    hasPrevious: {
      type: Function,
      default: function _default() {
        return true;
      }
    },
    hasNext: {
      type: Function,
      default: function _default() {
        return true;
      }
    }
  }),
  computed: {
    normalizedDate_: function normalizedDate_() {
      return NormalizedDate.from(this.normalizedDate);
    },
    dateSelectionNeedsReset: function dateSelectionNeedsReset() {
      return this.normalizedDate_.isComplete;
    },
    selectionStart: function selectionStart() {
      return this.normalizedDate_.start;
    },
    selectionEnd: function selectionEnd() {
      return this.normalizedDate_.end;
    },
    yearPickerYears: function yearPickerYears() {
      var _this = this;

      return Array.from({
        length: 12
      }).map(function (_, index) {
        return _this.displayedYear + (index - 6);
      });
    },
    currentRange: function currentRange() {
      var month = this.month;
      var lastWeek = month[month.length - 1];
      var min = month[0][0];
      var max = lastWeek[lastWeek.length - 1];
      return {
        min: min,
        max: max
      };
    },
    displayedMonthName: function displayedMonthName() {
      var month = this.displayedMonth;

      if (month == null) {
        return null;
      }

      return this.monthNames[month];
    }
  },
  data: function data() {
    return {
      normalizedDate: NormalizedDate.from(this.value).asFromToValue(),
      currentPicker: null
    };
  },
  methods: {
    isPresent: function isPresent(date) {
      return sameDay(this.today, date);
    },
    selectionContains: function selectionContains(date) {
      return this.normalizedDate_.contains(date);
    },
    selectionContainsYear: function selectionContainsYear(year) {
      return this.normalizedDate_.containsYear(year);
    },
    selectionContainsMonth: function selectionContainsMonth(month) {
      return this.normalizedDate_.containsMonth(month);
    },
    resetSelection: function resetSelection() {
      this.normalizedDate.from = null;
      this.normalizedDate.to = null;
      this.$emit("input", this.normalizedDate_.asFromToValue());
    },
    emitCurrentSelection: function emitCurrentSelection() {
      this.$emit("input", this.normalizedDate_.asFromToValue());
    },
    selectDate: function selectDate(date) {
      if (this.mode === Mode.single) {
        this.normalizedDate.from = date;
        this.normalizedDate.to = null;
        this.emitCurrentSelection();
        return;
      } // From here on we are only handling range-selections


      if (this.dateSelectionNeedsReset) {
        this.resetSelection();
      }

      var from = this.normalizedDate.from;

      if (from == null) {
        this.normalizedDate.from = date;
        this.emitCurrentSelection();
        return;
      }

      this.normalizedDate.to = date;
      this.emitCurrentSelection();
    },
    previousButtonEnabled: function previousButtonEnabled() {
      var range = this.currentRange;
      return this.hasPrevious(range) && this.minDateValidator(range);
    },
    nextButtonEnabled: function nextButtonEnabled() {
      var range = this.currentRange;
      return this.hasNext(range) && this.maxDateValidator(range);
    },
    nextYear: function nextYear() {
      var delta = this.currentPicker === PickerType.month ? 1 : 12;
      var copy = new Date(this.displayedDate);
      copy.setFullYear(this.displayedDate.getFullYear() + delta);
      this.displayedDate = copy;
    },
    displayPreviousYear: function displayPreviousYear() {
      var delta = this.currentPicker === PickerType.month ? 1 : 12;
      var copy = new Date(this.displayedDate);
      copy.setFullYear(this.displayedDate.getFullYear() - delta);
      this.displayedDate = copy;
    },
    displayNextMonth: function displayNextMonth() {
      var copy = new Date(this.displayedDate); // fixes: https://github.com/SAP/fundamental-vue/issues/324

      copy.setDate(1);
      copy.setMonth(this.displayedDate.getMonth() + 1);
      this.displayedDate = copy;
    },
    displayPreviousMonth: function displayPreviousMonth() {
      var copy = new Date(this.displayedDate); // fixes: https://github.com/SAP/fundamental-vue/issues/324

      copy.setDate(1);
      copy.setMonth(this.displayedDate.getMonth() - 1);
      this.displayedDate = copy;
    },
    didClickDate: function didClickDate(date) {
      this.selectDate(date);
    },
    next: function next() {
      if (this.currentPicker == null) {
        this.displayNextMonth();
        return;
      }

      this.nextYear();
    },
    previous: function previous() {
      if (this.currentPicker == null) {
        this.displayPreviousMonth();
        return;
      }

      this.displayPreviousYear();
    },
    didClickOnMonth: function didClickOnMonth(month) {
      this.displayedMonth = month;
      this.currentPicker = null;
    },
    didClickOnYear: function didClickOnYear(year) {
      this.displayedYear = year;
      this.currentPicker = null;
    },
    maxDateValidator: function maxDateValidator(_ref) {
      var max = _ref.max;
      return max.getFullYear() <= this.maxDate.getFullYear();
    },
    minDateValidator: function minDateValidator(_ref2) {
      var min = _ref2.min;
      return min.getFullYear() >= this.minDate.getFullYear();
    },
    togglePicker: function togglePicker(pickerType) {
      if (this.currentPicker === pickerType) {
        this.currentPicker = null;
        return;
      }

      this.currentPicker = pickerType;
    },
    toggleMonthPicker: function toggleMonthPicker() {
      this.togglePicker(PickerType.month);
    },
    toggleYearPicker: function toggleYearPicker() {
      this.togglePicker(PickerType.year);
    }
  }
};

/* script */
var __vue_script__$k = script$k;
/* template */

var __vue_render__$g = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-calendar"
  }, [_vm.headerVisible ? _c('CalendarHeader', {
    attrs: {
      "month": _vm.displayedMonthName || '',
      "year": _vm.displayedYear,
      "hasNext": _vm.nextButtonEnabled,
      "hasPrevious": _vm.previousButtonEnabled
    },
    on: {
      "previous": _vm.previous,
      "next": _vm.next,
      "month": _vm.toggleMonthPicker,
      "year": _vm.toggleYearPicker
    }
  }) : _vm._e(), _vm._v(" "), _c('div', {
    staticClass: "fd-calendar__content"
  }, [_vm.currentPicker == 'month' ? _c('MonthPicker', {
    attrs: {
      "monthNames": _vm.monthNames,
      "presentMonth": _vm.presentMonth,
      "selectionContainsMonth": _vm.selectionContainsMonth
    },
    on: {
      "select": _vm.didClickOnMonth
    }
  }) : _vm._e(), _vm._v(" "), _vm.currentPicker == null ? _c('DayPicker', {
    attrs: {
      "dayNames": _vm.adjustedDayNames,
      "month": _vm.month,
      "selectionEnd": _vm.selectionEnd,
      "selectionStart": _vm.selectionStart,
      "displayedMonth": _vm.displayedMonth,
      "disabledDate": _vm.disabledDate,
      "blockedDate": _vm.blockedDate,
      "isPresent": _vm.isPresent,
      "selectionContainsDate": _vm.selectionContains,
      "mode": _vm.mode
    },
    on: {
      "select": _vm.didClickDate
    }
  }) : _vm._e(), _vm._v(" "), _vm.currentPicker === 'year' ? _c('YearPicker', {
    attrs: {
      "minDate": _vm.minDate,
      "maxDate": _vm.maxDate,
      "years": _vm.yearPickerYears,
      "presentYear": _vm.presentYear,
      "selectionContainsYear": _vm.selectionContainsYear
    },
    on: {
      "select": _vm.didClickOnYear
    }
  }) : _vm._e()], 1)], 1);
};

var __vue_staticRenderFns__$g = [];
/* style */

var __vue_inject_styles__$k = undefined;
/* scoped */

var __vue_scope_id__$k = undefined;
/* module identifier */

var __vue_module_identifier__$k = undefined;
/* functional template */

var __vue_is_functional_template__$k = false;
/* style inject */

/* style inject SSR */

var FdCalendar = normalizeComponent_1({
  render: __vue_render__$g,
  staticRenderFns: __vue_staticRenderFns__$g
}, __vue_inject_styles__$k, __vue_script__$k, __vue_scope_id__$k, __vue_is_functional_template__$k, __vue_module_identifier__$k, undefined, undefined);

var Calendar = pluginify(FdCalendar, CalendarHeader);

/*
  { props: {
    size: {
      type: String,
      default: null,
      validator: val => ["x", "l", "s"].indexOf(value) >= 0}
    }
  }
  ---- vs. ----
  { props: {
    size: $enum("x", "l", "s")
  }
*/

var $enum = function $enum() {
  for (var _len = arguments.length, values = new Array(_len), _key = 0; _key < _len; _key++) {
    values[_key] = arguments[_key];
  }

  return {
    type: String,
    default: null,
    validator: function validator(value) {
      return values.indexOf(value) >= 0;
    }
  };
};
/**
 *
 * @param {number | boolean | string} value
 */

var _default = function _default(value) {
  switch (_typeof(value)) {
    case "string":
      return {
        type: String,
        default: value
      };

    case "number":
      return {
        type: Number,
        default: value
      };

    case "boolean":
      return {
        type: Boolean,
        default: value
      };
  }
};

var $default = _default;
var ValueCtors = [String, Number, Boolean];
var $valueWithDefault = function $valueWithDefault(value) {
  return {
    type: ValueCtors,
    default: value
  };
};
var $modelValueWithDefault = function $modelValueWithDefault(value) {
  return {
    type: [Array].concat(ValueCtors),
    default: value
  };
};

// of props, injections and computed properties.

var InputMixin = {
  inject: {
    itemId: {
      default: null
    }
  },
  mixins: [Compactable],
  props: {
    state: $enum("valid", "invalid", "warning"),
    required: $default(false),
    disabled: $default(false),
    readonly: $default(false),
    // If true, certain classes like fd-input and fd-form__control
    // are not added to the input-element.
    plain: $default(false)
  },
  computed: {
    inputClasses: function inputClasses() {
      return {
        "fd-form__control": !this.plain,
        "fd-input--compact": this.finalCompact,
        "is-required": this.required,
        "is-valid": this.state === "valid",
        "is-invalid": this.state === "invalid",
        "is-warning": this.state === "warning"
      };
    },
    inputId: function inputId() {
      return this.itemId;
    }
  }
};

var script$l = {
  methods: {
    handleBlur: function handleBlur(event) {
      this.focused = false;
      this.$emit("blur", event);
    },
    handleFocus: function handleFocus(event) {
      this.focused = true;
      this.$emit("focus", event);
    },
    handleChange: function handleChange(event) {
      this.$emit("change", event.target.value);
    },
    handleUpdate: function handleUpdate(event) {
      this.$emit("update", event.target.value);
    }
  },
  name: "FdInput",
  mixins: [InputMixin],
  model: {
    event: "update"
  },
  data: function data() {
    return {
      focused: false
    };
  },
  computed: {
    listeners: function listeners() {
      return _objectSpread2({}, this.$listeners, {
        change: this.handleChange,
        input: this.handleUpdate
      });
    },
    inputClasses_: function inputClasses_() {
      return _objectSpread2({}, this.inputClasses, {
        "fd-input": !this.plain
      });
    }
  },
  props: {
    placeholder: $default(""),
    type: $default("text"),
    value: $valueWithDefault("")
  }
};

/* script */
var __vue_script__$l = script$l;
/* template */

var __vue_render__$h = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _vm.type === 'textarea' ? _c('textarea', _vm._g(_vm._b({
    class: _vm.inputClasses,
    attrs: {
      "readonly": _vm.readonly ? '' : null,
      "disabled": _vm.disabled ? '' : null,
      "placeholder": _vm.placeholder,
      "id": _vm.inputId
    },
    domProps: {
      "value": _vm.value
    }
  }, 'textarea', _vm.$attrs, false), _vm.listeners)) : _c('input', _vm._g(_vm._b({
    class: _vm.inputClasses_,
    attrs: {
      "readonly": _vm.readonly ? '' : null,
      "disabled": _vm.disabled ? '' : null,
      "type": _vm.type,
      "placeholder": _vm.placeholder,
      "id": _vm.inputId
    },
    domProps: {
      "value": _vm.value
    },
    on: {
      "blur": _vm.handleBlur,
      "focus": _vm.handleFocus
    }
  }, 'input', _vm.$attrs, false), _vm.listeners));
};

var __vue_staticRenderFns__$h = [];
/* style */

var __vue_inject_styles__$l = undefined;
/* scoped */

var __vue_scope_id__$l = undefined;
/* module identifier */

var __vue_module_identifier__$l = undefined;
/* functional template */

var __vue_is_functional_template__$l = false;
/* style inject */

/* style inject SSR */

var FdInput = normalizeComponent_1({
  render: __vue_render__$h,
  staticRenderFns: __vue_staticRenderFns__$h
}, __vue_inject_styles__$l, __vue_script__$l, __vue_scope_id__$l, __vue_is_functional_template__$l, __vue_module_identifier__$l, undefined, undefined);

var CreateAddon = function CreateAddon(context) {
  return {
    name: "fd-addon-provider-".concat(context),
    provide: function provide() {
      return {
        $_fdInputGroupAddonContext: context
      };
    },
    render: function render(h) {
      var defaultSlot = this.$scopedSlots.default;

      if (defaultSlot) {
        return defaultSlot();
      }

      return h("");
    }
  };
};

var script$m = {
  name: "FdInputGroup",
  mixins: [CompactableContainer],
  components: {
    FdAddonProviderBefore: CreateAddon("before"),
    FdAddonProviderAfter: CreateAddon("after")
  },
  computed: {
    afterClasses: function afterClasses() {
      var afterClass = this.afterClass;
      return ["fd-input-group__addon", "fd-input-group__addon--after", this.finalCompact ? "fd-input-group--compact" : ""].concat(_toConsumableArray(afterClass != null ? [afterClass] : []));
    },
    classes: function classes() {
      return {
        "fd-input-group--before": this.before || this.$slots.before,
        "fd-input-group--after": this.after || this.$slots.after,
        "fd-input-group--compact": this.compact
      };
    }
  }
};

/* script */
var __vue_script__$m = script$m;
/* template */

var __vue_render__$i = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-input-group",
    class: _vm.classes
  }, [_c('fd-addon-provider-before', [_vm._t("before")], 2), _vm._v(" "), _vm._t("before-input"), _vm._v(" "), _vm._t("input"), _vm._v(" "), _vm._t("after-input"), _vm._v(" "), _c('fd-addon-provider-after', [_vm._t("after")], 2)], 2);
};

var __vue_staticRenderFns__$i = [];
/* style */

var __vue_inject_styles__$m = undefined;
/* scoped */

var __vue_scope_id__$m = undefined;
/* module identifier */

var __vue_module_identifier__$m = undefined;
/* functional template */

var __vue_is_functional_template__$m = false;
/* style inject */

/* style inject SSR */

var FdInputGroup = normalizeComponent_1({
  render: __vue_render__$i,
  staticRenderFns: __vue_staticRenderFns__$i
}, __vue_inject_styles__$m, __vue_script__$m, __vue_scope_id__$m, __vue_is_functional_template__$m, __vue_module_identifier__$m, undefined, undefined);

//
//
//
//
// Use this in before-/after-slots within fd-input-groups.
var script$n = {
  name: "FdInputGroupAddon",
  inject: {
    $_fdInputGroupAddonContext: {
      default: null
    }
  },
  provide: function provide() {
    return {
      $_fdInputGroupAddon: this
    };
  },
  data: function data() {
    return {
      hasButton: false
    };
  },
  computed: {
    addonContext: function addonContext() {
      return this.$_fdInputGroupAddonContext;
    },
    classes: function classes() {
      return {
        "fd-input-group__addon--button": this.hasButton,
        "fd-input-group__addon--before": this.addonContext === "before",
        "fd-input-group__addon--after": this.addonContext === "after"
      };
    }
  }
};

/* script */
var __vue_script__$n = script$n;
/* template */

var __vue_render__$j = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('span', {
    staticClass: "fd-input-group__addon",
    class: _vm.classes
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$j = [];
/* style */

var __vue_inject_styles__$n = undefined;
/* scoped */

var __vue_scope_id__$n = undefined;
/* module identifier */

var __vue_module_identifier__$n = undefined;
/* functional template */

var __vue_is_functional_template__$n = false;
/* style inject */

/* style inject SSR */

var FdInputGroupAddon = normalizeComponent_1({
  render: __vue_render__$j,
  staticRenderFns: __vue_staticRenderFns__$j
}, __vue_inject_styles__$n, __vue_script__$n, __vue_scope_id__$n, __vue_is_functional_template__$n, __vue_module_identifier__$n, undefined, undefined);

var url = 'bjectSymhasOwnProp-0123456789ABCDEFGHIJKLMNQRTUVWXYZ_dfgiklquvxz';

/**
 * Generate URL-friendly unique ID. This method use non-secure predictable
 * random generator.
 *
 * By default, ID will have 21 symbols to have a collision probability similar
 * to UUID v4.
 *
 * @param {number} [size=21] The number of symbols in ID.
 *
 * @return {string} Random string.
 *
 * @example
 * const nanoid = require('nanoid/non-secure')
 * model.id = nanoid() //=> "Uakgb_J5m9g-0JDMbcJqL"
 *
 * @name nonSecure
 * @function
 */
var nonSecure = function (size) {
  size = size || 21;
  var id = '';
  while (0 < size--) {
    id += url[Math.random() * 64 | 0];
  }
  return id
};

function _typeof$1(obj) {
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof$1 = function (obj) {
      return typeof obj;
    };
  } else {
    _typeof$1 = function (obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
  }

  return _typeof$1(obj);
}

var config = {
  selector: "vue-portal-target-".concat(nonSecure())
};
var setSelector = function setSelector(selector) {
  return config.selector = selector;
};
var isBrowser$1 = typeof window !== 'undefined' && (typeof document === "undefined" ? "undefined" : _typeof$1(document)) !== undefined;

var TargetContainer = Vue$1.extend({
  // as an abstract component, it doesn't appear in
  // the $parent chain of components.
  // which means the next parent of any component rendered inside of this oen
  // will be the parent from which is was portal'd
  abstract: true,
  name: 'PortalOutlet',
  props: ['nodes', 'tag'],
  data: function data(vm) {
    return {
      updatedNodes: vm.nodes
    };
  },
  render: function render(h) {
    var nodes = this.updatedNodes && this.updatedNodes();
    if (!nodes) return h();
    return nodes.length < 2 && !nodes[0].text ? nodes : h(this.tag || 'DIV', nodes);
  },
  destroyed: function destroyed() {
    var el = this.$el;
    el.parentNode.removeChild(el);
  }
});

var Portal = Vue$1.extend({
  name: 'VueSimplePortal',
  props: {
    disabled: {
      type: Boolean
    },
    prepend: {
      type: Boolean
    },
    selector: {
      type: String,
      default: function _default() {
        return "#".concat(config.selector);
      }
    },
    tag: {
      type: String,
      default: 'DIV'
    }
  },
  render: function render(h) {
    if (this.disabled) {
      var nodes = this.$scopedSlots && this.$scopedSlots.default();
      if (!nodes) return h();
      return nodes.length < 2 && !nodes[0].text ? nodes : h(this.tag, nodes);
    }

    return h();
  },
  created: function created() {
    if (!this.getTargetEl()) {
      this.insertTargetEl();
    }
  },
  updated: function updated() {
    var _this = this;

    // We only update the target container component
    // if the scoped slot function is a fresh one
    // The new slot syntax (since Vue 2.6) can cache unchanged slot functions
    // and we want to respect that here.
    this.$nextTick(function () {
      if (!_this.disabled && _this.slotFn !== _this.$scopedSlots.default) {
        _this.container.updatedNodes = _this.$scopedSlots.default;
      }

      _this.slotFn = _this.$scopedSlots.default;
    });
  },
  beforeDestroy: function beforeDestroy() {
    this.unmount();
  },
  watch: {
    disabled: {
      immediate: true,
      handler: function handler(disabled) {
        disabled ? this.unmount() : this.$nextTick(this.mount);
      }
    }
  },
  methods: {
    // This returns the element into which the content should be mounted.
    getTargetEl: function getTargetEl() {
      if (!isBrowser$1) return;
      return document.querySelector(this.selector);
    },
    insertTargetEl: function insertTargetEl() {
      if (!isBrowser$1) return;
      var parent = document.querySelector('body');
      var child = document.createElement(this.tag);
      child.id = this.selector.substring(1);
      parent.appendChild(child);
    },
    mount: function mount() {
      var targetEl = this.getTargetEl();
      var el = document.createElement('DIV');

      if (this.prepend && targetEl.firstChild) {
        targetEl.insertBefore(el, targetEl.firstChild);
      } else {
        targetEl.appendChild(el);
      }

      this.container = new TargetContainer({
        el: el,
        parent: this,
        propsData: {
          tag: this.tag,
          nodes: this.$scopedSlots.default
        }
      });
    },
    unmount: function unmount() {
      if (this.container) {
        this.container.$destroy();
        delete this.container;
      }
    }
  }
});

function install(_Vue) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  _Vue.component(options.name || 'portal', Portal);

  if (options.defaultSelector) {
    setSelector(options.defaultSelector);
  }
}

if (typeof window !== 'undefined' && window.Vue && window.Vue === Vue$1) {
  // plugin was inlcuded directly in a browser
  Vue$1.use(install);
}

/**!
 * @fileOverview Kickass library to create and place poppers near their reference elements.
 * @version 1.15.0
 * @license
 * Copyright (c) 2016 Federico Zivolo and contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
var isBrowser$2 = typeof window !== 'undefined' && typeof document !== 'undefined';

var longerTimeoutBrowsers = ['Edge', 'Trident', 'Firefox'];
var timeoutDuration = 0;
for (var i = 0; i < longerTimeoutBrowsers.length; i += 1) {
  if (isBrowser$2 && navigator.userAgent.indexOf(longerTimeoutBrowsers[i]) >= 0) {
    timeoutDuration = 1;
    break;
  }
}

function microtaskDebounce(fn) {
  var called = false;
  return function () {
    if (called) {
      return;
    }
    called = true;
    window.Promise.resolve().then(function () {
      called = false;
      fn();
    });
  };
}

function taskDebounce(fn) {
  var scheduled = false;
  return function () {
    if (!scheduled) {
      scheduled = true;
      setTimeout(function () {
        scheduled = false;
        fn();
      }, timeoutDuration);
    }
  };
}

var supportsMicroTasks = isBrowser$2 && window.Promise;

/**
* Create a debounced version of a method, that's asynchronously deferred
* but called in the minimum time possible.
*
* @method
* @memberof Popper.Utils
* @argument {Function} fn
* @returns {Function}
*/
var debounce = supportsMicroTasks ? microtaskDebounce : taskDebounce;

/**
 * Check if the given variable is a function
 * @method
 * @memberof Popper.Utils
 * @argument {Any} functionToCheck - variable to check
 * @returns {Boolean} answer to: is a function?
 */
function isFunction(functionToCheck) {
  var getType = {};
  return functionToCheck && getType.toString.call(functionToCheck) === '[object Function]';
}

/**
 * Get CSS computed property of the given element
 * @method
 * @memberof Popper.Utils
 * @argument {Eement} element
 * @argument {String} property
 */
function getStyleComputedProperty(element, property) {
  if (element.nodeType !== 1) {
    return [];
  }
  // NOTE: 1 DOM access here
  var window = element.ownerDocument.defaultView;
  var css = window.getComputedStyle(element, null);
  return property ? css[property] : css;
}

/**
 * Returns the parentNode or the host of the element
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @returns {Element} parent
 */
function getParentNode(element) {
  if (element.nodeName === 'HTML') {
    return element;
  }
  return element.parentNode || element.host;
}

/**
 * Returns the scrolling parent of the given element
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @returns {Element} scroll parent
 */
function getScrollParent(element) {
  // Return body, `getScroll` will take care to get the correct `scrollTop` from it
  if (!element) {
    return document.body;
  }

  switch (element.nodeName) {
    case 'HTML':
    case 'BODY':
      return element.ownerDocument.body;
    case '#document':
      return element.body;
  }

  // Firefox want us to check `-x` and `-y` variations as well

  var _getStyleComputedProp = getStyleComputedProperty(element),
      overflow = _getStyleComputedProp.overflow,
      overflowX = _getStyleComputedProp.overflowX,
      overflowY = _getStyleComputedProp.overflowY;

  if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
    return element;
  }

  return getScrollParent(getParentNode(element));
}

var isIE11 = isBrowser$2 && !!(window.MSInputMethodContext && document.documentMode);
var isIE10 = isBrowser$2 && /MSIE 10/.test(navigator.userAgent);

/**
 * Determines if the browser is Internet Explorer
 * @method
 * @memberof Popper.Utils
 * @param {Number} version to check
 * @returns {Boolean} isIE
 */
function isIE(version) {
  if (version === 11) {
    return isIE11;
  }
  if (version === 10) {
    return isIE10;
  }
  return isIE11 || isIE10;
}

/**
 * Returns the offset parent of the given element
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @returns {Element} offset parent
 */
function getOffsetParent(element) {
  if (!element) {
    return document.documentElement;
  }

  var noOffsetParent = isIE(10) ? document.body : null;

  // NOTE: 1 DOM access here
  var offsetParent = element.offsetParent || null;
  // Skip hidden elements which don't have an offsetParent
  while (offsetParent === noOffsetParent && element.nextElementSibling) {
    offsetParent = (element = element.nextElementSibling).offsetParent;
  }

  var nodeName = offsetParent && offsetParent.nodeName;

  if (!nodeName || nodeName === 'BODY' || nodeName === 'HTML') {
    return element ? element.ownerDocument.documentElement : document.documentElement;
  }

  // .offsetParent will return the closest TH, TD or TABLE in case
  // no offsetParent is present, I hate this job...
  if (['TH', 'TD', 'TABLE'].indexOf(offsetParent.nodeName) !== -1 && getStyleComputedProperty(offsetParent, 'position') === 'static') {
    return getOffsetParent(offsetParent);
  }

  return offsetParent;
}

function isOffsetContainer(element) {
  var nodeName = element.nodeName;

  if (nodeName === 'BODY') {
    return false;
  }
  return nodeName === 'HTML' || getOffsetParent(element.firstElementChild) === element;
}

/**
 * Finds the root node (document, shadowDOM root) of the given element
 * @method
 * @memberof Popper.Utils
 * @argument {Element} node
 * @returns {Element} root node
 */
function getRoot(node) {
  if (node.parentNode !== null) {
    return getRoot(node.parentNode);
  }

  return node;
}

/**
 * Finds the offset parent common to the two provided nodes
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element1
 * @argument {Element} element2
 * @returns {Element} common offset parent
 */
function findCommonOffsetParent(element1, element2) {
  // This check is needed to avoid errors in case one of the elements isn't defined for any reason
  if (!element1 || !element1.nodeType || !element2 || !element2.nodeType) {
    return document.documentElement;
  }

  // Here we make sure to give as "start" the element that comes first in the DOM
  var order = element1.compareDocumentPosition(element2) & Node.DOCUMENT_POSITION_FOLLOWING;
  var start = order ? element1 : element2;
  var end = order ? element2 : element1;

  // Get common ancestor container
  var range = document.createRange();
  range.setStart(start, 0);
  range.setEnd(end, 0);
  var commonAncestorContainer = range.commonAncestorContainer;

  // Both nodes are inside #document

  if (element1 !== commonAncestorContainer && element2 !== commonAncestorContainer || start.contains(end)) {
    if (isOffsetContainer(commonAncestorContainer)) {
      return commonAncestorContainer;
    }

    return getOffsetParent(commonAncestorContainer);
  }

  // one of the nodes is inside shadowDOM, find which one
  var element1root = getRoot(element1);
  if (element1root.host) {
    return findCommonOffsetParent(element1root.host, element2);
  } else {
    return findCommonOffsetParent(element1, getRoot(element2).host);
  }
}

/**
 * Gets the scroll value of the given element in the given side (top and left)
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @argument {String} side `top` or `left`
 * @returns {number} amount of scrolled pixels
 */
function getScroll(element) {
  var side = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'top';

  var upperSide = side === 'top' ? 'scrollTop' : 'scrollLeft';
  var nodeName = element.nodeName;

  if (nodeName === 'BODY' || nodeName === 'HTML') {
    var html = element.ownerDocument.documentElement;
    var scrollingElement = element.ownerDocument.scrollingElement || html;
    return scrollingElement[upperSide];
  }

  return element[upperSide];
}

/*
 * Sum or subtract the element scroll values (left and top) from a given rect object
 * @method
 * @memberof Popper.Utils
 * @param {Object} rect - Rect object you want to change
 * @param {HTMLElement} element - The element from the function reads the scroll values
 * @param {Boolean} subtract - set to true if you want to subtract the scroll values
 * @return {Object} rect - The modifier rect object
 */
function includeScroll(rect, element) {
  var subtract = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

  var scrollTop = getScroll(element, 'top');
  var scrollLeft = getScroll(element, 'left');
  var modifier = subtract ? -1 : 1;
  rect.top += scrollTop * modifier;
  rect.bottom += scrollTop * modifier;
  rect.left += scrollLeft * modifier;
  rect.right += scrollLeft * modifier;
  return rect;
}

/*
 * Helper to detect borders of a given element
 * @method
 * @memberof Popper.Utils
 * @param {CSSStyleDeclaration} styles
 * Result of `getStyleComputedProperty` on the given element
 * @param {String} axis - `x` or `y`
 * @return {number} borders - The borders size of the given axis
 */

function getBordersSize(styles, axis) {
  var sideA = axis === 'x' ? 'Left' : 'Top';
  var sideB = sideA === 'Left' ? 'Right' : 'Bottom';

  return parseFloat(styles['border' + sideA + 'Width'], 10) + parseFloat(styles['border' + sideB + 'Width'], 10);
}

function getSize(axis, body, html, computedStyle) {
  return Math.max(body['offset' + axis], body['scroll' + axis], html['client' + axis], html['offset' + axis], html['scroll' + axis], isIE(10) ? parseInt(html['offset' + axis]) + parseInt(computedStyle['margin' + (axis === 'Height' ? 'Top' : 'Left')]) + parseInt(computedStyle['margin' + (axis === 'Height' ? 'Bottom' : 'Right')]) : 0);
}

function getWindowSizes(document) {
  var body = document.body;
  var html = document.documentElement;
  var computedStyle = isIE(10) && getComputedStyle(html);

  return {
    height: getSize('Height', body, html, computedStyle),
    width: getSize('Width', body, html, computedStyle)
  };
}

var classCallCheck = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

var createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);
    if (staticProps) defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();





var defineProperty = function (obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
};

var _extends = Object.assign || function (target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i];

    for (var key in source) {
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }

  return target;
};

/**
 * Given element offsets, generate an output similar to getBoundingClientRect
 * @method
 * @memberof Popper.Utils
 * @argument {Object} offsets
 * @returns {Object} ClientRect like output
 */
function getClientRect(offsets) {
  return _extends({}, offsets, {
    right: offsets.left + offsets.width,
    bottom: offsets.top + offsets.height
  });
}

/**
 * Get bounding client rect of given element
 * @method
 * @memberof Popper.Utils
 * @param {HTMLElement} element
 * @return {Object} client rect
 */
function getBoundingClientRect(element) {
  var rect = {};

  // IE10 10 FIX: Please, don't ask, the element isn't
  // considered in DOM in some circumstances...
  // This isn't reproducible in IE10 compatibility mode of IE11
  try {
    if (isIE(10)) {
      rect = element.getBoundingClientRect();
      var scrollTop = getScroll(element, 'top');
      var scrollLeft = getScroll(element, 'left');
      rect.top += scrollTop;
      rect.left += scrollLeft;
      rect.bottom += scrollTop;
      rect.right += scrollLeft;
    } else {
      rect = element.getBoundingClientRect();
    }
  } catch (e) {}

  var result = {
    left: rect.left,
    top: rect.top,
    width: rect.right - rect.left,
    height: rect.bottom - rect.top
  };

  // subtract scrollbar size from sizes
  var sizes = element.nodeName === 'HTML' ? getWindowSizes(element.ownerDocument) : {};
  var width = sizes.width || element.clientWidth || result.right - result.left;
  var height = sizes.height || element.clientHeight || result.bottom - result.top;

  var horizScrollbar = element.offsetWidth - width;
  var vertScrollbar = element.offsetHeight - height;

  // if an hypothetical scrollbar is detected, we must be sure it's not a `border`
  // we make this check conditional for performance reasons
  if (horizScrollbar || vertScrollbar) {
    var styles = getStyleComputedProperty(element);
    horizScrollbar -= getBordersSize(styles, 'x');
    vertScrollbar -= getBordersSize(styles, 'y');

    result.width -= horizScrollbar;
    result.height -= vertScrollbar;
  }

  return getClientRect(result);
}

function getOffsetRectRelativeToArbitraryNode(children, parent) {
  var fixedPosition = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

  var isIE10 = isIE(10);
  var isHTML = parent.nodeName === 'HTML';
  var childrenRect = getBoundingClientRect(children);
  var parentRect = getBoundingClientRect(parent);
  var scrollParent = getScrollParent(children);

  var styles = getStyleComputedProperty(parent);
  var borderTopWidth = parseFloat(styles.borderTopWidth, 10);
  var borderLeftWidth = parseFloat(styles.borderLeftWidth, 10);

  // In cases where the parent is fixed, we must ignore negative scroll in offset calc
  if (fixedPosition && isHTML) {
    parentRect.top = Math.max(parentRect.top, 0);
    parentRect.left = Math.max(parentRect.left, 0);
  }
  var offsets = getClientRect({
    top: childrenRect.top - parentRect.top - borderTopWidth,
    left: childrenRect.left - parentRect.left - borderLeftWidth,
    width: childrenRect.width,
    height: childrenRect.height
  });
  offsets.marginTop = 0;
  offsets.marginLeft = 0;

  // Subtract margins of documentElement in case it's being used as parent
  // we do this only on HTML because it's the only element that behaves
  // differently when margins are applied to it. The margins are included in
  // the box of the documentElement, in the other cases not.
  if (!isIE10 && isHTML) {
    var marginTop = parseFloat(styles.marginTop, 10);
    var marginLeft = parseFloat(styles.marginLeft, 10);

    offsets.top -= borderTopWidth - marginTop;
    offsets.bottom -= borderTopWidth - marginTop;
    offsets.left -= borderLeftWidth - marginLeft;
    offsets.right -= borderLeftWidth - marginLeft;

    // Attach marginTop and marginLeft because in some circumstances we may need them
    offsets.marginTop = marginTop;
    offsets.marginLeft = marginLeft;
  }

  if (isIE10 && !fixedPosition ? parent.contains(scrollParent) : parent === scrollParent && scrollParent.nodeName !== 'BODY') {
    offsets = includeScroll(offsets, parent);
  }

  return offsets;
}

function getViewportOffsetRectRelativeToArtbitraryNode(element) {
  var excludeScroll = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

  var html = element.ownerDocument.documentElement;
  var relativeOffset = getOffsetRectRelativeToArbitraryNode(element, html);
  var width = Math.max(html.clientWidth, window.innerWidth || 0);
  var height = Math.max(html.clientHeight, window.innerHeight || 0);

  var scrollTop = !excludeScroll ? getScroll(html) : 0;
  var scrollLeft = !excludeScroll ? getScroll(html, 'left') : 0;

  var offset = {
    top: scrollTop - relativeOffset.top + relativeOffset.marginTop,
    left: scrollLeft - relativeOffset.left + relativeOffset.marginLeft,
    width: width,
    height: height
  };

  return getClientRect(offset);
}

/**
 * Check if the given element is fixed or is inside a fixed parent
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @argument {Element} customContainer
 * @returns {Boolean} answer to "isFixed?"
 */
function isFixed(element) {
  var nodeName = element.nodeName;
  if (nodeName === 'BODY' || nodeName === 'HTML') {
    return false;
  }
  if (getStyleComputedProperty(element, 'position') === 'fixed') {
    return true;
  }
  var parentNode = getParentNode(element);
  if (!parentNode) {
    return false;
  }
  return isFixed(parentNode);
}

/**
 * Finds the first parent of an element that has a transformed property defined
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @returns {Element} first transformed parent or documentElement
 */

function getFixedPositionOffsetParent(element) {
  // This check is needed to avoid errors in case one of the elements isn't defined for any reason
  if (!element || !element.parentElement || isIE()) {
    return document.documentElement;
  }
  var el = element.parentElement;
  while (el && getStyleComputedProperty(el, 'transform') === 'none') {
    el = el.parentElement;
  }
  return el || document.documentElement;
}

/**
 * Computed the boundaries limits and return them
 * @method
 * @memberof Popper.Utils
 * @param {HTMLElement} popper
 * @param {HTMLElement} reference
 * @param {number} padding
 * @param {HTMLElement} boundariesElement - Element used to define the boundaries
 * @param {Boolean} fixedPosition - Is in fixed position mode
 * @returns {Object} Coordinates of the boundaries
 */
function getBoundaries(popper, reference, padding, boundariesElement) {
  var fixedPosition = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;

  // NOTE: 1 DOM access here

  var boundaries = { top: 0, left: 0 };
  var offsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, reference);

  // Handle viewport case
  if (boundariesElement === 'viewport') {
    boundaries = getViewportOffsetRectRelativeToArtbitraryNode(offsetParent, fixedPosition);
  } else {
    // Handle other cases based on DOM element used as boundaries
    var boundariesNode = void 0;
    if (boundariesElement === 'scrollParent') {
      boundariesNode = getScrollParent(getParentNode(reference));
      if (boundariesNode.nodeName === 'BODY') {
        boundariesNode = popper.ownerDocument.documentElement;
      }
    } else if (boundariesElement === 'window') {
      boundariesNode = popper.ownerDocument.documentElement;
    } else {
      boundariesNode = boundariesElement;
    }

    var offsets = getOffsetRectRelativeToArbitraryNode(boundariesNode, offsetParent, fixedPosition);

    // In case of HTML, we need a different computation
    if (boundariesNode.nodeName === 'HTML' && !isFixed(offsetParent)) {
      var _getWindowSizes = getWindowSizes(popper.ownerDocument),
          height = _getWindowSizes.height,
          width = _getWindowSizes.width;

      boundaries.top += offsets.top - offsets.marginTop;
      boundaries.bottom = height + offsets.top;
      boundaries.left += offsets.left - offsets.marginLeft;
      boundaries.right = width + offsets.left;
    } else {
      // for all the other DOM elements, this one is good
      boundaries = offsets;
    }
  }

  // Add paddings
  padding = padding || 0;
  var isPaddingNumber = typeof padding === 'number';
  boundaries.left += isPaddingNumber ? padding : padding.left || 0;
  boundaries.top += isPaddingNumber ? padding : padding.top || 0;
  boundaries.right -= isPaddingNumber ? padding : padding.right || 0;
  boundaries.bottom -= isPaddingNumber ? padding : padding.bottom || 0;

  return boundaries;
}

function getArea(_ref) {
  var width = _ref.width,
      height = _ref.height;

  return width * height;
}

/**
 * Utility used to transform the `auto` placement to the placement with more
 * available space.
 * @method
 * @memberof Popper.Utils
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function computeAutoPlacement(placement, refRect, popper, reference, boundariesElement) {
  var padding = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;

  if (placement.indexOf('auto') === -1) {
    return placement;
  }

  var boundaries = getBoundaries(popper, reference, padding, boundariesElement);

  var rects = {
    top: {
      width: boundaries.width,
      height: refRect.top - boundaries.top
    },
    right: {
      width: boundaries.right - refRect.right,
      height: boundaries.height
    },
    bottom: {
      width: boundaries.width,
      height: boundaries.bottom - refRect.bottom
    },
    left: {
      width: refRect.left - boundaries.left,
      height: boundaries.height
    }
  };

  var sortedAreas = Object.keys(rects).map(function (key) {
    return _extends({
      key: key
    }, rects[key], {
      area: getArea(rects[key])
    });
  }).sort(function (a, b) {
    return b.area - a.area;
  });

  var filteredAreas = sortedAreas.filter(function (_ref2) {
    var width = _ref2.width,
        height = _ref2.height;
    return width >= popper.clientWidth && height >= popper.clientHeight;
  });

  var computedPlacement = filteredAreas.length > 0 ? filteredAreas[0].key : sortedAreas[0].key;

  var variation = placement.split('-')[1];

  return computedPlacement + (variation ? '-' + variation : '');
}

/**
 * Get offsets to the reference element
 * @method
 * @memberof Popper.Utils
 * @param {Object} state
 * @param {Element} popper - the popper element
 * @param {Element} reference - the reference element (the popper will be relative to this)
 * @param {Element} fixedPosition - is in fixed position mode
 * @returns {Object} An object containing the offsets which will be applied to the popper
 */
function getReferenceOffsets(state, popper, reference) {
  var fixedPosition = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;

  var commonOffsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, reference);
  return getOffsetRectRelativeToArbitraryNode(reference, commonOffsetParent, fixedPosition);
}

/**
 * Get the outer sizes of the given element (offset size + margins)
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @returns {Object} object containing width and height properties
 */
function getOuterSizes(element) {
  var window = element.ownerDocument.defaultView;
  var styles = window.getComputedStyle(element);
  var x = parseFloat(styles.marginTop || 0) + parseFloat(styles.marginBottom || 0);
  var y = parseFloat(styles.marginLeft || 0) + parseFloat(styles.marginRight || 0);
  var result = {
    width: element.offsetWidth + y,
    height: element.offsetHeight + x
  };
  return result;
}

/**
 * Get the opposite placement of the given one
 * @method
 * @memberof Popper.Utils
 * @argument {String} placement
 * @returns {String} flipped placement
 */
function getOppositePlacement(placement) {
  var hash = { left: 'right', right: 'left', bottom: 'top', top: 'bottom' };
  return placement.replace(/left|right|bottom|top/g, function (matched) {
    return hash[matched];
  });
}

/**
 * Get offsets to the popper
 * @method
 * @memberof Popper.Utils
 * @param {Object} position - CSS position the Popper will get applied
 * @param {HTMLElement} popper - the popper element
 * @param {Object} referenceOffsets - the reference offsets (the popper will be relative to this)
 * @param {String} placement - one of the valid placement options
 * @returns {Object} popperOffsets - An object containing the offsets which will be applied to the popper
 */
function getPopperOffsets(popper, referenceOffsets, placement) {
  placement = placement.split('-')[0];

  // Get popper node sizes
  var popperRect = getOuterSizes(popper);

  // Add position, width and height to our offsets object
  var popperOffsets = {
    width: popperRect.width,
    height: popperRect.height
  };

  // depending by the popper placement we have to compute its offsets slightly differently
  var isHoriz = ['right', 'left'].indexOf(placement) !== -1;
  var mainSide = isHoriz ? 'top' : 'left';
  var secondarySide = isHoriz ? 'left' : 'top';
  var measurement = isHoriz ? 'height' : 'width';
  var secondaryMeasurement = !isHoriz ? 'height' : 'width';

  popperOffsets[mainSide] = referenceOffsets[mainSide] + referenceOffsets[measurement] / 2 - popperRect[measurement] / 2;
  if (placement === secondarySide) {
    popperOffsets[secondarySide] = referenceOffsets[secondarySide] - popperRect[secondaryMeasurement];
  } else {
    popperOffsets[secondarySide] = referenceOffsets[getOppositePlacement(secondarySide)];
  }

  return popperOffsets;
}

/**
 * Mimics the `find` method of Array
 * @method
 * @memberof Popper.Utils
 * @argument {Array} arr
 * @argument prop
 * @argument value
 * @returns index or -1
 */
function find(arr, check) {
  // use native find if supported
  if (Array.prototype.find) {
    return arr.find(check);
  }

  // use `filter` to obtain the same behavior of `find`
  return arr.filter(check)[0];
}

/**
 * Return the index of the matching object
 * @method
 * @memberof Popper.Utils
 * @argument {Array} arr
 * @argument prop
 * @argument value
 * @returns index or -1
 */
function findIndex(arr, prop, value) {
  // use native findIndex if supported
  if (Array.prototype.findIndex) {
    return arr.findIndex(function (cur) {
      return cur[prop] === value;
    });
  }

  // use `find` + `indexOf` if `findIndex` isn't supported
  var match = find(arr, function (obj) {
    return obj[prop] === value;
  });
  return arr.indexOf(match);
}

/**
 * Loop trough the list of modifiers and run them in order,
 * each of them will then edit the data object.
 * @method
 * @memberof Popper.Utils
 * @param {dataObject} data
 * @param {Array} modifiers
 * @param {String} ends - Optional modifier name used as stopper
 * @returns {dataObject}
 */
function runModifiers(modifiers, data, ends) {
  var modifiersToRun = ends === undefined ? modifiers : modifiers.slice(0, findIndex(modifiers, 'name', ends));

  modifiersToRun.forEach(function (modifier) {
    if (modifier['function']) {
      // eslint-disable-line dot-notation
      console.warn('`modifier.function` is deprecated, use `modifier.fn`!');
    }
    var fn = modifier['function'] || modifier.fn; // eslint-disable-line dot-notation
    if (modifier.enabled && isFunction(fn)) {
      // Add properties to offsets to make them a complete clientRect object
      // we do this before each modifier to make sure the previous one doesn't
      // mess with these values
      data.offsets.popper = getClientRect(data.offsets.popper);
      data.offsets.reference = getClientRect(data.offsets.reference);

      data = fn(data, modifier);
    }
  });

  return data;
}

/**
 * Updates the position of the popper, computing the new offsets and applying
 * the new style.<br />
 * Prefer `scheduleUpdate` over `update` because of performance reasons.
 * @method
 * @memberof Popper
 */
function update() {
  // if popper is destroyed, don't perform any further update
  if (this.state.isDestroyed) {
    return;
  }

  var data = {
    instance: this,
    styles: {},
    arrowStyles: {},
    attributes: {},
    flipped: false,
    offsets: {}
  };

  // compute reference element offsets
  data.offsets.reference = getReferenceOffsets(this.state, this.popper, this.reference, this.options.positionFixed);

  // compute auto placement, store placement inside the data object,
  // modifiers will be able to edit `placement` if needed
  // and refer to originalPlacement to know the original value
  data.placement = computeAutoPlacement(this.options.placement, data.offsets.reference, this.popper, this.reference, this.options.modifiers.flip.boundariesElement, this.options.modifiers.flip.padding);

  // store the computed placement inside `originalPlacement`
  data.originalPlacement = data.placement;

  data.positionFixed = this.options.positionFixed;

  // compute the popper offsets
  data.offsets.popper = getPopperOffsets(this.popper, data.offsets.reference, data.placement);

  data.offsets.popper.position = this.options.positionFixed ? 'fixed' : 'absolute';

  // run the modifiers
  data = runModifiers(this.modifiers, data);

  // the first `update` will call `onCreate` callback
  // the other ones will call `onUpdate` callback
  if (!this.state.isCreated) {
    this.state.isCreated = true;
    this.options.onCreate(data);
  } else {
    this.options.onUpdate(data);
  }
}

/**
 * Helper used to know if the given modifier is enabled.
 * @method
 * @memberof Popper.Utils
 * @returns {Boolean}
 */
function isModifierEnabled(modifiers, modifierName) {
  return modifiers.some(function (_ref) {
    var name = _ref.name,
        enabled = _ref.enabled;
    return enabled && name === modifierName;
  });
}

/**
 * Get the prefixed supported property name
 * @method
 * @memberof Popper.Utils
 * @argument {String} property (camelCase)
 * @returns {String} prefixed property (camelCase or PascalCase, depending on the vendor prefix)
 */
function getSupportedPropertyName(property) {
  var prefixes = [false, 'ms', 'Webkit', 'Moz', 'O'];
  var upperProp = property.charAt(0).toUpperCase() + property.slice(1);

  for (var i = 0; i < prefixes.length; i++) {
    var prefix = prefixes[i];
    var toCheck = prefix ? '' + prefix + upperProp : property;
    if (typeof document.body.style[toCheck] !== 'undefined') {
      return toCheck;
    }
  }
  return null;
}

/**
 * Destroys the popper.
 * @method
 * @memberof Popper
 */
function destroy() {
  this.state.isDestroyed = true;

  // touch DOM only if `applyStyle` modifier is enabled
  if (isModifierEnabled(this.modifiers, 'applyStyle')) {
    this.popper.removeAttribute('x-placement');
    this.popper.style.position = '';
    this.popper.style.top = '';
    this.popper.style.left = '';
    this.popper.style.right = '';
    this.popper.style.bottom = '';
    this.popper.style.willChange = '';
    this.popper.style[getSupportedPropertyName('transform')] = '';
  }

  this.disableEventListeners();

  // remove the popper if user explicity asked for the deletion on destroy
  // do not use `remove` because IE11 doesn't support it
  if (this.options.removeOnDestroy) {
    this.popper.parentNode.removeChild(this.popper);
  }
  return this;
}

/**
 * Get the window associated with the element
 * @argument {Element} element
 * @returns {Window}
 */
function getWindow(element) {
  var ownerDocument = element.ownerDocument;
  return ownerDocument ? ownerDocument.defaultView : window;
}

function attachToScrollParents(scrollParent, event, callback, scrollParents) {
  var isBody = scrollParent.nodeName === 'BODY';
  var target = isBody ? scrollParent.ownerDocument.defaultView : scrollParent;
  target.addEventListener(event, callback, { passive: true });

  if (!isBody) {
    attachToScrollParents(getScrollParent(target.parentNode), event, callback, scrollParents);
  }
  scrollParents.push(target);
}

/**
 * Setup needed event listeners used to update the popper position
 * @method
 * @memberof Popper.Utils
 * @private
 */
function setupEventListeners(reference, options, state, updateBound) {
  // Resize event listener on window
  state.updateBound = updateBound;
  getWindow(reference).addEventListener('resize', state.updateBound, { passive: true });

  // Scroll event listener on scroll parents
  var scrollElement = getScrollParent(reference);
  attachToScrollParents(scrollElement, 'scroll', state.updateBound, state.scrollParents);
  state.scrollElement = scrollElement;
  state.eventsEnabled = true;

  return state;
}

/**
 * It will add resize/scroll events and start recalculating
 * position of the popper element when they are triggered.
 * @method
 * @memberof Popper
 */
function enableEventListeners() {
  if (!this.state.eventsEnabled) {
    this.state = setupEventListeners(this.reference, this.options, this.state, this.scheduleUpdate);
  }
}

/**
 * Remove event listeners used to update the popper position
 * @method
 * @memberof Popper.Utils
 * @private
 */
function removeEventListeners(reference, state) {
  // Remove resize event listener on window
  getWindow(reference).removeEventListener('resize', state.updateBound);

  // Remove scroll event listener on scroll parents
  state.scrollParents.forEach(function (target) {
    target.removeEventListener('scroll', state.updateBound);
  });

  // Reset state
  state.updateBound = null;
  state.scrollParents = [];
  state.scrollElement = null;
  state.eventsEnabled = false;
  return state;
}

/**
 * It will remove resize/scroll events and won't recalculate popper position
 * when they are triggered. It also won't trigger `onUpdate` callback anymore,
 * unless you call `update` method manually.
 * @method
 * @memberof Popper
 */
function disableEventListeners() {
  if (this.state.eventsEnabled) {
    cancelAnimationFrame(this.scheduleUpdate);
    this.state = removeEventListeners(this.reference, this.state);
  }
}

/**
 * Tells if a given input is a number
 * @method
 * @memberof Popper.Utils
 * @param {*} input to check
 * @return {Boolean}
 */
function isNumeric(n) {
  return n !== '' && !isNaN(parseFloat(n)) && isFinite(n);
}

/**
 * Set the style to the given popper
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element - Element to apply the style to
 * @argument {Object} styles
 * Object with a list of properties and values which will be applied to the element
 */
function setStyles(element, styles) {
  Object.keys(styles).forEach(function (prop) {
    var unit = '';
    // add unit if the value is numeric and is one of the following
    if (['width', 'height', 'top', 'right', 'bottom', 'left'].indexOf(prop) !== -1 && isNumeric(styles[prop])) {
      unit = 'px';
    }
    element.style[prop] = styles[prop] + unit;
  });
}

/**
 * Set the attributes to the given popper
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element - Element to apply the attributes to
 * @argument {Object} styles
 * Object with a list of properties and values which will be applied to the element
 */
function setAttributes(element, attributes) {
  Object.keys(attributes).forEach(function (prop) {
    var value = attributes[prop];
    if (value !== false) {
      element.setAttribute(prop, attributes[prop]);
    } else {
      element.removeAttribute(prop);
    }
  });
}

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Object} data.styles - List of style properties - values to apply to popper element
 * @argument {Object} data.attributes - List of attribute properties - values to apply to popper element
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The same data object
 */
function applyStyle(data) {
  // any property present in `data.styles` will be applied to the popper,
  // in this way we can make the 3rd party modifiers add custom styles to it
  // Be aware, modifiers could override the properties defined in the previous
  // lines of this modifier!
  setStyles(data.instance.popper, data.styles);

  // any property present in `data.attributes` will be applied to the popper,
  // they will be set as HTML attributes of the element
  setAttributes(data.instance.popper, data.attributes);

  // if arrowElement is defined and arrowStyles has some properties
  if (data.arrowElement && Object.keys(data.arrowStyles).length) {
    setStyles(data.arrowElement, data.arrowStyles);
  }

  return data;
}

/**
 * Set the x-placement attribute before everything else because it could be used
 * to add margins to the popper margins needs to be calculated to get the
 * correct popper offsets.
 * @method
 * @memberof Popper.modifiers
 * @param {HTMLElement} reference - The reference element used to position the popper
 * @param {HTMLElement} popper - The HTML element used as popper
 * @param {Object} options - Popper.js options
 */
function applyStyleOnLoad(reference, popper, options, modifierOptions, state) {
  // compute reference element offsets
  var referenceOffsets = getReferenceOffsets(state, popper, reference, options.positionFixed);

  // compute auto placement, store placement inside the data object,
  // modifiers will be able to edit `placement` if needed
  // and refer to originalPlacement to know the original value
  var placement = computeAutoPlacement(options.placement, referenceOffsets, popper, reference, options.modifiers.flip.boundariesElement, options.modifiers.flip.padding);

  popper.setAttribute('x-placement', placement);

  // Apply `position` to popper before anything else because
  // without the position applied we can't guarantee correct computations
  setStyles(popper, { position: options.positionFixed ? 'fixed' : 'absolute' });

  return options;
}

/**
 * @function
 * @memberof Popper.Utils
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Boolean} shouldRound - If the offsets should be rounded at all
 * @returns {Object} The popper's position offsets rounded
 *
 * The tale of pixel-perfect positioning. It's still not 100% perfect, but as
 * good as it can be within reason.
 * Discussion here: https://github.com/FezVrasta/popper.js/pull/715
 *
 * Low DPI screens cause a popper to be blurry if not using full pixels (Safari
 * as well on High DPI screens).
 *
 * Firefox prefers no rounding for positioning and does not have blurriness on
 * high DPI screens.
 *
 * Only horizontal placement and left/right values need to be considered.
 */
function getRoundedOffsets(data, shouldRound) {
  var _data$offsets = data.offsets,
      popper = _data$offsets.popper,
      reference = _data$offsets.reference;
  var round = Math.round,
      floor = Math.floor;

  var noRound = function noRound(v) {
    return v;
  };

  var referenceWidth = round(reference.width);
  var popperWidth = round(popper.width);

  var isVertical = ['left', 'right'].indexOf(data.placement) !== -1;
  var isVariation = data.placement.indexOf('-') !== -1;
  var sameWidthParity = referenceWidth % 2 === popperWidth % 2;
  var bothOddWidth = referenceWidth % 2 === 1 && popperWidth % 2 === 1;

  var horizontalToInteger = !shouldRound ? noRound : isVertical || isVariation || sameWidthParity ? round : floor;
  var verticalToInteger = !shouldRound ? noRound : round;

  return {
    left: horizontalToInteger(bothOddWidth && !isVariation && shouldRound ? popper.left - 1 : popper.left),
    top: verticalToInteger(popper.top),
    bottom: verticalToInteger(popper.bottom),
    right: horizontalToInteger(popper.right)
  };
}

var isFirefox = isBrowser$2 && /Firefox/i.test(navigator.userAgent);

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function computeStyle(data, options) {
  var x = options.x,
      y = options.y;
  var popper = data.offsets.popper;

  // Remove this legacy support in Popper.js v2

  var legacyGpuAccelerationOption = find(data.instance.modifiers, function (modifier) {
    return modifier.name === 'applyStyle';
  }).gpuAcceleration;
  if (legacyGpuAccelerationOption !== undefined) {
    console.warn('WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!');
  }
  var gpuAcceleration = legacyGpuAccelerationOption !== undefined ? legacyGpuAccelerationOption : options.gpuAcceleration;

  var offsetParent = getOffsetParent(data.instance.popper);
  var offsetParentRect = getBoundingClientRect(offsetParent);

  // Styles
  var styles = {
    position: popper.position
  };

  var offsets = getRoundedOffsets(data, window.devicePixelRatio < 2 || !isFirefox);

  var sideA = x === 'bottom' ? 'top' : 'bottom';
  var sideB = y === 'right' ? 'left' : 'right';

  // if gpuAcceleration is set to `true` and transform is supported,
  //  we use `translate3d` to apply the position to the popper we
  // automatically use the supported prefixed version if needed
  var prefixedProperty = getSupportedPropertyName('transform');

  // now, let's make a step back and look at this code closely (wtf?)
  // If the content of the popper grows once it's been positioned, it
  // may happen that the popper gets misplaced because of the new content
  // overflowing its reference element
  // To avoid this problem, we provide two options (x and y), which allow
  // the consumer to define the offset origin.
  // If we position a popper on top of a reference element, we can set
  // `x` to `top` to make the popper grow towards its top instead of
  // its bottom.
  var left = void 0,
      top = void 0;
  if (sideA === 'bottom') {
    // when offsetParent is <html> the positioning is relative to the bottom of the screen (excluding the scrollbar)
    // and not the bottom of the html element
    if (offsetParent.nodeName === 'HTML') {
      top = -offsetParent.clientHeight + offsets.bottom;
    } else {
      top = -offsetParentRect.height + offsets.bottom;
    }
  } else {
    top = offsets.top;
  }
  if (sideB === 'right') {
    if (offsetParent.nodeName === 'HTML') {
      left = -offsetParent.clientWidth + offsets.right;
    } else {
      left = -offsetParentRect.width + offsets.right;
    }
  } else {
    left = offsets.left;
  }
  if (gpuAcceleration && prefixedProperty) {
    styles[prefixedProperty] = 'translate3d(' + left + 'px, ' + top + 'px, 0)';
    styles[sideA] = 0;
    styles[sideB] = 0;
    styles.willChange = 'transform';
  } else {
    // othwerise, we use the standard `top`, `left`, `bottom` and `right` properties
    var invertTop = sideA === 'bottom' ? -1 : 1;
    var invertLeft = sideB === 'right' ? -1 : 1;
    styles[sideA] = top * invertTop;
    styles[sideB] = left * invertLeft;
    styles.willChange = sideA + ', ' + sideB;
  }

  // Attributes
  var attributes = {
    'x-placement': data.placement
  };

  // Update `data` attributes, styles and arrowStyles
  data.attributes = _extends({}, attributes, data.attributes);
  data.styles = _extends({}, styles, data.styles);
  data.arrowStyles = _extends({}, data.offsets.arrow, data.arrowStyles);

  return data;
}

/**
 * Helper used to know if the given modifier depends from another one.<br />
 * It checks if the needed modifier is listed and enabled.
 * @method
 * @memberof Popper.Utils
 * @param {Array} modifiers - list of modifiers
 * @param {String} requestingName - name of requesting modifier
 * @param {String} requestedName - name of requested modifier
 * @returns {Boolean}
 */
function isModifierRequired(modifiers, requestingName, requestedName) {
  var requesting = find(modifiers, function (_ref) {
    var name = _ref.name;
    return name === requestingName;
  });

  var isRequired = !!requesting && modifiers.some(function (modifier) {
    return modifier.name === requestedName && modifier.enabled && modifier.order < requesting.order;
  });

  if (!isRequired) {
    var _requesting = '`' + requestingName + '`';
    var requested = '`' + requestedName + '`';
    console.warn(requested + ' modifier is required by ' + _requesting + ' modifier in order to work, be sure to include it before ' + _requesting + '!');
  }
  return isRequired;
}

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function arrow(data, options) {
  var _data$offsets$arrow;

  // arrow depends on keepTogether in order to work
  if (!isModifierRequired(data.instance.modifiers, 'arrow', 'keepTogether')) {
    return data;
  }

  var arrowElement = options.element;

  // if arrowElement is a string, suppose it's a CSS selector
  if (typeof arrowElement === 'string') {
    arrowElement = data.instance.popper.querySelector(arrowElement);

    // if arrowElement is not found, don't run the modifier
    if (!arrowElement) {
      return data;
    }
  } else {
    // if the arrowElement isn't a query selector we must check that the
    // provided DOM node is child of its popper node
    if (!data.instance.popper.contains(arrowElement)) {
      console.warn('WARNING: `arrow.element` must be child of its popper element!');
      return data;
    }
  }

  var placement = data.placement.split('-')[0];
  var _data$offsets = data.offsets,
      popper = _data$offsets.popper,
      reference = _data$offsets.reference;

  var isVertical = ['left', 'right'].indexOf(placement) !== -1;

  var len = isVertical ? 'height' : 'width';
  var sideCapitalized = isVertical ? 'Top' : 'Left';
  var side = sideCapitalized.toLowerCase();
  var altSide = isVertical ? 'left' : 'top';
  var opSide = isVertical ? 'bottom' : 'right';
  var arrowElementSize = getOuterSizes(arrowElement)[len];

  //
  // extends keepTogether behavior making sure the popper and its
  // reference have enough pixels in conjunction
  //

  // top/left side
  if (reference[opSide] - arrowElementSize < popper[side]) {
    data.offsets.popper[side] -= popper[side] - (reference[opSide] - arrowElementSize);
  }
  // bottom/right side
  if (reference[side] + arrowElementSize > popper[opSide]) {
    data.offsets.popper[side] += reference[side] + arrowElementSize - popper[opSide];
  }
  data.offsets.popper = getClientRect(data.offsets.popper);

  // compute center of the popper
  var center = reference[side] + reference[len] / 2 - arrowElementSize / 2;

  // Compute the sideValue using the updated popper offsets
  // take popper margin in account because we don't have this info available
  var css = getStyleComputedProperty(data.instance.popper);
  var popperMarginSide = parseFloat(css['margin' + sideCapitalized], 10);
  var popperBorderSide = parseFloat(css['border' + sideCapitalized + 'Width'], 10);
  var sideValue = center - data.offsets.popper[side] - popperMarginSide - popperBorderSide;

  // prevent arrowElement from being placed not contiguously to its popper
  sideValue = Math.max(Math.min(popper[len] - arrowElementSize, sideValue), 0);

  data.arrowElement = arrowElement;
  data.offsets.arrow = (_data$offsets$arrow = {}, defineProperty(_data$offsets$arrow, side, Math.round(sideValue)), defineProperty(_data$offsets$arrow, altSide, ''), _data$offsets$arrow);

  return data;
}

/**
 * Get the opposite placement variation of the given one
 * @method
 * @memberof Popper.Utils
 * @argument {String} placement variation
 * @returns {String} flipped placement variation
 */
function getOppositeVariation(variation) {
  if (variation === 'end') {
    return 'start';
  } else if (variation === 'start') {
    return 'end';
  }
  return variation;
}

/**
 * List of accepted placements to use as values of the `placement` option.<br />
 * Valid placements are:
 * - `auto`
 * - `top`
 * - `right`
 * - `bottom`
 * - `left`
 *
 * Each placement can have a variation from this list:
 * - `-start`
 * - `-end`
 *
 * Variations are interpreted easily if you think of them as the left to right
 * written languages. Horizontally (`top` and `bottom`), `start` is left and `end`
 * is right.<br />
 * Vertically (`left` and `right`), `start` is top and `end` is bottom.
 *
 * Some valid examples are:
 * - `top-end` (on top of reference, right aligned)
 * - `right-start` (on right of reference, top aligned)
 * - `bottom` (on bottom, centered)
 * - `auto-end` (on the side with more space available, alignment depends by placement)
 *
 * @static
 * @type {Array}
 * @enum {String}
 * @readonly
 * @method placements
 * @memberof Popper
 */
var placements = ['auto-start', 'auto', 'auto-end', 'top-start', 'top', 'top-end', 'right-start', 'right', 'right-end', 'bottom-end', 'bottom', 'bottom-start', 'left-end', 'left', 'left-start'];

// Get rid of `auto` `auto-start` and `auto-end`
var validPlacements = placements.slice(3);

/**
 * Given an initial placement, returns all the subsequent placements
 * clockwise (or counter-clockwise).
 *
 * @method
 * @memberof Popper.Utils
 * @argument {String} placement - A valid placement (it accepts variations)
 * @argument {Boolean} counter - Set to true to walk the placements counterclockwise
 * @returns {Array} placements including their variations
 */
function clockwise(placement) {
  var counter = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

  var index = validPlacements.indexOf(placement);
  var arr = validPlacements.slice(index + 1).concat(validPlacements.slice(0, index));
  return counter ? arr.reverse() : arr;
}

var BEHAVIORS = {
  FLIP: 'flip',
  CLOCKWISE: 'clockwise',
  COUNTERCLOCKWISE: 'counterclockwise'
};

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function flip(data, options) {
  // if `inner` modifier is enabled, we can't use the `flip` modifier
  if (isModifierEnabled(data.instance.modifiers, 'inner')) {
    return data;
  }

  if (data.flipped && data.placement === data.originalPlacement) {
    // seems like flip is trying to loop, probably there's not enough space on any of the flippable sides
    return data;
  }

  var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, options.boundariesElement, data.positionFixed);

  var placement = data.placement.split('-')[0];
  var placementOpposite = getOppositePlacement(placement);
  var variation = data.placement.split('-')[1] || '';

  var flipOrder = [];

  switch (options.behavior) {
    case BEHAVIORS.FLIP:
      flipOrder = [placement, placementOpposite];
      break;
    case BEHAVIORS.CLOCKWISE:
      flipOrder = clockwise(placement);
      break;
    case BEHAVIORS.COUNTERCLOCKWISE:
      flipOrder = clockwise(placement, true);
      break;
    default:
      flipOrder = options.behavior;
  }

  flipOrder.forEach(function (step, index) {
    if (placement !== step || flipOrder.length === index + 1) {
      return data;
    }

    placement = data.placement.split('-')[0];
    placementOpposite = getOppositePlacement(placement);

    var popperOffsets = data.offsets.popper;
    var refOffsets = data.offsets.reference;

    // using floor because the reference offsets may contain decimals we are not going to consider here
    var floor = Math.floor;
    var overlapsRef = placement === 'left' && floor(popperOffsets.right) > floor(refOffsets.left) || placement === 'right' && floor(popperOffsets.left) < floor(refOffsets.right) || placement === 'top' && floor(popperOffsets.bottom) > floor(refOffsets.top) || placement === 'bottom' && floor(popperOffsets.top) < floor(refOffsets.bottom);

    var overflowsLeft = floor(popperOffsets.left) < floor(boundaries.left);
    var overflowsRight = floor(popperOffsets.right) > floor(boundaries.right);
    var overflowsTop = floor(popperOffsets.top) < floor(boundaries.top);
    var overflowsBottom = floor(popperOffsets.bottom) > floor(boundaries.bottom);

    var overflowsBoundaries = placement === 'left' && overflowsLeft || placement === 'right' && overflowsRight || placement === 'top' && overflowsTop || placement === 'bottom' && overflowsBottom;

    // flip the variation if required
    var isVertical = ['top', 'bottom'].indexOf(placement) !== -1;

    // flips variation if reference element overflows boundaries
    var flippedVariationByRef = !!options.flipVariations && (isVertical && variation === 'start' && overflowsLeft || isVertical && variation === 'end' && overflowsRight || !isVertical && variation === 'start' && overflowsTop || !isVertical && variation === 'end' && overflowsBottom);

    // flips variation if popper content overflows boundaries
    var flippedVariationByContent = !!options.flipVariationsByContent && (isVertical && variation === 'start' && overflowsRight || isVertical && variation === 'end' && overflowsLeft || !isVertical && variation === 'start' && overflowsBottom || !isVertical && variation === 'end' && overflowsTop);

    var flippedVariation = flippedVariationByRef || flippedVariationByContent;

    if (overlapsRef || overflowsBoundaries || flippedVariation) {
      // this boolean to detect any flip loop
      data.flipped = true;

      if (overlapsRef || overflowsBoundaries) {
        placement = flipOrder[index + 1];
      }

      if (flippedVariation) {
        variation = getOppositeVariation(variation);
      }

      data.placement = placement + (variation ? '-' + variation : '');

      // this object contains `position`, we want to preserve it along with
      // any additional property we may add in the future
      data.offsets.popper = _extends({}, data.offsets.popper, getPopperOffsets(data.instance.popper, data.offsets.reference, data.placement));

      data = runModifiers(data.instance.modifiers, data, 'flip');
    }
  });
  return data;
}

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function keepTogether(data) {
  var _data$offsets = data.offsets,
      popper = _data$offsets.popper,
      reference = _data$offsets.reference;

  var placement = data.placement.split('-')[0];
  var floor = Math.floor;
  var isVertical = ['top', 'bottom'].indexOf(placement) !== -1;
  var side = isVertical ? 'right' : 'bottom';
  var opSide = isVertical ? 'left' : 'top';
  var measurement = isVertical ? 'width' : 'height';

  if (popper[side] < floor(reference[opSide])) {
    data.offsets.popper[opSide] = floor(reference[opSide]) - popper[measurement];
  }
  if (popper[opSide] > floor(reference[side])) {
    data.offsets.popper[opSide] = floor(reference[side]);
  }

  return data;
}

/**
 * Converts a string containing value + unit into a px value number
 * @function
 * @memberof {modifiers~offset}
 * @private
 * @argument {String} str - Value + unit string
 * @argument {String} measurement - `height` or `width`
 * @argument {Object} popperOffsets
 * @argument {Object} referenceOffsets
 * @returns {Number|String}
 * Value in pixels, or original string if no values were extracted
 */
function toValue(str, measurement, popperOffsets, referenceOffsets) {
  // separate value from unit
  var split = str.match(/((?:\-|\+)?\d*\.?\d*)(.*)/);
  var value = +split[1];
  var unit = split[2];

  // If it's not a number it's an operator, I guess
  if (!value) {
    return str;
  }

  if (unit.indexOf('%') === 0) {
    var element = void 0;
    switch (unit) {
      case '%p':
        element = popperOffsets;
        break;
      case '%':
      case '%r':
      default:
        element = referenceOffsets;
    }

    var rect = getClientRect(element);
    return rect[measurement] / 100 * value;
  } else if (unit === 'vh' || unit === 'vw') {
    // if is a vh or vw, we calculate the size based on the viewport
    var size = void 0;
    if (unit === 'vh') {
      size = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);
    } else {
      size = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
    }
    return size / 100 * value;
  } else {
    // if is an explicit pixel unit, we get rid of the unit and keep the value
    // if is an implicit unit, it's px, and we return just the value
    return value;
  }
}

/**
 * Parse an `offset` string to extrapolate `x` and `y` numeric offsets.
 * @function
 * @memberof {modifiers~offset}
 * @private
 * @argument {String} offset
 * @argument {Object} popperOffsets
 * @argument {Object} referenceOffsets
 * @argument {String} basePlacement
 * @returns {Array} a two cells array with x and y offsets in numbers
 */
function parseOffset(offset, popperOffsets, referenceOffsets, basePlacement) {
  var offsets = [0, 0];

  // Use height if placement is left or right and index is 0 otherwise use width
  // in this way the first offset will use an axis and the second one
  // will use the other one
  var useHeight = ['right', 'left'].indexOf(basePlacement) !== -1;

  // Split the offset string to obtain a list of values and operands
  // The regex addresses values with the plus or minus sign in front (+10, -20, etc)
  var fragments = offset.split(/(\+|\-)/).map(function (frag) {
    return frag.trim();
  });

  // Detect if the offset string contains a pair of values or a single one
  // they could be separated by comma or space
  var divider = fragments.indexOf(find(fragments, function (frag) {
    return frag.search(/,|\s/) !== -1;
  }));

  if (fragments[divider] && fragments[divider].indexOf(',') === -1) {
    console.warn('Offsets separated by white space(s) are deprecated, use a comma (,) instead.');
  }

  // If divider is found, we divide the list of values and operands to divide
  // them by ofset X and Y.
  var splitRegex = /\s*,\s*|\s+/;
  var ops = divider !== -1 ? [fragments.slice(0, divider).concat([fragments[divider].split(splitRegex)[0]]), [fragments[divider].split(splitRegex)[1]].concat(fragments.slice(divider + 1))] : [fragments];

  // Convert the values with units to absolute pixels to allow our computations
  ops = ops.map(function (op, index) {
    // Most of the units rely on the orientation of the popper
    var measurement = (index === 1 ? !useHeight : useHeight) ? 'height' : 'width';
    var mergeWithPrevious = false;
    return op
    // This aggregates any `+` or `-` sign that aren't considered operators
    // e.g.: 10 + +5 => [10, +, +5]
    .reduce(function (a, b) {
      if (a[a.length - 1] === '' && ['+', '-'].indexOf(b) !== -1) {
        a[a.length - 1] = b;
        mergeWithPrevious = true;
        return a;
      } else if (mergeWithPrevious) {
        a[a.length - 1] += b;
        mergeWithPrevious = false;
        return a;
      } else {
        return a.concat(b);
      }
    }, [])
    // Here we convert the string values into number values (in px)
    .map(function (str) {
      return toValue(str, measurement, popperOffsets, referenceOffsets);
    });
  });

  // Loop trough the offsets arrays and execute the operations
  ops.forEach(function (op, index) {
    op.forEach(function (frag, index2) {
      if (isNumeric(frag)) {
        offsets[index] += frag * (op[index2 - 1] === '-' ? -1 : 1);
      }
    });
  });
  return offsets;
}

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @argument {Number|String} options.offset=0
 * The offset value as described in the modifier description
 * @returns {Object} The data object, properly modified
 */
function offset(data, _ref) {
  var offset = _ref.offset;
  var placement = data.placement,
      _data$offsets = data.offsets,
      popper = _data$offsets.popper,
      reference = _data$offsets.reference;

  var basePlacement = placement.split('-')[0];

  var offsets = void 0;
  if (isNumeric(+offset)) {
    offsets = [+offset, 0];
  } else {
    offsets = parseOffset(offset, popper, reference, basePlacement);
  }

  if (basePlacement === 'left') {
    popper.top += offsets[0];
    popper.left -= offsets[1];
  } else if (basePlacement === 'right') {
    popper.top += offsets[0];
    popper.left += offsets[1];
  } else if (basePlacement === 'top') {
    popper.left += offsets[0];
    popper.top -= offsets[1];
  } else if (basePlacement === 'bottom') {
    popper.left += offsets[0];
    popper.top += offsets[1];
  }

  data.popper = popper;
  return data;
}

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function preventOverflow(data, options) {
  var boundariesElement = options.boundariesElement || getOffsetParent(data.instance.popper);

  // If offsetParent is the reference element, we really want to
  // go one step up and use the next offsetParent as reference to
  // avoid to make this modifier completely useless and look like broken
  if (data.instance.reference === boundariesElement) {
    boundariesElement = getOffsetParent(boundariesElement);
  }

  // NOTE: DOM access here
  // resets the popper's position so that the document size can be calculated excluding
  // the size of the popper element itself
  var transformProp = getSupportedPropertyName('transform');
  var popperStyles = data.instance.popper.style; // assignment to help minification
  var top = popperStyles.top,
      left = popperStyles.left,
      transform = popperStyles[transformProp];

  popperStyles.top = '';
  popperStyles.left = '';
  popperStyles[transformProp] = '';

  var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, boundariesElement, data.positionFixed);

  // NOTE: DOM access here
  // restores the original style properties after the offsets have been computed
  popperStyles.top = top;
  popperStyles.left = left;
  popperStyles[transformProp] = transform;

  options.boundaries = boundaries;

  var order = options.priority;
  var popper = data.offsets.popper;

  var check = {
    primary: function primary(placement) {
      var value = popper[placement];
      if (popper[placement] < boundaries[placement] && !options.escapeWithReference) {
        value = Math.max(popper[placement], boundaries[placement]);
      }
      return defineProperty({}, placement, value);
    },
    secondary: function secondary(placement) {
      var mainSide = placement === 'right' ? 'left' : 'top';
      var value = popper[mainSide];
      if (popper[placement] > boundaries[placement] && !options.escapeWithReference) {
        value = Math.min(popper[mainSide], boundaries[placement] - (placement === 'right' ? popper.width : popper.height));
      }
      return defineProperty({}, mainSide, value);
    }
  };

  order.forEach(function (placement) {
    var side = ['left', 'top'].indexOf(placement) !== -1 ? 'primary' : 'secondary';
    popper = _extends({}, popper, check[side](placement));
  });

  data.offsets.popper = popper;

  return data;
}

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function shift(data) {
  var placement = data.placement;
  var basePlacement = placement.split('-')[0];
  var shiftvariation = placement.split('-')[1];

  // if shift shiftvariation is specified, run the modifier
  if (shiftvariation) {
    var _data$offsets = data.offsets,
        reference = _data$offsets.reference,
        popper = _data$offsets.popper;

    var isVertical = ['bottom', 'top'].indexOf(basePlacement) !== -1;
    var side = isVertical ? 'left' : 'top';
    var measurement = isVertical ? 'width' : 'height';

    var shiftOffsets = {
      start: defineProperty({}, side, reference[side]),
      end: defineProperty({}, side, reference[side] + reference[measurement] - popper[measurement])
    };

    data.offsets.popper = _extends({}, popper, shiftOffsets[shiftvariation]);
  }

  return data;
}

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function hide(data) {
  if (!isModifierRequired(data.instance.modifiers, 'hide', 'preventOverflow')) {
    return data;
  }

  var refRect = data.offsets.reference;
  var bound = find(data.instance.modifiers, function (modifier) {
    return modifier.name === 'preventOverflow';
  }).boundaries;

  if (refRect.bottom < bound.top || refRect.left > bound.right || refRect.top > bound.bottom || refRect.right < bound.left) {
    // Avoid unnecessary DOM access if visibility hasn't changed
    if (data.hide === true) {
      return data;
    }

    data.hide = true;
    data.attributes['x-out-of-boundaries'] = '';
  } else {
    // Avoid unnecessary DOM access if visibility hasn't changed
    if (data.hide === false) {
      return data;
    }

    data.hide = false;
    data.attributes['x-out-of-boundaries'] = false;
  }

  return data;
}

/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function inner(data) {
  var placement = data.placement;
  var basePlacement = placement.split('-')[0];
  var _data$offsets = data.offsets,
      popper = _data$offsets.popper,
      reference = _data$offsets.reference;

  var isHoriz = ['left', 'right'].indexOf(basePlacement) !== -1;

  var subtractLength = ['top', 'left'].indexOf(basePlacement) === -1;

  popper[isHoriz ? 'left' : 'top'] = reference[basePlacement] - (subtractLength ? popper[isHoriz ? 'width' : 'height'] : 0);

  data.placement = getOppositePlacement(placement);
  data.offsets.popper = getClientRect(popper);

  return data;
}

/**
 * Modifier function, each modifier can have a function of this type assigned
 * to its `fn` property.<br />
 * These functions will be called on each update, this means that you must
 * make sure they are performant enough to avoid performance bottlenecks.
 *
 * @function ModifierFn
 * @argument {dataObject} data - The data object generated by `update` method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {dataObject} The data object, properly modified
 */

/**
 * Modifiers are plugins used to alter the behavior of your poppers.<br />
 * Popper.js uses a set of 9 modifiers to provide all the basic functionalities
 * needed by the library.
 *
 * Usually you don't want to override the `order`, `fn` and `onLoad` props.
 * All the other properties are configurations that could be tweaked.
 * @namespace modifiers
 */
var modifiers = {
  /**
   * Modifier used to shift the popper on the start or end of its reference
   * element.<br />
   * It will read the variation of the `placement` property.<br />
   * It can be one either `-end` or `-start`.
   * @memberof modifiers
   * @inner
   */
  shift: {
    /** @prop {number} order=100 - Index used to define the order of execution */
    order: 100,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: shift
  },

  /**
   * The `offset` modifier can shift your popper on both its axis.
   *
   * It accepts the following units:
   * - `px` or unit-less, interpreted as pixels
   * - `%` or `%r`, percentage relative to the length of the reference element
   * - `%p`, percentage relative to the length of the popper element
   * - `vw`, CSS viewport width unit
   * - `vh`, CSS viewport height unit
   *
   * For length is intended the main axis relative to the placement of the popper.<br />
   * This means that if the placement is `top` or `bottom`, the length will be the
   * `width`. In case of `left` or `right`, it will be the `height`.
   *
   * You can provide a single value (as `Number` or `String`), or a pair of values
   * as `String` divided by a comma or one (or more) white spaces.<br />
   * The latter is a deprecated method because it leads to confusion and will be
   * removed in v2.<br />
   * Additionally, it accepts additions and subtractions between different units.
   * Note that multiplications and divisions aren't supported.
   *
   * Valid examples are:
   * ```
   * 10
   * '10%'
   * '10, 10'
   * '10%, 10'
   * '10 + 10%'
   * '10 - 5vh + 3%'
   * '-10px + 5vh, 5px - 6%'
   * ```
   * > **NB**: If you desire to apply offsets to your poppers in a way that may make them overlap
   * > with their reference element, unfortunately, you will have to disable the `flip` modifier.
   * > You can read more on this at this [issue](https://github.com/FezVrasta/popper.js/issues/373).
   *
   * @memberof modifiers
   * @inner
   */
  offset: {
    /** @prop {number} order=200 - Index used to define the order of execution */
    order: 200,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: offset,
    /** @prop {Number|String} offset=0
     * The offset value as described in the modifier description
     */
    offset: 0
  },

  /**
   * Modifier used to prevent the popper from being positioned outside the boundary.
   *
   * A scenario exists where the reference itself is not within the boundaries.<br />
   * We can say it has "escaped the boundaries" — or just "escaped".<br />
   * In this case we need to decide whether the popper should either:
   *
   * - detach from the reference and remain "trapped" in the boundaries, or
   * - if it should ignore the boundary and "escape with its reference"
   *
   * When `escapeWithReference` is set to`true` and reference is completely
   * outside its boundaries, the popper will overflow (or completely leave)
   * the boundaries in order to remain attached to the edge of the reference.
   *
   * @memberof modifiers
   * @inner
   */
  preventOverflow: {
    /** @prop {number} order=300 - Index used to define the order of execution */
    order: 300,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: preventOverflow,
    /**
     * @prop {Array} [priority=['left','right','top','bottom']]
     * Popper will try to prevent overflow following these priorities by default,
     * then, it could overflow on the left and on top of the `boundariesElement`
     */
    priority: ['left', 'right', 'top', 'bottom'],
    /**
     * @prop {number} padding=5
     * Amount of pixel used to define a minimum distance between the boundaries
     * and the popper. This makes sure the popper always has a little padding
     * between the edges of its container
     */
    padding: 5,
    /**
     * @prop {String|HTMLElement} boundariesElement='scrollParent'
     * Boundaries used by the modifier. Can be `scrollParent`, `window`,
     * `viewport` or any DOM element.
     */
    boundariesElement: 'scrollParent'
  },

  /**
   * Modifier used to make sure the reference and its popper stay near each other
   * without leaving any gap between the two. Especially useful when the arrow is
   * enabled and you want to ensure that it points to its reference element.
   * It cares only about the first axis. You can still have poppers with margin
   * between the popper and its reference element.
   * @memberof modifiers
   * @inner
   */
  keepTogether: {
    /** @prop {number} order=400 - Index used to define the order of execution */
    order: 400,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: keepTogether
  },

  /**
   * This modifier is used to move the `arrowElement` of the popper to make
   * sure it is positioned between the reference element and its popper element.
   * It will read the outer size of the `arrowElement` node to detect how many
   * pixels of conjunction are needed.
   *
   * It has no effect if no `arrowElement` is provided.
   * @memberof modifiers
   * @inner
   */
  arrow: {
    /** @prop {number} order=500 - Index used to define the order of execution */
    order: 500,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: arrow,
    /** @prop {String|HTMLElement} element='[x-arrow]' - Selector or node used as arrow */
    element: '[x-arrow]'
  },

  /**
   * Modifier used to flip the popper's placement when it starts to overlap its
   * reference element.
   *
   * Requires the `preventOverflow` modifier before it in order to work.
   *
   * **NOTE:** this modifier will interrupt the current update cycle and will
   * restart it if it detects the need to flip the placement.
   * @memberof modifiers
   * @inner
   */
  flip: {
    /** @prop {number} order=600 - Index used to define the order of execution */
    order: 600,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: flip,
    /**
     * @prop {String|Array} behavior='flip'
     * The behavior used to change the popper's placement. It can be one of
     * `flip`, `clockwise`, `counterclockwise` or an array with a list of valid
     * placements (with optional variations)
     */
    behavior: 'flip',
    /**
     * @prop {number} padding=5
     * The popper will flip if it hits the edges of the `boundariesElement`
     */
    padding: 5,
    /**
     * @prop {String|HTMLElement} boundariesElement='viewport'
     * The element which will define the boundaries of the popper position.
     * The popper will never be placed outside of the defined boundaries
     * (except if `keepTogether` is enabled)
     */
    boundariesElement: 'viewport',
    /**
     * @prop {Boolean} flipVariations=false
     * The popper will switch placement variation between `-start` and `-end` when
     * the reference element overlaps its boundaries.
     *
     * The original placement should have a set variation.
     */
    flipVariations: false,
    /**
     * @prop {Boolean} flipVariationsByContent=false
     * The popper will switch placement variation between `-start` and `-end` when
     * the popper element overlaps its reference boundaries.
     *
     * The original placement should have a set variation.
     */
    flipVariationsByContent: false
  },

  /**
   * Modifier used to make the popper flow toward the inner of the reference element.
   * By default, when this modifier is disabled, the popper will be placed outside
   * the reference element.
   * @memberof modifiers
   * @inner
   */
  inner: {
    /** @prop {number} order=700 - Index used to define the order of execution */
    order: 700,
    /** @prop {Boolean} enabled=false - Whether the modifier is enabled or not */
    enabled: false,
    /** @prop {ModifierFn} */
    fn: inner
  },

  /**
   * Modifier used to hide the popper when its reference element is outside of the
   * popper boundaries. It will set a `x-out-of-boundaries` attribute which can
   * be used to hide with a CSS selector the popper when its reference is
   * out of boundaries.
   *
   * Requires the `preventOverflow` modifier before it in order to work.
   * @memberof modifiers
   * @inner
   */
  hide: {
    /** @prop {number} order=800 - Index used to define the order of execution */
    order: 800,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: hide
  },

  /**
   * Computes the style that will be applied to the popper element to gets
   * properly positioned.
   *
   * Note that this modifier will not touch the DOM, it just prepares the styles
   * so that `applyStyle` modifier can apply it. This separation is useful
   * in case you need to replace `applyStyle` with a custom implementation.
   *
   * This modifier has `850` as `order` value to maintain backward compatibility
   * with previous versions of Popper.js. Expect the modifiers ordering method
   * to change in future major versions of the library.
   *
   * @memberof modifiers
   * @inner
   */
  computeStyle: {
    /** @prop {number} order=850 - Index used to define the order of execution */
    order: 850,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: computeStyle,
    /**
     * @prop {Boolean} gpuAcceleration=true
     * If true, it uses the CSS 3D transformation to position the popper.
     * Otherwise, it will use the `top` and `left` properties
     */
    gpuAcceleration: true,
    /**
     * @prop {string} [x='bottom']
     * Where to anchor the X axis (`bottom` or `top`). AKA X offset origin.
     * Change this if your popper should grow in a direction different from `bottom`
     */
    x: 'bottom',
    /**
     * @prop {string} [x='left']
     * Where to anchor the Y axis (`left` or `right`). AKA Y offset origin.
     * Change this if your popper should grow in a direction different from `right`
     */
    y: 'right'
  },

  /**
   * Applies the computed styles to the popper element.
   *
   * All the DOM manipulations are limited to this modifier. This is useful in case
   * you want to integrate Popper.js inside a framework or view library and you
   * want to delegate all the DOM manipulations to it.
   *
   * Note that if you disable this modifier, you must make sure the popper element
   * has its position set to `absolute` before Popper.js can do its work!
   *
   * Just disable this modifier and define your own to achieve the desired effect.
   *
   * @memberof modifiers
   * @inner
   */
  applyStyle: {
    /** @prop {number} order=900 - Index used to define the order of execution */
    order: 900,
    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
    enabled: true,
    /** @prop {ModifierFn} */
    fn: applyStyle,
    /** @prop {Function} */
    onLoad: applyStyleOnLoad,
    /**
     * @deprecated since version 1.10.0, the property moved to `computeStyle` modifier
     * @prop {Boolean} gpuAcceleration=true
     * If true, it uses the CSS 3D transformation to position the popper.
     * Otherwise, it will use the `top` and `left` properties
     */
    gpuAcceleration: undefined
  }
};

/**
 * The `dataObject` is an object containing all the information used by Popper.js.
 * This object is passed to modifiers and to the `onCreate` and `onUpdate` callbacks.
 * @name dataObject
 * @property {Object} data.instance The Popper.js instance
 * @property {String} data.placement Placement applied to popper
 * @property {String} data.originalPlacement Placement originally defined on init
 * @property {Boolean} data.flipped True if popper has been flipped by flip modifier
 * @property {Boolean} data.hide True if the reference element is out of boundaries, useful to know when to hide the popper
 * @property {HTMLElement} data.arrowElement Node used as arrow by arrow modifier
 * @property {Object} data.styles Any CSS property defined here will be applied to the popper. It expects the JavaScript nomenclature (eg. `marginBottom`)
 * @property {Object} data.arrowStyles Any CSS property defined here will be applied to the popper arrow. It expects the JavaScript nomenclature (eg. `marginBottom`)
 * @property {Object} data.boundaries Offsets of the popper boundaries
 * @property {Object} data.offsets The measurements of popper, reference and arrow elements
 * @property {Object} data.offsets.popper `top`, `left`, `width`, `height` values
 * @property {Object} data.offsets.reference `top`, `left`, `width`, `height` values
 * @property {Object} data.offsets.arrow] `top` and `left` offsets, only one of them will be different from 0
 */

/**
 * Default options provided to Popper.js constructor.<br />
 * These can be overridden using the `options` argument of Popper.js.<br />
 * To override an option, simply pass an object with the same
 * structure of the `options` object, as the 3rd argument. For example:
 * ```
 * new Popper(ref, pop, {
 *   modifiers: {
 *     preventOverflow: { enabled: false }
 *   }
 * })
 * ```
 * @type {Object}
 * @static
 * @memberof Popper
 */
var Defaults = {
  /**
   * Popper's placement.
   * @prop {Popper.placements} placement='bottom'
   */
  placement: 'bottom',

  /**
   * Set this to true if you want popper to position it self in 'fixed' mode
   * @prop {Boolean} positionFixed=false
   */
  positionFixed: false,

  /**
   * Whether events (resize, scroll) are initially enabled.
   * @prop {Boolean} eventsEnabled=true
   */
  eventsEnabled: true,

  /**
   * Set to true if you want to automatically remove the popper when
   * you call the `destroy` method.
   * @prop {Boolean} removeOnDestroy=false
   */
  removeOnDestroy: false,

  /**
   * Callback called when the popper is created.<br />
   * By default, it is set to no-op.<br />
   * Access Popper.js instance with `data.instance`.
   * @prop {onCreate}
   */
  onCreate: function onCreate() {},

  /**
   * Callback called when the popper is updated. This callback is not called
   * on the initialization/creation of the popper, but only on subsequent
   * updates.<br />
   * By default, it is set to no-op.<br />
   * Access Popper.js instance with `data.instance`.
   * @prop {onUpdate}
   */
  onUpdate: function onUpdate() {},

  /**
   * List of modifiers used to modify the offsets before they are applied to the popper.
   * They provide most of the functionalities of Popper.js.
   * @prop {modifiers}
   */
  modifiers: modifiers
};

/**
 * @callback onCreate
 * @param {dataObject} data
 */

/**
 * @callback onUpdate
 * @param {dataObject} data
 */

// Utils
// Methods
var Popper = function () {
  /**
   * Creates a new Popper.js instance.
   * @class Popper
   * @param {Element|referenceObject} reference - The reference element used to position the popper
   * @param {Element} popper - The HTML / XML element used as the popper
   * @param {Object} options - Your custom options to override the ones defined in [Defaults](#defaults)
   * @return {Object} instance - The generated Popper.js instance
   */
  function Popper(reference, popper) {
    var _this = this;

    var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    classCallCheck(this, Popper);

    this.scheduleUpdate = function () {
      return requestAnimationFrame(_this.update);
    };

    // make update() debounced, so that it only runs at most once-per-tick
    this.update = debounce(this.update.bind(this));

    // with {} we create a new object with the options inside it
    this.options = _extends({}, Popper.Defaults, options);

    // init state
    this.state = {
      isDestroyed: false,
      isCreated: false,
      scrollParents: []
    };

    // get reference and popper elements (allow jQuery wrappers)
    this.reference = reference && reference.jquery ? reference[0] : reference;
    this.popper = popper && popper.jquery ? popper[0] : popper;

    // Deep merge modifiers options
    this.options.modifiers = {};
    Object.keys(_extends({}, Popper.Defaults.modifiers, options.modifiers)).forEach(function (name) {
      _this.options.modifiers[name] = _extends({}, Popper.Defaults.modifiers[name] || {}, options.modifiers ? options.modifiers[name] : {});
    });

    // Refactoring modifiers' list (Object => Array)
    this.modifiers = Object.keys(this.options.modifiers).map(function (name) {
      return _extends({
        name: name
      }, _this.options.modifiers[name]);
    })
    // sort the modifiers by order
    .sort(function (a, b) {
      return a.order - b.order;
    });

    // modifiers have the ability to execute arbitrary code when Popper.js get inited
    // such code is executed in the same order of its modifier
    // they could add new properties to their options configuration
    // BE AWARE: don't add options to `options.modifiers.name` but to `modifierOptions`!
    this.modifiers.forEach(function (modifierOptions) {
      if (modifierOptions.enabled && isFunction(modifierOptions.onLoad)) {
        modifierOptions.onLoad(_this.reference, _this.popper, _this.options, modifierOptions, _this.state);
      }
    });

    // fire the first update to position the popper in the right place
    this.update();

    var eventsEnabled = this.options.eventsEnabled;
    if (eventsEnabled) {
      // setup event listeners, they will take care of update the position in specific situations
      this.enableEventListeners();
    }

    this.state.eventsEnabled = eventsEnabled;
  }

  // We can't use class properties because they don't get listed in the
  // class prototype and break stuff like Sinon stubs


  createClass(Popper, [{
    key: 'update',
    value: function update$$1() {
      return update.call(this);
    }
  }, {
    key: 'destroy',
    value: function destroy$$1() {
      return destroy.call(this);
    }
  }, {
    key: 'enableEventListeners',
    value: function enableEventListeners$$1() {
      return enableEventListeners.call(this);
    }
  }, {
    key: 'disableEventListeners',
    value: function disableEventListeners$$1() {
      return disableEventListeners.call(this);
    }

    /**
     * Schedules an update. It will run on the next UI update available.
     * @method scheduleUpdate
     * @memberof Popper
     */


    /**
     * Collection of utilities useful when writing custom modifiers.
     * Starting from version 1.7, this method is available only if you
     * include `popper-utils.js` before `popper.js`.
     *
     * **DEPRECATION**: This way to access PopperUtils is deprecated
     * and will be removed in v2! Use the PopperUtils module directly instead.
     * Due to the high instability of the methods contained in Utils, we can't
     * guarantee them to follow semver. Use them at your own risk!
     * @static
     * @private
     * @type {Object}
     * @deprecated since version 1.8
     * @member Utils
     * @memberof Popper
     */

  }]);
  return Popper;
}();

/**
 * The `referenceObject` is an object that provides an interface compatible with Popper.js
 * and lets you use it as replacement of a real DOM node.<br />
 * You can use this method to position a popper relatively to a set of coordinates
 * in case you don't have a DOM node to use as reference.
 *
 * ```
 * new Popper(referenceObject, popperNode);
 * ```
 *
 * NB: This feature isn't supported in Internet Explorer 10.
 * @name referenceObject
 * @property {Function} data.getBoundingClientRect
 * A function that returns a set of coordinates compatible with the native `getBoundingClientRect` method.
 * @property {number} data.clientWidth
 * An ES6 getter that will return the width of the virtual reference element.
 * @property {number} data.clientHeight
 * An ES6 getter that will return the height of the virtual reference element.
 */


Popper.Utils = (typeof window !== 'undefined' ? window : global).PopperUtils;
Popper.placements = placements;
Popper.Defaults = Defaults;

function _typeof$2(obj) {
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof$2 = function (obj) {
      return typeof obj;
    };
  } else {
    _typeof$2 = function (obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
  }

  return _typeof$2(obj);
}

function _defineProperty$1(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};
    var ownKeys = Object.keys(source);

    if (typeof Object.getOwnPropertySymbols === 'function') {
      ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
        return Object.getOwnPropertyDescriptor(source, sym).enumerable;
      }));
    }

    ownKeys.forEach(function (key) {
      _defineProperty$1(target, key, source[key]);
    });
  }

  return target;
}

function _toConsumableArray$1(arr) {
  return _arrayWithoutHoles$1(arr) || _iterableToArray$1(arr) || _nonIterableSpread$1();
}

function _arrayWithoutHoles$1(arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  }
}

function _iterableToArray$1(iter) {
  if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
}

function _nonIterableSpread$1() {
  throw new TypeError("Invalid attempt to spread non-iterable instance");
}

// @ts-check

/**
 * @param {any} cls
 * @returns {boolean}
 */
var invalidClasses = function invalidClasses(cls) {
  return typeof cls === "string" && cls.length > 0;
};
/**
 * @typedef {string | null | undefined} Value
 *
 * @returns {Array.<string> | null}
 * @param {Array.<Value>} classes
 */


var _classes = function _classes(classes) {
  // Filter out null, undefined and ""
  var onlyClasses = classes.filter(invalidClasses);

  if (onlyClasses.length === 0) {
    return null;
  } // @ts-ignore


  return onlyClasses;
};

// Adopted from https://raw.githubusercontent.com/egoist/vue-no-ssr
// LICENSE: see LICENSE-no-ssr.text
var NoSsr = {
  name: "NoSsr",
  functional: true,
  props: {
    placeholder: String,
    placeholderTag: {
      type: String,
      default: "div"
    }
  },
  render: function render(h, _ref) {
    var parent = _ref.parent,
        slots = _ref.slots,
        props = _ref.props;

    var _slots = slots(),
        _slots$default = _slots.default,
        defaultSlot = _slots$default === void 0 ? [] : _slots$default,
        placeholderSlot = _slots.placeholder;

    if (parent._isMounted) {
      return defaultSlot;
    }

    parent.$once("hook:mounted", function () {
      parent.$forceUpdate();
    });

    if (props.placeholderTag && (props.placeholder || placeholderSlot)) {
      return h(props.placeholderTag, {
        class: ["no-ssr-placeholder"]
      }, props.placeholder || placeholderSlot);
    } // Return a placeholder element for each child in the default slot
    // Or if no children return a single placeholder


    return defaultSlot.length > 0 ? defaultSlot.map(function () {
      return h(false);
    }) : h(false);
  }
};

var boundaries = ["scrollParent", "viewport", "window"];
var defaultBoundary = boundaries[0];
var isValidBoundary = function isValidBoundary(value) {
  return boundaries.indexOf(value) >= 0;
};

var AUTO = "auto";
var EQUALS_TRIGGER = "equal-trigger";
var AT_LEAST_TRIGGER = "at-least-trigger";
var all$1 = [AUTO, // default
EQUALS_TRIGGER, AT_LEAST_TRIGGER];
var isValid = function isValid(value) {
  return all$1.indexOf(value) >= 0;
};
var defaultMode = AUTO;

var KPopTrigger = {
  mounted: function mounted() {
    this.$forceUpdate();
  },
  updated: function updated() {
    this.$parent.popperReference = this.$el;
    this.$parent.updatePopperInstance();
  },
  render: function render(h) {
    return this.$scopedSlots.default();
  }
}; // Because IE does not support Number.MAX_SAFE_INTEGER we hardcode
// it's value here.

var maxSafeInt = Math.pow(2, 53) - 1;
var isBrowser$3 = typeof window !== "undefined" && (typeof document === "undefined" ? "undefined" : _typeof$2(document)) !== undefined;
var script$o = {
  // eslint-disable-next-line vue/name-property-casing
  name: "k-pop",
  components: {
    KPopTrigger: KPopTrigger,
    NoSsr: NoSsr,
    Portal: Portal,
    VpArrow: {
      render: function render(h) {
        return h("span");
      }
    }
  },
  props: {
    bodyStyles: {
      type: Object,
      default: function _default() {}
    },
    portalId: {
      default: function _default() {
        return "k-pop-portal-container";
      },
      type: String
    },
    offset: {
      type: Number,
      default: 0
    },
    adjustsBodyWidth: {
      type: Boolean,
      default: false
    },
    adjustsVisibility: {
      type: Boolean,
      default: true
    },
    boundary: {
      type: String,
      default: defaultBoundary,
      validator: isValidBoundary
    },
    bodySizeMode: {
      type: String,
      default: defaultMode,
      validator: isValid
    },
    theme: {
      type: String,
      default: null
    },
    bodyClass: {
      type: String,
      default: ""
    },
    defaultBodyZIndex: {
      type: [Number, String],
      default: maxSafeInt
    },
    arrowClass: {
      type: String,
      default: null
    },
    transition: {
      type: String,
      default: "fade"
    },
    withArrow: {
      type: Boolean,
      default: false
    },
    flips: {
      type: Boolean,
      default: true
    },
    visible: {
      type: Boolean,
      default: false
    },
    modifiers: {
      type: Object,
      default: function _default() {}
    },
    placement: {
      type: String,
      validator: function validator(value) {
        return Popper.placements.indexOf(value) >= 0;
      },
      default: "bottom"
    }
  },
  data: function data() {
    return {
      visible_: this.visible,
      outOfBoundaries_: false
    };
  },
  computed: {
    bodySizeMode_: function bodySizeMode_() {
      // Handle deprecated first for compatibility
      if (this.adjustsBodyWidth) {
        return EQUALS_TRIGGER;
      }

      return this.bodySizeMode;
    },
    slotProps: function slotProps() {
      return {
        visible: this.visible_,
        show: this.show,
        hide: this.hide,
        toggle: this.toggle
      };
    },
    portalSelector: function portalSelector() {
      return "#".concat(this.portalId);
    },
    // This computed prop simply references every prop that, when changed
    // should cause the Popper-instance to be recreated.
    stateThatRequiredPopperInstanceUpdate: function stateThatRequiredPopperInstanceUpdate() {
      return {
        offset: this.offset,
        flips: this.flips,
        withArrow: this.withArrow,
        placement: this.placement
      };
    },
    hasCustomTriggerLogic: function hasCustomTriggerLogic() {
      return this.$slots.trigger == null && this.$scopedSlots.trigger != null;
    },
    arrowClasses: function arrowClasses() {
      var theme = this.theme,
          arrowClass = this.arrowClass;
      return _classes([arrowClass, theme ? "kpop-arrow" : null]);
    },
    bodyStyles_: function bodyStyles_() {
      var result = _objectSpread({}, this.bodyStyles, {
        zIndex: this.defaultBodyZIndex
      });

      if (this.theme == null && this.adjustsVisibility) {
        // We cannot adjust "display" because this will result in the popover body jumping around.
        result.visibility = this.visible_ && this.outOfBoundaries_ === false ? "visible" : "hidden";
      }

      return result;
    },
    bodyClasses: function bodyClasses() {
      var theme = this.theme,
          bodyClass = this.bodyClass,
          withArrow = this.withArrow;
      var bodyClassAsArray = bodyClass.split(" ");
      return _classes([].concat(_toConsumableArray$1(bodyClassAsArray), ["kpop-body", theme ? "kpop-theme-".concat(this.theme) : null, !withArrow ? "kpop-no-arrow" : null]));
    },
    // We merge the user defined modifiers with the modifiers required by FdPopper
    modifiers_: function modifiers_() {
      return _objectSpread({
        updateState: {
          enabled: true,
          order: 9999999,
          fn: this.modifier_updateState
        },
        bodySizeMode: {
          enabled: true,
          order: 0,
          fn: this.modifier_bodySizeMode
        },
        flip: {
          enabled: this.flips
        },
        arrow: {
          enabled: this.withArrow
        },
        preventOverflow: {
          enabled: true,
          escapeWithReference: true,
          boundariesElement: this.boundary
        },
        offset: {
          enabled: true,
          offset: "0,".concat(this.offset)
        }
      }, this.modifiers);
    }
  },
  watch: {
    adjustsBodyWidth: function adjustsBodyWidth() {
      this.updatePopperInstance();
    },
    stateThatRequiredPopperInstanceUpdate: {
      deep: true,
      handler: function handler() {
        this.updatePopperInstance();
      }
    },
    visible: function visible(_visible) {
      this.visible_ = _visible;

      if (_visible && this.popperInstance == null) {
        this.updatePopperInstance();
      }

      this.scheduleUpdate();
    }
  },
  beforeDestroy: function beforeDestroy() {
    this.destroyPopperInstance();
  },
  mounted: function mounted() {
    this.$forceUpdate();
  },
  methods: {
    modifier_bodySizeMode: function modifier_bodySizeMode(data) {
      var mode = this.bodySizeMode_;

      if (mode === AUTO) {
        return data;
      }

      var instance = data.instance,
          offsets = data.offsets;
      var reference = instance.reference,
          popper = instance.popper;
      var referenceWidth = instance.reference.clientWidth;

      if (mode === AT_LEAST_TRIGGER) {
        popper.style.minWidth = referenceWidth + "px";
        return data;
      }

      if (mode === EQUALS_TRIGGER) {
        var delta = referenceWidth - offsets.popper.width;
        popper.style.width = referenceWidth + "px";
        offsets.popper.width = referenceWidth;
        offsets.popper.left = offsets.popper.left - 0.5 * delta;
        return data;
      }

      return data;
    },
    modifier_updateState: function modifier_updateState(data) {
      var rawOutOfBoundaries = data.attributes["x-out-of-boundaries"];
      var isOutOfBoundaries = rawOutOfBoundaries === true || rawOutOfBoundaries === "" || rawOutOfBoundaries === "true";
      this.outOfBoundaries_ = isOutOfBoundaries;
      return data;
    },
    handleClickOnTrigger: function handleClickOnTrigger() {
      if (this.hasCustomTriggerLogic) {
        return;
      }

      this.toggle();
    },
    destroyPopperInstance: function destroyPopperInstance() {
      if (!this.popperInstance) {
        return;
      }

      this.popperInstance.destroy();
      this.popperInstance = null;
    },
    updatePopperInstance: function updatePopperInstance() {
      this.destroyPopperInstance();
      var placement = this.placement,
          modifiers = this.modifiers_,
          popperReference = this.popperReference;

      if (popperReference == null) {
        return;
      }

      var body = this.$refs.body;

      if (body == null) {
        return;
      }

      var options = {
        modifiers: modifiers,
        placement: placement
      };
      this.popperInstance = new Popper(popperReference, body, options);
    },
    scheduleUpdate: function scheduleUpdate() {
      if (this.popperInstance) {
        this.popperInstance.scheduleUpdate();
      }
    },
    setVisible: function setVisible(newVisible) {
      this.visible_ = newVisible;
      this.$emit("update:visible", this.visible_);

      if (this.visible_ && this.popperInstance == null) {
        this.updatePopperInstance();
      }

      setTimeout(this.scheduleUpdate);
    },
    show: function show() {
      this.setVisible(true);
    },
    hide: function hide(event) {
      this.setVisible(false);
    },
    toggle: function toggle() {
      this.setVisible(!this.visible_);
    }
  }
};

/* script */
var __vue_script__$o = script$o;
/* template */

var __vue_render__$k = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', [_c('k-pop-trigger', {
    ref: "trigger",
    nativeOn: {
      "click": function click($event) {
        return _vm.handleClickOnTrigger($event);
      }
    }
  }, [_vm._t("trigger", null, null, _vm.slotProps)], 2), _vm._v(" "), _c('no-ssr', [_c('portal', {
    attrs: {
      "selector": _vm.portalSelector
    }
  }, [_c('div', {
    ref: "body",
    class: _vm.bodyClasses,
    style: _vm.bodyStyles_,
    attrs: {
      "aria-hidden": String(!_vm.visible_)
    }
  }, [_vm._t("default", null, null, _vm.slotProps), _vm._v(" "), _c('vp-arrow', {
    class: _vm.arrowClasses,
    attrs: {
      "x-arrow": ""
    }
  })], 2)])], 1)], 1);
};

var __vue_staticRenderFns__$k = [];
/* style */

var __vue_inject_styles__$o = undefined;
/* scoped */

var __vue_scope_id__$o = undefined;
/* module identifier */

var __vue_module_identifier__$o = undefined;
/* functional template */

var __vue_is_functional_template__$o = false;
/* style inject */

/* style inject SSR */

var KPop = normalizeComponent_1({
  render: __vue_render__$k,
  staticRenderFns: __vue_staticRenderFns__$k
}, __vue_inject_styles__$o, __vue_script__$o, __vue_scope_id__$o, __vue_is_functional_template__$o, __vue_module_identifier__$o, undefined, undefined);

KPop.install = function (_vue) {
  _vue.component("k-pop", KPop);
};

if (typeof window !== "undefined" && window.Vue && window.Vue === Vue) {
  Vue.use(KPop);
}

var AUTO$1 = "auto";
var EQUALS_TRIGGER$1 = "equal-trigger";
var AT_LEAST_TRIGGER$1 = "at-least-trigger";
var all$2 = [AUTO$1, // default
EQUALS_TRIGGER$1, AT_LEAST_TRIGGER$1];
var isValid$1 = function isValid(value) {
  return all$2.indexOf(value) >= 0;
};
var defaultMode$1 = AUTO$1;

var script$p = {
  name: "FdPopover",
  components: {
    FdOnClickOutside: FdOnClickOutside,
    KPop: KPop
  },
  mixins: [Uid],
  methods: {
    handleClickOutside: function handleClickOutside() {
      this.hide();
    },
    show: function show() {
      this.kpop.show();
    },
    hide: function hide() {
      this.kpop.hide();
    },
    toggle: function toggle() {
      this.kpop.toggle();
    },
    ignoredElements_: function ignoredElements_() {
      if (this.controlEl == null) {
        return this.ignoredElements();
      }

      return [].concat(_toConsumableArray(this.ignoredElements()), [this.controlEl]);
    }
  },
  computed: {
    kpop: function kpop() {
      return this.$refs.kpop;
    },
    controlEl: function controlEl() {
      var kpop = this.$refs.kpop;

      if (kpop == null) {
        return;
      }

      return kpop.$el;
    },
    fdBodyClass: function fdBodyClass() {
      var result = ["fd-popover__popper"];

      if (!this.withArrow) {
        result.push("fd-popover__popper--no-arrow");
      }

      return result.join(" ");
    }
  },
  props: {
    // Default z-index that should be used for the popover body.
    defaultBodyZIndex: {
      type: Number,
      // `1000`
      default: 1000
    },
    // Use a custom body size mode. For details please refer to the [K-Pop](https://christiankienle.github.io/k-pop/examples/#body-size-modes) documentation.
    bodySizeMode: {
      // Possible Values: `auto` / `equal-trigger` / `at-least-trigger`
      type: String,
      validator: isValid$1,
      // `auto`
      default: defaultMode$1
    },
    adjustsBodyWidth: {
      type: Boolean,
      default: false
    },
    // Customize elements that can be interacted with, without the popover being dismissed.
    ignoredElements: {
      // A function that returns an array of `Element`s that should be ignored:
      // Signature: `() => Element[]`
      type: Function,
      // By default no elements are ignored: `() => []`
      default: function _default() {
        return [];
      }
    },
    // Whether or not the popover body has an arrow pointing to the control.
    withArrow: {
      type: Boolean,
      // `false` – no arrow is created by default
      default: false
    },
    // Set the placement of the popover body. This is passed – as is – to Popper.js. This means that all [Popper.js placements](https://popper.js.org/popper-documentation.html#Popper.placements) can be used.
    placement: {
      type: String,
      // `bottom`
      default: "bottom"
    }
  }
};

/* script */
var __vue_script__$p = script$p;
/* template */

var __vue_render__$l = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('k-pop', _vm._g(_vm._b({
    ref: "kpop",
    staticClass: "fd-popover",
    attrs: {
      "arrow-class": "fd-popover__arrow",
      "defaultBodyZIndex": _vm.defaultBodyZIndex,
      "portal-id": _vm.$fdDefaultPortalId,
      "body-class": _vm.fdBodyClass,
      "placement": _vm.placement,
      "with-arrow": _vm.withArrow,
      "body-size-mode": _vm.bodySizeMode
    },
    scopedSlots: _vm._u([{
      key: "trigger",
      fn: function fn(popProps) {
        return [_c('div', {
          staticClass: "fd-popover__control"
        }, [_vm._t("control", null, null, popProps)], 2)];
      }
    }, {
      key: "default",
      fn: function fn(popProps) {
        return [_c('fd-on-click-outside', {
          attrs: {
            "ignoredElements": _vm.ignoredElements_,
            "active": popProps.visible
          },
          on: {
            "do": _vm.handleClickOutside
          }
        }, [_vm._t("default", null, null, popProps)], 2)];
      }
    }], null, true)
  }, 'k-pop', _vm.$attrs, false), _vm.$listeners));
};

var __vue_staticRenderFns__$l = [];
/* style */

var __vue_inject_styles__$p = undefined;
/* scoped */

var __vue_scope_id__$p = undefined;
/* module identifier */

var __vue_module_identifier__$p = undefined;
/* functional template */

var __vue_is_functional_template__$p = false;
/* style inject */

/* style inject SSR */

var FdPopover = normalizeComponent_1({
  render: __vue_render__$l,
  staticRenderFns: __vue_staticRenderFns__$l
}, __vue_inject_styles__$p, __vue_script__$p, __vue_scope_id__$p, __vue_is_functional_template__$p, __vue_module_identifier__$p, undefined, undefined);

//
var script$q = {
  name: "FdComboboxBase",
  mixins: [Uid],
  model: {
    prop: "value",
    event: "update"
  },
  components: {
    FdPopover: FdPopover,
    FdInputGroup: FdInputGroup,
    FdInputGroupAddon: FdInputGroupAddon
  },
  computed: {
    popover: function popover() {
      return this.$refs.popover;
    }
  },
  methods: {
    show: function show() {
      this.popover.show();
    },
    hide: function hide() {
      this.popover.hide();
    },
    toggle: function toggle() {
      this.popover.toggle();
    }
  },
  props: {
    popoverControlClass: {
      type: [Array, Object, String],
      default: null
    },
    popoverClass: {
      type: [Array, Object, String],
      default: null
    },
    ignoredElements: {
      type: Function,
      default: function _default() {
        return [];
      }
    },
    value: {
      type: String,
      default: null
    },
    placeholder: {
      type: String,
      default: ""
    },
    compact: {
      type: Boolean,
      default: false
    }
  },
  data: function data() {
    return {
      currentValue: this.value
    };
  }
};

/* script */
var __vue_script__$q = script$q;
/* template */

var __vue_render__$m = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('fd-popover', {
    ref: "popover",
    attrs: {
      "body-size-mode": "equal-trigger",
      "placement": "bottom-start"
    },
    scopedSlots: _vm._u([{
      key: "control",
      fn: function fn(ref) {
        var hide = ref.hide;
        var show = ref.show;
        var toggle = ref.toggle;
        return [_c('div', {
          staticClass: "fd-combobox-control"
        }, [_c('fd-input-group', {
          attrs: {
            "compact": _vm.compact
          },
          scopedSlots: _vm._u([{
            key: "input",
            fn: function fn() {
              return [_vm._t("input", null, {
                "hideCompletions": hide,
                "showCompletions": show
              })];
            },
            proxy: true
          }, {
            key: "after",
            fn: function fn() {
              return [_c('fd-input-group-addon', [_vm._t("after", null, {
                "toggleCompletions": toggle
              })], 2)];
            },
            proxy: true
          }], null, true)
        })], 1)];
      }
    }, {
      key: "default",
      fn: function fn(ref) {
        var hide = ref.hide;
        return [_vm._t("default", null, {
          "hideCompletions": hide
        })];
      }
    }], null, true)
  });
};

var __vue_staticRenderFns__$m = [];
/* style */

var __vue_inject_styles__$q = undefined;
/* scoped */

var __vue_scope_id__$q = undefined;
/* module identifier */

var __vue_module_identifier__$q = undefined;
/* functional template */

var __vue_is_functional_template__$q = false;
/* style inject */

/* style inject SSR */

var FdComboboxBase = normalizeComponent_1({
  render: __vue_render__$m,
  staticRenderFns: __vue_staticRenderFns__$m
}, __vue_inject_styles__$q, __vue_script__$q, __vue_scope_id__$q, __vue_is_functional_template__$q, __vue_module_identifier__$q, undefined, undefined);

// A little helper that converts a NodeList into a real array.
// We are not using Array.from(…) in order to work in IE without Polyfills.

/**
 * @param {NodeList} nodeList
 * @returns {Node[]}
 */
var arrayFromNodeList = function arrayFromNodeList(nodeList) {
  return Array.prototype.slice.call(nodeList);
};

/** @param {HTMLElement} el */
var getMenuItemLinkUidFromEl = function getMenuItemLinkUidFromEl(el) {
  return el.getAttribute("data-fd-menu-item-link-uid");
};

//
var script$r = {
  name: "FdMenu",
  provide: function provide() {
    return {
      menuHighlight: this.menuHighlight_,
      menu: this
    };
  },
  props: {
    highlightsSelection: {
      type: Boolean,
      default: false
    },
    highlightedUid: {
      type: String,
      default: null
    },
    selectedUid: {
      type: String,
      default: null
    },
    canHaveAddon: {
      type: Boolean,
      default: false
    }
  },
  data: function data() {
    return {
      menuItemsById: {},
      highlightedUid_: this.highlightedUid,
      selectedUid_: this.selectedUid
    };
  },
  watch: {
    highlightedUid: function highlightedUid(value) {
      this.highlightedUid_ = value;
      this.highlightedId = value;
    },
    selectedUid: function selectedUid(value) {
      this.selectedUid_ = value;
    }
  },
  beforeCreate: function beforeCreate() {
    this.menuHighlight_ = Vue$1.observable({
      highlightedId: null
    });
  },
  computed: {
    highlightedId: {
      set: function set(newId) {
        this.menuHighlight_.highlightedId = newId;
      },
      get: function get() {
        return this.menuHighlight_.highlightedId;
      }
    },
    highlightedItem: function highlightedItem() {
      return this.menuItemForId(this.highlightedId);
    },
    classes: function classes() {
      return {
        "fd-menu": true,
        "fd-menu--addon-before": this.canHaveAddon
      };
    }
  },
  methods: {
    menuItemForId: function menuItemForId(id) {
      return this.menuItemsById[id];
    },
    registerMenuItem: function registerMenuItem(menuItem) {
      this.menuItemsById[menuItem.uid] = menuItem;
    },
    unregisterMenuItem: function unregisterMenuItem(menuItem) {
      delete this.menuItemsById[menuItem.uid];
    },
    highlightMenuItemLinkEl: function highlightMenuItemLinkEl(el) {
      var linkUid = getMenuItemLinkUidFromEl(el);
      var menuItemsById = this.menuItemsById;

      for (var itemId in menuItemsById) {
        var item = menuItemsById[itemId];

        if (item.uid === linkUid) {
          this.menuHighlight_.highlightedId = item.uid;
          this.$emit("highlight", item);
          this.highlightedUid_ = item.uid;
          this.$emit("update:highlightedUid", this.highlightedUid_);
          return;
        }
      }
    },
    highlightNextItem: function highlightNextItem() {
      var items = this.menuItemElements();

      if (items.length === 0) {
        return;
      }
      /** @param {HTMLElement} el */


      var isSelected = function isSelected(el) {
        return el.classList.contains("is-selected");
      };

      var index = items.findIndex(isSelected);

      if (index < 0) {
        /** @type {HTMLElement} */
        var firstLink = items[0];
        this.highlightMenuItemLinkEl(firstLink);
      } else {
        // Is there a next item?
        var nextIndex = index + 1;
        var hasNext = nextIndex < items.length;

        if (!hasNext) {
          return;
        }

        var nextItem = items[nextIndex];
        this.highlightMenuItemLinkEl(nextItem);
      }
    },
    highlightPreviousItem: function highlightPreviousItem() {
      var items = this.menuItemElements();

      if (items.length === 0) {
        return;
      }

      if (this.menuHighlight_.highlightedId == null) {
        // No selection means that we should now select the last element
        this.highlightMenuItemLinkEl(items[items.length - 1]);
        return;
      }
      /** @param {HTMLElement} el */


      var isSelected = function isSelected(el) {
        return el.classList.contains("is-selected");
      };

      var index = items.findIndex(isSelected);

      if (index <= 0) {
        return;
      }

      this.highlightMenuItemLinkEl(items[index - 1]);
    },
    menuItemElements: function menuItemElements() {
      var selector = ".fd-menu__item:not(.is-disabled):not([disabled])";
      return arrayFromNodeList(this.$el.querySelectorAll(selector));
    },
    menuItemDidClick: function menuItemDidClick(item, event) {
      this.$emit("select", item, event);
      this.selectedUid_ = item.uid;
      this.$emit("update:selectedUid", this.selectedUid_);

      if (this.highlightsSelection) {
        this.highlightedUid_ = item.uid;
        this.menuHighlight_.highlightedId = item.uid;
        this.$emit("update:highlightedUid", this.highlightedUid_);
      }
    }
  }
};

/* script */
var __vue_script__$r = script$r;
/* template */

var __vue_render__$n = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('nav', {
    class: _vm.classes
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$n = [];
/* style */

var __vue_inject_styles__$r = undefined;
/* scoped */

var __vue_scope_id__$r = undefined;
/* module identifier */

var __vue_module_identifier__$r = undefined;
/* functional template */

var __vue_is_functional_template__$r = false;
/* style inject */

/* style inject SSR */

var FdMenu = normalizeComponent_1({
  render: __vue_render__$n,
  staticRenderFns: __vue_staticRenderFns__$n
}, __vue_inject_styles__$r, __vue_script__$r, __vue_scope_id__$r, __vue_is_functional_template__$r, __vue_module_identifier__$r, undefined, undefined);

//
//
//
//
//
//
//
//
//
//
//
//
var script$s = {
  name: "FdMenuList",
  provide: function provide() {
    return {
      menuList: this
    };
  },
  inject: ["menu"],
  props: {
    header: {
      type: String,
      default: null
    },
    separated: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    canHaveAddon: function canHaveAddon() {
      return this.menu.canHaveAddon;
    },
    menuListClasses: function menuListClasses() {
      return {
        "fd-menu__list--separated": this.separated
      };
    }
  },
  methods: {
    menuItemDidClick: function menuItemDidClick(item
    /* MenuItem */
    , event) {
      this.menu.menuItemDidClick(item, event);
      this.$emit("select", item.value, event);
    }
  }
};

/* script */
var __vue_script__$s = script$s;
/* template */

var __vue_render__$o = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _vm.header != null ? _c('div', {
    staticClass: "fd-menu__group"
  }, [_c('h1', {
    staticClass: "fd-menu__title"
  }, [_vm._v(_vm._s(_vm.header))]), _vm._v(" "), _c('ul', {
    staticClass: "fd-menu__list",
    class: _vm.menuListClasses
  }, [_vm._t("default")], 2)]) : _c('ul', {
    staticClass: "fd-menu__list",
    class: _vm.menuListClasses
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$o = [];
/* style */

var __vue_inject_styles__$s = undefined;
/* scoped */

var __vue_scope_id__$s = undefined;
/* module identifier */

var __vue_module_identifier__$s = undefined;
/* functional template */

var __vue_is_functional_template__$s = false;
/* style inject */

/* style inject SSR */

var FdMenuList = normalizeComponent_1({
  render: __vue_render__$o,
  staticRenderFns: __vue_staticRenderFns__$o
}, __vue_inject_styles__$s, __vue_script__$s, __vue_scope_id__$s, __vue_is_functional_template__$s, __vue_module_identifier__$s, undefined, undefined);

//
var script$t = {
  name: "FdInputGroupButton",
  components: {
    FdButton: Button
  },
  inject: ["$_fdInputGroupAddon"],
  mounted: function mounted() {
    this.$_fdInputGroupAddon.hasButton = true;
  }
};

/* script */
var __vue_script__$t = script$t;
/* template */

var __vue_render__$p = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('fd-button', _vm._g(_vm._b({
    attrs: {
      "styling": "light"
    }
  }, 'fd-button', _vm.$attrs, false), _vm.$listeners), [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$p = [];
/* style */

var __vue_inject_styles__$t = undefined;
/* scoped */

var __vue_scope_id__$t = undefined;
/* module identifier */

var __vue_module_identifier__$t = undefined;
/* functional template */

var __vue_is_functional_template__$t = false;
/* style inject */

/* style inject SSR */

var FdInputGroupButton = normalizeComponent_1({
  render: __vue_render__$p,
  staticRenderFns: __vue_staticRenderFns__$p
}, __vue_inject_styles__$t, __vue_script__$t, __vue_scope_id__$t, __vue_is_functional_template__$t, __vue_module_identifier__$t, undefined, undefined);

//

var script$u = {
  name: "FdCombobox",
  mixins: [Uid],
  provide: function provide() {
    return {
      combobox: this
    };
  },
  model: {
    prop: "value",
    event: "update"
  },
  components: {
    FdMenu: FdMenu,
    FdMenuList: FdMenuList,
    FdComboboxBase: FdComboboxBase,
    FdInput: FdInput,
    FdInputGroupButton: FdInputGroupButton
  },
  props: {
    // Value
    value: {
      type: String,
      // `null`
      default: null
    },
    // Placeholder used by the input component
    placeholder: {
      type: String,
      // `""`
      default: ""
    },
    // Whether or not the combobox is compactable. A compactable combobox can become less tall on desktop if the view port is getting smaller.
    compact: Boolean
  },
  computed: {
    comboboxBase: function comboboxBase() {
      return this.$refs.comboboxBase;
    }
  },
  data: function data() {
    return {
      // type: string | number | null
      currentValue: this.value
    };
  },
  watch: {
    value: {
      immediate: true,
      handler: function handler(newValue) {
        this.currentValue = newValue;
      }
    }
  },
  methods: {
    // @vuese
    // Shows the combobox menu
    show: function show() {
      this.comboboxBase.show();
    },
    // @vuese
    // Hides the combobox menu
    hide: function hide() {
      this.comboboxBase.hide();
    },
    // @vuese
    // Toggles the combobox menu
    toggle: function toggle() {
      this.comboboxBase.toggle();
    },
    handleBlur: function handleBlur() {
      var _this = this;

      setTimeout(function () {
        _this.$refs.comboboxBase.hide();
      });
    },
    selectItem: function selectItem(item) {
      this.setCurrentValue(item.value);
      this.$refs.comboboxBase.hide();
    },
    ignoredElements: function ignoredElements() {
      return [this.$refs.input.$el];
    },
    setCurrentValue: function setCurrentValue(newValue) {
      this.currentValue = newValue; // Trigged when the current value changes
      // @arg the current value

      this.$emit("update", this.currentValue); // Trigged when the current value changes
      // @arg the current value

      this.$emit("update:value", this.currentValue);
    }
  }
};

/* script */
var __vue_script__$u = script$u;
/* template */

var __vue_render__$q = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('FdComboboxBase', {
    ref: "comboboxBase",
    staticClass: "fd-combobox-input",
    attrs: {
      "ignoredElements": _vm.ignoredElements,
      "compact": _vm.compact
    },
    scopedSlots: _vm._u([{
      key: "input",
      fn: function fn(ref) {
        var showCompletions = ref.showCompletions;
        var hideCompletions = ref.hideCompletions;
        return [_c('FdInput', {
          ref: "input",
          attrs: {
            "value": _vm.currentValue,
            "placeholder": _vm.placeholder,
            "compact": _vm.compact
          },
          on: {
            "blur": _vm.handleBlur,
            "focus": showCompletions,
            "update": _vm.setCurrentValue,
            "click": showCompletions,
            "keyup": function keyup($event) {
              if (!$event.type.indexOf('key') && _vm._k($event.keyCode, "esc", 27, $event.key, ["Esc", "Escape"])) {
                return null;
              }

              return hideCompletions($event);
            }
          }
        })];
      }
    }, {
      key: "after",
      fn: function fn(ref) {
        var toggleCompletions = ref.toggleCompletions;
        return [_c('FdInputGroupButton', {
          attrs: {
            "compact": _vm.compact,
            "icon": "navigation-down-arrow",
            "styling": "light"
          },
          on: {
            "click": toggleCompletions
          }
        })];
      }
    }, {
      key: "default",
      fn: function fn() {
        return [_vm._t("menu", [_c('FdMenu', {
          on: {
            "select": _vm.selectItem
          }
        }, [_c('FdMenuList', [_vm._t("default")], 2)], 1)])];
      },
      proxy: true
    }], null, true)
  });
};

var __vue_staticRenderFns__$q = [];
/* style */

var __vue_inject_styles__$u = undefined;
/* scoped */

var __vue_scope_id__$u = undefined;
/* module identifier */

var __vue_module_identifier__$u = undefined;
/* functional template */

var __vue_is_functional_template__$u = false;
/* style inject */

/* style inject SSR */

var Combobox = normalizeComponent_1({
  render: __vue_render__$q,
  staticRenderFns: __vue_staticRenderFns__$q
}, __vue_inject_styles__$u, __vue_script__$u, __vue_scope_id__$u, __vue_is_functional_template__$u, __vue_module_identifier__$u, undefined, undefined);

var Combobox$1 = pluginify(Combobox);

//
var script$v = {
  name: "FdMenuPopover",
  components: {
    FdPopover: FdPopover,
    FdMenu: FdMenu
  },
  props: {
    // Imagine the following scenario:
    // 1. A user clicks on the control – a menu is displayed.
    // 2. Now the user is using arrow.down to highlight the first
    //    menu item.
    // 3. Now the user clicks outside of the menu.
    // 4. User opens the menu again.
    // Sometimes you want the highlighted (but not selected item)
    // to remaing highlighted. Sometimes not (product menu).
    // This prop can be used to adjust exactly that.
    discardHighlight: {
      type: Boolean,
      default: false
    }
  },
  methods: {
    getPopover: function getPopover() {
      return this.$refs.popover;
    },
    // Delegate the usualal suspects to fd-popover…
    show: function show() {
      this.getPopover().show();
    },
    hide: function hide() {
      this.getPopover().hide();
    },
    toggle: function toggle() {
      this.getPopover().toggle();
    },
    // Highlight Management
    highlightNextItem: function highlightNextItem() {
      this.$refs.menu.highlightNextItem();
    },
    highlightPreviousItem: function highlightPreviousItem() {
      this.$refs.menu.highlightPreviousItem();
    },
    // Misc
    updateVisible: function updateVisible(visible) {
      this.visible_ = visible;

      if (this.discardHighlight) {
        this.highlightedId = null;
      }
    },
    handleMenuSelect: function handleMenuSelect(item) {
      this.$emit("select", item);
      this.getPopover().hide();
    }
  },
  computed: {
    highlightedId: {
      set: function set(newId) {
        this.$refs.menu.highlightedId = newId;
      },
      get: function get() {
        return this.$refs.menu.highlightedId;
      }
    },
    highlightedItem: function highlightedItem() {
      return this.$refs.menu.highlightedItem;
    }
  },
  data: function data() {
    return {
      visible_: false
    };
  }
};

/* script */
var __vue_script__$v = script$v;
/* template */

var __vue_render__$r = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('fd-popover', _vm._b({
    ref: "popover",
    on: {
      "update:visible": _vm.updateVisible
    },
    scopedSlots: _vm._u([{
      key: "control",
      fn: function fn(controlProps) {
        return [_c('div', {
          on: {
            "keydown": [function ($event) {
              if (!$event.type.indexOf('key') && _vm._k($event.keyCode, "down", 40, $event.key, ["Down", "ArrowDown"])) {
                return null;
              }

              $event.preventDefault();
              return _vm.highlightNextItem($event);
            }, function ($event) {
              if (!$event.type.indexOf('key') && _vm._k($event.keyCode, "up", 38, $event.key, ["Up", "ArrowUp"])) {
                return null;
              }

              $event.preventDefault();
              return _vm.highlightPreviousItem($event);
            }],
            "keyup": function keyup($event) {
              if (!$event.type.indexOf('key') && _vm._k($event.keyCode, "esc", 27, $event.key, ["Esc", "Escape"])) {
                return null;
              }

              $event.preventDefault();
              return controlProps.hide($event);
            }
          }
        }, [_vm._t("control", null, null, controlProps)], 2)];
      }
    }, {
      key: "default",
      fn: function fn(bodyProps) {
        return [_c('fd-menu', {
          ref: "menu",
          on: {
            "select": _vm.handleMenuSelect,
            "highlight": function highlight($event) {
              return _vm.$emit('highlight', $event);
            }
          }
        }, [_vm._t("default", null, null, bodyProps)], 2)];
      }
    }], null, true)
  }, 'fd-popover', _vm.$attrs, false));
};

var __vue_staticRenderFns__$r = [];
/* style */

var __vue_inject_styles__$v = undefined;
/* scoped */

var __vue_scope_id__$v = undefined;
/* module identifier */

var __vue_module_identifier__$v = undefined;
/* functional template */

var __vue_is_functional_template__$v = false;
/* style inject */

/* style inject SSR */

var MenuPopover = normalizeComponent_1({
  render: __vue_render__$r,
  staticRenderFns: __vue_staticRenderFns__$r
}, __vue_inject_styles__$v, __vue_script__$v, __vue_scope_id__$v, __vue_is_functional_template__$v, __vue_module_identifier__$v, undefined, undefined);

var script$w = {
  name: "FdContextButton",
  extends: Button,
  props: {
    styling: {
      default: "light"
    },
    icon: {
      default: "overflow"
    }
  }
};

/* script */
var __vue_script__$w = script$w;
/* template */

/* style */

var __vue_inject_styles__$w = undefined;
/* scoped */

var __vue_scope_id__$w = undefined;
/* module identifier */

var __vue_module_identifier__$w = undefined;
/* functional template */

var __vue_is_functional_template__$w = undefined;
/* style inject */

/* style inject SSR */

var ContextButton = normalizeComponent_1({}, __vue_inject_styles__$w, __vue_script__$w, __vue_scope_id__$w, __vue_is_functional_template__$w, __vue_module_identifier__$w, undefined, undefined);

var script$x = {
  name: "FdContextMenu",
  components: {
    FdMenuPopover: MenuPopover,
    FdContextButton: ContextButton
  },
  methods: {
    controlProps: function controlProps(_controlProps) {
      return _objectSpread2({}, _controlProps, {
        toggleContextMenu: _controlProps.toggle
      });
    }
  }
};

/* script */
var __vue_script__$x = script$x;
/* template */

var __vue_render__$s = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('fd-menu-popover', {
    attrs: {
      "placement": "bottom-start",
      "with-arrow": "",
      "flips": false
    },
    scopedSlots: _vm._u([{
      key: "control",
      fn: function fn(popoverProps) {
        return [_vm._t("button", [_c('fd-context-button', {
          on: {
            "click": popoverProps.toggle
          }
        })], null, _vm.controlProps(popoverProps))];
      }
    }, {
      key: "default",
      fn: function fn() {
        return [_vm._t("default")];
      },
      proxy: true
    }], null, true)
  });
};

var __vue_staticRenderFns__$s = [];
/* style */

var __vue_inject_styles__$x = undefined;
/* scoped */

var __vue_scope_id__$x = undefined;
/* module identifier */

var __vue_module_identifier__$x = undefined;
/* functional template */

var __vue_is_functional_template__$x = false;
/* style inject */

/* style inject SSR */

var ContextMenu = normalizeComponent_1({
  render: __vue_render__$s,
  staticRenderFns: __vue_staticRenderFns__$s
}, __vue_inject_styles__$x, __vue_script__$x, __vue_scope_id__$x, __vue_is_functional_template__$x, __vue_module_identifier__$x, undefined, undefined);

var ContextMenu$1 = pluginify(ContextMenu);

var ContextButton$1 = pluginify(ContextButton);

//
var script$y = {
  name: "FdComboboxMenu",
  inject: ["combobox"],
  components: {
    FdMenu: FdMenu
  },
  methods: {
    selectItem: function selectItem(item) {
      this.combobox.selectItem(item);
    }
  }
};

/* script */
var __vue_script__$y = script$y;
/* template */

var __vue_render__$t = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('fd-menu', {
    on: {
      "select": _vm.selectItem
    }
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$t = [];
/* style */

var __vue_inject_styles__$y = undefined;
/* scoped */

var __vue_scope_id__$y = undefined;
/* module identifier */

var __vue_module_identifier__$y = undefined;
/* functional template */

var __vue_is_functional_template__$y = false;
/* style inject */

/* style inject SSR */

var ComboboxMenu = normalizeComponent_1({
  render: __vue_render__$t,
  staticRenderFns: __vue_staticRenderFns__$t
}, __vue_inject_styles__$y, __vue_script__$y, __vue_scope_id__$y, __vue_is_functional_template__$y, __vue_module_identifier__$y, undefined, undefined);

var ComboboxMenu$1 = pluginify(ComboboxMenu);

//
//
//
//
//
//
//
// Container component – should contains `fd-col`-instances.
var script$z = {
  name: "FdContainer",
  props: {
    // If `true`, the container will act as a flexbox.
    flex: {
      type: Boolean,
      default: false
    },
    fluid: {
      type: Boolean,
      default: false
    },
    // If `true`, the wrapper is centered within it's parent.
    centered: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    classes: function classes() {
      return {
        "fd-container--flex": this.flex,
        "fd-container--fluid": this.fluid,
        "fd-container--centered": this.centered
      };
    }
  }
};

/* script */
var __vue_script__$z = script$z;
/* template */

var __vue_render__$u = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-container",
    class: _vm.classes
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$u = [];
/* style */

var __vue_inject_styles__$z = undefined;
/* scoped */

var __vue_scope_id__$z = undefined;
/* module identifier */

var __vue_module_identifier__$z = undefined;
/* functional template */

var __vue_is_functional_template__$z = false;
/* style inject */

/* style inject SSR */

var FdContainer = normalizeComponent_1({
  render: __vue_render__$u,
  staticRenderFns: __vue_staticRenderFns__$u
}, __vue_inject_styles__$z, __vue_script__$z, __vue_scope_id__$z, __vue_is_functional_template__$z, __vue_module_identifier__$z, undefined, undefined);

var Container = pluginify(FdContainer);

//
//
//
//
//
//
// Column-component – used together with `fd-container`.
var script$A = {
  name: "FdCol",
  props: {
    // Number of columns to span
    span: {
      type: Number,
      // `null` – width is automatically computed
      default: null
    },
    // Number of columns to shift the column
    shiftBy: {
      type: Number,
      // `null` – no shifting
      default: null
    }
  },
  computed: {
    classes: function classes() {
      var span = this.span,
          shiftBy = this.shiftBy;
      return [span == null ? "" : "fd-col--".concat(span), shiftBy == null ? "" : "fd-col--shift-".concat(shiftBy)];
    }
  }
};

/* script */
var __vue_script__$A = script$A;
/* template */

var __vue_render__$v = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-col",
    class: _vm.classes
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$v = [];
/* style */

var __vue_inject_styles__$A = undefined;
/* scoped */

var __vue_scope_id__$A = undefined;
/* module identifier */

var __vue_module_identifier__$A = undefined;
/* functional template */

var __vue_is_functional_template__$A = false;
/* style inject */

/* style inject SSR */

var FdCol = normalizeComponent_1({
  render: __vue_render__$v,
  staticRenderFns: __vue_staticRenderFns__$v
}, __vue_inject_styles__$A, __vue_script__$A, __vue_scope_id__$A, __vue_is_functional_template__$A, __vue_module_identifier__$A, undefined, undefined);

var Col = pluginify(FdCol);

//
//
//
//
var counterTypeValues = ["info", "notification"]; // Component to display counts

var script$B = {
  name: "FdCounter",
  props: {
    // Counter type
    type: {
      // `info` / `notification`
      type: String,
      // `info`
      default: "info",
      validator: function validator(value) {
        return counterTypeValues.indexOf(value) >= 0;
      }
    },
    // counter value
    value: {
      type: Number,
      // `0`
      default: 0
    }
  },
  computed: {
    formattedValue: function formattedValue() {
      return !isNaN(Number(this.value)) ? Number(this.value) <= 999 ? String(this.value) : "999+" : "1";
    },
    classes: function classes() {
      return {
        "fd-counter--notification": this.type === "notification"
      };
    }
  }
};

/* script */
var __vue_script__$B = script$B;
/* template */

var __vue_render__$w = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('span', {
    staticClass: "fd-counter",
    class: _vm.classes
  }, [_vm._v(_vm._s(_vm.formattedValue))]);
};

var __vue_staticRenderFns__$w = [];
/* style */

var __vue_inject_styles__$B = undefined;
/* scoped */

var __vue_scope_id__$B = undefined;
/* module identifier */

var __vue_module_identifier__$B = undefined;
/* functional template */

var __vue_is_functional_template__$B = false;
/* style inject */

/* style inject SSR */

var Counter = normalizeComponent_1({
  render: __vue_render__$w,
  staticRenderFns: __vue_staticRenderFns__$w
}, __vue_inject_styles__$B, __vue_script__$B, __vue_scope_id__$B, __vue_is_functional_template__$B, __vue_module_identifier__$B, undefined, undefined);

var Counter$1 = pluginify(Counter);

var DefaultDateFormatter = (function (date) {
  if (date == null) {
    return;
  }

  if (date === "") {
    return;
  }

  var month = date.getMonth() + 1;
  var day = date.getDate();
  var year = date.getFullYear();
  return "".concat(month, "/").concat(day, "/").concat(year);
});

var DefaultDateRangeFormatter = (function (_ref) {
  var start = _ref.start,
      end = _ref.end;
  var formattedStart = DefaultDateFormatter(start);
  var formattedEnd = DefaultDateFormatter(end);

  if (formattedStart == null && formattedEnd == null) {
    return;
  }

  if (formattedEnd == null) {
    return formattedStart;
  }

  if (formattedStart == null) {
    return formattedEnd;
  }

  return "".concat(formattedStart, " - ").concat(formattedEnd);
});

/**
 * Default Parser
 * @param {string=} dateString
 * @returns {Date=}
 */
var DefaultDateParser = (function (dateString) {
  if (dateString == null) {
    return;
  }

  return new Date(dateString);
});

/**
 * @typedef {object} DateRange
 * @prop {Date=} from
 * @prop {Date=} to
 *
 * Default Range Parser
 * @param {string=} rangeString
 * @returns {DateRange=}
 */

var DefaultDateRangeParser = (function (rangeString) {
  if (rangeString == null) {
    return {
      from: null,
      to: null
    };
  }

  if (rangeString === "") {
    return {
      from: null,
      to: null
    };
  }

  var rangeDelimiter = " - ";

  var _rangeString$split = rangeString.split(rangeDelimiter),
      _rangeString$split2 = _slicedToArray(_rangeString$split, 2),
      rawStart = _rangeString$split2[0],
      rawEnd = _rangeString$split2[1];

  var from = DefaultDateParser(rawStart);
  var to = DefaultDateParser(rawEnd);
  return {
    from: from,
    to: to
  };
});

//

var script$C = {
  name: "FdDateInput",
  components: {
    FdInput: FdInput
  },
  data: function data() {
    return {
      normalizedDate: this.value,
      displayedInputValue: ""
    };
  },
  computed: {
    displayedValue: {
      get: function get() {
        var mode = this.mode,
            normalizedDate = this.normalizedDate,
            dateFormatter = this.dateFormatter,
            dateRangeFormatter = this.dateRangeFormatter;

        if (mode === "single") {
          return dateFormatter(NormalizedDate.from(normalizedDate).start);
        }

        return dateRangeFormatter(NormalizedDate.from(normalizedDate).asStartEndValue());
      },
      set: function set(newDateString) {
        var mode = this.mode,
            dateParser = this.dateParser,
            dateRangeParser = this.dateRangeParser,
            normalizedDate = this.normalizedDate;

        if (mode === "single") {
          normalizedDate.to = null;
          normalizedDate.from = dateParser(newDateString);
        }

        if (mode === "range") {
          var range = dateRangeParser(newDateString);
          normalizedDate.from = range.from;
          normalizedDate.to = range.to;
        }

        this.emitCurrentValue();
      }
    },
    dateValue: function dateValue() {
      return this.dateParser(this.displayedInputValue);
    }
  },
  watch: {
    value: {
      deep: true,
      handler: function handler(value) {
        this.normalizedDate.from = value.from;
        this.normalizedDate.to = value.to;
      }
    }
  },
  methods: {
    emitCurrentValue: function emitCurrentValue() {
      // Emitted whenever the date or range has been confirmed by the user.
      // @arg An object with two keys: `from` and `to` – both can be either `null` or `Date`. In `single`-mode only `from` will be a `Date`.
      this.$emit("input", NormalizedDate.from(this.normalizedDate).asFromToValue());
    },
    dateInputChanged: function dateInputChanged(inputString) {
      this.displayedValue = inputString;
    }
  },
  props: {
    // Input mode – 'single' allows the user to input a single date, 'range' allows the user to enter a date range.
    mode: {
      // `'range'` / `'single'`
      type: String,
      validator: function validator(value) {
        return ["range", "single"].indexOf(value) >= 0;
      },
      default: "single"
    },
    // The value – can be a range or a single date – however in both cases an object with `from`- and `to`-properties is expected.
    value: {
      // The value-object should have the following shape:
      // ```typescript
      // { from?: Date, to?: Date }
      // ```
      type: Object,
      // Defaults to the 'null-date': `{ from?: Date, to?: Date }`
      default: function _default() {
        return {
          from: null,
          to: null
        };
      }
    },
    // Custom date formatter – should return a string for a given `Date`.
    dateFormatter: {
      // `date => string`
      type: Function,
      // A default date formatter provided by the framework.
      default: DefaultDateFormatter
    },
    // Custom date range formatter.
    // Should return a string for a given date range:
    // ```typescript
    // { from?: Date, to?: Date }
    // ```
    dateRangeFormatter: {
      // `({from?: Date, to?: Date}) => string`
      type: Function,
      // A default date range formatter provided by the framework.
      default: DefaultDateRangeFormatter
    },
    // Custom date parser – should return a `Date` for a given `String`.
    dateParser: {
      // `String => Date`
      type: Function,
      // A default date parser provided by the framework.
      default: DefaultDateParser
    },
    // Custom date range parser – should return a date range for a given `String`.
    dateRangeParser: {
      // `String => ({from?: Date, to?: Date})`
      type: Function,
      // A default date range parser provided by the framework.
      default: DefaultDateRangeParser
    }
  }
};

/* script */
var __vue_script__$C = script$C;
/* template */

var __vue_render__$x = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('fd-input', {
    attrs: {
      "value": _vm.displayedValue
    },
    on: {
      "change": _vm.dateInputChanged
    }
  });
};

var __vue_staticRenderFns__$x = [];
/* style */

var __vue_inject_styles__$C = undefined;
/* scoped */

var __vue_scope_id__$C = undefined;
/* module identifier */

var __vue_module_identifier__$C = undefined;
/* functional template */

var __vue_is_functional_template__$C = false;
/* style inject */

/* style inject SSR */

var DateInput = normalizeComponent_1({
  render: __vue_render__$x,
  staticRenderFns: __vue_staticRenderFns__$x
}, __vue_inject_styles__$C, __vue_script__$C, __vue_scope_id__$C, __vue_is_functional_template__$C, __vue_module_identifier__$C, undefined, undefined);

//
var script$D = {
  name: "FdDatePickerInput",
  components: {
    FdDateInput: DateInput
  },
  inject: ["$_fdDatePicker"],
  computed: {
    datePicker: function datePicker() {
      return this.$_fdDatePicker;
    },
    datePickerValue: function datePickerValue() {
      return this.datePicker.value;
    },
    datePickerMode: function datePickerMode() {
      return this.datePicker.mode;
    }
  },
  watch: {
    value: {
      handler: function handler(value) {
        this.$_fdDatePicker.setValue(value);
      }
    },
    mode: {
      handler: function handler(mode) {
        this.$_fdDatePicker.mode = mode;
      }
    },
    datePickerValue: {
      deep: true,
      immediate: true,
      handler: function handler(value) {
        this.value = value;
      }
    },
    datePickerMode: {
      immediate: true,
      handler: function handler(mode) {
        this.mode = mode;
      }
    }
  },
  data: function data() {
    return {
      value: createNullDate(),
      mode: "single"
    };
  }
};

/* script */
var __vue_script__$D = script$D;
/* template */

var __vue_render__$y = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('fd-date-input', {
    attrs: {
      "mode": _vm.mode
    },
    model: {
      value: _vm.value,
      callback: function callback($$v) {
        _vm.value = $$v;
      },
      expression: "value"
    }
  });
};

var __vue_staticRenderFns__$y = [];
/* style */

var __vue_inject_styles__$D = undefined;
/* scoped */

var __vue_scope_id__$D = undefined;
/* module identifier */

var __vue_module_identifier__$D = undefined;
/* functional template */

var __vue_is_functional_template__$D = false;
/* style inject */

/* style inject SSR */

var DatePickerInput = normalizeComponent_1({
  render: __vue_render__$y,
  staticRenderFns: __vue_staticRenderFns__$y
}, __vue_inject_styles__$D, __vue_script__$D, __vue_scope_id__$D, __vue_is_functional_template__$D, __vue_module_identifier__$D, undefined, undefined);

//
var script$E = {
  name: "FdDatePickerCalendar",
  inject: ["$_fdDatePicker"],
  components: {
    FdCalendar: FdCalendar
  },
  watch: {
    datePickerMode: {
      immediate: true,
      handler: function handler(mode) {
        this.mode = mode;
      }
    },
    datePickerValue: {
      immediate: true,
      deep: true,
      handler: function handler(value) {
        this.value = value;
      }
    }
  },
  methods: {
    takeValueFromCalendar: function takeValueFromCalendar(value) {
      this.value = value;
      this.$emit("input", this.value);
      this.datePicker.setValue(value);
    }
  },
  computed: {
    datePicker: function datePicker() {
      return this.$_fdDatePicker;
    },
    datePickerMode: function datePickerMode() {
      return this.datePicker.mode;
    },
    datePickerValue: function datePickerValue() {
      return this.datePicker.value;
    }
  },
  data: function data() {
    return {
      value: createNullDate(),
      mode: "single"
    };
  }
};

/* script */
var __vue_script__$E = script$E;
/* template */

var __vue_render__$z = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('fd-calendar', {
    directives: [{
      name: "fd-margin",
      rawName: "v-fd-margin:tiny",
      arg: "tiny"
    }],
    attrs: {
      "mode": _vm.mode,
      "value": _vm.value
    },
    on: {
      "input": _vm.takeValueFromCalendar
    }
  });
};

var __vue_staticRenderFns__$z = [];
/* style */

var __vue_inject_styles__$E = undefined;
/* scoped */

var __vue_scope_id__$E = undefined;
/* module identifier */

var __vue_module_identifier__$E = undefined;
/* functional template */

var __vue_is_functional_template__$E = false;
/* style inject */

/* style inject SSR */

var DatePickerCalendar = normalizeComponent_1({
  render: __vue_render__$z,
  staticRenderFns: __vue_staticRenderFns__$z
}, __vue_inject_styles__$E, __vue_script__$E, __vue_scope_id__$E, __vue_is_functional_template__$E, __vue_module_identifier__$E, undefined, undefined);

//
var script$F = {
  name: "FdDatePicker",
  components: {
    FdDatePickerInput: DatePickerInput,
    FdDatePickerCalendar: DatePickerCalendar,
    FdInputGroup: FdInputGroup,
    FdInputGroupAddon: FdInputGroupAddon,
    FdInputGroupButton: FdInputGroupButton,
    FdPopover: FdPopover
  },
  watch: {
    value: {
      deep: true,
      immediate: true,
      handler: function handler(value) {
        this.state.value.from = value.from;
        this.state.value.to = value.to;
      }
    },
    mode: {
      immediate: true,
      deep: true,
      handler: function handler(mode) {
        this.state.mode = mode;
      }
    }
  },
  provide: function provide() {
    return {
      $_fdDatePicker: {
        mode: this.state.mode,
        value: this.state.value,
        setValue: this.setValue
      }
    };
  },
  methods: {
    setValue: function setValue(value) {
      this.state.value.from = value.from;
      this.state.value.to = value.to;
      this.$emit("input", {
        from: this.state.value.from,
        to: this.state.value.to
      });
    }
  },
  data: function data() {
    return {
      state: Vue$1.observable({
        value: {
          from: createNormalizedDate(this.value).asFromToValue().from,
          to: createNormalizedDate(this.value).asFromToValue().to
        },
        mode: this.mode
      })
    };
  },
  props: {
    // The date-value represented by this date picker
    value: {
      // `{ from?: Date, to?: Date }`
      type: Object,
      // `{ from: null, to: null }`
      default: createNullDate
    },
    // Selection mode
    mode: {
      // `single` / `range`
      type: String,
      // `single` – only a single date can be selected
      default: "single"
    }
  }
};

/* script */
var __vue_script__$F = script$F;
/* template */

var __vue_render__$A = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-date-picker"
  }, [_c('fd-popover', {
    attrs: {
      "flips": false,
      "body-style": "",
      "body-size-mode": "at-least-trigger",
      "placement": "bottom-end"
    },
    scopedSlots: _vm._u([{
      key: "control",
      fn: function fn(ref) {
        var toggle = ref.toggle;
        return [_c('fd-input-group', {
          scopedSlots: _vm._u([{
            key: "input",
            fn: function fn() {
              return [_vm._t("input", [_c('fd-date-picker-input')])];
            },
            proxy: true
          }, {
            key: "after",
            fn: function fn() {
              return [_c('fd-input-group-addon', [_c('fd-input-group-button', {
                attrs: {
                  "icon": "calendar"
                },
                on: {
                  "click": toggle
                }
              })], 1)];
            },
            proxy: true
          }], null, true)
        })];
      }
    }, {
      key: "default",
      fn: function fn() {
        return [_vm._t("calendar", [_c('fd-date-picker-calendar', {
          directives: [{
            name: "fd-margin",
            rawName: "v-fd-margin:tiny",
            arg: "tiny"
          }]
        })])];
      },
      proxy: true
    }], null, true)
  })], 1);
};

var __vue_staticRenderFns__$A = [];
/* style */

var __vue_inject_styles__$F = undefined;
/* scoped */

var __vue_scope_id__$F = undefined;
/* module identifier */

var __vue_module_identifier__$F = undefined;
/* functional template */

var __vue_is_functional_template__$F = false;
/* style inject */

/* style inject SSR */

var DatePicker = normalizeComponent_1({
  render: __vue_render__$A,
  staticRenderFns: __vue_staticRenderFns__$A
}, __vue_inject_styles__$F, __vue_script__$F, __vue_scope_id__$F, __vue_is_functional_template__$F, __vue_module_identifier__$F, undefined, undefined);

var DatePicker$1 = pluginify(DatePicker);

var DatePickerInput$1 = pluginify(DatePickerInput);

var DatePickerCalendar$1 = pluginify(DatePickerCalendar);

var DateInput$1 = pluginify(DateInput);

//
var script$G = {
  name: "FdDropdownControl",
  components: {
    FdButton: Button
  }
};

/* script */
var __vue_script__$G = script$G;
/* template */

var __vue_render__$B = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('fd-button', _vm._g(_vm._b({
    staticClass: "fd-dropdown__control"
  }, 'fd-button', _vm.$attrs, false), _vm.$listeners), [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$B = [];
/* style */

var __vue_inject_styles__$G = undefined;
/* scoped */

var __vue_scope_id__$G = undefined;
/* module identifier */

var __vue_module_identifier__$G = undefined;
/* functional template */

var __vue_is_functional_template__$G = false;
/* style inject */

/* style inject SSR */

var DropdownControl = normalizeComponent_1({
  render: __vue_render__$B,
  staticRenderFns: __vue_staticRenderFns__$B
}, __vue_inject_styles__$G, __vue_script__$G, __vue_scope_id__$G, __vue_is_functional_template__$G, __vue_module_identifier__$G, undefined, undefined);

//
var script$H = {
  name: "FdDropdown",
  inheritAttrs: false,
  props: {
    title: String,
    compact: Boolean,
    toolbar: Boolean,
    icon: String,
    disabled: Boolean
  },
  methods: {
    // This method is called in two different scenarios:
    // 1. The user clicks on the control element or presses enter while it
    //    has focus: In that case we simply want to show the menu.
    // 2. The user clicks on the control element or presses enter while it
    //    is already open. The intention is to either confirm the selection
    //    or to close the menu.
    handleControlClick: function handleControlClick() {
      var menuPopover = this.$refs.menuPopover;

      if (menuPopover.visible_) {
        this._confirmHighlighted();

        return;
      }

      menuPopover.show();
    },
    handleEnter: function handleEnter() {
      this._confirmHighlighted();
    },
    handleMenuPopoverSelect: function handleMenuPopoverSelect(item) {
      var menuPopover = this.$refs.menuPopover;
      menuPopover.highlightedId = item.uid;
      this.$emit("select", item);
    },
    _confirmHighlighted: function _confirmHighlighted() {
      var menuPopover = this.$refs.menuPopover;
      this.$emit("select", menuPopover.highlightedItem);
      menuPopover.hide();
    }
  },
  computed: {
    controlType: function controlType() {
      return this.toolbar ? "standard" : null;
    },
    classes: function classes() {
      return {
        "fd-dropdown--compact": this.compact,
        "fd-dropdown--standard": this.toolbar
      };
    }
  },
  components: {
    FdDropdownControl: DropdownControl,
    FdMenuPopover: MenuPopover
  }
};

/* script */
var __vue_script__$H = script$H;
/* template */

var __vue_render__$C = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('fd-menu-popover', {
    ref: "menuPopover",
    attrs: {
      "placement": "bottom-end",
      "body-size-mode": "at-least-trigger"
    },
    on: {
      "select": _vm.handleMenuPopoverSelect
    },
    scopedSlots: _vm._u([{
      key: "control",
      fn: function fn(popoverProps) {
        return [_c('div', _vm._b({
          staticClass: "fd-dropdown",
          class: _vm.classes
        }, 'div', _vm.$attrs, false), [_vm._t("control", [_c('fd-dropdown-control', {
          attrs: {
            "compact": _vm.compact,
            "icon": _vm.icon,
            "type": _vm.controlType,
            "disabled": _vm.disabled
          },
          on: {
            "click": _vm.handleControlClick
          },
          nativeOn: {
            "keydown": function keydown($event) {
              if (!$event.type.indexOf('key') && _vm._k($event.keyCode, "enter", 13, $event.key, "Enter")) {
                return null;
              }

              $event.preventDefault();
              return _vm.handleEnter($event);
            }
          }
        }, [_vm._v("\n          " + _vm._s(_vm.title) + "\n        ")])], {
          "compact": _vm.compact,
          "icon": _vm.icon,
          "disabled": _vm.disabled
        }, popoverProps)], 2)];
      }
    }, {
      key: "default",
      fn: function fn(popoverProps) {
        return [_vm._t("default", null, null, popoverProps)];
      }
    }], null, true)
  });
};

var __vue_staticRenderFns__$C = [];
/* style */

var __vue_inject_styles__$H = undefined;
/* scoped */

var __vue_scope_id__$H = undefined;
/* module identifier */

var __vue_module_identifier__$H = undefined;
/* functional template */

var __vue_is_functional_template__$H = false;
/* style inject */

/* style inject SSR */

var Dropdown = normalizeComponent_1({
  render: __vue_render__$C,
  staticRenderFns: __vue_staticRenderFns__$C
}, __vue_inject_styles__$H, __vue_script__$H, __vue_scope_id__$H, __vue_is_functional_template__$H, __vue_module_identifier__$H, undefined, undefined);

var Dropdown$1 = pluginify(Dropdown);

var DropdownControl$1 = pluginify(DropdownControl);

//
var script$I = {
  mixins: [Uid],
  name: "FdFormItem",
  provide: function provide() {
    return {
      formItem: this,
      itemId: this.uid
    };
  },
  inject: {
    $formGroup: {
      from: "formGroup",
      default: null
    }
  },
  props: {
    inline: {
      type: Boolean,
      default: null
    }
  },
  methods: {
    setCheck: function setCheck(check) {
      this.check = check;
    }
  },
  computed: {
    hasLabel: function hasLabel() {
      return this.label != null;
    },
    classes: function classes() {
      return {
        "fd-form__item--inline": this.computedInline,
        "fd-form__item--check": this.check
      };
    },
    formGroup: function formGroup() {
      return this.$formGroup;
    },
    computedInline: function computedInline() {
      var inline = this.inline;

      if (inline != null) {
        return inline;
      }

      var container = this.formGroup;

      if (container != null) {
        return container.inline;
      }

      return false;
    }
  },
  data: function data() {
    return {
      check: false
    };
  }
};

/* script */
var __vue_script__$I = script$I;
/* template */

var __vue_render__$D = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-form__item",
    class: _vm.classes
  }, [_vm._t("default"), _vm._v(" "), _vm._t("message")], 2);
};

var __vue_staticRenderFns__$D = [];
/* style */

var __vue_inject_styles__$I = undefined;
/* scoped */

var __vue_scope_id__$I = undefined;
/* module identifier */

var __vue_module_identifier__$I = undefined;
/* functional template */

var __vue_is_functional_template__$I = false;
/* style inject */

/* style inject SSR */

var FormItem = normalizeComponent_1({
  render: __vue_render__$D,
  staticRenderFns: __vue_staticRenderFns__$D
}, __vue_inject_styles__$I, __vue_script__$I, __vue_scope_id__$I, __vue_is_functional_template__$I, __vue_module_identifier__$I, undefined, undefined);

//
//
//
//
//
//
//
//
//
//
var script$J = {
  name: "FdFormLabel",
  inject: {
    itemId: {
      default: null
    }
  },
  props: {
    inline: {
      type: Boolean,
      default: false
    },
    required: {
      default: false,
      type: Boolean
    }
  }
};

/* script */
var __vue_script__$J = script$J;
/* template */

var __vue_render__$E = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('label', {
    staticClass: "fd-form__label",
    attrs: {
      "for": _vm.itemId,
      "aria-required": String(_vm.required)
    }
  }, [_vm._t("control"), _vm._v(" "), _vm._t("default"), _vm._v(" "), _vm.required ? [_vm._v("\n    *\n  ")] : _vm._e()], 2);
};

var __vue_staticRenderFns__$E = [];
/* style */

var __vue_inject_styles__$J = undefined;
/* scoped */

var __vue_scope_id__$J = undefined;
/* module identifier */

var __vue_module_identifier__$J = undefined;
/* functional template */

var __vue_is_functional_template__$J = false;
/* style inject */

/* style inject SSR */

var FormLabel = normalizeComponent_1({
  render: __vue_render__$E,
  staticRenderFns: __vue_staticRenderFns__$E
}, __vue_inject_styles__$J, __vue_script__$J, __vue_scope_id__$J, __vue_is_functional_template__$J, __vue_module_identifier__$J, undefined, undefined);

//
//
//
//
//
//
var typeMapping = {
  error: "error",
  warning: "warning",
  help: "help"
};
var MessageTypes = Object.keys(typeMapping);

var isMessageType = function isMessageType(value) {
  return MessageTypes.indexOf(value) >= 0;
};

var script$K = {
  name: "FdFormMessage",
  props: {
    type: {
      default: null,
      type: String,
      validator: isMessageType
    }
  },
  computed: {
    classes: function classes() {
      var _ref;

      var staticClass = "fd-form__message";
      return _ref = {}, _defineProperty(_ref, staticClass, true), _defineProperty(_ref, "".concat(staticClass, "--").concat(this.type || ""), this.type != null), _ref;
    }
  }
};

/* script */
var __vue_script__$K = script$K;
/* template */

var __vue_render__$F = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('span', {
    class: _vm.classes
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$F = [];
/* style */

var __vue_inject_styles__$K = undefined;
/* scoped */

var __vue_scope_id__$K = undefined;
/* module identifier */

var __vue_module_identifier__$K = undefined;
/* functional template */

var __vue_is_functional_template__$K = false;
/* style inject */

/* style inject SSR */

var FormMessage = normalizeComponent_1({
  render: __vue_render__$F,
  staticRenderFns: __vue_staticRenderFns__$F
}, __vue_inject_styles__$K, __vue_script__$K, __vue_scope_id__$K, __vue_is_functional_template__$K, __vue_module_identifier__$K, undefined, undefined);

//
//
//
//
//
//
var script$L = {
  name: "FdFormGroup",
  provide: function provide() {
    return {
      formGroup: this
    };
  },
  props: {
    inline: {
      type: Boolean,
      default: false
    }
  }
};

/* script */
var __vue_script__$L = script$L;
/* template */

var __vue_render__$G = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-form__group"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$G = [];
/* style */

var __vue_inject_styles__$L = undefined;
/* scoped */

var __vue_scope_id__$L = undefined;
/* module identifier */

var __vue_module_identifier__$L = undefined;
/* functional template */

var __vue_is_functional_template__$L = false;
/* style inject */

/* style inject SSR */

var FormGroup = normalizeComponent_1({
  render: __vue_render__$G,
  staticRenderFns: __vue_staticRenderFns__$G
}, __vue_inject_styles__$L, __vue_script__$L, __vue_scope_id__$L, __vue_is_functional_template__$L, __vue_module_identifier__$L, undefined, undefined);

//
//
//
//
//
//
var script$M = {
  name: "FdLegend"
};

/* script */
var __vue_script__$M = script$M;
/* template */

var __vue_render__$H = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('legend', {
    staticClass: "fd-form__legend"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$H = [];
/* style */

var __vue_inject_styles__$M = undefined;
/* scoped */

var __vue_scope_id__$M = undefined;
/* module identifier */

var __vue_module_identifier__$M = undefined;
/* functional template */

var __vue_is_functional_template__$M = false;
/* style inject */

/* style inject SSR */

var Legend = normalizeComponent_1({
  render: __vue_render__$H,
  staticRenderFns: __vue_staticRenderFns__$H
}, __vue_inject_styles__$M, __vue_script__$M, __vue_scope_id__$M, __vue_is_functional_template__$M, __vue_module_identifier__$M, undefined, undefined);

//
//
//
//
//
//
var script$N = {
  name: "FdFieldSet"
};

/* script */
var __vue_script__$N = script$N;
/* template */

var __vue_render__$I = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('fieldset', {
    staticClass: "fd-form__set"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$I = [];
/* style */

var __vue_inject_styles__$N = undefined;
/* scoped */

var __vue_scope_id__$N = undefined;
/* module identifier */

var __vue_module_identifier__$N = undefined;
/* functional template */

var __vue_is_functional_template__$N = false;
/* style inject */

/* style inject SSR */

var FieldSet = normalizeComponent_1({
  render: __vue_render__$I,
  staticRenderFns: __vue_staticRenderFns__$I
}, __vue_inject_styles__$N, __vue_script__$N, __vue_scope_id__$N, __vue_is_functional_template__$N, __vue_module_identifier__$N, undefined, undefined);

//
//
//
//
//
//
var script$O = {
  name: "FdForm"
};

/* script */
var __vue_script__$O = script$O;
/* template */

var __vue_render__$J = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('form', [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$J = [];
/* style */

var __vue_inject_styles__$O = undefined;
/* scoped */

var __vue_scope_id__$O = undefined;
/* module identifier */

var __vue_module_identifier__$O = undefined;
/* functional template */

var __vue_is_functional_template__$O = false;
/* style inject */

/* style inject SSR */

var Form = normalizeComponent_1({
  render: __vue_render__$J,
  staticRenderFns: __vue_staticRenderFns__$J
}, __vue_inject_styles__$O, __vue_script__$O, __vue_scope_id__$O, __vue_is_functional_template__$O, __vue_module_identifier__$O, undefined, undefined);

//
var script$P = {
  name: "FdSelect",
  mixins: [InputMixin],
  inheritAttrs: false,
  model: {
    event: "update"
  },
  props: {
    value: $valueWithDefault("")
  }
};

/* script */
var __vue_script__$P = script$P;
/* template */

var __vue_render__$K = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('select', _vm._g(_vm._b({
    class: _vm.inputClasses,
    attrs: {
      "readonly": _vm.readonly ? '' : null,
      "disabled": _vm.disabled ? '' : null,
      "id": _vm.inputId
    },
    domProps: {
      "value": _vm.value
    },
    on: {
      "change": function change($event) {
        return _vm.$emit('update', $event.target.value);
      }
    }
  }, 'select', _vm.$attrs, false), _vm.$listeners), [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$K = [];
/* style */

var __vue_inject_styles__$P = undefined;
/* scoped */

var __vue_scope_id__$P = undefined;
/* module identifier */

var __vue_module_identifier__$P = undefined;
/* functional template */

var __vue_is_functional_template__$P = false;
/* style inject */

/* style inject SSR */

var Select = normalizeComponent_1({
  render: __vue_render__$K,
  staticRenderFns: __vue_staticRenderFns__$K
}, __vue_inject_styles__$P, __vue_script__$P, __vue_scope_id__$P, __vue_is_functional_template__$P, __vue_module_identifier__$P, undefined, undefined);

//
var script$Q = {
  name: "FdTextArea",
  components: {
    FdInput: FdInput
  },
  model: {
    event: "update"
  }
};

/* script */
var __vue_script__$Q = script$Q;
/* template */

var __vue_render__$L = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('FdInput', _vm._g(_vm._b({
    attrs: {
      "type": "textarea"
    }
  }, 'FdInput', _vm.$attrs, false), _vm.$listeners));
};

var __vue_staticRenderFns__$L = [];
/* style */

var __vue_inject_styles__$Q = undefined;
/* scoped */

var __vue_scope_id__$Q = undefined;
/* module identifier */

var __vue_module_identifier__$Q = undefined;
/* functional template */

var __vue_is_functional_template__$Q = false;
/* style inject */

/* style inject SSR */

var TextArea = normalizeComponent_1({
  render: __vue_render__$L,
  staticRenderFns: __vue_staticRenderFns__$L
}, __vue_inject_styles__$Q, __vue_script__$Q, __vue_scope_id__$Q, __vue_is_functional_template__$Q, __vue_module_identifier__$Q, undefined, undefined);

var isElement = function isElement(target) {
  return "tagName" in target;
};
var isInputElement = function isInputElement(target) {
  return isElement(target) && target.tagName === "INPUT";
};

var script$R = {
  name: "FdCheckbox",
  mixins: [InputMixin],
  // inheritAttrs: true,
  inject: {
    // We need the form item so that we can say tell the form item
    // to render the checked-style
    formItem: {
      default: null
    }
  },
  model: {
    event: "update",
    prop: "modelValue"
  },
  props: {
    trueValue: $valueWithDefault(true),
    falseValue: $valueWithDefault(false),
    value: $valueWithDefault(false),
    modelValue: $modelValueWithDefault(false)
  },
  mounted: function mounted() {
    var formItem = this.formItem;

    if (formItem) {
      formItem.setCheck(true);
    }
  },
  computed: {
    checked: function checked() {
      var modelValue = this.modelValue,
          value = this.value,
          trueValue = this.trueValue;

      if (Array.isArray(modelValue)) {
        if (value == null) {
          throw Error("value cannot be null");
        }

        return modelValue.indexOf(value) >= 0;
      }

      return modelValue === trueValue;
    }
  },
  methods: {
    updateInput: function updateInput(event) {
      var target = event.target;

      if (target == null) {
        return;
      }

      if (!isInputElement(target)) {
        return;
      }

      var checked = target.checked;
      var modelValue = this.modelValue,
          value = this.value,
          trueValue = this.trueValue,
          falseValue = this.falseValue;

      if (value == null) {
        throw Error("value cannot be null");
      }

      if (Array.isArray(modelValue)) {
        var newValue = _toConsumableArray(modelValue);

        if (checked) {
          newValue.push(value);
        } else {
          newValue = newValue.filter(function (currentValue) {
            return currentValue !== value;
          });
        }

        var newValueWithoutDuplicates = withoutDuplicates(newValue);
        this.$emit("update", newValueWithoutDuplicates, event);
      } else {
        this.$emit("update", checked ? trueValue : falseValue, event);
      }
    }
  }
};

/* script */
var __vue_script__$R = script$R;
/* template */

var __vue_render__$M = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('input', _vm._g(_vm._b({
    class: _vm.inputClasses,
    attrs: {
      "disabled": _vm.disabled ? '' : null,
      "type": "checkbox",
      "id": _vm.inputId
    },
    domProps: {
      "checked": _vm.checked,
      "value": _vm.value
    },
    on: {
      "change": _vm.updateInput
    }
  }, 'input', _vm.$attrs, false), _vm.$listeners));
};

var __vue_staticRenderFns__$M = [];
/* style */

var __vue_inject_styles__$R = undefined;
/* scoped */

var __vue_scope_id__$R = undefined;
/* module identifier */

var __vue_module_identifier__$R = undefined;
/* functional template */

var __vue_is_functional_template__$R = false;
/* style inject */

/* style inject SSR */

var Checkbox = normalizeComponent_1({
  render: __vue_render__$M,
  staticRenderFns: __vue_staticRenderFns__$M
}, __vue_inject_styles__$R, __vue_script__$R, __vue_scope_id__$R, __vue_is_functional_template__$R, __vue_module_identifier__$R, undefined, undefined);

var script$S = {
  name: "FdToggle",
  mixins: [InputMixin],
  inheritAttrs: false,
  components: {
    FdCheckbox: Checkbox
  },
  model: {
    event: "update",
    prop: "on"
  },
  props: {
    size: $enum("xs", "s", "l"),
    trueValue: $valueWithDefault(true),
    falseValue: $valueWithDefault(false),
    value: $valueWithDefault(true),
    on: {
      type: Boolean
    }
  },
  mounted: function mounted() {
    var formItem = this.formItem;

    if (formItem) {
      formItem.setCheck(true);
    }
  },
  computed: {
    classes: function classes() {
      var _ref;

      return _ref = {
        "fd-toggle": true
      }, _defineProperty(_ref, "fd-toggle--".concat(this.size), this.size != null), _defineProperty(_ref, "fd-form__control", true), _ref;
    }
  }
};

/* script */
var __vue_script__$S = script$S;
/* template */

var __vue_render__$N = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('span', {
    class: _vm.classes
  }, [_c('FdCheckbox', _vm._g(_vm._b({
    attrs: {
      "modelValue": _vm.on,
      "value": _vm.value,
      "disabled": _vm.disabled
    },
    on: {
      "update": function update($event) {
        return _vm.$emit('update', $event);
      }
    }
  }, 'FdCheckbox', _vm.$attrs, false), _vm.$listeners)), _vm._v(" "), _c('span', {
    staticClass: "fd-toggle__switch",
    attrs: {
      "role": "presentation"
    }
  })], 1);
};

var __vue_staticRenderFns__$N = [];
/* style */

var __vue_inject_styles__$S = undefined;
/* scoped */

var __vue_scope_id__$S = undefined;
/* module identifier */

var __vue_module_identifier__$S = undefined;
/* functional template */

var __vue_is_functional_template__$S = false;
/* style inject */

/* style inject SSR */

var Toggle = normalizeComponent_1({
  render: __vue_render__$N,
  staticRenderFns: __vue_staticRenderFns__$N
}, __vue_inject_styles__$S, __vue_script__$S, __vue_scope_id__$S, __vue_is_functional_template__$S, __vue_module_identifier__$S, undefined, undefined);

//
var script$T = {
  name: "FdRadio",
  mixins: [InputMixin],
  inheritAttrs: false,
  model: {
    prop: "modelValue",
    event: "update"
  },
  inject: {
    // We need the form item so that we can say tell the form item
    // to render the checked-style
    formItem: {
      default: null
    }
  },
  props: {
    value: $valueWithDefault(false),
    modelValue: $modelValueWithDefault(false)
  },
  mounted: function mounted() {
    var formItem = this.formItem;

    if (formItem) {
      formItem.setCheck(true);
    }
  },
  computed: {
    checked: function checked() {
      return this.modelValue === this.value;
    }
  }
};

/* script */
var __vue_script__$T = script$T;
/* template */

var __vue_render__$O = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('input', _vm._g(_vm._b({
    class: _vm.inputClasses,
    attrs: {
      "type": "radio",
      "disabled": _vm.disabled ? '' : null,
      "id": _vm.inputId
    },
    domProps: {
      "checked": _vm.checked ? true : false,
      "value": _vm.value
    },
    on: {
      "change": function change($event) {
        return _vm.$emit('update', $event.target.value, $event);
      }
    }
  }, 'input', _vm.$attrs, false), _vm.$listeners));
};

var __vue_staticRenderFns__$O = [];
/* style */

var __vue_inject_styles__$T = undefined;
/* scoped */

var __vue_scope_id__$T = undefined;
/* module identifier */

var __vue_module_identifier__$T = undefined;
/* functional template */

var __vue_is_functional_template__$T = false;
/* style inject */

/* style inject SSR */

var Radio = normalizeComponent_1({
  render: __vue_render__$O,
  staticRenderFns: __vue_staticRenderFns__$O
}, __vue_inject_styles__$T, __vue_script__$T, __vue_scope_id__$T, __vue_is_functional_template__$T, __vue_module_identifier__$T, undefined, undefined);

//
var script$U = {
  name: "FdFormItemRadio",
  components: {
    FdFormLabel: FormLabel
  },
  inject: {
    formGroup: {
      default: {
        inline: null
      }
    }
  },
  props: {
    label: {
      type: String,
      default: null
    },
    inline: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    inline_: function inline_() {
      return this.formGroup.inline != null ? this.formGroup.inline : this.inline;
    },
    classes: function classes() {
      return {
        "fd-form__item--inline": this.inline_
      };
    }
  }
};

/* script */
var __vue_script__$U = script$U;
/* template */

var __vue_render__$P = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-form__item fd-form__item--check",
    class: _vm.classes
  }, [_c('fd-form-label', {
    attrs: {
      "inline": _vm.inline_
    },
    scopedSlots: _vm._u([{
      key: "control",
      fn: function fn() {
        return [_vm._t("default"), _vm._v("\n      " + _vm._s(_vm.label) + "\n    ")];
      },
      proxy: true
    }], null, true)
  })], 1);
};

var __vue_staticRenderFns__$P = [];
/* style */

var __vue_inject_styles__$U = undefined;
/* scoped */

var __vue_scope_id__$U = undefined;
/* module identifier */

var __vue_module_identifier__$U = undefined;
/* functional template */

var __vue_is_functional_template__$U = false;
/* style inject */

/* style inject SSR */

var FdFormItemRadio = normalizeComponent_1({
  render: __vue_render__$P,
  staticRenderFns: __vue_staticRenderFns__$P
}, __vue_inject_styles__$U, __vue_script__$U, __vue_scope_id__$U, __vue_is_functional_template__$U, __vue_module_identifier__$U, undefined, undefined);

var script$V = {
  name: "FdFormItemCheckbox",
  extends: FdFormItemRadio
};

/* script */
var __vue_script__$V = script$V;
/* template */

/* style */

var __vue_inject_styles__$V = undefined;
/* scoped */

var __vue_scope_id__$V = undefined;
/* module identifier */

var __vue_module_identifier__$V = undefined;
/* functional template */

var __vue_is_functional_template__$V = undefined;
/* style inject */

/* style inject SSR */

var FdFormItemCheckbox = normalizeComponent_1({}, __vue_inject_styles__$V, __vue_script__$V, __vue_scope_id__$V, __vue_is_functional_template__$V, __vue_module_identifier__$V, undefined, undefined);

var script$W = {
  name: "FdFormItemToggle",
  extends: FdFormItemRadio
};

/* script */
var __vue_script__$W = script$W;
/* template */

/* style */

var __vue_inject_styles__$W = undefined;
/* scoped */

var __vue_scope_id__$W = undefined;
/* module identifier */

var __vue_module_identifier__$W = undefined;
/* functional template */

var __vue_is_functional_template__$W = undefined;
/* style inject */

/* style inject SSR */

var FdFormItemToggle = normalizeComponent_1({}, __vue_inject_styles__$W, __vue_script__$W, __vue_scope_id__$W, __vue_is_functional_template__$W, __vue_module_identifier__$W, undefined, undefined);

var Form$1 = pluginify(Form, FdInput, Select, TextArea, Toggle, Checkbox, Radio, FormItem, FormLabel, FormMessage, FormGroup, Legend, FieldSet, FdFormItemRadio, FdFormItemCheckbox, FdFormItemToggle);

//
//
//
//
//
//
//
//
//
var script$X = {
  name: "FdFormLabel",
  props: {
    required: {
      type: Boolean,
      default: false
    }
  }
};

/* script */
var __vue_script__$X = script$X;
/* template */

var __vue_render__$Q = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('label', {
    staticClass: "fd-form__label",
    attrs: {
      "aria-required": String(_vm.required)
    }
  }, [_vm._t("default"), _vm._v(" "), _vm.required ? [_vm._t("required", [_vm._v("*")])] : _vm._e()], 2);
};

var __vue_staticRenderFns__$Q = [];
/* style */

var __vue_inject_styles__$X = undefined;
/* scoped */

var __vue_scope_id__$X = undefined;
/* module identifier */

var __vue_module_identifier__$X = undefined;
/* functional template */

var __vue_is_functional_template__$X = false;
/* style inject */

/* style inject SSR */

var FormLabel$1 = normalizeComponent_1({
  render: __vue_render__$Q,
  staticRenderFns: __vue_staticRenderFns__$Q
}, __vue_inject_styles__$X, __vue_script__$X, __vue_scope_id__$X, __vue_is_functional_template__$X, __vue_module_identifier__$X, undefined, undefined);

var FormLabel$2 = pluginify(FormLabel$1);

//
//
//
//
var IsValidSize = function IsValidSize(value) {
  return ["s", "m", "l", "xl"].indexOf(value) >= 0;
};

var script$Y = {
  name: "FdIcon",
  props: {
    name: {
      type: String,
      required: true
    },
    size: {
      type: String,
      default: null,
      validator: IsValidSize
    }
  },
  computed: {
    classes: function classes() {
      var size = this.size == null ? {} : _defineProperty({}, "sap-icon--".concat(this.size), true);
      return _objectSpread2(_defineProperty({}, "sap-icon--".concat(this.name), true), size);
    }
  }
};

/* script */
var __vue_script__$Y = script$Y;
/* template */

var __vue_render__$R = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('span', {
    class: _vm.classes,
    attrs: {
      "role": "presentation"
    }
  });
};

var __vue_staticRenderFns__$R = [];
/* style */

var __vue_inject_styles__$Y = undefined;
/* scoped */

var __vue_scope_id__$Y = undefined;
/* module identifier */

var __vue_module_identifier__$Y = undefined;
/* functional template */

var __vue_is_functional_template__$Y = false;
/* style inject */

/* style inject SSR */

var Icon = normalizeComponent_1({
  render: __vue_render__$R,
  staticRenderFns: __vue_staticRenderFns__$R
}, __vue_inject_styles__$Y, __vue_script__$Y, __vue_scope_id__$Y, __vue_is_functional_template__$Y, __vue_module_identifier__$Y, undefined, undefined);

var Icon$1 = pluginify(Icon);

var identifierSizes = ["xxs", "xs", "s", "m", "l", "xl", "xxl"];

var identifierSizeValidator = function identifierSizeValidator(size) {
  return identifierSizes.indexOf(size) >= 0;
};

var script$Z = {
  name: "FdIdentifier",
  mixins: [IconMixin],
  props: {
    url: String,
    size: {
      type: String,
      default: "m",
      validator: identifierSizeValidator
    },
    circle: {
      type: Boolean,
      default: false
    },
    transparent: {
      type: Boolean,
      default: false
    },
    thumbnail: {
      type: Boolean,
      default: false
    },
    backgroundColor: String
  },
  computed: {
    role: function role() {
      return this.icon != null ? "presentation" : null;
    },
    classes: function classes() {
      return [].concat(_toConsumableArray(this.iconClasses), _toConsumableArray(backgroundColorClasses(this.backgroundColor)), ["fd-identifier--".concat(this.size)], _toConsumableArray(this.transparent ? ["fd-identifier--transparent"] : []), _toConsumableArray(this.circle ? ["fd-identifier--circle"] : []), _toConsumableArray(this.thumbnail ? ["fd-identifier--thumbnail"] : []));
    },
    style: function style() {
      var url = this.url;

      if (url == null || !this.thumbnail) {
        return {};
      }

      return {
        backgroundImage: "url('".concat(this.url, "')")
      };
    }
  }
};

/* script */
var __vue_script__$Z = script$Z;
/* template */

var __vue_render__$S = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('span', _vm._g({
    class: _vm.classes,
    style: _vm.style,
    attrs: {
      "role": _vm.role
    }
  }, _vm.$listeners), [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$S = [];
/* style */

var __vue_inject_styles__$Z = undefined;
/* scoped */

var __vue_scope_id__$Z = undefined;
/* module identifier */

var __vue_module_identifier__$Z = undefined;
/* functional template */

var __vue_is_functional_template__$Z = false;
/* style inject */

/* style inject SSR */

var FdIdentifier = normalizeComponent_1({
  render: __vue_render__$S,
  staticRenderFns: __vue_staticRenderFns__$S
}, __vue_inject_styles__$Z, __vue_script__$Z, __vue_scope_id__$Z, __vue_is_functional_template__$Z, __vue_module_identifier__$Z, undefined, undefined);

var Identifier = pluginify(FdIdentifier);

//
//
//
//
//
//
var sizeMapping = {
  s: "s",
  m: "m",
  // default
  l: "l"
};
var IdentifierSizes = Object.keys(sizeMapping);
var script$_ = {
  name: "FdImage",
  props: {
    url: {
      type: String,
      default: null
    },
    size: {
      type: String,
      default: sizeMapping.m,
      validator: function validator(value) {
        return IdentifierSizes.indexOf(value) >= 0;
      }
    },
    circle: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    style: function style() {
      var url = this.url;

      if (url == null) {
        return {};
      }

      return {
        backgroundImage: "url(".concat(this.url, ")")
      };
    },
    classes: function classes() {
      var _ref;

      return _ref = {}, _defineProperty(_ref, "fd-image--".concat(this.size), true), _defineProperty(_ref, "fd-image--circle", this.circle), _ref;
    }
  }
};

/* script */
var __vue_script__$_ = script$_;
/* template */

var __vue_render__$T = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('span', {
    class: _vm.classes,
    style: _vm.style
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$T = [];
/* style */

var __vue_inject_styles__$_ = undefined;
/* scoped */

var __vue_scope_id__$_ = undefined;
/* module identifier */

var __vue_module_identifier__$_ = undefined;
/* functional template */

var __vue_is_functional_template__$_ = false;
/* style inject */

/* style inject SSR */

var Image = normalizeComponent_1({
  render: __vue_render__$T,
  staticRenderFns: __vue_staticRenderFns__$T
}, __vue_inject_styles__$_, __vue_script__$_, __vue_scope_id__$_, __vue_is_functional_template__$_, __vue_module_identifier__$_, undefined, undefined);

var Image$1 = pluginify(Image);

//
//
//
//
//
//
var positionMapping = {
  left: "left",
  right: "right",
  // default
  center: "center"
};
var Positions = Object.keys(positionMapping);

var isValidPosition = function isValidPosition(value) {
  return Positions.indexOf(value) >= 0;
};

var script$$ = {
  name: "FdInlineHelp",
  props: {
    position: {
      type: String,
      default: positionMapping.right,
      validator: isValidPosition
    },
    inline: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    classes: function classes() {
      return {
        "fd-inline-help__content": true,
        "fd-inline-help__content--bottom-left": this.position === "left" && this.inline === false,
        "fd-inline-help__content--bottom-right": this.position === "right" && this.inline === false,
        "fd-inline-help__content--bottom-center": this.position === "center" && this.inline === false,
        "fd-inline-help__content--left": this.position === "left" && this.inline === true,
        "fd-inline-help__content--right": this.position === "right" && this.inline === true
      };
    }
  }
};

/* script */
var __vue_script__$$ = script$$;
/* template */

var __vue_render__$U = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('span', {
    staticClass: "fd-inline-help"
  }, [_c('span', {
    class: _vm.classes
  }, [_vm._t("default")], 2)]);
};

var __vue_staticRenderFns__$U = [];
/* style */

var __vue_inject_styles__$$ = undefined;
/* scoped */

var __vue_scope_id__$$ = undefined;
/* module identifier */

var __vue_module_identifier__$$ = undefined;
/* functional template */

var __vue_is_functional_template__$$ = false;
/* style inject */

/* style inject SSR */

var InlineHelp = normalizeComponent_1({
  render: __vue_render__$U,
  staticRenderFns: __vue_staticRenderFns__$U
}, __vue_inject_styles__$$, __vue_script__$$, __vue_scope_id__$$, __vue_is_functional_template__$$, __vue_module_identifier__$$, undefined, undefined);

var InlineHelp$1 = pluginify(InlineHelp);

//
var script$10 = {
  name: "FdInputGroupSearch",
  components: {
    FdInputGroup: FdInputGroup,
    FdInputGroupAddon: FdInputGroupAddon
  }
};

/* script */
var __vue_script__$10 = script$10;
/* template */

var __vue_render__$V = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('fd-input-group', {
    scopedSlots: _vm._u([{
      key: "input",
      fn: function fn() {
        return [_vm._t("input")];
      },
      proxy: true
    }, {
      key: "after-input",
      fn: function fn() {
        return [_c('fd-input-group-addon', [_vm._t("clear")], 2)];
      },
      proxy: true
    }], null, true)
  });
};

var __vue_staticRenderFns__$V = [];
/* style */

var __vue_inject_styles__$10 = undefined;
/* scoped */

var __vue_scope_id__$10 = undefined;
/* module identifier */

var __vue_module_identifier__$10 = undefined;
/* functional template */

var __vue_is_functional_template__$10 = false;
/* style inject */

/* style inject SSR */

var InputGroupSearch = normalizeComponent_1({
  render: __vue_render__$V,
  staticRenderFns: __vue_staticRenderFns__$V
}, __vue_inject_styles__$10, __vue_script__$10, __vue_scope_id__$10, __vue_is_functional_template__$10, __vue_module_identifier__$10, undefined, undefined);

//
//
//
//
//
//
//
//
//
//
//
//
//
//
var script$11 = {
  name: "FdInputGroupClearButton",
  inject: ["$_fdInputGroupAddon"],
  mounted: function mounted() {
    this.$_fdInputGroupAddon.hasButton = true;
  }
};

/* script */
var __vue_script__$11 = script$11;
/* template */

var __vue_render__$W = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('button', _vm._g(_vm._b({
    staticClass: "fd-input-group__button fd-input-group__button--clear",
    staticStyle: {
      "z-index": "2"
    },
    attrs: {
      "aria-label": "Clear"
    }
  }, 'button', _vm.$attrs, false), _vm.$listeners), [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$W = [];
/* style */

var __vue_inject_styles__$11 = undefined;
/* scoped */

var __vue_scope_id__$11 = undefined;
/* module identifier */

var __vue_module_identifier__$11 = undefined;
/* functional template */

var __vue_is_functional_template__$11 = false;
/* style inject */

/* style inject SSR */

var InputGroupClearButton = normalizeComponent_1({
  render: __vue_render__$W,
  staticRenderFns: __vue_staticRenderFns__$W
}, __vue_inject_styles__$11, __vue_script__$11, __vue_scope_id__$11, __vue_is_functional_template__$11, __vue_module_identifier__$11, undefined, undefined);

var InputGroup = pluginify(FdInputGroup, FdInputGroupAddon, FdInputGroupButton, InputGroupClearButton, InputGroupSearch);

//
//
//
//
//
//
var typeMapping$1 = {
  warning: "warning",
  error: "error",
  success: "success"
};
var LabelTypes = Object.keys(typeMapping$1);

var isValidLabelType = function isValidLabelType(value) {
  return LabelTypes.indexOf(value) >= 0;
};

var script$12 = {
  name: "FdLabel",
  props: {
    type: {
      type: String,
      default: null,
      validator: isValidLabelType
    }
  },
  computed: {
    classes: function classes() {
      var type = this.type == null ? {} : _defineProperty({}, "fd-label--".concat(this.type), true);
      return _objectSpread2({
        "fd-label": true
      }, type);
    }
  }
};

/* script */
var __vue_script__$12 = script$12;
/* template */

var __vue_render__$X = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('span', {
    class: _vm.classes
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$X = [];
/* style */

var __vue_inject_styles__$12 = undefined;
/* scoped */

var __vue_scope_id__$12 = undefined;
/* module identifier */

var __vue_module_identifier__$12 = undefined;
/* functional template */

var __vue_is_functional_template__$12 = false;
/* style inject */

/* style inject SSR */

var Label = normalizeComponent_1({
  render: __vue_render__$X,
  staticRenderFns: __vue_staticRenderFns__$X
}, __vue_inject_styles__$12, __vue_script__$12, __vue_scope_id__$12, __vue_is_functional_template__$12, __vue_module_identifier__$12, undefined, undefined);

var Label$1 = pluginify(Label);

//
//
//
//
//
//
//
//
//
var script$13 = {
  name: "FdApp"
};

/* script */
var __vue_script__$13 = script$13;
/* template */

var __vue_render__$Y = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-app"
  }, [_vm._t("navigation"), _vm._v(" "), _vm._t("main")], 2);
};

var __vue_staticRenderFns__$Y = [];
/* style */

var __vue_inject_styles__$13 = undefined;
/* scoped */

var __vue_scope_id__$13 = undefined;
/* module identifier */

var __vue_module_identifier__$13 = undefined;
/* functional template */

var __vue_is_functional_template__$13 = false;
/* style inject */

/* style inject SSR */

var App = normalizeComponent_1({
  render: __vue_render__$Y,
  staticRenderFns: __vue_staticRenderFns__$Y
}, __vue_inject_styles__$13, __vue_script__$13, __vue_scope_id__$13, __vue_is_functional_template__$13, __vue_module_identifier__$13, undefined, undefined);

//
//
//
//
//
//
var script$14 = {
  name: "FdAppMain"
};

/* script */
var __vue_script__$14 = script$14;
/* template */

var __vue_render__$Z = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('main', {
    staticClass: "fd-app__main"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$Z = [];
/* style */

var __vue_inject_styles__$14 = undefined;
/* scoped */

var __vue_scope_id__$14 = undefined;
/* module identifier */

var __vue_module_identifier__$14 = undefined;
/* functional template */

var __vue_is_functional_template__$14 = false;
/* style inject */

/* style inject SSR */

var AppMain = normalizeComponent_1({
  render: __vue_render__$Z,
  staticRenderFns: __vue_staticRenderFns__$Z
}, __vue_inject_styles__$14, __vue_script__$14, __vue_scope_id__$14, __vue_is_functional_template__$14, __vue_module_identifier__$14, undefined, undefined);

//
//
//
//
var orientationMapping = {
  horizontal: "horizontal",
  // default
  vertical: "vertical"
};
var Orientations = Object.keys(orientationMapping);

var isOrientation = function isOrientation(value) {
  return Orientations.indexOf(value) >= 0;
};

var APP_NAV_CLASS = "fd-app__navigation";
var script$15 = {
  name: "FdAppNavigation",
  props: {
    orientation: {
      type: String,
      default: orientationMapping.horizontal,
      validator: isOrientation
    }
  },
  computed: {
    classes: function classes() {
      return [APP_NAV_CLASS, "".concat(APP_NAV_CLASS, "--").concat(this.orientation)];
    }
  }
};

/* script */
var __vue_script__$15 = script$15;
/* template */

var __vue_render__$_ = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    class: _vm.classes
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$_ = [];
/* style */

var __vue_inject_styles__$15 = undefined;
/* scoped */

var __vue_scope_id__$15 = undefined;
/* module identifier */

var __vue_module_identifier__$15 = undefined;
/* functional template */

var __vue_is_functional_template__$15 = false;
/* style inject */

/* style inject SSR */

var AppNavigation = normalizeComponent_1({
  render: __vue_render__$_,
  staticRenderFns: __vue_staticRenderFns__$_
}, __vue_inject_styles__$15, __vue_script__$15, __vue_scope_id__$15, __vue_is_functional_template__$15, __vue_module_identifier__$15, undefined, undefined);

//
//
//
//
//
//
//
//
//
//
//
var script$16 = {
  name: "FdShell"
};

/* script */
var __vue_script__$16 = script$16;
/* template */

var __vue_render__$$ = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-shell fd-shell--fundamentals"
  }, [_vm._t("header"), _vm._v(" "), _vm._t("app"), _vm._v(" "), _vm._t("footer")], 2);
};

var __vue_staticRenderFns__$$ = [];
/* style */

var __vue_inject_styles__$16 = undefined;
/* scoped */

var __vue_scope_id__$16 = undefined;
/* module identifier */

var __vue_module_identifier__$16 = undefined;
/* functional template */

var __vue_is_functional_template__$16 = false;
/* style inject */

/* style inject SSR */

var Shell = normalizeComponent_1({
  render: __vue_render__$$,
  staticRenderFns: __vue_staticRenderFns__$$
}, __vue_inject_styles__$16, __vue_script__$16, __vue_scope_id__$16, __vue_is_functional_template__$16, __vue_module_identifier__$16, undefined, undefined);

//
//
//
//
//
//
var script$17 = {
  name: "FdShellHeader",
  props: {
    fixed: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    classes: function classes() {
      return {
        "fd-shell__header--fixed": this.fixed
      };
    }
  }
};

/* script */
var __vue_script__$17 = script$17;
/* template */

var __vue_render__$10 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-shell__header",
    class: _vm.classes
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$10 = [];
/* style */

var __vue_inject_styles__$17 = undefined;
/* scoped */

var __vue_scope_id__$17 = undefined;
/* module identifier */

var __vue_module_identifier__$17 = undefined;
/* functional template */

var __vue_is_functional_template__$17 = false;
/* style inject */

/* style inject SSR */

var ShellHeader = normalizeComponent_1({
  render: __vue_render__$10,
  staticRenderFns: __vue_staticRenderFns__$10
}, __vue_inject_styles__$17, __vue_script__$17, __vue_scope_id__$17, __vue_is_functional_template__$17, __vue_module_identifier__$17, undefined, undefined);

//
//
//
//
//
//
//
var script$18 = {
  name: "FdShellApp"
};

/* script */
var __vue_script__$18 = script$18;
/* template */

var __vue_render__$11 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-shell__app"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$11 = [];
/* style */

var __vue_inject_styles__$18 = undefined;
/* scoped */

var __vue_scope_id__$18 = undefined;
/* module identifier */

var __vue_module_identifier__$18 = undefined;
/* functional template */

var __vue_is_functional_template__$18 = false;
/* style inject */

/* style inject SSR */

var ShellApp = normalizeComponent_1({
  render: __vue_render__$11,
  staticRenderFns: __vue_staticRenderFns__$11
}, __vue_inject_styles__$18, __vue_script__$18, __vue_scope_id__$18, __vue_is_functional_template__$18, __vue_module_identifier__$18, undefined, undefined);

//
//
//
//
//
//
var script$19 = {
  name: "FdShellFooter",
  props: {
    fixed: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    classes: function classes() {
      return {
        "fd-shell__footer--fixed": this.fixed
      };
    }
  }
};

/* script */
var __vue_script__$19 = script$19;
/* template */

var __vue_render__$12 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-shell__footer",
    class: _vm.classes
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$12 = [];
/* style */

var __vue_inject_styles__$19 = undefined;
/* scoped */

var __vue_scope_id__$19 = undefined;
/* module identifier */

var __vue_module_identifier__$19 = undefined;
/* functional template */

var __vue_is_functional_template__$19 = false;
/* style inject */

/* style inject SSR */

var ShellFooter = normalizeComponent_1({
  render: __vue_render__$12,
  staticRenderFns: __vue_staticRenderFns__$12
}, __vue_inject_styles__$19, __vue_script__$19, __vue_scope_id__$19, __vue_is_functional_template__$19, __vue_module_identifier__$19, undefined, undefined);

//
//
//
//
var script$1a = {
  name: "FdShellBar"
};

/* script */
var __vue_script__$1a = script$1a;
/* template */

var __vue_render__$13 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-shellbar"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$13 = [];
/* style */

var __vue_inject_styles__$1a = undefined;
/* scoped */

var __vue_scope_id__$1a = undefined;
/* module identifier */

var __vue_module_identifier__$1a = undefined;
/* functional template */

var __vue_is_functional_template__$1a = false;
/* style inject */

/* style inject SSR */

var ShellBar = normalizeComponent_1({
  render: __vue_render__$13,
  staticRenderFns: __vue_staticRenderFns__$13
}, __vue_inject_styles__$1a, __vue_script__$1a, __vue_scope_id__$1a, __vue_is_functional_template__$1a, __vue_module_identifier__$1a, undefined, undefined);

//
//
//
//
//
//
var positionMapping$1 = {
  start: "start",
  middle: "middle",
  end: "end"
};
var Positions$1 = Object.keys(positionMapping$1);

var isPosition = function isPosition(value) {
  return Positions$1.indexOf(value) >= 0;
};

var script$1b = {
  name: "FdShellBarGroup",
  props: {
    position: {
      type: String,
      validator: isPosition
    }
  },
  computed: {
    classes: function classes() {
      return ["fd-shellbar__group fd-shellbar__group--".concat(this.position)];
    }
  }
};

/* script */
var __vue_script__$1b = script$1b;
/* template */

var __vue_render__$14 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    class: _vm.classes
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$14 = [];
/* style */

var __vue_inject_styles__$1b = undefined;
/* scoped */

var __vue_scope_id__$1b = undefined;
/* module identifier */

var __vue_module_identifier__$1b = undefined;
/* functional template */

var __vue_is_functional_template__$1b = false;
/* style inject */

/* style inject SSR */

var ShellBarGroup = normalizeComponent_1({
  render: __vue_render__$14,
  staticRenderFns: __vue_staticRenderFns__$14
}, __vue_inject_styles__$1b, __vue_script__$1b, __vue_scope_id__$1b, __vue_is_functional_template__$1b, __vue_module_identifier__$1b, undefined, undefined);

//
var script$1c = {
  name: "FdShellBarLogo",
  mixins: [withTargetLocation("/")],
  inheritAttrs: false,
  props: {
    src: String,
    srcset: String
  }
};

/* script */
var __vue_script__$1c = script$1c;
/* template */

var __vue_render__$15 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('a', _vm._g({
    staticClass: "fd-shellbar__logo",
    attrs: {
      "href": "#"
    },
    on: {
      "click": function click($event) {
        $event.preventDefault();
        return _vm.pushLocationIfPossible($event);
      }
    }
  }, _vm.$listeners), [_vm._t("default", [_c('img', _vm._b({
    attrs: {
      "src": _vm.src,
      "srcset": _vm.srcset
    }
  }, 'img', _vm.$attrs, false))])], 2);
};

var __vue_staticRenderFns__$15 = [];
/* style */

var __vue_inject_styles__$1c = undefined;
/* scoped */

var __vue_scope_id__$1c = undefined;
/* module identifier */

var __vue_module_identifier__$1c = undefined;
/* functional template */

var __vue_is_functional_template__$1c = false;
/* style inject */

/* style inject SSR */

var ShellBarLogo = normalizeComponent_1({
  render: __vue_render__$15,
  staticRenderFns: __vue_staticRenderFns__$15
}, __vue_inject_styles__$1c, __vue_script__$1c, __vue_scope_id__$1c, __vue_is_functional_template__$1c, __vue_module_identifier__$1c, undefined, undefined);

//
//
//
//
//
//
var script$1d = {
  name: "FdShellBarSubtitle"
};

/* script */
var __vue_script__$1d = script$1d;
/* template */

var __vue_render__$16 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('span', {
    staticClass: "fd-shellbar__subtitle"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$16 = [];
/* style */

var __vue_inject_styles__$1d = undefined;
/* scoped */

var __vue_scope_id__$1d = undefined;
/* module identifier */

var __vue_module_identifier__$1d = undefined;
/* functional template */

var __vue_is_functional_template__$1d = false;
/* style inject */

/* style inject SSR */

var ShellBarSubtitle = normalizeComponent_1({
  render: __vue_render__$16,
  staticRenderFns: __vue_staticRenderFns__$16
}, __vue_inject_styles__$1d, __vue_script__$1d, __vue_scope_id__$1d, __vue_is_functional_template__$1d, __vue_module_identifier__$1d, undefined, undefined);

//
//
//
//
//
//
var script$1e = {
  name: "FdShellBarProductTitle"
};

/* script */
var __vue_script__$1e = script$1e;
/* template */

var __vue_render__$17 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('span', {
    staticClass: "fd-shellbar__title"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$17 = [];
/* style */

var __vue_inject_styles__$1e = undefined;
/* scoped */

var __vue_scope_id__$1e = undefined;
/* module identifier */

var __vue_module_identifier__$1e = undefined;
/* functional template */

var __vue_is_functional_template__$1e = false;
/* style inject */

/* style inject SSR */

var FdShellBarProductTitle = normalizeComponent_1({
  render: __vue_render__$17,
  staticRenderFns: __vue_staticRenderFns__$17
}, __vue_inject_styles__$1e, __vue_script__$1e, __vue_scope_id__$1e, __vue_is_functional_template__$1e, __vue_module_identifier__$1e, undefined, undefined);

//
var script$1f = {
  name: "FdShellBarProduct",
  components: {
    FdShellBarProductTitle: FdShellBarProductTitle
  },
  props: {
    productTitle: {
      type: String,
      default: null
    }
  }
};

/* script */
var __vue_script__$1f = script$1f;
/* template */

var __vue_render__$18 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-shellbar__product"
  }, [_vm.productTitle != null ? _c('FdShellBarProductTitle', [_vm._v(_vm._s(_vm.productTitle))]) : _vm._e(), _vm._v(" "), _vm._t("default")], 2);
};

var __vue_staticRenderFns__$18 = [];
/* style */

var __vue_inject_styles__$1f = undefined;
/* scoped */

var __vue_scope_id__$1f = undefined;
/* module identifier */

var __vue_module_identifier__$1f = undefined;
/* functional template */

var __vue_is_functional_template__$1f = false;
/* style inject */

/* style inject SSR */

var ShellBarProduct = normalizeComponent_1({
  render: __vue_render__$18,
  staticRenderFns: __vue_staticRenderFns__$18
}, __vue_inject_styles__$1f, __vue_script__$1f, __vue_scope_id__$1f, __vue_is_functional_template__$1f, __vue_module_identifier__$1f, undefined, undefined);

//
var script$1g = {
  name: "FdShellBarProductMenu",
  components: {
    FdMenuPopover: MenuPopover,
    FdShellBarProductTitle: FdShellBarProductTitle
  }
};

/* script */
var __vue_script__$1g = script$1g;
/* template */

var __vue_render__$19 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-product-menu"
  }, [_c('fd-menu-popover', {
    attrs: {
      "flips": false,
      "body-styles": {
        overflowY: 'auto',
        maxHeight: 'calc(100vh - 65px)'
      },
      "discard-highlight": "",
      "offset": 10,
      "body-size-mode": "at-least-trigger",
      "placement": "bottom-start"
    },
    scopedSlots: _vm._u([{
      key: "control",
      fn: function fn(ref) {
        var toggle = ref.toggle;
        return [_c('button', {
          staticClass: "fd-product-menu__control",
          on: {
            "click": toggle
          }
        }, [_c('fd-shell-bar-product-title', {
          staticClass: "fd-product-menu__title"
        }, [_vm._t("title")], 2)], 1)];
      }
    }, {
      key: "default",
      fn: function fn(bodyProps) {
        return [_vm._t("default", null, null, bodyProps)];
      }
    }], null, true)
  })], 1);
};

var __vue_staticRenderFns__$19 = [];
/* style */

var __vue_inject_styles__$1g = undefined;
/* scoped */

var __vue_scope_id__$1g = undefined;
/* module identifier */

var __vue_module_identifier__$1g = undefined;
/* functional template */

var __vue_is_functional_template__$1g = false;
/* style inject */

/* style inject SSR */

var ShellBarProductMenu = normalizeComponent_1({
  render: __vue_render__$19,
  staticRenderFns: __vue_staticRenderFns__$19
}, __vue_inject_styles__$1g, __vue_script__$1g, __vue_scope_id__$1g, __vue_is_functional_template__$1g, __vue_module_identifier__$1g, undefined, undefined);

//
//
//
//
var script$1h = {
  name: "FdShellBarActions"
};

/* script */
var __vue_script__$1h = script$1h;
/* template */

var __vue_render__$1a = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-shellbar__actions"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1a = [];
/* style */

var __vue_inject_styles__$1h = undefined;
/* scoped */

var __vue_scope_id__$1h = undefined;
/* module identifier */

var __vue_module_identifier__$1h = undefined;
/* functional template */

var __vue_is_functional_template__$1h = false;
/* style inject */

/* style inject SSR */

var ShellBarActions = normalizeComponent_1({
  render: __vue_render__$1a,
  staticRenderFns: __vue_staticRenderFns__$1a
}, __vue_inject_styles__$1h, __vue_script__$1h, __vue_scope_id__$1h, __vue_is_functional_template__$1h, __vue_module_identifier__$1h, undefined, undefined);

//
//
//
//
var script$1i = {
  name: "FdShellBarAction",
  props: {
    showAlways: {
      type: Boolean,
      default: true
    },
    collapsible: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    classes: function classes() {
      return {
        "fd-shellbar__action": true,
        "fd-shellbar__action--show-always": this.showAlways,
        "fd-shellbar__action--collapsible": this.collapsible
      };
    }
  }
};

/* script */
var __vue_script__$1i = script$1i;
/* template */

var __vue_render__$1b = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    class: _vm.classes
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1b = [];
/* style */

var __vue_inject_styles__$1i = undefined;
/* scoped */

var __vue_scope_id__$1i = undefined;
/* module identifier */

var __vue_module_identifier__$1i = undefined;
/* functional template */

var __vue_is_functional_template__$1i = false;
/* style inject */

/* style inject SSR */

var ShellBarAction = normalizeComponent_1({
  render: __vue_render__$1b,
  staticRenderFns: __vue_staticRenderFns__$1b
}, __vue_inject_styles__$1i, __vue_script__$1i, __vue_scope_id__$1i, __vue_is_functional_template__$1i, __vue_module_identifier__$1i, undefined, undefined);

//
var script$1j = {
  name: "FdShellBarUserMenuControl",
  components: {
    FdIdentifier: FdIdentifier
  }
};

/* script */
var __vue_script__$1j = script$1j;
/* template */

var __vue_render__$1c = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', _vm._g({
    staticClass: "fd-user-menu__control",
    attrs: {
      "role": "button"
    }
  }, _vm.$listeners), [_vm._t("default", [_c('fd-identifier', {
    attrs: {
      "size": "s",
      "backgroundColor": "accent-6",
      "circle": "",
      "icon": "person-placeholder"
    }
  })])], 2);
};

var __vue_staticRenderFns__$1c = [];
/* style */

var __vue_inject_styles__$1j = undefined;
/* scoped */

var __vue_scope_id__$1j = undefined;
/* module identifier */

var __vue_module_identifier__$1j = undefined;
/* functional template */

var __vue_is_functional_template__$1j = false;
/* style inject */

/* style inject SSR */

var FdShellBarUserMenuControl = normalizeComponent_1({
  render: __vue_render__$1c,
  staticRenderFns: __vue_staticRenderFns__$1c
}, __vue_inject_styles__$1j, __vue_script__$1j, __vue_scope_id__$1j, __vue_is_functional_template__$1j, __vue_module_identifier__$1j, undefined, undefined);

//
var script$1k = {
  name: "FdShellBarUserMenu",
  components: {
    FdShellBarUserMenuControl: FdShellBarUserMenuControl,
    FdPopover: FdPopover
  },
  methods: {
    close: function close() {
      this.popover().hide();
    },
    popover: function popover() {
      return this.$refs.popover;
    }
  }
};

/* script */
var __vue_script__$1k = script$1k;
/* template */

var __vue_render__$1d = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-user-menu"
  }, [_c('FdPopover', {
    ref: "popover",
    attrs: {
      "with-arrow": "",
      "placement": "bottom-end"
    },
    scopedSlots: _vm._u([{
      key: "control",
      fn: function fn(ref) {
        var toggle = ref.toggle;
        return [_vm._t("control", [_c('fd-shell-bar-user-menu-control', {
          on: {
            "click": toggle
          }
        })], {
          "toggle": toggle
        })];
      }
    }, {
      key: "default",
      fn: function fn() {
        return [_vm._t("default")];
      },
      proxy: true
    }], null, true)
  })], 1);
};

var __vue_staticRenderFns__$1d = [];
/* style */

var __vue_inject_styles__$1k = undefined;
/* scoped */

var __vue_scope_id__$1k = undefined;
/* module identifier */

var __vue_module_identifier__$1k = undefined;
/* functional template */

var __vue_is_functional_template__$1k = false;
/* style inject */

/* style inject SSR */

var ShellBarUserMenu = normalizeComponent_1({
  render: __vue_render__$1d,
  staticRenderFns: __vue_staticRenderFns__$1d
}, __vue_inject_styles__$1k, __vue_script__$1k, __vue_scope_id__$1k, __vue_is_functional_template__$1k, __vue_module_identifier__$1k, undefined, undefined);

var sizeFrom = function sizeFrom(_ref) {
  var s = _ref.s,
      m = _ref.m,
      l = _ref.l,
      xl = _ref.xl;

  if (s != null) {
    return "s";
  }

  if (m != null) {
    return "m";
  }

  if (l != null) {
    return "l";
  }

  if (xl != null) {
    return "xl";
  }
};

var icon = (function (_ref2, _ref3) {
  var classList = _ref2.classList;
  var value = _ref3.value,
      arg = _ref3.arg,
      modifiers = _ref3.modifiers;
  var classes = iconClasses(arg || value, sizeFrom(modifiers));
  classes.forEach(function (iconClass) {
    if (!classList.contains(iconClass)) {
      classList.add(iconClass);
    }
  });
});

//
var script$1l = {
  name: "FdShellBarActionButton",
  mixins: [IconMixin],
  directives: {
    "fd-icon": icon
  }
};

/* script */
var __vue_script__$1l = script$1l;
/* template */

var __vue_render__$1e = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('button', _vm._g({
    directives: [{
      name: "fd-icon",
      rawName: "v-fd-icon",
      value: _vm.icon,
      expression: "icon"
    }],
    staticClass: "fd-button--shell"
  }, _vm.$listeners), [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1e = [];
/* style */

var __vue_inject_styles__$1l = undefined;
/* scoped */

var __vue_scope_id__$1l = undefined;
/* module identifier */

var __vue_module_identifier__$1l = undefined;
/* functional template */

var __vue_is_functional_template__$1l = false;
/* style inject */

/* style inject SSR */

var FdShellBarActionButton = normalizeComponent_1({
  render: __vue_render__$1e,
  staticRenderFns: __vue_staticRenderFns__$1e
}, __vue_inject_styles__$1l, __vue_script__$1l, __vue_scope_id__$1l, __vue_is_functional_template__$1l, __vue_module_identifier__$1l, undefined, undefined);

//
var script$1m = {
  name: "FdShellBarProductSwitcher",
  components: {
    FdShellBarActionButton: FdShellBarActionButton,
    FdPopover: FdPopover
  }
};

/* script */
var __vue_script__$1m = script$1m;
/* template */

var __vue_render__$1f = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-product-switcher"
  }, [_c('FdPopover', {
    attrs: {
      "withArrow": "",
      "placement": "bottom-end"
    },
    scopedSlots: _vm._u([{
      key: "control",
      fn: function fn(ref) {
        var toggle = ref.toggle;
        return [_vm._t("control", [_c('FdShellBarActionButton', {
          attrs: {
            "icon": "grid"
          },
          on: {
            "click": toggle
          }
        })])];
      }
    }, {
      key: "default",
      fn: function fn() {
        return [_c('div', {
          staticClass: "fd-product-switcher__body"
        }, [_c('nav', [_c('ul', [_vm._t("default")], 2)])])];
      },
      proxy: true
    }], null, true)
  })], 1);
};

var __vue_staticRenderFns__$1f = [];
/* style */

var __vue_inject_styles__$1m = undefined;
/* scoped */

var __vue_scope_id__$1m = undefined;
/* module identifier */

var __vue_module_identifier__$1m = undefined;
/* functional template */

var __vue_is_functional_template__$1m = false;
/* style inject */

/* style inject SSR */

var ShellBarProductSwitcher = normalizeComponent_1({
  render: __vue_render__$1f,
  staticRenderFns: __vue_staticRenderFns__$1f
}, __vue_inject_styles__$1m, __vue_script__$1m, __vue_scope_id__$1m, __vue_is_functional_template__$1m, __vue_module_identifier__$1m, undefined, undefined);

//
//
//
//
//
//
//
//
var script$1n = {
  name: "FdShellBarProductSwitcherItemImg",
  inheritAttrs: false,
  props: {
    src: String
  }
};

/* script */
var __vue_script__$1n = script$1n;
/* template */

var __vue_render__$1g = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('span', _vm._g({
    staticClass: "fd-product-switcher__product-icon"
  }, _vm.$listeners), [_vm._t("default", [_c('img', _vm._b({
    attrs: {
      "src": _vm.src
    }
  }, 'img', _vm.$attrs, false))])], 2);
};

var __vue_staticRenderFns__$1g = [];
/* style */

var __vue_inject_styles__$1n = undefined;
/* scoped */

var __vue_scope_id__$1n = undefined;
/* module identifier */

var __vue_module_identifier__$1n = undefined;
/* functional template */

var __vue_is_functional_template__$1n = false;
/* style inject */

/* style inject SSR */

var ShellBarProductSwitcherItemImg = normalizeComponent_1({
  render: __vue_render__$1g,
  staticRenderFns: __vue_staticRenderFns__$1g
}, __vue_inject_styles__$1n, __vue_script__$1n, __vue_scope_id__$1n, __vue_is_functional_template__$1n, __vue_module_identifier__$1n, undefined, undefined);

//
//
//
//
//
//
var script$1o = {
  name: "FdShellBarProductSwitcherItemTitle"
};

/* script */
var __vue_script__$1o = script$1o;
/* template */

var __vue_render__$1h = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('span', {
    staticClass: "fd-product-switcher__product-title"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1h = [];
/* style */

var __vue_inject_styles__$1o = undefined;
/* scoped */

var __vue_scope_id__$1o = undefined;
/* module identifier */

var __vue_module_identifier__$1o = undefined;
/* functional template */

var __vue_is_functional_template__$1o = false;
/* style inject */

/* style inject SSR */

var ShellBarProductSwitcherItemTitle = normalizeComponent_1({
  render: __vue_render__$1h,
  staticRenderFns: __vue_staticRenderFns__$1h
}, __vue_inject_styles__$1o, __vue_script__$1o, __vue_scope_id__$1o, __vue_is_functional_template__$1o, __vue_module_identifier__$1o, undefined, undefined);

//
var script$1p = {
  name: "FdShellBarProductSwitcherItem",
  mixins: [withTargetLocation()],
  components: {
    ShellBarProductSwitcherItemImg: ShellBarProductSwitcherItemImg,
    ShellBarProductSwitcherItemTitle: ShellBarProductSwitcherItemTitle
  },
  props: {
    src: {
      type: String,
      default: ""
    },
    title: {
      type: String,
      default: ""
    },
    href: {
      type: String,
      required: false,
      default: "#"
    }
  },
  computed: {
    hrefForLink: function hrefForLink() {
      return this.href || "#";
    }
  },
  methods: {
    onClick: function onClick(event) {
      if (this.to != null) {
        this.pushLocation(event);
        return;
      }

      this.$emit("click", this);
    }
  }
};

/* script */
var __vue_script__$1p = script$1p;
/* template */

var __vue_render__$1i = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('li', [_vm._t("default", [_c('a', {
    attrs: {
      "href": _vm.hrefForLink
    },
    on: {
      "click": function click($event) {
        $event.preventDefault();
        return _vm.onClick($event);
      }
    }
  }, [_c('ShellBarProductSwitcherItemImg', {
    attrs: {
      "src": _vm.src
    }
  }), _vm._v(" "), _c('ShellBarProductSwitcherItemTitle', [_vm._v(_vm._s(_vm.title))])], 1)])], 2);
};

var __vue_staticRenderFns__$1i = [];
/* style */

var __vue_inject_styles__$1p = undefined;
/* scoped */

var __vue_scope_id__$1p = undefined;
/* module identifier */

var __vue_module_identifier__$1p = undefined;
/* functional template */

var __vue_is_functional_template__$1p = false;
/* style inject */

/* style inject SSR */

var ShellBarProductSwitcherItem = normalizeComponent_1({
  render: __vue_render__$1i,
  staticRenderFns: __vue_staticRenderFns__$1i
}, __vue_inject_styles__$1p, __vue_script__$1p, __vue_scope_id__$1p, __vue_is_functional_template__$1p, __vue_module_identifier__$1p, undefined, undefined);



var ShellBar$1 = /*#__PURE__*/Object.freeze({
  ShellBar: ShellBar,
  ShellBarGroup: ShellBarGroup,
  ShellBarLogo: ShellBarLogo,
  ShellBarSubtitle: ShellBarSubtitle,
  ShellBarProduct: ShellBarProduct,
  ShellBarProductTitle: FdShellBarProductTitle,
  ShellBarProductMenu: ShellBarProductMenu,
  ShellBarActions: ShellBarActions,
  ShellBarAction: ShellBarAction,
  ShellBarUserMenu: ShellBarUserMenu,
  ShellBarUserMenuControl: FdShellBarUserMenuControl,
  ShellBarProductSwitcher: ShellBarProductSwitcher,
  ShellBarProductSwitcherItem: ShellBarProductSwitcherItem,
  ShellBarProductSwitcherItemImg: ShellBarProductSwitcherItemImg,
  ShellBarProductSwitcherItemTitle: ShellBarProductSwitcherItemTitle,
  ShellBarActionButton: FdShellBarActionButton
});

var Layout = pluginify.apply(void 0, [App, AppMain, AppNavigation, Shell, ShellHeader, ShellFooter, ShellApp].concat(_toConsumableArray(objectValues(ShellBar$1))));

//
//
//
//
//
//
var script$1q = {
  name: "FdLink",
  props: {
    title: String,
    selected: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    }
  },
  methods: {
    click: function click(event) {
      if (event.defaultPrevented) {
        return;
      }

      event.preventDefault();

      if (this.disabled) {
        event.stopPropagation();
        return;
      }

      this.$emit("click", event);
    }
  },
  computed: {
    classes: function classes() {
      return {
        "fd-link": true,
        "is-selected": this.selected,
        "is-disabled": this.disabled
      };
    }
  }
};

/* script */
var __vue_script__$1q = script$1q;
/* template */

var __vue_render__$1j = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('a', _vm._g({
    class: _vm.classes,
    attrs: {
      "href": "#",
      "title": _vm.title
    },
    nativeOn: {
      "click": function click($event) {
        return _vm.click($event);
      }
    }
  }, _vm.$listeners), [_vm._t("default", [_vm._v(_vm._s(_vm.title))])], 2);
};

var __vue_staticRenderFns__$1j = [];
/* style */

var __vue_inject_styles__$1q = undefined;
/* scoped */

var __vue_scope_id__$1q = undefined;
/* module identifier */

var __vue_module_identifier__$1q = undefined;
/* functional template */

var __vue_is_functional_template__$1q = false;
/* style inject */

/* style inject SSR */

var Link = normalizeComponent_1({
  render: __vue_render__$1j,
  staticRenderFns: __vue_staticRenderFns__$1j
}, __vue_inject_styles__$1q, __vue_script__$1q, __vue_scope_id__$1q, __vue_is_functional_template__$1q, __vue_module_identifier__$1q, undefined, undefined);

var Link$1 = pluginify(Link);

//
//
//
//
//
//
var script$1r = {
  name: "FdListGroup"
};

/* script */
var __vue_script__$1r = script$1r;
/* template */

var __vue_render__$1k = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('ul', {
    staticClass: "fd-list-group"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1k = [];
/* style */

var __vue_inject_styles__$1r = undefined;
/* scoped */

var __vue_scope_id__$1r = undefined;
/* module identifier */

var __vue_module_identifier__$1r = undefined;
/* functional template */

var __vue_is_functional_template__$1r = false;
/* style inject */

/* style inject SSR */

var ListGroup = normalizeComponent_1({
  render: __vue_render__$1k,
  staticRenderFns: __vue_staticRenderFns__$1k
}, __vue_inject_styles__$1r, __vue_script__$1r, __vue_scope_id__$1r, __vue_is_functional_template__$1r, __vue_module_identifier__$1r, undefined, undefined);

//
//
//
//
//
//
//
//
//
var script$1s = {
  name: "FdListGroupItem",
  computed: {
    hasAction: function hasAction() {
      return this.$slots.action != null;
    }
  }
};

/* script */
var __vue_script__$1s = script$1s;
/* template */

var __vue_render__$1l = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('li', {
    staticClass: "fd-list-group__item"
  }, [_vm._t("default"), _vm._v(" "), _vm.hasAction ? _c('span', {
    staticClass: "fd-list-group__action"
  }, [_vm._t("action")], 2) : _vm._e()], 2);
};

var __vue_staticRenderFns__$1l = [];
/* style */

var __vue_inject_styles__$1s = undefined;
/* scoped */

var __vue_scope_id__$1s = undefined;
/* module identifier */

var __vue_module_identifier__$1s = undefined;
/* functional template */

var __vue_is_functional_template__$1s = false;
/* style inject */

/* style inject SSR */

var ListGroupItem = normalizeComponent_1({
  render: __vue_render__$1l,
  staticRenderFns: __vue_staticRenderFns__$1l
}, __vue_inject_styles__$1s, __vue_script__$1s, __vue_scope_id__$1s, __vue_is_functional_template__$1s, __vue_module_identifier__$1s, undefined, undefined);

var ListGroup$1 = pluginify(ListGroup, ListGroupItem);

//
//
//
//
//
//
//
//
//
//
//
//
var script$1t = {
  name: "FdMenuLink",
  inject: ["menuItem", "menuHighlight"],
  props: {
    selected: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    }
  },
  methods: {
    click: function click(event) {
      if (this.disabled) {
        event.preventDefault();
        return;
      }

      this.$emit("click", event);
    }
  },
  computed: {
    menuItemId: function menuItemId() {
      return this.menuItem.uid;
    },
    highlighted_: function highlighted_() {
      if (this.menuHighlight.highlightedId === this.menuItemId) {
        return true;
      }

      return this.selected;
    },
    listeners: function listeners() {
      var _this$$listeners = this.$listeners,
          click = _this$$listeners.click,
          others = _objectWithoutProperties(_this$$listeners, ["click"]); // eslint-disable-line no-unused-vars


      return others;
    },
    classes: function classes() {
      return {
        "is-selected": this.highlighted_,
        "is-disabled": this.disabled,
        "fd-has-color-text-4": this.disabled
      };
    }
  }
};

/* script */
var __vue_script__$1t = script$1t;
/* template */

var __vue_render__$1m = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('a', _vm._g({
    staticClass: "fd-menu__item",
    class: _vm.classes,
    attrs: {
      "data-fd-menu-item-link-uid": _vm.menuItemId
    },
    on: {
      "click": _vm.click
    }
  }, _vm.listeners), [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1m = [];
/* style */

var __vue_inject_styles__$1t = undefined;
/* scoped */

var __vue_scope_id__$1t = undefined;
/* module identifier */

var __vue_module_identifier__$1t = undefined;
/* functional template */

var __vue_is_functional_template__$1t = false;
/* style inject */

/* style inject SSR */

var FdMenuLink = normalizeComponent_1({
  render: __vue_render__$1m,
  staticRenderFns: __vue_staticRenderFns__$1m
}, __vue_inject_styles__$1t, __vue_script__$1t, __vue_scope_id__$1t, __vue_is_functional_template__$1t, __vue_module_identifier__$1t, undefined, undefined);

var FdSmartMenuInterior = {
  functional: true,
  components: {
    FdMenuLink: FdMenuLink
  },
  render: function render(h, context) {
    var children = context.children,
        data = context.data,
        scopedSlots = context.scopedSlots;

    var _children = _slicedToArray(children, 1),
        onlyChild = _children[0];

    if (children.length === 1 && onlyChild.tag == null) {
      return h(FdMenuLink, data, children);
    }

    return scopedSlots.default();
  }
};
var script$1u = {
  name: "FdMenuItem",
  mixins: [Uid],
  components: {
    FdSmartMenuInterior: FdSmartMenuInterior
  },
  provide: function provide() {
    return {
      menuItem: this
    };
  },
  inject: ["menu", "menuList"],
  created: function created() {
    var menu = this.menu;
    menu.registerMenuItem(this);
  },
  beforeDestroy: function beforeDestroy() {
    var menu = this.menu;
    menu.unregisterMenuItem(this);
  },
  props: {
    selected: {
      type: Boolean,
      default: false
    },
    value: {
      default: null,
      type: [String, Number]
    }
  },
  computed: {
    canHaveAddon: function canHaveAddon() {
      return this.menuList.canHaveAddon;
    }
  },
  methods: {
    onClick: function onClick(event) {
      this.menuList.menuItemDidClick(this, event);
      this.$emit("click", this.value, event);
    }
  }
};

/* script */
var __vue_script__$1u = script$1u;
/* template */

var __vue_render__$1n = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('li', {
    on: {
      "mousedown": function mousedown($event) {
        $event.preventDefault();
      },
      "click": _vm.onClick
    }
  }, [_vm.canHaveAddon ? _c('div', {
    staticClass: "fd-menu__addon-before"
  }, [_vm._t("addon")], 2) : _vm._e(), _vm._v(" "), _c('FdSmartMenuInterior', [_vm._t("default")], 2)], 1);
};

var __vue_staticRenderFns__$1n = [];
/* style */

var __vue_inject_styles__$1u = undefined;
/* scoped */

var __vue_scope_id__$1u = undefined;
/* module identifier */

var __vue_module_identifier__$1u = undefined;
/* functional template */

var __vue_is_functional_template__$1u = false;
/* style inject */

/* style inject SSR */

var FdMenuItem = normalizeComponent_1({
  render: __vue_render__$1n,
  staticRenderFns: __vue_staticRenderFns__$1n
}, __vue_inject_styles__$1u, __vue_script__$1u, __vue_scope_id__$1u, __vue_is_functional_template__$1u, __vue_module_identifier__$1u, undefined, undefined);

var Menu = pluginify(FdMenu, FdMenuLink, FdMenuList, FdMenuItem);

pluginify(MenuPopover);

//
//
//
//
//
//
//
//
// This component is used to render the translucent modal background that covers the whole screen.
var script$1v = {
  name: "FdModalOverlay",
  props: {
    // True if the overlay is visible – otherwise false.
    visible: {
      type: Boolean,
      default: false
    }
  }
};

/* script */
var __vue_script__$1v = script$1v;
/* template */

var __vue_render__$1o = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('transition', {
    attrs: {
      "name": "fdv-overlay"
    },
    on: {
      "after-enter": function afterEnter($event) {
        return _vm.$emit('after-enter');
      }
    }
  }, [_c('div', {
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.visible,
      expression: "visible"
    }],
    staticClass: "fd-ui__overlay fd-overlay fd-overlay--modal"
  }, [_vm._t("default")], 2)]);
};

var __vue_staticRenderFns__$1o = [];
/* style */

var __vue_inject_styles__$1v = undefined;
/* scoped */

var __vue_scope_id__$1v = undefined;
/* module identifier */

var __vue_module_identifier__$1v = undefined;
/* functional template */

var __vue_is_functional_template__$1v = false;
/* style inject */

/* style inject SSR */

var ModalOverlay = normalizeComponent_1({
  render: __vue_render__$1o,
  staticRenderFns: __vue_staticRenderFns__$1o
}, __vue_inject_styles__$1v, __vue_script__$1v, __vue_scope_id__$1v, __vue_is_functional_template__$1v, __vue_module_identifier__$1v, undefined, undefined);

//
var script$1w = {
  name: "FdModal",
  mixins: [FocusTrap],
  inheritAttrs: false,
  components: {
    FdModalOverlay: ModalOverlay,
    FdButton: Button$1,
    FdPortal: Portal
  },
  props: {
    handleEscManually: {
      type: Boolean,
      default: false
    },
    modalStyle: {
      default: null
    },
    title: {
      type: String,
      default: null
    },
    name: {
      type: String,
      default: function _default() {
        return "fd-modal-".concat(shortUuid());
      }
    }
  },
  computed: {
    portalSelector: function portalSelector() {
      return "[data-fd-vue-modal-portal=\"".concat(this.name, "\"]");
    },
    modalTabIndex: function modalTabIndex() {
      return this.visible ? -1 : 0;
    }
  },
  data: function data() {
    return {
      visible: false,
      overlayVisible: false
    };
  },
  methods: {
    handleEsc: function handleEsc() {
      if (this.handleEscManually) {
        this.$emit("esc");
        return;
      }

      this.close();
    },
    modalEl: function modalEl() {
      return this.$refs.modalEl;
    },
    $_open: function $_open() {
      this.overlayVisible = true;
    },
    $_close: function $_close() {
      this.visible = false;
    },
    // Used by the App developer.
    open: function open() {
      this.$fdModal.open(this);
    },
    close: function close() {
      this.$emit("close");
      this.$fdModal.close(this);
    }
  },
  created: function created() {
    this.$fdModal.registerModalVM(this);
  },
  beforeDestroy: function beforeDestroy() {
    this.$fdModal.unregisterModalVM(this);
  }
};

/* script */
var __vue_script__$1w = script$1w;
/* template */

var __vue_render__$1p = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('fd-portal', {
    attrs: {
      "selector": _vm.portalSelector
    }
  }, [_c('fd-modal-overlay', {
    attrs: {
      "visible": _vm.overlayVisible
    },
    on: {
      "after-enter": function afterEnter($event) {
        _vm.visible = _vm.overlayVisible;
      }
    }
  }, [_c('transition', {
    attrs: {
      "name": "fdv-modal"
    },
    on: {
      "after-leave": function afterLeave($event) {
        _vm.overlayVisible = _vm.visible;
      }
    }
  }, [_c('div', _vm._b({
    directives: [{
      name: "show",
      rawName: "v-show",
      value: _vm.visible,
      expression: "visible"
    }],
    key: _vm.name,
    ref: "modalEl",
    staticClass: "fd-modal",
    style: _vm.modalStyle,
    attrs: {
      "data-fd-modal-identifier": _vm.name,
      "aria-hidden": String(!_vm.visible),
      "tabindex": _vm.modalTabIndex
    },
    on: {
      "keydown": function keydown($event) {
        if (!$event.type.indexOf('key') && _vm._k($event.keyCode, "esc", 27, $event.key, ["Esc", "Escape"])) {
          return null;
        }

        return _vm.handleEsc($event);
      }
    }
  }, 'div', _vm.$attrs, false), [_c('div', {
    staticClass: "fd-modal__content",
    attrs: {
      "role": "document"
    }
  }, [_c('div', {
    staticClass: "fd-modal__header"
  }, [_vm._t("title", [_c('h3', {
    staticClass: "fd-modal__title"
  }, [_vm._v("\n                " + _vm._s(_vm.title) + "\n              ")])], null, this), _vm._v(" "), _vm._t("close", [_c('FdButton', {
    staticClass: "fd-modal__close",
    attrs: {
      "styling": "light",
      "aria-label": "close"
    },
    on: {
      "click": _vm.close
    }
  })], null, this)], 2), _vm._v(" "), _c('div', {
    staticClass: "fd-modal__body"
  }, [_vm._t("default", null, null, this)], 2), _vm._v(" "), _vm.$scopedSlots.footer != null || _vm.$scopedSlots.actions != null ? _c('footer', {
    staticClass: "fd-modal__footer"
  }, [_vm._t("footer", null, null, this), _vm._v(" "), _vm.$scopedSlots.actions != null ? _c('div', {
    staticClass: "fd-modal__actions"
  }, [_vm._t("actions", null, null, this)], 2) : _vm._e()], 2) : _vm._e()])])])], 1)], 1);
};

var __vue_staticRenderFns__$1p = [];
/* style */

var __vue_inject_styles__$1w = undefined;
/* scoped */

var __vue_scope_id__$1w = undefined;
/* module identifier */

var __vue_module_identifier__$1w = undefined;
/* functional template */

var __vue_is_functional_template__$1w = false;
/* style inject */

/* style inject SSR */

var Modal = normalizeComponent_1({
  render: __vue_render__$1p,
  staticRenderFns: __vue_staticRenderFns__$1p
}, __vue_inject_styles__$1w, __vue_script__$1w, __vue_scope_id__$1w, __vue_is_functional_template__$1w, __vue_module_identifier__$1w, undefined, undefined);

var CONTAINER_DATA_ATTRIBUTE = "data-fd-vue-modals-container";
var CONTAINER_SELECTOR = "[".concat(CONTAINER_DATA_ATTRIBUTE, "]");
var getModalsContainer = (function () {
  var el = document.querySelector(CONTAINER_SELECTOR);
  return el != null ? el : createContainer();
});

var createContainer = function createContainer() {
  var container = document.createElement("DIV");
  container.setAttribute(CONTAINER_DATA_ATTRIBUTE, "");
  document.body.appendChild(container);
  return container;
};

var PORTAL_DATA_ATTRIBUTE = "data-fd-vue-modal-portal";
var createModalPortal = (function (modalName) {
  var portal = document.createElement("DIV");
  portal.setAttribute(PORTAL_DATA_ATTRIBUTE, modalName);
  return portal;
});

var ModalWrapper =
/*#__PURE__*/
function () {
  function ModalWrapper(vm) {
    _classCallCheck(this, ModalWrapper);

    this.vm = vm;
    this.onDeactivate = noop;
  }

  _createClass(ModalWrapper, [{
    key: "trapDidDeactivate",
    value: function trapDidDeactivate() {
      // @ts-ignore
      this.onDeactivate(this);
    }
  }, {
    key: "orderToBackground",
    value: function orderToBackground() {
      return this;
    }
  }, {
    key: "orderOut",
    value: function orderOut() {
      this.vm.$_close();
      return this;
    }
  }, {
    key: "orderFront",
    value: function orderFront() {
      this.vm.$_open();
      return this;
    }
  }, {
    key: "createTrap",
    value: function createTrap() {
      var modalEl = this.vm.modalEl();
      this.trap = focusTrap_1(modalEl, {
        initialFocus: modalEl,
        escapeDeactivates: !this.vm.handleEscManually,
        onDeactivate: this.trapDidDeactivate.bind(this),
        returnFocusOnDeactivate: false
      });
      return this;
    }
  }, {
    key: "deactivateTrap",
    value: function deactivateTrap() {
      this.trap.deactivate();
      return this;
    }
  }, {
    key: "focus",
    value: function focus() {
      var _this = this;

      // We first check if the modal is visible. If yes, focus it,
      if (this.vm.visible) {
        this.trap.activate();
        return this;
      } // If not, we expect "visible" to switch to true "soon".
      // Thus we watch (once) and then activate the trap.
      // If we are not doing this – the focusTrap will not work.


      var unwatch = this.vm.$watch("visible", function (visible) {
        unwatch();

        if (visible) {
          _this.trap.activate();

          return;
        }
      });
      return this;
    }
  }]);

  return ModalWrapper;
}();

var ModalManager =
/*#__PURE__*/
function () {
  function ModalManager() {
    _classCallCheck(this, ModalManager);

    /** @type { {[modalName: string]: ModalWrapper} } */
    this.modalsByName = {};
    /** @type {ModalWrapper[]} */

    this.openModals = [];
  }

  _createClass(ModalManager, [{
    key: "registerModalVM",
    value: function registerModalVM(vm) {
      var portalEl = createModalPortal(vm.name);
      var container = getModalsContainer();
      container.appendChild(portalEl);
      var wrapper = new ModalWrapper(vm);
      wrapper.onDeactivate = this.handleDeactivate.bind(this);
      this.modalsByName[vm.name] = wrapper;
    }
  }, {
    key: "unregisterModalVM",
    value: function unregisterModalVM(_ref) {
      var name = _ref.name;
      var modal = this.modalsByName[name];
      modal.onDeactivate = noop;
      delete this.modalsByName[name];
    }
  }, {
    key: "open",
    // This is our 'public' method. We expose only one method for
    // opening modals to keep it simple. To make this work, open(…)
    // can be given just the name of a modal or a modal instance.
    // Usually app developers should open modals only by name.
    value: function open(modalOrModalName) {
      if (typeof modalOrModalName === "string") {
        this._openModalByName(modalOrModalName);
      } else {
        this._openModalByName(modalOrModalName.name);
      }
    }
  }, {
    key: "_openModalByName",
    value: function _openModalByName(modalName) {
      var wrapper = this.modalsByName[modalName];

      this.__openModal(wrapper);
    }
  }, {
    key: "handleDeactivate",
    value: function handleDeactivate(wrapper) {
      if (this.topModal !== wrapper) {
        return;
      }

      wrapper.orderOut();
      this.openModals.pop();
      var topModal = this.topModal;

      if (topModal != null) {
        topModal.orderFront().focus();
      }
    }
  }, {
    key: "_closeTheOnlyOpenModal",
    value: function _closeTheOnlyOpenModal(wrapper) {
      wrapper.deactivateTrap();
    }
  }, {
    key: "_closeTopModal",
    value: function _closeTopModal(wrapper) {
      wrapper.deactivateTrap();
    }
  }, {
    key: "__openModal",
    value: function __openModal(wrapper) {
      this.openModals.push(wrapper);
      wrapper.orderFront().createTrap().focus();
    }
  }, {
    key: "close",
    value: function close(modalOrModalName) {
      if (typeof modalOrModalName === "string") {
        this._closeModalByName(modalOrModalName);
      } else {
        var wrapper = this.modalsByName[modalOrModalName.name];

        this.__closeModal(wrapper);
      }
    }
  }, {
    key: "_closeModalByName",
    value: function _closeModalByName(modalName) {
      var wrapper = this.modalsByName[modalName];

      this.__closeModal(wrapper);
    }
  }, {
    key: "__closeModal",
    value: function __closeModal(wrapper) {
      var index = this.openModals.indexOf(wrapper);

      if (index < 0) {
        return;
      }

      if (this.openModals.length === 1) {
        this._closeTheOnlyOpenModal(wrapper);

        return;
      }

      this._closeTopModal(this.topModal);
    }
  }, {
    key: "topModal",
    get: function get() {
      var openModals = this.openModals;
      return openModals.length === 0 ? undefined : openModals[openModals.length - 1];
    }
  }]);

  return ModalManager;
}();

pluginify(Modal); // Monkey-patch Modal.install because we want to add our modal manager there

var originalInstall = Modal.install;

Modal.install = function (vue, options) {
  originalInstall(vue, options);
  vue.prototype.$fdModal = new ModalManager();
};

pluginify(ModalOverlay);

//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
var script$1x = {
  name: "FdPagination",
  props: {
    itemsPerPage: {
      type: Number,
      default: 10
    },
    itemsTotal: {
      type: Number,
      required: true
    },
    initialPage: {
      type: Number,
      default: 1
    },
    displayTotal: {
      type: Boolean,
      default: true
    },
    totalText: {
      type: String,
      default: ""
    }
  },
  computed: {
    pages: function pages() {
      var numbers = Array.from({
        length: this.numberOfPages
      }).map(function (_, index) {
        return index;
      });
      var notSuppressed = true;
      var pages = [];
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = numbers[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var number = _step.value;

          if (this.isClickablePage(number)) {
            pages.push({
              number: number,
              type: "normal"
            });
            notSuppressed = true;
          } else if (notSuppressed === true) {
            pages.push({
              number: number,
              type: "more"
            });
            notSuppressed = false;
          }
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return != null) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return pages;
    },
    formattedTotalText: function formattedTotalText() {
      return this.totalText || "items";
    },
    numberOfPages: function numberOfPages() {
      return Math.ceil(this.itemsTotal / (this.itemsPerPage || 10));
    }
  },
  methods: {
    isClickablePage: function isClickablePage(page) {
      return page === 0 || page === this.numberOfPages - 1 || page >= this.selectedPage - this.numberOfNeighbour - 1 && page <= this.selectedPage + this.numberOfNeighbour - 1;
    },
    pageClicked: function pageClicked(event) {
      var element = event.target;
      this.selectedPage = element && +element.text || 1;
      this.$emit("update:initialPage", this.selectedPage);
    },
    navigateToFirst: function navigateToFirst() {
      this.selectedPage = 1;
      this.$emit("update:initialPage", this.selectedPage);
    },
    navigateToLast: function navigateToLast() {
      this.selectedPage = this.numberOfPages;
      this.$emit("update:initialPage", this.selectedPage);
    },
    navigateForward: function navigateForward() {
      if (this.selectedPage === this.numberOfPages) {
        return;
      }

      ++this.selectedPage;
      this.$emit("update:initialPage", this.selectedPage);
    },
    navigateBack: function navigateBack() {
      if (this.selectedPage === 1) {
        return;
      }

      --this.selectedPage;
      this.$emit("update:initialPage", this.selectedPage);
    },
    keyHandler: function keyHandler(e) {
      var key = e.code;

      if (key === "Home") {
        this.navigateToFirst();
      } else if (key === "End") {
        this.navigateToLast();
      } else if (key === "ArrowLeft" || key === "ArrowUp" || key === "PageUp") {
        this.navigateBack();
      } else if (key === "ArrowRight" || key === "ArrowDown" || key === "PageDown") {
        this.navigateForward();
      }
    }
  },
  data: function data() {
    return {
      // when selectedPage = 27, render like [1,...26,27,28,...100]
      selectedPage: this.initialPage ? this.initialPage : 1,
      numberOfNeighbour: 1
    };
  }
};

/* script */
var __vue_script__$1x = script$1x;
/* template */

var __vue_render__$1q = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-pagination",
    on: {
      "keydown": _vm.keyHandler
    }
  }, [_vm.displayTotal ? _c('span', {
    staticClass: "fd-pagination__total"
  }, [_vm._v("\n    " + _vm._s(_vm.itemsTotal) + " " + _vm._s(_vm.formattedTotalText) + "\n  ")]) : _vm._e(), _vm._v(" "), _c('nav', {
    staticClass: "fd-pagination__nav"
  }, [_c('a', {
    staticClass: "fd-pagination__link fd-pagination__link--previous",
    attrs: {
      "href": "#",
      "aria-label": "Previous",
      "aria-disabled": _vm.selectedPage === 1
    },
    on: {
      "click": function click($event) {
        $event.preventDefault();
        return _vm.navigateBack($event);
      }
    }
  }), _vm._v(" "), _vm._l(_vm.pages, function (page) {
    return [page.type === 'normal' ? _c('a', {
      key: "page-link-" + page.number,
      staticClass: "fd-pagination__link",
      attrs: {
        "href": "#",
        "aria-selected": _vm.selectedPage === page.number + 1
      },
      on: {
        "click": function click($event) {
          $event.preventDefault();
          return _vm.pageClicked($event);
        }
      }
    }, [_vm._v("\n        " + _vm._s(page.number + 1) + "\n      ")]) : _c('span', {
      key: "page-more-" + page.number,
      staticClass: "fd-pagination__link fd-pagination__link--more",
      attrs: {
        "aria-hidden": "true",
        "aria-label": "…",
        "role": "presentation"
      }
    })];
  }), _vm._v(" "), _c('a', {
    staticClass: "fd-pagination__link fd-pagination__link--next",
    attrs: {
      "href": "#",
      "aria-label": "Next",
      "aria-disabled": _vm.selectedPage === _vm.numberOfPages
    },
    on: {
      "click": function click($event) {
        $event.preventDefault();
        return _vm.navigateForward($event);
      }
    }
  })], 2)]);
};

var __vue_staticRenderFns__$1q = [];
/* style */

var __vue_inject_styles__$1x = undefined;
/* scoped */

var __vue_scope_id__$1x = undefined;
/* module identifier */

var __vue_module_identifier__$1x = undefined;
/* functional template */

var __vue_is_functional_template__$1x = false;
/* style inject */

/* style inject SSR */

var Pagination = normalizeComponent_1({
  render: __vue_render__$1q,
  staticRenderFns: __vue_staticRenderFns__$1q
}, __vue_inject_styles__$1x, __vue_script__$1x, __vue_scope_id__$1x, __vue_is_functional_template__$1x, __vue_module_identifier__$1x, undefined, undefined);

var Pagination$1 = pluginify(Pagination);

var sizeMapping$1 = {
  none: "none",
  tiny: "tiny",
  small: "small",
  medium: "medium",
  large: "large"
};
var Sizes = Object.keys(sizeMapping$1);

var isSize = function isSize(value) {
  return value === undefined || Sizes.indexOf(value) >= 0;
}; // Helper


var addClasses = function addClasses(list, classes) {
  return classes.forEach(function (cssClass) {
    return list.add(cssClass);
  });
}; // Actual Design System Utils


var designClass = function designClass(prefix, size, side) {
  return side == null ? "fd-has-".concat(prefix, "-").concat(size) : "fd-has-".concat(prefix, "-").concat(side, "-").concat(size);
};

var designClasses = function designClasses(prefix, size) {
  var modifiers = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var top = modifiers.top,
      left = modifiers.left,
      right = modifiers.right,
      bottom = modifiers.bottom;

  if (top == null && left == null && right == null && bottom == null) {
    return [designClass(prefix, size)];
  }

  var classes = [];

  if (top === true) {
    classes.push(designClass(prefix, size, "top"));
  }

  if (bottom === true) {
    classes.push(designClass(prefix, size, "bottom"));
  }

  if (left === true) {
    classes.push(designClass(prefix, size, "left"));
  }

  if (right === true) {
    classes.push(designClass(prefix, size, "right"));
  }

  return classes;
};

var paddingClasses = function paddingClasses(size) {
  var modifiers = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return designClasses("padding", size, modifiers);
};

var marginClasses = function marginClasses(size) {
  var modifiers = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return designClasses("margin", size, modifiers);
};
/*
  Usage:
  v-fd-padding:small
  v-fd-padding:small.left.right.bottom
            ^---^ ^---------------^
             arg      modifiers
*/


var padding = function padding(_ref, binding) {
  var classList = _ref.classList;
  var arg = binding.arg,
      modifiers = binding.modifiers;

  if (!isSize(arg)) {
    return;
  }

  var size = arg;
  addClasses(classList, paddingClasses(size || "none", modifiers));
};
var margin = function margin(_ref2, binding) {
  var classList = _ref2.classList;
  var arg = binding.arg,
      modifiers = binding.modifiers;

  if (!isSize(arg)) {
    return;
  }

  var size = arg;
  addClasses(classList, marginClasses(size || "none", modifiers));
};

var isFontWeight = function isFontWeight(value) {
  return ["light", "bold", "normal"].indexOf(value) > -1;
};

var fontWeight = function fontWeight(_ref3, binding) {
  var classList = _ref3.classList;
  var arg = binding.arg;

  if (!isFontWeight(arg)) {
    return;
  }

  addClasses(classList, ["fd-has-font-weight-".concat(arg)]);
};

var isFontFamily = function isFontFamily(value) {
  return ["body", "header", "code"].indexOf(value) >= 0;
};

var fontFamily = function fontFamily(_ref4, _ref5) {
  var classList = _ref4.classList;
  var arg = _ref5.arg;

  if (!isFontFamily(arg)) {
    return;
  }

  addClasses(classList, ["fd-has-font-family-".concat(arg)]);
}; // Valid values for arg are -1, 0, …, 6 (as strings)
// We don't validate this but the only thing we do it to fix "-1" by replacing it with "minus-1".

var type = function type(_ref6, _ref7) {
  var classList = _ref6.classList;
  var arg = _ref7.arg;

  if (arg == null) {
    return "fd-has-type";
  }

  addClasses(classList, ["fd-has-type-".concat(arg === "-1" ? "minus-1" : arg)]);
};

var isValidColSpan = function isValidColSpan(value) {
  return value >= 2 && value <= 6;
};

var PANEL_CLASS = "fd-panel";
var script$1y = {
  name: "FdPanel",
  props: {
    title: {
      type: String,
      default: null
    },
    description: {
      type: String,
      default: null
    },
    span: {
      type: Number,
      default: null,
      validator: isValidColSpan
    },
    condensed: {
      type: Boolean,
      default: false
    },
    condensedFooter: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    bodyClasses: function bodyClasses() {
      var classes = !this.condensed ? [] : paddingClasses("none");
      return ["".concat(PANEL_CLASS, "__body")].concat(_toConsumableArray(classes));
    },
    footerClasses: function footerClasses() {
      var classes = !this.condensedFooter ? [] : paddingClasses("none");
      return ["".concat(PANEL_CLASS, "__footer")].concat(_toConsumableArray(classes));
    },
    classes: function classes() {
      var staticClasses = [PANEL_CLASS];
      var span = this.span;
      return span == null ? staticClasses : [].concat(staticClasses, ["fd-has-grid-column-span-".concat(span)]);
    },
    hasTitle: function hasTitle() {
      return this.$slots.title != null || this.title != null;
    },
    hasDescription: function hasDescription() {
      return this.$slots.description != null || this.description != null;
    },
    hasActions: function hasActions() {
      return this.$slots.actions != null;
    },
    needsHeader: function needsHeader() {
      return this.needsHead || this.hasActions;
    },
    needsHead: function needsHead() {
      return this.hasTitle || this.hasDescription;
    }
  }
};

/* script */
var __vue_script__$1y = script$1y;
/* template */

var __vue_render__$1r = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    class: _vm.classes
  }, [_vm.needsHeader ? _c('div', {
    staticClass: "fd-panel__header"
  }, [_vm.needsHead ? _c('div', {
    staticClass: "fd-panel__head"
  }, [_vm.hasTitle ? _c('h1', {
    staticClass: "fd-panel__title"
  }, [_vm._t("title", [_vm._v("\n          " + _vm._s(_vm.title) + "\n        ")])], 2) : _vm._e(), _vm._v(" "), _vm.hasDescription ? _c('p', {
    staticClass: "fd-panel__description"
  }, [_vm._t("description", [_vm._v("\n          " + _vm._s(_vm.description) + "\n        ")])], 2) : _vm._e()]) : _vm._e(), _vm._v(" "), _vm.hasActions ? _c('div', {
    staticClass: "fd-panel__actions"
  }, [_vm._t("actions")], 2) : _vm._e()]) : _vm._e(), _vm._v(" "), _vm.$slots.filters != null ? _c('div', {
    staticClass: "fd-panel__filters"
  }, [_vm._t("filters")], 2) : _vm._e(), _vm._v(" "), _vm.$slots.default ? _c('div', {
    class: _vm.bodyClasses
  }, [_vm._t("default")], 2) : _vm._e(), _vm._v(" "), _vm.$slots.footer ? _c('div', {
    class: _vm.footerClasses
  }, [_vm._t("footer")], 2) : _vm._e()]);
};

var __vue_staticRenderFns__$1r = [];
/* style */

var __vue_inject_styles__$1y = undefined;
/* scoped */

var __vue_scope_id__$1y = undefined;
/* module identifier */

var __vue_module_identifier__$1y = undefined;
/* functional template */

var __vue_is_functional_template__$1y = false;
/* style inject */

/* style inject SSR */

var Panel = normalizeComponent_1({
  render: __vue_render__$1r,
  staticRenderFns: __vue_staticRenderFns__$1r
}, __vue_inject_styles__$1y, __vue_script__$1y, __vue_scope_id__$1y, __vue_is_functional_template__$1y, __vue_module_identifier__$1y, undefined, undefined);

//
//
//
//
//
//
var PANEL_GRID_CLASS = "fd-panel-grid";
var script$1z = {
  name: "FdPanelGrid",
  props: {
    col: {
      type: Number,
      default: null,
      validator: function validator(value) {
        return value >= 2 && value <= 6;
      }
    },
    nogap: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    classes: function classes() {
      var col = this.col;
      return [PANEL_GRID_CLASS].concat(_toConsumableArray(col != null ? ["".concat(PANEL_GRID_CLASS, "--").concat(col, "col")] : []), _toConsumableArray(this.nogap ? ["".concat(PANEL_GRID_CLASS, "--nogap")] : []));
    }
  }
};

/* script */
var __vue_script__$1z = script$1z;
/* template */

var __vue_render__$1s = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    class: _vm.classes
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1s = [];
/* style */

var __vue_inject_styles__$1z = undefined;
/* scoped */

var __vue_scope_id__$1z = undefined;
/* module identifier */

var __vue_module_identifier__$1z = undefined;
/* functional template */

var __vue_is_functional_template__$1z = false;
/* style inject */

/* style inject SSR */

var PanelGrid = normalizeComponent_1({
  render: __vue_render__$1s,
  staticRenderFns: __vue_staticRenderFns__$1s
}, __vue_inject_styles__$1z, __vue_script__$1z, __vue_scope_id__$1z, __vue_is_functional_template__$1z, __vue_module_identifier__$1z, undefined, undefined);

var Panel$1 = pluginify(Panel, PanelGrid);

var Popover = pluginify(FdPopover);

//
//
//
//
//
//
//
var script$1A = {
  name: "FdSection"
};

/* script */
var __vue_script__$1A = script$1A;
/* template */

var __vue_render__$1t = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('section', {
    staticClass: "fd-section"
  }, [_vm._t("header"), _vm._v(" "), _vm._t("default")], 2);
};

var __vue_staticRenderFns__$1t = [];
/* style */

var __vue_inject_styles__$1A = undefined;
/* scoped */

var __vue_scope_id__$1A = undefined;
/* module identifier */

var __vue_module_identifier__$1A = undefined;
/* functional template */

var __vue_is_functional_template__$1A = false;
/* style inject */

/* style inject SSR */

var FdSection = normalizeComponent_1({
  render: __vue_render__$1t,
  staticRenderFns: __vue_staticRenderFns__$1t
}, __vue_inject_styles__$1A, __vue_script__$1A, __vue_scope_id__$1A, __vue_is_functional_template__$1A, __vue_module_identifier__$1A, undefined, undefined);

var script$1B = {
  name: "FdSectionTitle",
  props: {
    tag: {
      type: String,
      default: "h3"
    }
  },
  render: function render(h) {
    var tag = this.tag;
    return h(tag, {
      class: "fd-section__title"
    }, [this.$slots.default]);
  }
};

/* script */
var __vue_script__$1B = script$1B;
/* template */

/* style */

var __vue_inject_styles__$1B = undefined;
/* scoped */

var __vue_scope_id__$1B = undefined;
/* module identifier */

var __vue_module_identifier__$1B = undefined;
/* functional template */

var __vue_is_functional_template__$1B = undefined;
/* style inject */

/* style inject SSR */

var FdSectionTitle = normalizeComponent_1({}, __vue_inject_styles__$1B, __vue_script__$1B, __vue_scope_id__$1B, __vue_is_functional_template__$1B, __vue_module_identifier__$1B, undefined, undefined);

//
//
//
//
var script$1C = {
  name: "FdSectionHeader"
};

/* script */
var __vue_script__$1C = script$1C;
/* template */

var __vue_render__$1u = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-section__header"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1u = [];
/* style */

var __vue_inject_styles__$1C = undefined;
/* scoped */

var __vue_scope_id__$1C = undefined;
/* module identifier */

var __vue_module_identifier__$1C = undefined;
/* functional template */

var __vue_is_functional_template__$1C = false;
/* style inject */

/* style inject SSR */

var FdSectionHeader = normalizeComponent_1({
  render: __vue_render__$1u,
  staticRenderFns: __vue_staticRenderFns__$1u
}, __vue_inject_styles__$1C, __vue_script__$1C, __vue_scope_id__$1C, __vue_is_functional_template__$1C, __vue_module_identifier__$1C, undefined, undefined);

var Section = pluginify(FdSection, FdSectionTitle, FdSectionHeader);

//
var script$1D = {
  name: "FdSearchCompletionList",
  components: {
    FdMenuList: FdMenuList
  },
  props: {
    completions: {
      type: Array,
      default: function _default() {
        return [];
      }
    },
    predicate: {
      type: String,
      default: null
    }
  },
  computed: {
    hasMatches: function hasMatches() {
      return this.completionsMatchingPredicate.length > 0;
    },
    normalizedPredicate: function normalizedPredicate() {
      return this.predicate != null ? this.predicate.toLowerCase() : null;
    },
    completionsMatchingPredicate: function completionsMatchingPredicate() {
      var completions = this.completions,
          predicate = this.normalizedPredicate;

      if (predicate == null) {
        return completions;
      }

      var matchesPredicate = function matchesPredicate(completion) {
        return completion.toLowerCase().startsWith(predicate);
      };

      return completions.filter(matchesPredicate);
    }
  },
  methods: {
    matchingCompletionProps: function matchingCompletionProps(completion) {
      var predicate = this.predicate;

      if (predicate == null) {
        return {
          value: completion,
          matchingPrefix: "",
          remainingCompletion: completion
        };
      }

      var matchingPrefix = completion.slice(0, predicate.length);
      var remainingCompletion = completion.slice(predicate.length);
      return {
        matchingPrefix: matchingPrefix,
        remainingCompletion: remainingCompletion,
        value: completion
      };
    }
  }
};

/* script */
var __vue_script__$1D = script$1D;
/* template */

var __vue_render__$1v = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _vm.hasMatches ? _c('FdMenuList', [_vm._l(_vm.completions, function (completion) {
    return [_vm._t("item", null, null, _vm.matchingCompletionProps(completion))];
  })], 2) : _c('FdMenuList', [_vm._t("no-results")], 2);
};

var __vue_staticRenderFns__$1v = [];
/* style */

var __vue_inject_styles__$1D = undefined;
/* scoped */

var __vue_scope_id__$1D = undefined;
/* module identifier */

var __vue_module_identifier__$1D = undefined;
/* functional template */

var __vue_is_functional_template__$1D = false;
/* style inject */

/* style inject SSR */

var CompletionList = normalizeComponent_1({
  render: __vue_render__$1v,
  staticRenderFns: __vue_staticRenderFns__$1v
}, __vue_inject_styles__$1D, __vue_script__$1D, __vue_scope_id__$1D, __vue_is_functional_template__$1D, __vue_module_identifier__$1D, undefined, undefined);

//
var script$1E = {
  name: "FdMatchingCompletion",
  components: {
    FdMenuLink: FdMenuLink
  },
  props: {
    selected: {
      type: Boolean,
      default: false
    },
    value: {
      type: String,
      default: null
    },
    matchingPrefix: {
      type: String,
      default: ""
    },
    remainingCompletion: {
      type: String,
      default: ""
    }
  }
};

/* script */
var __vue_script__$1E = script$1E;
/* template */

var __vue_render__$1w = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('FdMenuLink', {
    attrs: {
      "selected": _vm.selected
    },
    on: {
      "click": function click($event) {
        return _vm.$emit('click', $event);
      }
    }
  }, [_vm.matchingPrefix != null && _vm.matchingPrefix.length > 0 ? _c('strong', [_vm._v(_vm._s(_vm.matchingPrefix))]) : _vm._e(), _vm._v("\n  " + _vm._s(_vm.remainingCompletion) + "\n")]);
};

var __vue_staticRenderFns__$1w = [];
/* style */

var __vue_inject_styles__$1E = undefined;
/* scoped */

var __vue_scope_id__$1E = undefined;
/* module identifier */

var __vue_module_identifier__$1E = undefined;
/* functional template */

var __vue_is_functional_template__$1E = false;
/* style inject */

/* style inject SSR */

var FdMatchingCompletion = normalizeComponent_1({
  render: __vue_render__$1w,
  staticRenderFns: __vue_staticRenderFns__$1w
}, __vue_inject_styles__$1E, __vue_script__$1E, __vue_scope_id__$1E, __vue_is_functional_template__$1E, __vue_module_identifier__$1E, undefined, undefined);

//
var EVENT_SELECT = "select";
var EVENT_UPDATE = "update";
var script$1F = {
  name: "FdSearchInput",
  mixins: [Uid],
  model: {
    prop: "predicate",
    event: "update"
  },
  components: {
    FdMatchingCompletion: FdMatchingCompletion,
    FdCompletionList: CompletionList,
    FdMenu: FdMenu,
    FdMenuItem: FdMenuItem,
    FdComboboxBase: FdComboboxBase,
    FdInputGroupButton: FdInputGroupButton,
    FdInput: FdInput
  },
  props: {
    popoverClass: {
      type: [Array, Object, String],
      default: null
    },
    predicate: {
      type: String,
      default: null
    },
    completions: {
      type: Array,
      default: function _default() {
        return [];
      }
    },
    placeholder: {
      type: String,
      default: ""
    },
    compact: {
      type: Boolean,
      default: false
    },
    confirmOn: {
      type: String,
      default: "keyup.enter",
      validator: function validator(value) {
        return ["keyup.enter", "keyup.tab"].indexOf(value) >= 0;
      }
    }
  },
  computed: {
    combobox: function combobox() {
      return this.$refs.combobox;
    },
    hasMatches: function hasMatches() {
      return this.completionsMatchingPredicate.length > 0;
    },
    normalizedPredicate: function normalizedPredicate() {
      return this.predicate != null ? this.predicate.toLowerCase() : null;
    },
    completionsMatchingPredicate: function completionsMatchingPredicate() {
      var completions = this.completions,
          predicate = this.normalizedPredicate;

      if (predicate == null) {
        return completions;
      }

      var matchesPredicate = function matchesPredicate(completion) {
        return completion.toLowerCase().startsWith(predicate);
      };

      return completions.filter(matchesPredicate);
    }
  },
  methods: {
    handleKeydownTab: function handleKeydownTab(event) {
      if (this.confirmOn === "keyup.tab") {
        var combobox = this.$refs.combobox;
        var popover = combobox.$refs.popover;
        var visible_ = popover.kpop.visible_;

        if (visible_) {
          event.preventDefault();
        }
      }
    },
    handleTab: function handleTab() {
      if (this.selectedValue == null || this.confirmOn !== "keyup.tab") {
        return;
      }

      this.selectCompletion(this.selectedValue);
    },
    handleEnter: function handleEnter() {
      if (this.selectedValue == null || this.confirmOn !== "keyup.enter") {
        return;
      }

      this.selectCompletion(this.selectedValue);
    },
    showCompletions: function showCompletions() {
      if (this.completions.length === 0) {
        return;
      }

      this.combobox.show();
    },
    hideCompletions: function hideCompletions() {
      this.combobox.hide();
    },
    toggleCompletions: function toggleCompletions() {
      if (this.completions.length === 0) {
        return;
      }

      this.combobox.toggle();
    },
    isValueSelected: function isValueSelected(value) {
      return value === this.selectedValue;
    },
    highlightNext: function highlightNext() {
      var completions = this.completionsMatchingPredicate;

      if (completions.length === 0) {
        return;
      }

      var selectedValue = this.selectedValue;
      var index = completions.indexOf(selectedValue);

      if (index < 0) {
        this.selectedValue = completions[0];
        return;
      }

      var maxIndex = completions.length - 1;
      var nextIndex = Math.min(maxIndex, index + 1);
      var nextValue = completions[nextIndex];
      this.selectedValue = nextValue;
    },
    highlightPrevious: function highlightPrevious() {
      var completions = this.completionsMatchingPredicate;

      if (completions.length === 0) {
        return;
      }

      var selectedValue = this.selectedValue;
      var index = completions.indexOf(selectedValue);

      if (index < 0) {
        return;
      }

      var newIndex = Math.max(0, index - 1);
      this.selectedValue = completions[newIndex];
    },
    selectCompletion: function selectCompletion(value) {
      this.setCurrentPredicate(value);
      this.hideCompletions();

      if (value != null) {
        this.$emit(EVENT_SELECT, value);
      }
    },
    ignoredElements: function ignoredElements() {
      // @ts-ignore
      return [this.$refs.input.$el];
    },
    setCurrentPredicate: function setCurrentPredicate(newValue) {
      this.currentPredicate = newValue;
      this.$emit(EVENT_UPDATE, this.currentPredicate);
    },
    setCurrentPredicateAndShowCompletions: function setCurrentPredicateAndShowCompletions(newValue) {
      this.setCurrentPredicate(newValue);
      this.showCompletions();
    }
  },
  watch: {
    predicate: {
      immediate: true,
      handler: function handler(newValue) {
        this.currentPredicate = newValue;
      }
    }
  },
  data: function data() {
    return {
      selectedValue: null,
      currentPredicate: this.predicate
    };
  }
};

/* script */
var __vue_script__$1F = script$1F;
/* template */

var __vue_render__$1x = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-search-input"
  }, [_c('fd-combobox-base', {
    ref: "combobox",
    attrs: {
      "popoverClass": _vm.popoverClass,
      "ignoredElements": _vm.ignoredElements
    },
    scopedSlots: _vm._u([{
      key: "input",
      fn: function fn() {
        return [_c('fd-input', {
          ref: "input",
          attrs: {
            "value": _vm.currentPredicate,
            "placeholder": _vm.placeholder,
            "compact": _vm.compact
          },
          on: {
            "update": _vm.setCurrentPredicateAndShowCompletions,
            "change": function change($event) {
              return _vm.$emit('change', $event);
            },
            "focus": _vm.showCompletions,
            "click": _vm.showCompletions,
            "keyup": [function ($event) {
              if (!$event.type.indexOf('key') && _vm._k($event.keyCode, "esc", 27, $event.key, ["Esc", "Escape"])) {
                return null;
              }

              return _vm.hideCompletions($event);
            }, function ($event) {
              if (!$event.type.indexOf('key') && _vm._k($event.keyCode, "enter", 13, $event.key, "Enter")) {
                return null;
              }

              return _vm.handleEnter($event);
            }, function ($event) {
              if (!$event.type.indexOf('key') && _vm._k($event.keyCode, "tab", 9, $event.key, "Tab")) {
                return null;
              }

              return _vm.handleTab($event);
            }],
            "keydown": function keydown($event) {
              if (!$event.type.indexOf('key') && _vm._k($event.keyCode, "tab", 9, $event.key, "Tab")) {
                return null;
              }

              return _vm.handleKeydownTab($event);
            }
          },
          nativeOn: {
            "keydown": [function ($event) {
              if (!$event.type.indexOf('key') && _vm._k($event.keyCode, "down", 40, $event.key, ["Down", "ArrowDown"])) {
                return null;
              }

              $event.preventDefault();
              return _vm.highlightNext($event);
            }, function ($event) {
              if (!$event.type.indexOf('key') && _vm._k($event.keyCode, "up", 38, $event.key, ["Up", "ArrowUp"])) {
                return null;
              }

              $event.preventDefault();
              return _vm.highlightPrevious($event);
            }]
          }
        })];
      },
      proxy: true
    }, {
      key: "after",
      fn: function fn() {
        return [_vm._t("search-button", [_c('fd-input-group-button', {
          attrs: {
            "compact": _vm.compact,
            "icon": "search",
            "styling": "light"
          },
          on: {
            "click": _vm.toggleCompletions
          }
        })])];
      },
      proxy: true
    }, {
      key: "default",
      fn: function fn() {
        return [_c('fd-menu', {
          ref: "menu"
        }, [_c('fd-completion-list', {
          attrs: {
            "completions": _vm.completionsMatchingPredicate,
            "predicate": _vm.currentPredicate
          },
          scopedSlots: _vm._u([{
            key: "no-results",
            fn: function fn() {
              return [_vm._t("no-results", [_c('fd-menu-item', [_vm._v("No Results")])])];
            },
            proxy: true
          }, {
            key: "item",
            fn: function fn(completion) {
              return [_c('fd-menu-item', {
                on: {
                  "click": function click($event) {
                    return _vm.selectCompletion(completion.value);
                  }
                }
              }, [_c('fd-matching-completion', _vm._b({
                attrs: {
                  "selected": _vm.isValueSelected(completion.value)
                }
              }, 'fd-matching-completion', completion, false))], 1)];
            }
          }], null, true)
        })], 1)];
      },
      proxy: true
    }], null, true)
  })], 1);
};

var __vue_staticRenderFns__$1x = [];
/* style */

var __vue_inject_styles__$1F = undefined;
/* scoped */

var __vue_scope_id__$1F = undefined;
/* module identifier */

var __vue_module_identifier__$1F = undefined;
/* functional template */

var __vue_is_functional_template__$1F = false;
/* style inject */

/* style inject SSR */

var SearchInput = normalizeComponent_1({
  render: __vue_render__$1x,
  staticRenderFns: __vue_staticRenderFns__$1x
}, __vue_inject_styles__$1F, __vue_script__$1F, __vue_scope_id__$1F, __vue_is_functional_template__$1F, __vue_module_identifier__$1F, undefined, undefined);

var SearchInput$1 = pluginify(SearchInput, CompletionList);

//
//
//
//
//
//
var script$1G = {
  name: "FdSideNavSubItem"
};

/* script */
var __vue_script__$1G = script$1G;
/* template */

var __vue_render__$1y = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('li', {
    staticClass: "fd-side-nav__subitem"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1y = [];
/* style */

var __vue_inject_styles__$1G = undefined;
/* scoped */

var __vue_scope_id__$1G = undefined;
/* module identifier */

var __vue_module_identifier__$1G = undefined;
/* functional template */

var __vue_is_functional_template__$1G = false;
/* style inject */

/* style inject SSR */

var SideNavSubItem = normalizeComponent_1({
  render: __vue_render__$1y,
  staticRenderFns: __vue_staticRenderFns__$1y
}, __vue_inject_styles__$1G, __vue_script__$1G, __vue_scope_id__$1G, __vue_is_functional_template__$1G, __vue_module_identifier__$1G, undefined, undefined);

var $_FDID = "$_fdId";
var $_FDCHILDREN = "$_fdChildren";
/**
 * @typedef {object} NormalizedItem
 * @prop {string} $_fdId;
 * @prop {NormalizedItem[]} $_fdChildren;
 */

/**
 * @param {NormalizedItem} item
 * @returns {string}
 */

var normalizedId = function normalizedId(item) {
  return item[$_FDID];
};
/**
 * @param {NormalizedItem} item
 * @returns {NormalizedItem[]}
 */

var normalizedChildren = function normalizedChildren(item) {
  return item[$_FDCHILDREN];
};
/**
 * @param {any} raw
 * @returns {NormalizedItem}
 */

function normalizeItem(raw) {
  var _objectSpread2$1;

  if (raw == null) {
    return normalizeItem({});
  }

  var id = raw.id || shortUuid();
  var children = normalizeItems(raw.children || []);
  return _objectSpread2({}, raw, (_objectSpread2$1 = {
    id: id,
    children: children
  }, _defineProperty(_objectSpread2$1, $_FDID, id), _defineProperty(_objectSpread2$1, $_FDCHILDREN, children), _objectSpread2$1));
}

function normalizeItems(items) {
  return items.map(normalizeItem);
}

//

var script$1H = {
  name: "FdSideNavSubLink",
  inject: {
    fdSubItemProvider: {
      default: null
    },
    sideNavStore: {
      default: null
    }
  },
  props: {
    asRouterLink: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    subItem: function subItem() {
      return this.fdSubItemProvider.subItem;
    },
    selected: function selected() {
      return this.store.itemWithIdIsSelected(this.subItemId);
    },
    classes: function classes() {
      return {
        "is-selected": this.selected
      };
    },
    store: function store() {
      return this.sideNavStore;
    },
    subItemId: function subItemId() {
      return normalizedId(this.subItem);
    }
  },
  methods: {
    selectSelf: function selectSelf() {
      this.store.selectedId = this.subItemId;
    }
  }
};

/* script */
var __vue_script__$1H = script$1H;
/* template */

var __vue_render__$1z = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _vm.asRouterLink ? _c('router-link', _vm._b({
    staticClass: "fd-side-nav__sublink",
    attrs: {
      "exact-active-class": "is-selected"
    },
    nativeOn: {
      "click": function click($event) {
        return _vm.selectSelf($event);
      }
    }
  }, 'router-link', _vm.$attrs, false), [_vm._t("default")], 2) : _c('a', {
    staticClass: "fd-side-nav__sublink",
    class: _vm.classes,
    attrs: {
      "href": "#",
      "aria-selected": String(_vm.selected)
    },
    on: {
      "click": function click($event) {
        $event.preventDefault();
        $event.stopPropagation();
        return _vm.selectSelf($event);
      }
    }
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1z = [];
/* style */

var __vue_inject_styles__$1H = undefined;
/* scoped */

var __vue_scope_id__$1H = undefined;
/* module identifier */

var __vue_module_identifier__$1H = undefined;
/* functional template */

var __vue_is_functional_template__$1H = false;
/* style inject */

/* style inject SSR */

var SideNavSubLink = normalizeComponent_1({
  render: __vue_render__$1z,
  staticRenderFns: __vue_staticRenderFns__$1z
}, __vue_inject_styles__$1H, __vue_script__$1H, __vue_scope_id__$1H, __vue_is_functional_template__$1H, __vue_module_identifier__$1H, undefined, undefined);

var FdSideNavSubItemProvider = {
  props: {
    subItem: {
      type: Object,
      required: true
    }
  },
  provide: function provide() {
    return {
      fdSubItemProvider: this.fdSubItemProvider
    };
  },
  render: function render() {
    return this.$scopedSlots.default();
  },
  watch: {
    subItem: {
      immediate: true,
      handler: function handler(newItem) {
        this.fdSubItemProvider.subItem = newItem;
      }
    }
  },
  data: function data() {
    return {
      fdSubItemProvider: {
        subItem: this.subItem
      }
    };
  }
};

//
var script$1I = {
  name: "FdSideNavSubList",
  inject: ["fdItemProvider", "sideNavStore"],
  components: {
    FdSideNavSubItemProvider: FdSideNavSubItemProvider
  },
  props: {
    items: {
      type: Array,
      default: function _default() {
        return [];
      }
    }
  },
  methods: {
    keyFor: function keyFor(item) {
      return normalizedId(item);
    }
  },
  computed: {
    parentItem: function parentItem() {
      return this.fdItemProvider.item;
    },
    parentId: function parentId() {
      return normalizedId(this.parentItem);
    },
    store: function store() {
      return this.sideNavStore;
    },
    hidden: function hidden() {
      return !this.store.itemWithIdIsExpanded(this.parentId);
    }
  }
};

/* script */
var __vue_script__$1I = script$1I;
/* template */

var __vue_render__$1A = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('ul', {
    staticClass: "fd-side-nav__sublist",
    attrs: {
      "aria-hidden": String(_vm.hidden)
    }
  }, [_vm._t("default"), _vm._v(" "), _vm._l(_vm.items, function (subItem) {
    return _c('fd-side-nav-sub-item-provider', {
      key: _vm.keyFor(subItem),
      attrs: {
        "subItem": subItem
      }
    }, [_vm._t("subItem", null, null, subItem)], 2);
  })], 2);
};

var __vue_staticRenderFns__$1A = [];
/* style */

var __vue_inject_styles__$1I = undefined;
/* scoped */

var __vue_scope_id__$1I = undefined;
/* module identifier */

var __vue_module_identifier__$1I = undefined;
/* functional template */

var __vue_is_functional_template__$1I = false;
/* style inject */

/* style inject SSR */

var SideNavSubList = normalizeComponent_1({
  render: __vue_render__$1A,
  staticRenderFns: __vue_staticRenderFns__$1A
}, __vue_inject_styles__$1I, __vue_script__$1I, __vue_scope_id__$1I, __vue_is_functional_template__$1I, __vue_module_identifier__$1I, undefined, undefined);

//
//
//
//
var script$1J = {
  name: "FdSideNavGroupTitle"
};

/* script */
var __vue_script__$1J = script$1J;
/* template */

var __vue_render__$1B = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('h1', {
    staticClass: "fd-side-nav__title"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1B = [];
/* style */

var __vue_inject_styles__$1J = undefined;
/* scoped */

var __vue_scope_id__$1J = undefined;
/* module identifier */

var __vue_module_identifier__$1J = undefined;
/* functional template */

var __vue_is_functional_template__$1J = false;
/* style inject */

/* style inject SSR */

var SideNavGroupTitle = normalizeComponent_1({
  render: __vue_render__$1B,
  staticRenderFns: __vue_staticRenderFns__$1B
}, __vue_inject_styles__$1J, __vue_script__$1J, __vue_scope_id__$1J, __vue_is_functional_template__$1J, __vue_module_identifier__$1J, undefined, undefined);

//
//
//
//
var script$1K = {
  name: "FdSideNavGroup"
};

/* script */
var __vue_script__$1K = script$1K;
/* template */

var __vue_render__$1C = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-side-nav__group"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1C = [];
/* style */

var __vue_inject_styles__$1K = undefined;
/* scoped */

var __vue_scope_id__$1K = undefined;
/* module identifier */

var __vue_module_identifier__$1K = undefined;
/* functional template */

var __vue_is_functional_template__$1K = false;
/* style inject */

/* style inject SSR */

var SideNavGroup = normalizeComponent_1({
  render: __vue_render__$1C,
  staticRenderFns: __vue_staticRenderFns__$1C
}, __vue_inject_styles__$1K, __vue_script__$1K, __vue_scope_id__$1K, __vue_is_functional_template__$1K, __vue_module_identifier__$1K, undefined, undefined);

//
var script$1L = {
  name: "FdSideNavIcon",
  mixins: [IconMixin]
};

/* script */
var __vue_script__$1L = script$1L;
/* template */

var __vue_render__$1D = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('span', {
    staticClass: "fd-side-nav__icon",
    class: _vm.iconClasses,
    attrs: {
      "role": "presentation"
    }
  });
};

var __vue_staticRenderFns__$1D = [];
/* style */

var __vue_inject_styles__$1L = undefined;
/* scoped */

var __vue_scope_id__$1L = undefined;
/* module identifier */

var __vue_module_identifier__$1L = undefined;
/* functional template */

var __vue_is_functional_template__$1L = false;
/* style inject */

/* style inject SSR */

var SideNavIcon = normalizeComponent_1({
  render: __vue_render__$1D,
  staticRenderFns: __vue_staticRenderFns__$1D
}, __vue_inject_styles__$1L, __vue_script__$1L, __vue_scope_id__$1L, __vue_is_functional_template__$1L, __vue_module_identifier__$1L, undefined, undefined);

var FdSideNavItemProvider = {
  props: {
    item: {
      type: Object,
      required: true
    }
  },
  provide: function provide() {
    return {
      fdItemProvider: this.fdItemProvider
    };
  },
  render: function render() {
    return this.$scopedSlots.default();
  },
  watch: {
    item: {
      immediate: true,
      handler: function handler(newItem) {
        this.fdItemProvider.item = newItem;
      }
    }
  },
  data: function data() {
    return {
      fdItemProvider: {
        item: this.item
      }
    };
  }
};

//
var script$1M = {
  name: "FdSideNavList",
  components: {
    FdSideNavItemProvider: FdSideNavItemProvider
  },
  props: {
    items: {
      type: Array,
      default: function _default() {
        return [];
      }
    }
  },
  computed: {
    normalizedItems: function normalizedItems() {
      return normalizeItems(this.items);
    }
  },
  methods: {
    keyFor: function keyFor(item) {
      return normalizedId(item);
    }
  }
};

/* script */
var __vue_script__$1M = script$1M;
/* template */

var __vue_render__$1E = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('ul', {
    staticClass: "fd-side-nav__list"
  }, [_vm._l(_vm.normalizedItems, function (item) {
    return _c('fd-side-nav-item-provider', {
      key: _vm.keyFor(item),
      attrs: {
        "item": item
      }
    }, [_vm._t("item", null, null, item)], 2);
  })], 2);
};

var __vue_staticRenderFns__$1E = [];
/* style */

var __vue_inject_styles__$1M = undefined;
/* scoped */

var __vue_scope_id__$1M = undefined;
/* module identifier */

var __vue_module_identifier__$1M = undefined;
/* functional template */

var __vue_is_functional_template__$1M = false;
/* style inject */

/* style inject SSR */

var SideNavList = normalizeComponent_1({
  render: __vue_render__$1E,
  staticRenderFns: __vue_staticRenderFns__$1E
}, __vue_inject_styles__$1M, __vue_script__$1M, __vue_scope_id__$1M, __vue_is_functional_template__$1M, __vue_module_identifier__$1M, undefined, undefined);

//
var script$1N = {
  name: "FdSideNavLink",
  props: {
    asRouterLink: {
      type: Boolean,
      default: false
    }
  },
  inheritAttrs: false,
  inject: ["fdItemProvider", "sideNavStore"],
  computed: {
    item: function item() {
      return this.fdItemProvider.item;
    },
    itemId: function itemId() {
      return normalizedId(this.item);
    },
    childItems: function childItems() {
      return normalizedChildren(this.item);
    },
    expandable: function expandable() {
      return this.childItems.length > 0;
    },
    isExpaned: function isExpaned() {
      return this.store.itemWithIdIsExpanded(this.itemId);
    },
    store: function store() {
      return this.sideNavStore;
    },
    selected: function selected() {
      return this.store.itemWithIdIsSelected(this.itemId);
    },
    routerLinkClasses: function routerLinkClasses() {
      return {
        "has-child": this.expandable
      };
    },
    classes: function classes() {
      return {
        "has-child": this.expandable,
        "is-selected": this.selected
      };
    }
  },
  methods: {
    selectSelf: function selectSelf() {
      this.store.selectedId = this.itemId;

      if (this.expandable) {
        this.store.toggleExpandedForItemWithId(this.itemId);
      }
    }
  }
};

/* script */
var __vue_script__$1N = script$1N;
/* template */

var __vue_render__$1F = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _vm.asRouterLink ? _c('router-link', _vm._b({
    staticClass: "fd-side-nav__link",
    class: _vm.routerLinkClasses,
    attrs: {
      "aria-selected": String(_vm.selected),
      "aria-expanded": String(_vm.isExpaned),
      "exact-active-class": "is-selected"
    },
    nativeOn: {
      "click": function click($event) {
        return _vm.selectSelf($event);
      }
    }
  }, 'router-link', _vm.$attrs, false), [_vm._t("default")], 2) : _c('a', {
    staticClass: "fd-side-nav__link",
    class: _vm.classes,
    attrs: {
      "href": "#",
      "aria-selected": String(_vm.selected),
      "aria-expanded": String(_vm.isExpaned)
    },
    on: {
      "click": function click($event) {
        $event.stopPropagation();
        $event.preventDefault();
        return _vm.selectSelf($event);
      }
    }
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1F = [];
/* style */

var __vue_inject_styles__$1N = undefined;
/* scoped */

var __vue_scope_id__$1N = undefined;
/* module identifier */

var __vue_module_identifier__$1N = undefined;
/* functional template */

var __vue_is_functional_template__$1N = false;
/* style inject */

/* style inject SSR */

var SideNavLink = normalizeComponent_1({
  render: __vue_render__$1F,
  staticRenderFns: __vue_staticRenderFns__$1F
}, __vue_inject_styles__$1N, __vue_script__$1N, __vue_scope_id__$1N, __vue_is_functional_template__$1N, __vue_module_identifier__$1N, undefined, undefined);

//
var script$1O = {
  name: "FdSideNavItem",
  components: {
    FdSideNavSubList: SideNavSubList
  },
  provide: function provide() {
    return {
      sideNavItem: Vue$1.observable({
        id: this.item.id,
        expandable: this.expandable
      })
    };
  },
  inject: ["fdItemProvider", "sideNavStore"],
  computed: {
    item: function item() {
      return this.fdItemProvider.item;
    },
    expandable: function expandable() {
      return this.hasChildItems;
    },
    hasChildItems: function hasChildItems() {
      return this.childItems.length > 0;
    },
    childItems: function childItems() {
      return normalizedChildren(this.item);
    },
    itemId: function itemId() {
      return this.item.id;
    },
    store: function store() {
      return this.sideNavStore;
    }
  }
};

/* script */
var __vue_script__$1O = script$1O;
/* template */

var __vue_render__$1G = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('li', {
    staticClass: "fd-side-nav__item"
  }, [_vm._t("default"), _vm._v(" "), _c('fd-side-nav-sub-list', {
    attrs: {
      "items": _vm.childItems
    },
    scopedSlots: _vm._u([{
      key: "subItem",
      fn: function fn(subItem) {
        return [_vm._t("subItem", null, null, subItem)];
      }
    }], null, true)
  })], 2);
};

var __vue_staticRenderFns__$1G = [];
/* style */

var __vue_inject_styles__$1O = undefined;
/* scoped */

var __vue_scope_id__$1O = undefined;
/* module identifier */

var __vue_module_identifier__$1O = undefined;
/* functional template */

var __vue_is_functional_template__$1O = false;
/* style inject */

/* style inject SSR */

var SideNavItem = normalizeComponent_1({
  render: __vue_render__$1G,
  staticRenderFns: __vue_staticRenderFns__$1G
}, __vue_inject_styles__$1O, __vue_script__$1O, __vue_scope_id__$1O, __vue_is_functional_template__$1O, __vue_module_identifier__$1O, undefined, undefined);

//
//
//
//
//
//
var script$1P = {
  name: "FdSideNav",
  provide: function provide() {
    return {
      sideNavStore: this.sideNavStore
    };
  },
  props: {
    selectedId: {
      type: String,
      default: null
    }
  },
  computed: {
    expandedIds: {
      set: function set(expandedIds) {
        this.sideNavStore.expandedIds = expandedIds;
      },
      get: function get() {
        return this.sideNavStore.expandedIds;
      }
    },
    store: function store() {
      return this.sideNavStore;
    },
    selectedId_: {
      set: function set(newValue) {
        this.store.selectedId = newValue;
      },
      get: function get() {
        return this.store.selectedId;
      }
    }
  },
  methods: {
    itemWithIdIsExpanded: function itemWithIdIsExpanded(id) {
      return this.expandedIds.indexOf(id) >= 0;
    },
    itemWithIdIsSelected: function itemWithIdIsSelected(id) {
      return id === this.selectedId_;
    },
    expandItemWithId: function expandItemWithId(id) {
      this.expandedIds = [].concat(_toConsumableArray(this.expandedIds), [id]);
    },
    collapseItemWithId: function collapseItemWithId(id) {
      this.expandedIds = _toConsumableArray(this.expandedIds.filter(function (expandedId) {
        return expandedId !== id;
      }));
    },
    toggleExpandedForItemWithId: function toggleExpandedForItemWithId(itemId) {
      var expandedIds = this.expandedIds;
      var needsToBeExpanded = expandedIds.indexOf(itemId) < 0;
      needsToBeExpanded ? this.expandItemWithId(itemId) : this.collapseItemWithId(itemId);
    }
  },
  watch: {
    selectedId: {
      immediate: true,
      handler: function handler(newId) {
        this.selectedId_ = newId;
      }
    }
  },
  data: function data() {
    return {
      sideNavStore: {
        toggleExpandedForItemWithId: this.toggleExpandedForItemWithId,
        expandedIds: [],
        selectedId: this.selectedId_,
        itemWithIdIsExpanded: this.itemWithIdIsExpanded,
        itemWithIdIsSelected: this.itemWithIdIsSelected
      }
    };
  }
};

/* script */
var __vue_script__$1P = script$1P;
/* template */

var __vue_render__$1H = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('nav', {
    staticClass: "fd-side-nav"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1H = [];
/* style */

var __vue_inject_styles__$1P = undefined;
/* scoped */

var __vue_scope_id__$1P = undefined;
/* module identifier */

var __vue_module_identifier__$1P = undefined;
/* functional template */

var __vue_is_functional_template__$1P = false;
/* style inject */

/* style inject SSR */

var SideNav = normalizeComponent_1({
  render: __vue_render__$1H,
  staticRenderFns: __vue_staticRenderFns__$1H
}, __vue_inject_styles__$1P, __vue_script__$1P, __vue_scope_id__$1P, __vue_is_functional_template__$1P, __vue_module_identifier__$1P, undefined, undefined);

var SideNav$1 = pluginify(SideNav, SideNavGroupTitle, SideNavGroup, SideNavIcon, SideNavList, SideNavItem, SideNavSubItem, SideNavLink, SideNavSubLink, SideNavSubList);

//
//
//
//
//
//
var script$1Q = {
  name: "FdSpinner",
  props: {
    ariaLabel: {
      type: String,
      default: "Loading"
    }
  }
};

/* script */
var __vue_script__$1Q = script$1Q;
/* template */

var __vue_render__$1I = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-spinner",
    attrs: {
      "aria-hidden": "false",
      "aria-label": _vm.ariaLabel
    }
  }, [_c('div')]);
};

var __vue_staticRenderFns__$1I = [];
/* style */

var __vue_inject_styles__$1Q = undefined;
/* scoped */

var __vue_scope_id__$1Q = undefined;
/* module identifier */

var __vue_module_identifier__$1Q = undefined;
/* functional template */

var __vue_is_functional_template__$1Q = false;
/* style inject */

/* style inject SSR */

var FdSpinner = normalizeComponent_1({
  render: __vue_render__$1I,
  staticRenderFns: __vue_staticRenderFns__$1I
}, __vue_inject_styles__$1Q, __vue_script__$1Q, __vue_scope_id__$1Q, __vue_is_functional_template__$1Q, __vue_module_identifier__$1Q, undefined, undefined);

var Spinner = pluginify(FdSpinner);

//
//
//
//
//
//
var typeMapping$2 = {
  warning: "warning",
  error: "error",
  success: "success"
};
var statusIconMapping = {
  available: "available",
  away: "away",
  busy: "busy",
  offline: "offline"
};
var StatusTypes = Object.keys(typeMapping$2);

var isStatusType = function isStatusType(value) {
  return StatusTypes.indexOf(value) >= 0;
};

var StatusIconTypes = Object.keys(statusIconMapping);

var isStatusIcon = function isStatusIcon(value) {
  return StatusIconTypes.indexOf(value) >= 0;
};

var script$1R = {
  name: "FdStatus",
  props: {
    statusIcon: {
      type: String,
      default: null,
      validator: isStatusIcon
    },
    type: {
      type: String,
      default: null,
      validator: isStatusType
    },
    icon: {
      type: String,
      default: null
    }
  },
  computed: {
    iconClasses: function iconClasses() {
      var icon = this.icon;

      if (icon == null) {
        return {};
      }

      return _defineProperty({}, "sap-icon--".concat(icon), true);
    },
    classes: function classes() {
      return _objectSpread2({
        "fd-status-label": true,
        "fd-status-label--success": this.type === "success",
        "fd-status-label--warning": this.type === "warning",
        "fd-status-label--error": this.type === "error",
        "fd-status-label--available": this.statusIcon === "available",
        "fd-status-label--away": this.statusIcon === "away",
        "fd-status-label--busy": this.statusIcon === "busy",
        "fd-status-label--offline": this.statusIcon === "offline"
      }, this.iconClasses);
    }
  }
};

/* script */
var __vue_script__$1R = script$1R;
/* template */

var __vue_render__$1J = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('span', {
    class: _vm.classes
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1J = [];
/* style */

var __vue_inject_styles__$1R = undefined;
/* scoped */

var __vue_scope_id__$1R = undefined;
/* module identifier */

var __vue_module_identifier__$1R = undefined;
/* functional template */

var __vue_is_functional_template__$1R = false;
/* style inject */

/* style inject SSR */

var Status = normalizeComponent_1({
  render: __vue_render__$1J,
  staticRenderFns: __vue_staticRenderFns__$1J
}, __vue_inject_styles__$1R, __vue_script__$1R, __vue_scope_id__$1R, __vue_is_functional_template__$1R, __vue_module_identifier__$1R, undefined, undefined);

var Status$1 = pluginify(Status);

//
var script$1S = {
  name: "FdSplitButtonAuxiliary",
  components: {
    FdButton: Button
  },
  inject: ["splitButton"],
  computed: {
    state: function state() {
      return this.splitButton.state;
    },
    type: function type() {
      return this.splitButton.type;
    },
    styling: function styling() {
      return this.splitButton.styling;
    },
    compact: function compact() {
      return this.splitButton.disacompactbled;
    }
  }
};

/* script */
var __vue_script__$1S = script$1S;
/* template */

var __vue_render__$1K = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('fd-button', _vm._g(_vm._b({
    staticClass: "fd-button sap-icon--slim-arrow-down",
    attrs: {
      "aria-label": "More",
      "state": _vm.state,
      "type": _vm.type,
      "styling": _vm.styling,
      "compact": _vm.compact
    }
  }, 'fd-button', _vm.$attrs, false), _vm.$listeners), [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1K = [];
/* style */

var __vue_inject_styles__$1S = undefined;
/* scoped */

var __vue_scope_id__$1S = undefined;
/* module identifier */

var __vue_module_identifier__$1S = undefined;
/* functional template */

var __vue_is_functional_template__$1S = false;
/* style inject */

/* style inject SSR */

var SplitButtonAuxiliary = normalizeComponent_1({
  render: __vue_render__$1K,
  staticRenderFns: __vue_staticRenderFns__$1K
}, __vue_inject_styles__$1S, __vue_script__$1S, __vue_scope_id__$1S, __vue_is_functional_template__$1S, __vue_module_identifier__$1S, undefined, undefined);

//
var script$1T = {
  name: "FdSplitButtonAction",
  components: {
    FdButton: Button
  },
  inject: ["splitButton"],
  computed: {
    state: function state() {
      return this.splitButton.state;
    },
    type: function type() {
      return this.splitButton.type;
    },
    styling: function styling() {
      return this.splitButton.styling;
    },
    compact: function compact() {
      return this.splitButton.disacompactbled;
    },
    icon: function icon() {
      return this.splitButton.icon;
    }
  }
};

/* script */
var __vue_script__$1T = script$1T;
/* template */

var __vue_render__$1L = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('fd-button', _vm._g(_vm._b({
    attrs: {
      "state": _vm.state,
      "type": _vm.type,
      "styling": _vm.styling,
      "compact": _vm.compact,
      "icon": _vm.icon
    }
  }, 'fd-button', _vm.$attrs, false), _vm.$listeners), [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1L = [];
/* style */

var __vue_inject_styles__$1T = undefined;
/* scoped */

var __vue_scope_id__$1T = undefined;
/* module identifier */

var __vue_module_identifier__$1T = undefined;
/* functional template */

var __vue_is_functional_template__$1T = false;
/* style inject */

/* style inject SSR */

var SplitButtonAction = normalizeComponent_1({
  render: __vue_render__$1L,
  staticRenderFns: __vue_staticRenderFns__$1L
}, __vue_inject_styles__$1T, __vue_script__$1T, __vue_scope_id__$1T, __vue_is_functional_template__$1T, __vue_module_identifier__$1T, undefined, undefined);

//
var script$1U = {
  name: "FdSplitButton",
  mixins: [IconMixin],
  components: {
    FdSplitButtonAction: SplitButtonAction,
    FdSplitButtonAuxiliary: SplitButtonAuxiliary
  },
  provide: function provide() {
    return {
      splitButton: this.splitButton
    };
  },
  computed: {
    slotProps: function slotProps() {
      return this.splitButton;
    }
  },
  props: {
    compact: Boolean,
    styling: {
      type: String,
      default: null,
      validator: function validator(value) {
        return ["emphasized", "light"].indexOf(value) >= 0;
      }
    },
    state: {
      type: String,
      default: "normal",
      validator: function validator(value) {
        return ["normal", "selected", "disabled"].indexOf(value) >= 0;
      }
    },
    type: {
      type: String,
      default: null,
      validator: function validator(value) {
        return ButtonTypes.indexOf(value) >= 0;
      }
    }
  },
  watch: {
    state: function state(_state) {
      this.splitButton.state = _state;
    },
    type: function type(_type) {
      this.splitButton.type = _type;
    },
    styling: function styling(_styling) {
      this.splitButton.styling = _styling;
    },
    compact: function compact(_compact) {
      this.splitButton.compact = _compact;
    },
    icon: function icon(_icon) {
      this.splitButton.icon = _icon;
    }
  },
  data: function data() {
    return {
      splitButton: Vue$1.observable({
        state: this.state,
        type: this.type,
        styling: this.styling,
        compact: this.compact,
        icon: this.icon
      })
    };
  }
};

/* script */
var __vue_script__$1U = script$1U;
/* template */

var __vue_render__$1M = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-button-split",
    attrs: {
      "role": "group"
    }
  }, [_vm._t("action", [_c('fd-split-button-action', {
    on: {
      "click": function click($event) {
        return _vm.$emit('click');
      }
    }
  }, [_vm._t("default")], 2)], null, _vm.slotProps), _vm._v(" "), _vm._t("auxiliary", [_c('fd-split-button-auxiliary', {
    on: {
      "click": function click($event) {
        return _vm.$emit('click:auxiliary');
      }
    }
  })], null, _vm.slotProps)], 2);
};

var __vue_staticRenderFns__$1M = [];
/* style */

var __vue_inject_styles__$1U = undefined;
/* scoped */

var __vue_scope_id__$1U = undefined;
/* module identifier */

var __vue_module_identifier__$1U = undefined;
/* functional template */

var __vue_is_functional_template__$1U = false;
/* style inject */

/* style inject SSR */

var SplitButton = normalizeComponent_1({
  render: __vue_render__$1M,
  staticRenderFns: __vue_staticRenderFns__$1M
}, __vue_inject_styles__$1U, __vue_script__$1U, __vue_scope_id__$1U, __vue_is_functional_template__$1U, __vue_module_identifier__$1U, undefined, undefined);

var SplitButton$1 = pluginify(SplitButton);

var SplitButtonAuxiliary$1 = pluginify(SplitButtonAuxiliary);

var SplitButtonAction$1 = pluginify(SplitButtonAction);

//
//
//
//
//
//
var script$1V = {
  name: "FdTableBody"
};

/* script */
var __vue_script__$1V = script$1V;
/* template */

var __vue_render__$1N = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('tbody', [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1N = [];
/* style */

var __vue_inject_styles__$1V = undefined;
/* scoped */

var __vue_scope_id__$1V = undefined;
/* module identifier */

var __vue_module_identifier__$1V = undefined;
/* functional template */

var __vue_is_functional_template__$1V = false;
/* style inject */

/* style inject SSR */

var TableBody = normalizeComponent_1({
  render: __vue_render__$1N,
  staticRenderFns: __vue_staticRenderFns__$1N
}, __vue_inject_styles__$1V, __vue_script__$1V, __vue_scope_id__$1V, __vue_is_functional_template__$1V, __vue_module_identifier__$1V, undefined, undefined);

// Renders a single table cell.
var script$1W = {
  name: "FdTableCell",
  props: {
    // Override the scope for this specific cell – used for a11y-related things.
    // The scope is automatically set for you – use this prop only if you have special needs.
    scope: {
      // `col` / `row` / `null`
      type: String,
      validator: function validator(value) {
        return value === "col" || value === "row";
      },
      // `null`
      default: null
    },
    // Whether or not this cell is rendered inside in a fixed column.
    // `fixed` is automatically set for you – use this prop only if you have special needs.
    fixed: {
      type: Boolean,
      default: false
    }
  },
  inject: {
    fdTableFixedProvider: {
      default: {
        fixed: null
      }
    }
  },
  render: function render(h) {
    var fixed_ = this.fixed_,
        style = this.style,
        classes = this.classes,
        $slots = this.$slots;
    var tag = fixed_ ? "th" : "td";
    var attrs = fixed_ ? {
      scope: this.scope_
    } : {};
    return h(tag, {
      attrs: attrs,
      style: style,
      class: classes
    }, $slots.default);
  },
  computed: {
    scope_: function scope_() {
      var scope = this.scope,
          fixed_ = this.fixed_;

      if (scope != null) {
        return scope;
      }

      return fixed_ ? "row" : null;
    },
    fixed_: function fixed_() {
      var fixed = this.fixed,
          fdTableFixedProvider = this.fdTableFixedProvider;
      return fdTableFixedProvider.fixed != null ? fdTableFixedProvider.fixed : fixed;
    },
    style: function style() {
      return this.fixed_ ? {
        left: "0",
        width: "200px"
      } : {};
    },
    classes: function classes() {
      var fixed_ = this.fixed_;

      if (!fixed_) {
        return null;
      }

      return {
        "fd-table__fixed-col": fixed_
      };
    }
  }
};

/* script */
var __vue_script__$1W = script$1W;
/* template */

/* style */

var __vue_inject_styles__$1W = undefined;
/* scoped */

var __vue_scope_id__$1W = undefined;
/* module identifier */

var __vue_module_identifier__$1W = undefined;
/* functional template */

var __vue_is_functional_template__$1W = undefined;
/* style inject */

/* style inject SSR */

var TableCell = normalizeComponent_1({}, __vue_inject_styles__$1W, __vue_script__$1W, __vue_scope_id__$1W, __vue_is_functional_template__$1W, __vue_module_identifier__$1W, undefined, undefined);

var SortOrder = {
  ascending: "ascending",
  descending: "descending"
};
var toggleSortOrder = function toggleSortOrder(order) {
  return order === SortOrder.ascending ? SortOrder.descending : SortOrder.ascending;
};

var TextAlignment = {
  default: "default",
  center: "center"
};
var TextAlignments = Object.keys(TextAlignment);
var isTextAlignment = function isTextAlignment(value) {
  return TextAlignments.indexOf(value) >= 0;
};

//
var script$1X = {
  name: "FdTableHeaderCell",
  props: {
    label: {
      type: String,
      default: null
    },
    alignment: {
      type: String,
      default: TextAlignment.default,
      validator: isTextAlignment
    },
    sortOrder: {
      type: String,
      default: null
    },
    sortable: {
      type: Boolean,
      default: false
    },
    sortBy: {
      type: String,
      default: null
    },
    columnFixed: {
      type: Boolean,
      default: null
    }
  },
  computed: {
    classes: function classes() {
      var sortOrder = this.sortOrder;
      return {
        "fd-has-text-align-center": this.alignment === TextAlignment.center,
        "fd-table__sort-column": this.sortable,
        "fd-table__sort-column--dsc": sortOrder === SortOrder.descending,
        "fd-table__sort-column--asc": sortOrder === SortOrder.ascending,
        "fd-table__fixed-col": this.columnFixed
      };
    },
    styles: function styles() {
      return this.columnFixed ? {
        left: 0,
        width: "200px"
      } : {};
    }
  }
};

/* script */
var __vue_script__$1X = script$1X;
/* template */

var __vue_render__$1O = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('th', _vm._g({
    class: _vm.classes,
    style: _vm.styles,
    attrs: {
      "scope": "col"
    }
  }, _vm.$listeners), [_vm._v("\n  " + _vm._s(_vm.label) + "\n  "), _vm._t("default")], 2);
};

var __vue_staticRenderFns__$1O = [];
/* style */

var __vue_inject_styles__$1X = undefined;
/* scoped */

var __vue_scope_id__$1X = undefined;
/* module identifier */

var __vue_module_identifier__$1X = undefined;
/* functional template */

var __vue_is_functional_template__$1X = false;
/* style inject */

/* style inject SSR */

var TableHeaderCell = normalizeComponent_1({
  render: __vue_render__$1O,
  staticRenderFns: __vue_staticRenderFns__$1O
}, __vue_inject_styles__$1X, __vue_script__$1X, __vue_scope_id__$1X, __vue_is_functional_template__$1X, __vue_module_identifier__$1X, undefined, undefined);

//
var script$1Y = {
  name: "FdTableHeader",
  components: {
    TableHeaderCell: TableHeaderCell
  },
  props: {
    headers: {
      type: Array,
      default: function _default() {
        return [];
      }
    },
    sortDescriptor: {
      type: Object,
      default: null
    }
  },
  methods: {
    sortOrder: function sortOrder(header) {
      var sortDescriptor = this.sortDescriptor;
      var sortedColumnId = sortDescriptor && sortDescriptor.columnId;

      if (sortedColumnId == null) {
        return null;
      }

      if (header.id !== sortedColumnId) {
        return null;
      }

      return sortDescriptor && sortDescriptor.order;
    }
  }
};

/* script */
var __vue_script__$1Y = script$1Y;
/* template */

var __vue_render__$1P = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('thead', [_c('tr', _vm._l(_vm.headers, function (header) {
    return _c('TableHeaderCell', {
      key: header.id,
      attrs: {
        "label": header.label,
        "sortable": header.sortable,
        "sortBy": header.sortBy,
        "sortOrder": _vm.sortOrder(header),
        "columnFixed": header.columnFixed
      },
      on: {
        "click": function click($event) {
          return _vm.$emit('click:column', header.id);
        }
      }
    });
  }), 1)]);
};

var __vue_staticRenderFns__$1P = [];
/* style */

var __vue_inject_styles__$1Y = undefined;
/* scoped */

var __vue_scope_id__$1Y = undefined;
/* module identifier */

var __vue_module_identifier__$1Y = undefined;
/* functional template */

var __vue_is_functional_template__$1Y = false;
/* style inject */

/* style inject SSR */

var TableHeader = normalizeComponent_1({
  render: __vue_render__$1P,
  staticRenderFns: __vue_staticRenderFns__$1P
}, __vue_inject_styles__$1Y, __vue_script__$1Y, __vue_scope_id__$1Y, __vue_is_functional_template__$1Y, __vue_module_identifier__$1Y, undefined, undefined);

var script$1Z = {
  props: {
    fixed: {
      type: Boolean,
      required: true
    }
  },
  provide: function provide() {
    return {
      fdTableFixedProvider: this.fdTableFixedProvider
    };
  },
  render: function render() {
    var defaultSlot = this.$scopedSlots.default;

    if (defaultSlot == null) {
      return null;
    }

    return defaultSlot();
  },
  watch: {
    fixed: function fixed(_fixed) {
      this.fdTableFixedProvider.fixed = _fixed;
    }
  },
  data: function data() {
    return {
      fdTableFixedProvider: {
        fixed: this.fixed
      }
    };
  }
};

/* script */
var __vue_script__$1Z = script$1Z;
/* template */

/* style */

var __vue_inject_styles__$1Z = undefined;
/* scoped */

var __vue_scope_id__$1Z = undefined;
/* module identifier */

var __vue_module_identifier__$1Z = undefined;
/* functional template */

var __vue_is_functional_template__$1Z = undefined;
/* style inject */

/* style inject SSR */

var FdTableCellFixedProvider = normalizeComponent_1({}, __vue_inject_styles__$1Z, __vue_script__$1Z, __vue_scope_id__$1Z, __vue_is_functional_template__$1Z, __vue_module_identifier__$1Z, undefined, undefined);

//
var script$1_ = {
  name: "FdTableRow",
  components: {
    FdTableCellFixedProvider: FdTableCellFixedProvider
  },
  inject: {
    fdTableItemProvider: {
      default: {
        item: {},
        selected: null
      }
    },
    table: {
      default: null
    }
  },
  props: {
    item: {
      type: Object,
      default: function _default() {}
    },
    selected: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    selected_: function selected_() {
      var selected = this.selected,
          fdTableItemProvider = this.fdTableItemProvider;
      return fdTableItemProvider.selected != null ? fdTableItemProvider.selected : selected;
    },
    normalizedHeaders: function normalizedHeaders() {
      return this.table.normalizedHeaders;
    }
  }
};

/* script */
var __vue_script__$1_ = script$1_;
/* template */

var __vue_render__$1Q = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('tr', _vm._g({
    attrs: {
      "aria-selected": String(_vm.selected_)
    }
  }, _vm.$listeners), [_vm._l(_vm.normalizedHeaders, function (header) {
    return [_c('fd-table-cell-fixed-provider', {
      key: header.id,
      attrs: {
        "fixed": header.columnFixed
      }
    }, [_vm._t(header.slotName)], 2)];
  })], 2);
};

var __vue_staticRenderFns__$1Q = [];
/* style */

var __vue_inject_styles__$1_ = undefined;
/* scoped */

var __vue_scope_id__$1_ = undefined;
/* module identifier */

var __vue_module_identifier__$1_ = undefined;
/* functional template */

var __vue_is_functional_template__$1_ = false;
/* style inject */

/* style inject SSR */

var TableRow = normalizeComponent_1({
  render: __vue_render__$1Q,
  staticRenderFns: __vue_staticRenderFns__$1Q
}, __vue_inject_styles__$1_, __vue_script__$1_, __vue_scope_id__$1_, __vue_is_functional_template__$1_, __vue_module_identifier__$1_, undefined, undefined);

//
//
//
//
// Use this component together wit `fd-table-fixed` and `fd-table` in order to create a table with a fixed column. Example:
// ```xml
// <fd-table-fixed-wrapper>
//   <fd-table-fixed>
//     <fd-table />
//   </fd-table-fixed>
// </fd-table-fixed-wrapper>
// ```
var script$1$ = {
  name: "FdTableFixedWrapper"
};

/* script */
var __vue_script__$1$ = script$1$;
/* template */

var __vue_render__$1R = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-table--fixed-wrapper"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1R = [];
/* style */

var __vue_inject_styles__$1$ = undefined;
/* scoped */

var __vue_scope_id__$1$ = undefined;
/* module identifier */

var __vue_module_identifier__$1$ = undefined;
/* functional template */

var __vue_is_functional_template__$1$ = false;
/* style inject */

/* style inject SSR */

var FdTableFixedWrapper = normalizeComponent_1({
  render: __vue_render__$1R,
  staticRenderFns: __vue_staticRenderFns__$1R
}, __vue_inject_styles__$1$, __vue_script__$1$, __vue_scope_id__$1$, __vue_is_functional_template__$1$, __vue_module_identifier__$1$, undefined, undefined);

//
//
//
//
// Use this component together wit `fd-table-fixed-wrapper` and `fd-table` in order to create a table with a fixed column. Example:
// ```xml
// <fd-table-fixed-wrapper>
//   <fd-table-fixed>
//     <fd-table />
//   </fd-table-fixed>
// </fd-table-fixed-wrapper>
// ```
var script$20 = {
  name: "FdTableFixed"
};

/* script */
var __vue_script__$20 = script$20;
/* template */

var __vue_render__$1S = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-table--fixed"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1S = [];
/* style */

var __vue_inject_styles__$20 = undefined;
/* scoped */

var __vue_scope_id__$20 = undefined;
/* module identifier */

var __vue_module_identifier__$20 = undefined;
/* functional template */

var __vue_is_functional_template__$20 = false;
/* style inject */

/* style inject SSR */

var FdTableFixed = normalizeComponent_1({
  render: __vue_render__$1S,
  staticRenderFns: __vue_staticRenderFns__$1S
}, __vue_inject_styles__$20, __vue_script__$20, __vue_scope_id__$20, __vue_is_functional_template__$20, __vue_module_identifier__$20, undefined, undefined);

var normalizedHeader = function normalizedHeader(raw, columnFixed) {
  var headerObject = typeof raw === "string" ? {
    id: raw,
    label: raw
  } : raw;
  var label = headerObject.label,
      _headerObject$sortBy = headerObject.sortBy,
      sortBy = _headerObject$sortBy === void 0 ? null : _headerObject$sortBy,
      _headerObject$sortabl = headerObject.sortable,
      sortable = _headerObject$sortabl === void 0 ? false : _headerObject$sortabl,
      _headerObject$alignme = headerObject.alignment,
      alignment = _headerObject$alignme === void 0 ? TextAlignment.default : _headerObject$alignme,
      renderHeader = headerObject.renderHeader,
      _headerObject$id = headerObject.id,
      id = _headerObject$id === void 0 ? shortUuid() : _headerObject$id;
  return {
    id: id,
    sortBy: sortBy,
    sortable: sortable,
    label: label,
    slotName: id,
    alignment: alignment,
    columnFixed: columnFixed,
    renderHeader: renderHeader
  };
};
var _normalizedHeaders = (function (raw, firstColumnFixed) {
  return raw.map(function (header, index) {
    var columnFixed = firstColumnFixed && index === 0;
    return normalizedHeader(header, columnFixed);
  });
});

var isString = function isString(value) {
  return value != null && typeof value === "string";
};

var compareValues = (function (key, order) {
  return function (a, b) {
    if (!a.hasOwnProperty(key) || !b.hasOwnProperty(key)) {
      // Property [key] does not exist on a and/or b.
      return 0;
    }

    var varA = a[key];
    var varB = b[key];
    var comparison = 0;

    if (isString(varA) && isString(varB)) {
      comparison = varA.localeCompare(varB);
    } else {
      if (varA > varB) {
        comparison = 1;
      } else if (varA < varB) {
        comparison = -1;
      }
    }

    return order === "descending" ? comparison * -1 : comparison;
  };
});

var _normalizedItems = (function (rawItems) {
  return rawItems.map(function (raw) {
    var id = raw.hasOwnProperty("id") ? raw.id : shortUuid();
    return _objectSpread2({
      id: id
    }, raw);
  });
});

var SelectionMode = {
  single: "single",
  multiple: "multiple",
  none: "none"
};
var SelectionModes = Object.keys(SelectionMode);
var SelectionModeValidator = function SelectionModeValidator(value) {
  return SelectionModes.indexOf(value) >= 0;
};

var script$21 = {
  props: {
    item: {
      type: Object,
      required: true
    },
    selected: {
      type: Boolean,
      require: true
    }
  },
  provide: function provide() {
    return {
      fdTableItemProvider: this.fdTableItemProvider
    };
  },
  render: function render() {
    return this.$scopedSlots.default();
  },
  watch: {
    selected: function selected(_selected) {
      this.fdTableItemProvider.selected = _selected;
    },
    item: function item(_item) {
      this.fdTableItemProvider.item = _item;
    }
  },
  data: function data() {
    return {
      fdTableItemProvider: {
        item: this.item,
        selected: this.selected
      }
    };
  }
};

/* script */
var __vue_script__$21 = script$21;
/* template */

/* style */

var __vue_inject_styles__$21 = undefined;
/* scoped */

var __vue_scope_id__$21 = undefined;
/* module identifier */

var __vue_module_identifier__$21 = undefined;
/* functional template */

var __vue_is_functional_template__$21 = undefined;
/* style inject */

/* style inject SSR */

var FdTableItemProvider = normalizeComponent_1({}, __vue_inject_styles__$21, __vue_script__$21, __vue_scope_id__$21, __vue_is_functional_template__$21, __vue_module_identifier__$21, undefined, undefined);

var SELECT_ACTION = {
  deselect: "deselect",
  select: "select"
}; // A table component used to display tabluar data.

var script$22 = {
  name: "FdTable",
  components: {
    FdTableBody: TableBody,
    FdTableHeader: TableHeader,
    FdTableItemProvider: FdTableItemProvider
  },
  provide: function provide() {
    return {
      table: this
    };
  },
  watch: {
    computedSelectedIds: {
      immediate: true,
      handler: function handler(computedSelectedIds) {
        this.$emit("update:selectedIds", computedSelectedIds);
      }
    }
  },
  props: {
    // Headers of the table
    headers: {
      // Either an array with plain strings. For each string in the headers-array you have to provide a scoped-slot of the same name. You can also pass in header objects instead of strings to customize the headers. Refer to the table guide for more details.
      type: Array,
      // `[]` (empty array)
      default: function _default() {
        return [];
      }
    },
    firstColumnFixed: {
      type: Boolean,
      default: false
    },
    // If `true` no border is drawn around the table.
    borderless: {
      type: Boolean,
      default: false
    },
    // If `true` tables are drawn with an alternating background color.
    striped: {
      type: Boolean,
      default: false
    },
    // Items to be displayed in the table.
    items: {
      type: Array,
      // `[]` (empty array)
      default: function _default() {
        return [];
      }
    },
    // Ids of selected items.
    selectedIds: {
      type: Array,
      // `[]` (empty array)
      default: function _default() {
        return [];
      }
    },
    // Selection mode
    selectionMode: {
      // - `none`: no selection possible
      // - `single`: single row can be selected
      // - `multiple`: multiple rows can be selected
      type: String,
      validator: SelectionModeValidator,
      // `none` – selecting rows is not possible by default
      default: SelectionMode.none
    }
  },
  computed: {
    computedSelectedIds: function computedSelectedIds() {
      var selectionMode = this.selectionMode,
          selectedIds_ = this.selectedIds_;

      switch (selectionMode) {
        case SelectionMode.single:
          {
            var isInvalid = selectedIds_.length > 1;

            if (isInvalid) {
              return selectedIds_[0];
            }

            return withoutDuplicates(selectedIds_);
          }

        case SelectionMode.none:
          {
            return [];
          }

        default:
          {
            return withoutDuplicates(selectedIds_);
          }
      }
    },
    normalizedItems: function normalizedItems() {
      var items = this.items,
          sortDescriptor = this.sortDescriptor;

      var result = _toConsumableArray(_normalizedItems(items));

      if (sortDescriptor == null) {
        return result;
      }

      return result.sort(compareValues(sortDescriptor.prop, sortDescriptor.order));
    },
    normalizedHeaders: function normalizedHeaders() {
      return _normalizedHeaders(this.headers, this.firstColumnFixed);
    },
    classes: function classes() {
      return {
        "fd-table--striped": this.striped,
        "fd-table--no-borders": this.borderless
      };
    },
    canSelect: function canSelect() {
      return this.selectionMode !== SelectionMode.none;
    },
    sortedByColumnId: function sortedByColumnId() {
      var sortDescriptor = this.sortDescriptor;

      if (sortDescriptor == null) {
        return null;
      }

      return sortDescriptor.columnId;
    }
  },
  methods: {
    keyForItem: function keyForItem(item) {
      return item.id;
    },
    onColumnClick: function onColumnClick(columnId) {
      var column = this.normalizedHeaders.find(function (_ref) {
        var id = _ref.id;
        return id === columnId;
      });

      if (column == null) {
        return;
      }

      var sortBy = column.sortBy;

      if (sortBy == null) {
        return;
      }

      this.sortBy(sortBy, columnId);
    },
    execute: function execute(action, id) {
      switch (this.selectionMode) {
        case SelectionMode.none:
          {
            this.selectedIds_ = [];
            break;
          }

        case SelectionMode.multiple:
          {
            if (action === SELECT_ACTION.select) {
              this.selectedIds_ = [id].concat(_toConsumableArray(this.selectedIds_));
            } else {
              var newIds = _toConsumableArray(this.selectedIds_).filter(function (selectedId) {
                return selectedId !== id;
              });

              this.selectedIds_ = newIds;
            }

            break;
          }

        case SelectionMode.single:
          {
            this.selectedIds_ = action === SELECT_ACTION.deselect ? [] : [id];
            break;
          }
      }
    },
    $_rowPropsToggle: function $_rowPropsToggle(item) {
      var _this = this;

      return function () {
        return _this.toggleSelectionForItem(item);
      };
    },
    $_rowPropsSetSelected: function $_rowPropsSetSelected(item) {
      var _this2 = this;

      return function (selected) {
        if (selected) {
          _this2.execute(SELECT_ACTION.select, item.id);
        } else {
          _this2.execute(SELECT_ACTION.deselect, item.id);
        }
      };
    },
    toggleSelectionForItem: function toggleSelectionForItem(item) {
      this.toggleSelectionForItemWithId(item.id);
    },
    toggleSelectionForItemWithId: function toggleSelectionForItemWithId(id) {
      var isSelected = this.selectedIds_.indexOf(id) >= 0;

      if (isSelected) {
        this.execute(SELECT_ACTION.deselect, id);
      } else {
        this.execute(SELECT_ACTION.select, id);
      }
    },
    isSelected: function isSelected(id) {
      return this.computedSelectedIds.indexOf(id) >= 0;
    },
    sortOrder: function sortOrder(columnId) {
      if (this.sortedByColumnId !== columnId) {
        return null;
      }

      var sortDescriptor = this.sortDescriptor;

      if (sortDescriptor == null) {
        return null;
      }

      return sortDescriptor.order;
    },
    sortBy: function sortBy(_sortBy, columnId) {
      var needsToggle = this.sortedByColumnId === columnId;

      var _ref2 = this.sortDescriptor || {},
          _ref2$order = _ref2.order,
          order = _ref2$order === void 0 ? SortOrder.ascending : _ref2$order;

      var newOrder = needsToggle ? toggleSortOrder(order) : order;
      this.sortDescriptor = {
        columnId: columnId,
        prop: _sortBy,
        order: newOrder
      };
    }
  },
  data: function data() {
    return {
      sortDescriptor: null,
      selectedIds_: this.selectedIds
    };
  }
};

/* script */
var __vue_script__$22 = script$22;
/* template */

var __vue_render__$1T = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('table', {
    staticClass: "fd-table",
    class: _vm.classes
  }, [_c('fd-table-header', {
    attrs: {
      "sortDescriptor": _vm.sortDescriptor,
      "headers": _vm.normalizedHeaders
    },
    on: {
      "click:column": _vm.onColumnClick
    }
  }), _vm._v(" "), _c('fd-table-body', [_vm._l(_vm.normalizedItems, function (item) {
    return [_c('fd-table-item-provider', {
      key: _vm.keyForItem(item),
      attrs: {
        "selected": _vm.isSelected(item.id),
        "item": item
      }
    }, [_vm._t("row", null, {
      "setSelected": _vm.$_rowPropsSetSelected(item),
      "toggle": _vm.$_rowPropsToggle(item),
      "item": item,
      "selectedIds": _vm.computedSelectedIds,
      "selected": _vm.isSelected(item.id),
      "canSelect": _vm.canSelect
    })], 2)];
  })], 2)], 1);
};

var __vue_staticRenderFns__$1T = [];
/* style */

var __vue_inject_styles__$22 = undefined;
/* scoped */

var __vue_scope_id__$22 = undefined;
/* module identifier */

var __vue_module_identifier__$22 = undefined;
/* functional template */

var __vue_is_functional_template__$22 = false;
/* style inject */

/* style inject SSR */

var FdTable = normalizeComponent_1({
  render: __vue_render__$1T,
  staticRenderFns: __vue_staticRenderFns__$1T
}, __vue_inject_styles__$22, __vue_script__$22, __vue_scope_id__$22, __vue_is_functional_template__$22, __vue_module_identifier__$22, undefined, undefined);

var Table = pluginify(FdTable, TableBody, TableCell, TableHeader, TableHeaderCell, TableRow, FdTableFixed, FdTableFixedWrapper);

var script$23 = {
  name: "FdTabs",
  provide: function provide() {
    return {
      tabs: this,
      store: this.store
    };
  },
  props: {
    value: String
  },
  computed: {
    activeName: {
      get: function get() {
        return this.store.activeName;
      },
      set: function set(newName) {
        this.store.activeName = newName;
      }
    }
  },
  watch: {
    value: {
      immediate: true,
      handler: function handler(newValue) {
        this.activeName = newValue;
      }
    }
  },
  methods: {
    onTabItemKeyup: function onTabItemKeyup(event, item) {
      if (event.defaultPrevented) {
        return;
      } // key is not supported everywhere (edge) this we check both values.


      var key = event.key || event.keyCode;
      var isEnter = key === "Enter" || key ===
      /* enter */
      13;

      if (isEnter) {
        this.activateTabItem(item);
        event.preventDefault();
      }
    },
    activateTabItem: function activateTabItem(item) {
      // Ignore disabled items
      if (item.disabled) {
        return;
      }

      this.activeName = item.name;
      this.$emit("input", item.name);
    },
    // TabItemContainer Implementation
    addTabItem: function addTabItem(item) {
      var index = (this.$slots.default || []).indexOf(item.$vnode);
      this.tabItems.splice(index, 0, item);
    },
    removeTabItem: function removeTabItem(item) {
      var tabItems = this.tabItems;
      var index = tabItems.indexOf(item);

      if (index > -1) {
        tabItems.splice(index, 1);
      }
    }
  },
  data: function data() {
    return {
      store: {
        activeName: ""
      },
      tabItems: []
    };
  },
  render: function render(h) {
    var activeName = this.activeName || "";
    var tabItems = this.tabItems.map(function (tabItem) {
      return tabItem.renderItem(activeName);
    });
    var tabList = h("ul", {
      class: "fd-tabs",
      attrs: {
        role: "tablist"
      }
    }, tabItems);
    return h("div", {}, [tabList, this.$slots.default]);
  }
};

/* script */
var __vue_script__$23 = script$23;
/* template */

/* style */

var __vue_inject_styles__$23 = undefined;
/* scoped */

var __vue_scope_id__$23 = undefined;
/* module identifier */

var __vue_module_identifier__$23 = undefined;
/* functional template */

var __vue_is_functional_template__$23 = undefined;
/* style inject */

/* style inject SSR */

var Tabs = normalizeComponent_1({}, __vue_inject_styles__$23, __vue_script__$23, __vue_scope_id__$23, __vue_is_functional_template__$23, __vue_module_identifier__$23, undefined, undefined);

//
var script$24 = {
  name: "FdTabItem",
  mixins: [Uid],
  inject: {
    store: {
      default: null
    },
    tabs: {
      default: null
    }
  },
  props: {
    label: {
      type: String,
      default: null
    },
    name: {
      type: String,
      default: null
    },
    disabled: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    ariaExpanded: function ariaExpanded() {
      return this.active ? "true" : "false";
    },
    active: function active() {
      return this.activeName === this.name;
    },
    activeName: {
      get: function get() {
        return this.store.activeName;
      },
      set: function set(newName) {
        this.store.activeName = newName;
      }
    }
  },
  mounted: function mounted() {
    var tabs = this.tabs;

    if (tabs != null) {
      tabs.addTabItem(this);
    }
  },
  destroyed: function destroyed() {
    var tabs = this.tabs;

    if (tabs != null) {
      tabs.removeTabItem(this);
    }
  },
  methods: {
    renderItem: function renderItem(current) {
      var active = current === this.name;
      var h = this.$createElement;
      var link = h("a", {
        class: "fd-tabs__link",
        attrs: {
          "aria-controls": this.uid,
          "aria-selected": active,
          "aria-disabled": this.disabled,
          role: "tab",
          tabIndex: 0
        },
        on: {
          click: this.onClick,
          keyup: this.onKeyup
        }
      }, this.label);
      return h("li", {
        class: "fd-tabs__item"
      }, [link]);
    },
    onClick: function onClick(event) {
      event.preventDefault();
      this.tabs != null && this.tabs.activateTabItem(this);
    },
    onKeyup: function onKeyup(event) {
      this.tabs != null && this.tabs.onTabItemKeyup(event, this);
    }
  }
};

/* script */
var __vue_script__$24 = script$24;
/* template */

var __vue_render__$1U = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-tabs__panel",
    attrs: {
      "id": _vm.uid,
      "role": "tabpanel",
      "aria-expanded": _vm.ariaExpanded
    }
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1U = [];
/* style */

var __vue_inject_styles__$24 = undefined;
/* scoped */

var __vue_scope_id__$24 = undefined;
/* module identifier */

var __vue_module_identifier__$24 = undefined;
/* functional template */

var __vue_is_functional_template__$24 = false;
/* style inject */

/* style inject SSR */

var TabItem = normalizeComponent_1({
  render: __vue_render__$1U,
  staticRenderFns: __vue_staticRenderFns__$1U
}, __vue_inject_styles__$24, __vue_script__$24, __vue_scope_id__$24, __vue_is_functional_template__$24, __vue_module_identifier__$24, undefined, undefined);

var Tabs$1 = pluginify(Tabs, TabItem);

//
//
//
//
//
//
//
//
//
//
//
// A tile component can be used to display information in a simple container format. This component is ideal for displaying collection data when a grid or list layout is preferred. See `fd-tile-grid` and `fd-virtualized-list`.
var script$25 = {
  name: "FdTile",
  props: {
    // If true, the file has no background color – it becomes transparent. This is used in combination with fd-virtualized-list in order to render rows. Since this prop relies on custom styles you have to include the Fundamental Vue supporting styles.
    transparent: {
      type: Boolean,
      default: false
    },
    // If true, the tile behaves like a button and emits `click` is not disabled.
    isButton: {
      type: Boolean,
      default: false
    },
    // Disables the tile.
    disabled: {
      type: Boolean,
      default: false
    },
    // Number of rows this tile spans when used inside `fd-tile-grid`
    rowSpan: {
      type: Number,
      default: null
    },
    // Number of columns this tile spans when used inside `fd-tile-grid`
    colSpan: {
      type: Number,
      default: null
    }
  },
  methods: {
    handleClick: function handleClick(event) {
      if (this.disabled || !this.isButton) {
        return;
      } // Fired only for button-tiles (`is-button` must be `true`).


      this.$emit("click", event);
    }
  },
  computed: {
    listeners: function listeners() {
      return _objectSpread2({}, this.$listeners, {
        click: this.handleClick
      });
    },
    classes: function classes() {
      return [this.transparent ? "fdv-tile--transparent" : "", this.rowSpan != null ? "fd-has-grid-row-span-".concat(this.rowSpan) : "", this.colSpan != null ? "fd-has-grid-column-span-".concat(this.colSpan) : ""];
    }
  }
};

/* script */
var __vue_script__$25 = script$25;
/* template */

var __vue_render__$1V = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', _vm._g({
    staticClass: "fd-tile",
    class: _vm.classes,
    attrs: {
      "role": _vm.isButton ? 'button' : null,
      "aria-disabled": String(_vm.disabled)
    }
  }, _vm.listeners), [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1V = [];
/* style */

var __vue_inject_styles__$25 = undefined;
/* scoped */

var __vue_scope_id__$25 = undefined;
/* module identifier */

var __vue_module_identifier__$25 = undefined;
/* functional template */

var __vue_is_functional_template__$25 = false;
/* style inject */

/* style inject SSR */

var Tile = normalizeComponent_1({
  render: __vue_render__$1V,
  staticRenderFns: __vue_staticRenderFns__$1V
}, __vue_inject_styles__$25, __vue_script__$25, __vue_scope_id__$25, __vue_is_functional_template__$25, __vue_module_identifier__$25, undefined, undefined);

//
//
//
//
//
//
//
//
//
//
var script$26 = {
  name: "FdProductTile",
  props: {
    url: {
      type: String,
      default: null
    },
    title: {
      type: String,
      default: null
    },
    isButton: {
      type: Boolean,
      default: null
    },
    disabled: {
      type: String,
      default: null
    }
  },
  computed: {
    style: function style() {
      var url = this.url;

      if (url == null) {
        return {};
      }

      return {
        "background-image": "url(".concat(this.url, ")")
      };
    },
    role: function role() {
      return this.isButton ? "button" : null;
    }
  }
};

/* script */
var __vue_script__$26 = script$26;
/* template */

var __vue_render__$1W = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-product-tile",
    attrs: {
      "role": _vm.role,
      "aria-disabled": _vm.disabled
    }
  }, [_c('div', {
    staticClass: "fd-product-tile__media",
    style: _vm.style
  }), _vm._v(" "), _c('div', {
    staticClass: "fd-product-tile__content"
  }, [_vm.title != null ? _c('h2', {
    staticClass: "fd-product-tile__title"
  }, [_vm._v(_vm._s(_vm.title))]) : _vm._e(), _vm._v(" "), _vm._t("content")], 2)]);
};

var __vue_staticRenderFns__$1W = [];
/* style */

var __vue_inject_styles__$26 = undefined;
/* scoped */

var __vue_scope_id__$26 = undefined;
/* module identifier */

var __vue_module_identifier__$26 = undefined;
/* functional template */

var __vue_is_functional_template__$26 = false;
/* style inject */

/* style inject SSR */

var ProductTile = normalizeComponent_1({
  render: __vue_render__$1W,
  staticRenderFns: __vue_staticRenderFns__$1W
}, __vue_inject_styles__$26, __vue_script__$26, __vue_scope_id__$26, __vue_is_functional_template__$26, __vue_module_identifier__$26, undefined, undefined);

var Tile$1 = pluginify(Tile, ProductTile);

//
//
//
//
var script$27 = {
  name: "FdTileActions"
};

/* script */
var __vue_script__$27 = script$27;
/* template */

var __vue_render__$1X = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-tile__actions"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1X = [];
/* style */

var __vue_inject_styles__$27 = undefined;
/* scoped */

var __vue_scope_id__$27 = undefined;
/* module identifier */

var __vue_module_identifier__$27 = undefined;
/* functional template */

var __vue_is_functional_template__$27 = false;
/* style inject */

/* style inject SSR */

var TileActions = normalizeComponent_1({
  render: __vue_render__$1X,
  staticRenderFns: __vue_staticRenderFns__$1X
}, __vue_inject_styles__$27, __vue_script__$27, __vue_scope_id__$27, __vue_is_functional_template__$27, __vue_module_identifier__$27, undefined, undefined);

var TileActions$1 = pluginify(TileActions);

//
//
//
//
var script$28 = {
  name: "FdTileMedia"
};

/* script */
var __vue_script__$28 = script$28;
/* template */

var __vue_render__$1Y = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-tile__media"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1Y = [];
/* style */

var __vue_inject_styles__$28 = undefined;
/* scoped */

var __vue_scope_id__$28 = undefined;
/* module identifier */

var __vue_module_identifier__$28 = undefined;
/* functional template */

var __vue_is_functional_template__$28 = false;
/* style inject */

/* style inject SSR */

var TileMedia = normalizeComponent_1({
  render: __vue_render__$1Y,
  staticRenderFns: __vue_staticRenderFns__$1Y
}, __vue_inject_styles__$28, __vue_script__$28, __vue_scope_id__$28, __vue_is_functional_template__$28, __vue_module_identifier__$28, undefined, undefined);

var TileMedia$1 = pluginify(TileMedia);

//
//
//
//
var script$29 = {
  name: "FdTileContent"
};

/* script */
var __vue_script__$29 = script$29;
/* template */

var __vue_render__$1Z = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-tile__content"
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1Z = [];
/* style */

var __vue_inject_styles__$29 = undefined;
/* scoped */

var __vue_scope_id__$29 = undefined;
/* module identifier */

var __vue_module_identifier__$29 = undefined;
/* functional template */

var __vue_is_functional_template__$29 = false;
/* style inject */

/* style inject SSR */

var TileContent = normalizeComponent_1({
  render: __vue_render__$1Z,
  staticRenderFns: __vue_staticRenderFns__$1Z
}, __vue_inject_styles__$29, __vue_script__$29, __vue_scope_id__$29, __vue_is_functional_template__$29, __vue_module_identifier__$29, undefined, undefined);

var TileContent$1 = pluginify(TileContent);

// The title of a tile. `fd-tile-title` should be a child of `fd-tile-content`.
var script$2a = {
  name: "FdTileTitle",
  props: {
    // Custom HTML-tag used for the tile title.
    tag: {
      type: String,
      // By default a tile title will be rendered as an h3-element. You should change that if it does not fit your structure.
      default: "h3"
    }
  },
  render: function render(h) {
    return h(this.tag, {
      class: "fd-tile__title"
    }, this.$slots.default);
  }
};

/* script */
var __vue_script__$2a = script$2a;
/* template */

/* style */

var __vue_inject_styles__$2a = undefined;
/* scoped */

var __vue_scope_id__$2a = undefined;
/* module identifier */

var __vue_module_identifier__$2a = undefined;
/* functional template */

var __vue_is_functional_template__$2a = undefined;
/* style inject */

/* style inject SSR */

var TileTitle = normalizeComponent_1({}, __vue_inject_styles__$2a, __vue_script__$2a, __vue_scope_id__$2a, __vue_is_functional_template__$2a, __vue_module_identifier__$2a, undefined, undefined);

var TileTitle$1 = pluginify(TileTitle);

//
//
//
//
//
//
var script$2b = {
  name: "FdTileGrid",
  props: {
    col: {
      type: Number,
      default: null,
      validator: function validator(value) {
        return value >= 2 && value <= 6;
      }
    }
  },
  computed: {
    classes: function classes() {
      var col = this.col;
      var colClass = col == null ? {} : _defineProperty({}, "fd-tile-grid--".concat(col, "col"), true);
      return _objectSpread2({
        "fd-tile-grid": true
      }, colClass);
    }
  }
};

/* script */
var __vue_script__$2b = script$2b;
/* template */

var __vue_render__$1_ = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    class: _vm.classes
  }, [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$1_ = [];
/* style */

var __vue_inject_styles__$2b = undefined;
/* scoped */

var __vue_scope_id__$2b = undefined;
/* module identifier */

var __vue_module_identifier__$2b = undefined;
/* functional template */

var __vue_is_functional_template__$2b = false;
/* style inject */

/* style inject SSR */

var TileGrid = normalizeComponent_1({
  render: __vue_render__$1_,
  staticRenderFns: __vue_staticRenderFns__$1_
}, __vue_inject_styles__$2b, __vue_script__$2b, __vue_scope_id__$2b, __vue_is_functional_template__$2b, __vue_module_identifier__$2b, undefined, undefined);

var TileGrid$1 = pluginify(TileGrid);

var makeDefaultRange = function makeDefaultRange() {
  return {
    hour24: {
      min: "00",
      max: "23"
    },
    hour12: {
      min: "01",
      max: "12"
    },
    minute: {
      min: "00",
      max: "59"
    },
    second: {
      min: "00",
      max: "59"
    },
    meridian: {
      min: "am",
      max: "pm"
    }
  };
};

var TimeRange = {
  methods: {
    checkValueRange: function checkValueRange(timeValue, timeType) {
      return !isNaN(Number(timeValue)) && Number(timeValue) >= Number(this.range[timeType].min) && Number(timeValue) <= Number(this.range[timeType].max);
    }
  },
  data: function data() {
    return {
      range: makeDefaultRange()
    };
  }
};

//

var isButtonType = function isButtonType(value) {
  return ButtonTypes.indexOf(value) >= 0;
};

var script$2c = {
  name: "FdTimeAction",
  components: {
    Button: Button
  },
  computed: {
    buttonState: function buttonState() {
      return this.disabled ? "disabled" : "normal";
    }
  },
  props: {
    title: String,
    icon: String,
    type: {
      type: String,
      validator: isButtonType
    },
    disabled: Boolean,
    ariaLabel: String,
    ariaControls: String
  }
};

/* script */
var __vue_script__$2c = script$2c;
/* template */

var __vue_render__$1$ = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-time__control"
  }, [_c('Button', {
    attrs: {
      "state": _vm.buttonState,
      "icon": _vm.icon,
      "compact": "",
      "styling": "light",
      "type": _vm.type,
      "aria-label": _vm.ariaLabel,
      "aria-controls": _vm.ariaControls
    },
    on: {
      "click": function click($event) {
        return _vm.$emit('click');
      }
    }
  }, [_vm._v("\n    " + _vm._s(_vm.title) + "\n  ")])], 1);
};

var __vue_staticRenderFns__$1$ = [];
/* style */

var __vue_inject_styles__$2c = undefined;
/* scoped */

var __vue_scope_id__$2c = undefined;
/* module identifier */

var __vue_module_identifier__$2c = undefined;
/* functional template */

var __vue_is_functional_template__$2c = false;
/* style inject */

/* style inject SSR */

var TimeAction = normalizeComponent_1({
  render: __vue_render__$1$,
  staticRenderFns: __vue_staticRenderFns__$1$
}, __vue_inject_styles__$2c, __vue_script__$2c, __vue_scope_id__$2c, __vue_is_functional_template__$2c, __vue_module_identifier__$2c, undefined, undefined);

//
//
//
//
//
//
//
//
//
//
//
//
//
//
var script$2d = {
  inheritAttrs: false,
  name: "FdTimeInput",
  props: ["value"]
};

/* script */
var __vue_script__$2d = script$2d;
/* template */

var __vue_render__$20 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-time__input"
  }, [_c('input', _vm._g(_vm._b({
    staticClass: "fd-form__control",
    attrs: {
      "maxlength": "2",
      "type": "text"
    },
    domProps: {
      "value": _vm.value
    },
    on: {
      "input": function input($event) {
        return _vm.$emit('update', $event.target.value);
      }
    }
  }, 'input', _vm.$attrs, false), _vm.$listeners))]);
};

var __vue_staticRenderFns__$20 = [];
/* style */

var __vue_inject_styles__$2d = undefined;
/* scoped */

var __vue_scope_id__$2d = undefined;
/* module identifier */

var __vue_module_identifier__$2d = undefined;
/* functional template */

var __vue_is_functional_template__$2d = false;
/* style inject */

/* style inject SSR */

var TimeInput = normalizeComponent_1({
  render: __vue_render__$20,
  staticRenderFns: __vue_staticRenderFns__$20
}, __vue_inject_styles__$2d, __vue_script__$2d, __vue_scope_id__$2d, __vue_is_functional_template__$2d, __vue_module_identifier__$2d, undefined, undefined);

// Time type
var typeMapping$3 = {
  hour24: "hour24",
  hour12: "hour12",
  minute: "minute",
  second: "second",
  meridian: "meridian"
};
var TimeTypeList = Object.keys(typeMapping$3);
var isTimeType = function isTimeType(value) {
  return TimeTypeList.indexOf(value) >= 0;
};

//
var script$2e = {
  name: "FdTime",
  mixins: [TimeRange],
  components: {
    TimeAction: TimeAction,
    TimeInput: TimeInput
  },
  props: {
    type: {
      type: String,
      required: true,
      validator: isTimeType
    },
    value: {
      type: [String, Number],
      default: ""
    },
    ariaLabel: {
      type: String,
      default: "Time Item"
    },
    placeholder: {
      type: String,
      default: ""
    }
  },
  computed: {
    sanitizeInputValue: function sanitizeInputValue() {
      var value;
      var isValInRange;

      if (this.type === "hour24" || this.type === "hour12" || this.type === "minute" || this.type === "second") {
        isValInRange = this.checkValueRange(this.inputValue, this.type);
        value = isValInRange ? this.inputValue : "";
      } else if (this.type === "meridian") {
        var meridian = this.inputValue.toString().toLowerCase();
        value = meridian === this.range[this.type].min || meridian === this.range[this.type].max ? meridian : "";
      } else {
        value = "";
      }

      return value;
    },
    previousValue: function previousValue() {
      var inputValue = Number(this.inputValue);
      var range = this.range[this.type];
      var min = range.min,
          max = range.max;
      var previousValue = inputValue > Number(min) ? inputValue - 1 : max;
      return previousValue.toString().padStart(2, "0");
    },
    nextValue: function nextValue() {
      var inputValue = Number(this.inputValue);
      var range = this.range[this.type];
      var min = range.min,
          max = range.max;
      var nextValue = inputValue < Number(max) ? inputValue + 1 : min;
      return nextValue.toString().padStart(2, "0");
    }
  },
  watch: {
    value: {
      immediate: true,
      handler: function handler(newValue) {
        this.inputValue = newValue;
        this.$emit("input", this.inputValue);
      }
    }
  },
  methods: {
    decreaseValue: function decreaseValue() {
      var value;
      var isValInRange;

      if (this.type === "hour24" || this.type === "hour12" || this.type === "minute" || this.type === "second") {
        value = !isNaN(Number(this.inputValue)) ? this.previousValue : this.range[this.type].min;
        isValInRange = this.checkValueRange(value, this.type);
        value = isValInRange ? value : this.range[this.type].min;
      } else if (this.type === "meridian") {
        value = this.inputValue.toString().toLowerCase() === this.range[this.type].min ? this.range[this.type].max : this.range[this.type].min;
      } else {
        value = "";
      }

      this.inputValue = value;
      this.$emit("update:value", this.inputValue);
      this.emitTimeUpdate();
    },
    increaseValue: function increaseValue() {
      var value;

      if (this.type === "hour24" || this.type === "hour12" || this.type === "minute" || this.type === "second") {
        value = !isNaN(Number(this.inputValue)) ? this.nextValue : this.range[this.type].min;
      } else if (this.type === "meridian") {
        value = this.inputValue.toString().toLowerCase() === this.range[this.type].min ? this.range[this.type].max : this.range[this.type].min;
      } else {
        value = "";
      }

      this.inputValue = value;
      this.$emit("update:value", this.inputValue);
      this.emitTimeUpdate();
    },
    emitTimeUpdate: function emitTimeUpdate() {
      this.$emit("timeUpdate", this.inputValue);
    },
    sanitizeValue: function sanitizeValue() {
      var value;
      var isValInRange;

      if (this.type === "hour24" || this.type === "hour12" || this.type === "minute" || this.type === "second") {
        isValInRange = this.checkValueRange(this.inputValue, this.type);
        value = isValInRange ? this.inputValue : "";
      } else if (this.type === "meridian") {
        var meridian = this.inputValue.toString().toLowerCase();
        value = meridian === this.range[this.type].min || meridian === this.range[this.type].max ? meridian : "";
      } else {
        value = "";
      }

      this.inputValue = value;
      this.$emit("update:value", this.inputValue);
    },
    timeUpdate: function timeUpdate(newValue) {
      if (this.type === "meridian" && newValue !== this.range[this.type].min && newValue !== this.range[this.type].max) {
        this.inputValue = "";
      } else {
        this.inputValue = newValue;
      }

      this.emitTimeUpdate();
    }
  },
  data: function data() {
    return {
      inputValue: this.value
    };
  }
};

/* script */
var __vue_script__$2e = script$2e;
/* template */

var __vue_render__$21 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-time__item",
    attrs: {
      "aria-label": _vm.ariaLabel
    }
  }, [_c('TimeAction', {
    attrs: {
      "icon": "navigation-up-arrow",
      "type": "standard"
    },
    on: {
      "click": _vm.increaseValue
    }
  }), _vm._v(" "), _c('TimeInput', {
    attrs: {
      "value": _vm.sanitizeInputValue,
      "placeholder": _vm.placeholder
    },
    on: {
      "update": _vm.timeUpdate
    }
  }), _vm._v(" "), _c('TimeAction', {
    attrs: {
      "icon": "navigation-down-arrow",
      "type": "standard"
    },
    on: {
      "click": _vm.decreaseValue
    }
  })], 1);
};

var __vue_staticRenderFns__$21 = [];
/* style */

var __vue_inject_styles__$2e = undefined;
/* scoped */

var __vue_scope_id__$2e = undefined;
/* module identifier */

var __vue_module_identifier__$2e = undefined;
/* functional template */

var __vue_is_functional_template__$2e = false;
/* style inject */

/* style inject SSR */

var Time = normalizeComponent_1({
  render: __vue_render__$21,
  staticRenderFns: __vue_staticRenderFns__$21
}, __vue_inject_styles__$2e, __vue_script__$2e, __vue_scope_id__$2e, __vue_is_functional_template__$2e, __vue_module_identifier__$2e, undefined, undefined);

//
var script$2f = {
  name: "FdTimeItem",
  mixins: [TimeRange],
  components: {
    Time: Time
  },
  props: {
    ariaLabel: {
      type: String,
      default: "Time Item"
    },
    value: String,
    // validator needs to be added.
    showMeridian: {
      type: Boolean,
      default: false
    }
  },
  computed: {
    shouldRenderSeconds: function shouldRenderSeconds() {
      return this.second != null;
    }
  },
  watch: {
    timeValue: {
      immediate: true,
      handler: function handler(newTimeValue) {
        if (newTimeValue != null) {
          var time = newTimeValue.toString().split(" ");
          var timeValue = time[0].split(":");
          var _ref = [timeValue[0], timeValue[1], timeValue[2], time[1]];
          this.hour = _ref[0];
          this.minute = _ref[1];
          this.second = _ref[2];
          this.meridian = _ref[3];
        }
      }
    }
  },
  methods: {
    updateHour: function updateHour(hour) {
      var hourType = this.showMeridian ? "hour12" : "hour24";

      if (Number(this.hour) === Number(this.range[hourType].max) && Number(hour) === Number(this.range[hourType].max) - 1 || Number(hour) === Number(this.range[hourType].max) && Number(this.hour) === Number(this.range[hourType].max) - 1) {
        var meridian = this.meridian;
        meridian = this.meridian === this.range.meridian.min ? this.range.meridian.max : this.range.meridian.min;
        this.updateMeridian(meridian);
      }

      this.validateTimeUnit("hour", hour, hourType);
    },
    updateMinute: function updateMinute(minute) {
      var minuteValue = this.minute === "00" && minute === "-1" ? this.range.minute.max : minute;
      var updateParameters = {
        timeUnitType: "minute",
        value: minuteValue,
        timeType: "minute",
        upperTimeUnitType: "hour",
        upperTimeUnitUpdateHandler: this.updateHour
      };
      this.updateUnit(updateParameters);
    },
    updateSecond: function updateSecond(second) {
      var updateParameters = {
        timeUnitType: "second",
        value: second,
        timeType: "second",
        upperTimeUnitType: "minute",
        upperTimeUnitUpdateHandler: this.updateMinute
      };
      this.updateUnit(updateParameters);
    },
    updateMeridian: function updateMeridian(meridian) {
      this.meridian = meridian ? meridian : "--";
      this.updateTimeItem();
    },
    updateUnit: function updateUnit(updateParameters) {
      var dividend = 0;
      var remainder = 0;

      if (Number(this[updateParameters.timeUnitType]) === Number(this.range[updateParameters.timeType].min) && Number(updateParameters.value) === Number(this.range[updateParameters.timeType].max)) {
        dividend = -1;
        remainder = Number(this.range[updateParameters.timeType].max);
        this[updateParameters.timeUnitType] = updateParameters.value;
      } else if (Number(this[updateParameters.timeUnitType]) === Number(this.range[updateParameters.timeType].max) && Number(updateParameters.value) === Number(this.range[updateParameters.timeType].min)) {
        dividend = 1;
        remainder = Number(this.range[updateParameters.timeType].min);
        this[updateParameters.timeUnitType] = updateParameters.value;
      } else {
        if (this.validateTimeUnit(updateParameters.timeUnitType, updateParameters.value, updateParameters.timeType)) {
          remainder = Number(updateParameters.value) % (Number(this.range[updateParameters.timeType].max) + 1);
          dividend = Math.floor(Number(updateParameters.value) / (Number(this.range[updateParameters.timeType].max) + 1));
          this.validateTimeUnit(updateParameters.timeUnitType, remainder.toString().padStart(2, "0"), updateParameters.timeType);
        }
      }

      var upperValue = (Number(this[updateParameters.upperTimeUnitType]) + dividend).toString().padStart(2, "0");
      updateParameters.upperTimeUnitUpdateHandler(upperValue);
    },
    validateTimeUnit: function validateTimeUnit(unitType, value, type) {
      var valueOutOfRange = false;

      if (this.checkValueRange(value, type)) {
        this[unitType] = value ? value : "--";
      } else if (!isNaN(Number(value))) {
        valueOutOfRange = true;
      } else {
        this[unitType] = "--";
      }

      this.updateTimeItem();
      return valueOutOfRange;
    },
    updateTimeItem: function updateTimeItem() {
      var timeValue = [this.hour, this.minute, this.second].join(":");
      var time = [timeValue, this.meridian].join(" ");
      this.timeValue = time;
      this.$emit("timeItemUpdate", this.timeValue);
    }
  },
  data: function data() {
    return {
      timeValue: this.value,
      hour: "--",
      minute: "--",
      second: "--",
      meridian: "--"
    };
  }
};

/* script */
var __vue_script__$2f = script$2f;
/* template */

var __vue_render__$22 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-time"
  }, [_c('Time', {
    attrs: {
      "type": _vm.showMeridian ? 'hour12' : 'hour24',
      "value": _vm.hour,
      "placeholder": "hh"
    },
    on: {
      "timeUpdate": _vm.updateHour
    }
  }), _vm._v(" "), _c('Time', {
    attrs: {
      "type": "minute",
      "value": _vm.minute,
      "placeholder": "mm"
    },
    on: {
      "timeUpdate": _vm.updateMinute
    }
  }), _vm._v(" "), _vm.shouldRenderSeconds ? _c('Time', {
    attrs: {
      "type": "second",
      "value": _vm.second,
      "placeholder": "ss"
    },
    on: {
      "timeUpdate": _vm.updateSecond
    }
  }) : _vm._e(), _vm._v(" "), _vm.showMeridian ? _c('Time', {
    attrs: {
      "type": "meridian",
      "value": _vm.meridian,
      "placeholder": "am"
    },
    on: {
      "timeUpdate": _vm.updateMeridian
    }
  }) : _vm._e()], 1);
};

var __vue_staticRenderFns__$22 = [];
/* style */

var __vue_inject_styles__$2f = undefined;
/* scoped */

var __vue_scope_id__$2f = undefined;
/* module identifier */

var __vue_module_identifier__$2f = undefined;
/* functional template */

var __vue_is_functional_template__$2f = false;
/* style inject */

/* style inject SSR */

var TimeItem = normalizeComponent_1({
  render: __vue_render__$22,
  staticRenderFns: __vue_staticRenderFns__$22
}, __vue_inject_styles__$2f, __vue_script__$2f, __vue_scope_id__$2f, __vue_is_functional_template__$2f, __vue_module_identifier__$2f, undefined, undefined);

//
var script$2g = {
  name: "FdTimePicker",
  components: {
    FdPopover: FdPopover,
    FdInput: FdInput,
    FdInputGroup: FdInputGroup,
    FdInputGroupButton: FdInputGroupButton,
    FdInputGroupAddon: FdInputGroupAddon,
    FdTimeItem: TimeItem
  },
  props: {
    id: String,
    // FIXME
    placeholder: String,
    value: String,
    // FIXME: Add Validator
    ariaLabel: String,
    compact: {
      type: Boolean,
      default: false
    },
    showMeridian: {
      type: Boolean,
      default: false
    }
  },
  methods: {
    updateTimeItem: function updateTimeItem(time) {
      this.timeValue = time;
      this.$emit("timePickerUpdate", this.timeValue);
    }
  },
  data: function data() {
    return {
      timeValue: this.value
    };
  }
};

/* script */
var __vue_script__$2g = script$2g;
/* template */

var __vue_render__$23 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "fd-time-picker"
  }, [_c('fd-popover', {
    attrs: {
      "body-size-mode": "equal-trigger",
      "placement": "bottom-start"
    },
    scopedSlots: _vm._u([{
      key: "control",
      fn: function fn(ref) {
        var toggle = ref.toggle;
        var show = ref.show;
        var hide = ref.hide;
        return [_c('fd-input-group', {
          attrs: {
            "compact": _vm.compact
          },
          scopedSlots: _vm._u([{
            key: "input",
            fn: function fn() {
              return [_c('fd-input', {
                attrs: {
                  "value": _vm.timeValue,
                  "compact": _vm.compact,
                  "placeholder": _vm.placeholder
                }
              })];
            },
            proxy: true
          }, {
            key: "after",
            fn: function fn() {
              return [_c('fd-input-group-addon', [_c('fd-input-group-button', {
                attrs: {
                  "styling": "light",
                  "icon": "fob-watch"
                },
                on: {
                  "click": toggle
                }
              })], 1)];
            },
            proxy: true
          }], null, true)
        })];
      }
    }])
  }, [_vm._v(" "), _c('fd-time-item', {
    attrs: {
      "value": _vm.timeValue,
      "showMeridian": _vm.showMeridian
    },
    on: {
      "timeItemUpdate": _vm.updateTimeItem
    }
  })], 1)], 1);
};

var __vue_staticRenderFns__$23 = [];
/* style */

var __vue_inject_styles__$2g = undefined;
/* scoped */

var __vue_scope_id__$2g = undefined;
/* module identifier */

var __vue_module_identifier__$2g = undefined;
/* functional template */

var __vue_is_functional_template__$2g = false;
/* style inject */

/* style inject SSR */

var TimePicker = normalizeComponent_1({
  render: __vue_render__$23,
  staticRenderFns: __vue_staticRenderFns__$23
}, __vue_inject_styles__$2g, __vue_script__$2g, __vue_scope_id__$2g, __vue_is_functional_template__$2g, __vue_module_identifier__$2g, undefined, undefined);

var TimePicker$1 = pluginify(TimePicker, TimeItem, TimeInput, TimeAction, Time);

//
//
//
//
//
//
var script$2h = {
  name: "FdToken"
};

/* script */
var __vue_script__$2h = script$2h;
/* template */

var __vue_render__$24 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('span', _vm._g({
    staticClass: "fd-token",
    attrs: {
      "role": "button"
    }
  }, _vm.$listeners), [_vm._t("default")], 2);
};

var __vue_staticRenderFns__$24 = [];
/* style */

var __vue_inject_styles__$2h = undefined;
/* scoped */

var __vue_scope_id__$2h = undefined;
/* module identifier */

var __vue_module_identifier__$2h = undefined;
/* functional template */

var __vue_is_functional_template__$2h = false;
/* style inject */

/* style inject SSR */

var Token = normalizeComponent_1({
  render: __vue_render__$24,
  staticRenderFns: __vue_staticRenderFns__$24
}, __vue_inject_styles__$2h, __vue_script__$2h, __vue_scope_id__$2h, __vue_is_functional_template__$2h, __vue_module_identifier__$2h, undefined, undefined);

var Token$1 = pluginify(Token);

var script$2i = {
  props: {
    itemIdPath: {
      // string indicating the path to the property to be used as unique key for every node
      type: String,
      default: "id"
    },
    itemChildrenPath: {
      // string indicating the path to the property containing the array of children
      type: String,
      default: "children"
    },
    itemValuePath: {
      // string indicating the path to the property to be used as label for every node
      type: String,
      default: "name"
    },
    itemDisabledPath: {
      // string indicating the path to the boolean property to use to determine whether a node should be disabled
      type: String,
      default: "disabled"
    }
  }
};

/* script */
var __vue_script__$2i = script$2i;
/* template */

/* style */

var __vue_inject_styles__$2i = undefined;
/* scoped */

var __vue_scope_id__$2i = undefined;
/* module identifier */

var __vue_module_identifier__$2i = undefined;
/* functional template */

var __vue_is_functional_template__$2i = undefined;
/* style inject */

/* style inject SSR */

var TreeItemProps = normalizeComponent_1({}, __vue_inject_styles__$2i, __vue_script__$2i, __vue_scope_id__$2i, __vue_is_functional_template__$2i, __vue_module_identifier__$2i, undefined, undefined);

/**
 *
 * @param {Object} obj the object that we want to query
 * @param {string} path the path of the property that we want to extract
 * @param {Object} fallback the default value to be returned in case of error
 */
function getPropertyByPath(obj, path, fallback) {
  // credit: http://stackoverflow.com/questions/6491463/accessing-nested-javascript-objects-with-string-key#comment55278413_6491621
  if (obj == null || !path || typeof path !== "string") return fallback;
  if (obj[path] !== undefined) return obj[path]; // convert indexes to properties

  path = path.replace(/\[(\w+)\]/g, ".$1"); // strip a leading dot

  path = path.replace(/^\./, "");
  return getNestedValue(obj, path.split("."), fallback);
}

function getNestedValue(obj, path, fallback) {
  var last = path.length - 1;
  if (last < 0) return obj === undefined ? fallback : obj;

  for (var i = 0; i < last; i++) {
    if (obj == null) {
      return fallback;
    }

    obj = obj[path[i]];
  }

  if (obj == null) return fallback;
  return obj[path[last]] === undefined ? fallback : obj[path[last]];
}

//
var script$2j = {
  name: "FdTreeItem",
  mixins: [TreeItemProps],
  data: function data() {
    return {
      isOpen: false
    };
  },
  props: {
    level: {
      // Used to determine the level of the element in the tree hierarchy
      type: Number,
      default: 0
    },
    item: {
      type: Object
    }
  },
  computed: {
    hasChildren: function hasChildren() {
      return this.children.length ? true : false;
    },
    label: function label() {
      return getPropertyByPath(this.item, this.itemValuePath, "");
    },
    disabled: function disabled() {
      return getPropertyByPath(this.item, this.itemDisabledPath, false);
    },
    children: function children() {
      return getPropertyByPath(this.item, this.itemChildrenPath, []);
    }
  },
  methods: {
    toggleExpansion: function toggleExpansion() {
      this.isOpen = !this.isOpen;
    }
  }
};

/* script */
var __vue_script__$2j = script$2j;
/* template */

var __vue_render__$25 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('li', {
    class: ['fd-tree__item', _vm.disabled ? 'fd-tree__item-disabled' : ''],
    attrs: {
      "role": "treeitem",
      "aria-isOpen": _vm.isOpen
    }
  }, [_c('div', {
    staticClass: "fd-tree__row"
  }, [_c('div', {
    staticClass: "fd-tree__col fd-tree__col--control"
  }, [_vm.hasChildren ? _c('button', {
    class: {
      'fd-tree__control': true,
      'is-pressed': _vm.isOpen,
      'fd-tree__control--disabled': _vm.disabled
    },
    attrs: {
      "aria-label": "Expand",
      "aria-disabled": _vm.disabled,
      "aria-pressed": _vm.isOpen
    },
    on: {
      "click": _vm.toggleExpansion
    }
  }) : _vm._e(), _vm._v(" "), _c('span', {
    staticClass: "prepend-wrapper"
  }, [_vm._t("prepend", null, {
    "item": _vm.item,
    "expanded": _vm.isOpen
  })], 2), _vm._v(" "), _vm._t("label", [_vm._v(_vm._s(_vm.label))], {
    "item": _vm.item,
    "expanded": _vm.isOpen
  })], 2)]), _vm._v(" "), _vm.hasChildren ? _c('ul', {
    class: ['fd-tree__group', "fd-tree__group--sublevel-" + (_vm.level + 1)],
    attrs: {
      "role": "group",
      "aria-hidden": !_vm.isOpen
    }
  }, _vm._l(_vm.children, function (child, index) {
    return _c('fd-tree-item', {
      key: index,
      attrs: {
        "level": _vm.level + 1,
        "item": child,
        "itemIdPath": _vm.itemIdPath,
        "itemValuePath": _vm.itemValuePath,
        "itemChildrenPath": _vm.itemChildrenPath,
        "itemDisabledPath": _vm.itemDisabledPath
      },
      scopedSlots: _vm._u([{
        key: "prepend",
        fn: function fn(ref) {
          var item = ref.item;
          var expanded = ref.expanded;
          return [_vm._t("prepend", null, {
            "item": item,
            "expanded": _vm.isOpen
          })];
        }
      }, {
        key: "label",
        fn: function fn(ref) {
          var item = ref.item;
          var expanded = ref.expanded;
          return [_vm._t("label", null, {
            "item": item,
            "expanded": _vm.isOpen
          })];
        }
      }], null, true)
    });
  }), 1) : _vm._e()]);
};

var __vue_staticRenderFns__$25 = [];
/* style */

var __vue_inject_styles__$2j = undefined;
/* scoped */

var __vue_scope_id__$2j = undefined;
/* module identifier */

var __vue_module_identifier__$2j = undefined;
/* functional template */

var __vue_is_functional_template__$2j = false;
/* style inject */

/* style inject SSR */

var TreeItem = normalizeComponent_1({
  render: __vue_render__$25,
  staticRenderFns: __vue_staticRenderFns__$25
}, __vue_inject_styles__$2j, __vue_script__$2j, __vue_scope_id__$2j, __vue_is_functional_template__$2j, __vue_module_identifier__$2j, undefined, undefined);

//
var script$2k = {
  name: "FdTree",
  mixins: [TreeItemProps],
  components: {
    FdTreeItem: TreeItem
  },
  props: {
    items: {
      type: Array,
      required: true
    }
  },
  data: function data() {
    return {};
  }
};

/* script */
var __vue_script__$2k = script$2k;
/* template */

var __vue_render__$26 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('ul', {
    staticClass: "fd-tree",
    attrs: {
      "role": "tree"
    }
  }, _vm._l(_vm.items, function (element, index) {
    return _c('fd-tree-item', {
      key: index,
      attrs: {
        "item": element,
        "itemIdPath": _vm.itemIdPath,
        "itemValuePath": _vm.itemValuePath,
        "itemChildrenPath": _vm.itemChildrenPath,
        "itemDisabledPath": _vm.itemDisabledPath
      },
      scopedSlots: _vm._u([{
        key: "prepend",
        fn: function fn(ref) {
          var item = ref.item;
          var expanded = ref.expanded;
          return [_vm._t("prepend", null, {
            "item": item,
            "expanded": expanded
          })];
        }
      }, {
        key: "label",
        fn: function fn(ref) {
          var item = ref.item;
          var expanded = ref.expanded;
          return [_vm._t("label", null, {
            "item": item,
            "expanded": expanded
          })];
        }
      }], null, true)
    });
  }), 1);
};

var __vue_staticRenderFns__$26 = [];
/* style */

var __vue_inject_styles__$2k = undefined;
/* scoped */

var __vue_scope_id__$2k = undefined;
/* module identifier */

var __vue_module_identifier__$2k = undefined;
/* functional template */

var __vue_is_functional_template__$2k = false;
/* style inject */

/* style inject SSR */

var Tree = normalizeComponent_1({
  render: __vue_render__$26,
  staticRenderFns: __vue_staticRenderFns__$26
}, __vue_inject_styles__$2k, __vue_script__$2k, __vue_scope_id__$2k, __vue_is_functional_template__$2k, __vue_module_identifier__$2k, undefined, undefined);

var Tree$1 = pluginify(Tree, TreeItem);

//
var script$2l = {
  name: "FdVirtualizedList",
  components: {
    FdSpinner: FdSpinner
  },
  props: {
    // this prop is passed – as it – to `vue-virtual-scroller`. For details please refer to `vue-virtual-scroller` documentation. To sum this prop up: Specify reactive values that can affect the size of the rendered item. This prop will be observed by `vue-virtual-scroller`.
    sizeDependencies: {
      type: [Array, Object],
      default: null
    },
    // Name of property that uniquely identifies an item.
    keyField: {
      type: String,
      required: true
    },
    // By default fd-virtualized-list will automatically requests more items if the use has scrolled down to the bottom of the list. Assume that your list has space for 30 items to be displayed at the same time and after loading the initial batch there is still space left. If total-item-count is set to a value greater than 30 or to null fd-virtualized-list automatically requests more items. This is repeated, until there is no space left or the total item count specified is reached. Of course the user can still load more items by scrolling to the bottom.
    totalItemCount: {
      type: Number,
      default: null
    },
    // Minimal size of the items. Will be passed onto DynamicScroller.
    minItemSize: {
      type: Number,
      default: 30
    },
    // Under the hood FdVirtualizedList is using Vue's built in dynamic-component-mechanism to render components that belong to vue-virtual-scroller. In case you have customized the installation of vue-virtual-scroller use this prop to tell FdVirtualizedList about the DynamicScroller.
    dynamicScrollerComponent: {
      type: [Object, Function, String],
      default: "DynamicScroller"
    },
    // See dynamicScrollerComponent for more information.
    dynamicScrollerItemComponent: {
      type: [Object, Function, String],
      default: "DynamicScrollerItem"
    },
    // Items to be rendered by the virtualized list. Each item must have a unique identifier. You can specify the name of the identifying property by using the key-field-prop.
    items: {
      type: Array,
      default: function _default() {
        return [];
      }
    },
    // Function to be called when the list needs more items from you. This function is called with a callback parameter that you MUST call at some point with additional items.
    loadMoreItems: {
      type: Function,
      default: null
    }
  },
  computed: {
    isLoading: function isLoading() {
      return this.state === "loading";
    },
    selectedItem: function selectedItem() {
      var _this = this;

      var selectedId = this.selectedId,
          items = this.items;

      if (selectedId == null) {
        return;
      }

      var index = items.findIndex(function (item) {
        return _this.idForItem(item) === selectedId;
      });
      return index < 0 ? undefined : items[index];
    }
  },
  mounted: function mounted() {
    if (this.items.length === 0) {
      this.startToLoadMoreItems();
    }

    this.$forceUpdate();
  },
  updated: function updated() {
    var _this2 = this;

    requestAnimationFrame(function () {
      _this2.loadMoreItemsIfNeeded();
    });
  },
  methods: {
    itemIsSelected: function itemIsSelected(item) {
      return this.idForItem(item) === this.selectedId;
    },
    idForItem: function idForItem(item) {
      return item[this.keyField];
    },
    afterVisibilityChanged: function afterVisibilityChanged(isVisible) {
      this.afterSlotVisible = isVisible;

      if (isVisible) {
        this.loadMoreItemsIfNeeded();
      }
    },
    loadMoreItemsIfNeeded: function loadMoreItemsIfNeeded() {
      var totalItemCount = this.totalItemCount,
          isLoading = this.isLoading,
          items = this.items,
          afterSlotVisible = this.afterSlotVisible;
      var loadingIsPossible = !isLoading;

      if (!loadingIsPossible) {
        return;
      }

      var moreItemsAvailable = totalItemCount == null ? true : totalItemCount > items.length;
      var isNeeded = afterSlotVisible && moreItemsAvailable;

      if (!isNeeded) {
        return;
      }

      this.startToLoadMoreItems();
    },
    startToLoadMoreItems: function startToLoadMoreItems(event) {
      if (this.loadMoreItems != null) {
        this.state = "loading";

        if (event != null) {
          event.preventDefault();
          event.stopPropagation();
        }

        this.loadMoreItems(this.acceptNewItems);
      }
    },
    acceptNewItems: function acceptNewItems() {
      var _this3 = this;

      this.state = "default";
      setTimeout(function () {
        _this3.loadMoreItemsIfNeeded();
      }, 100);
    },
    selectItem: function selectItem(item) {
      this.selectedId = this.idForItem(item); // Triggers when the selected item changes.
      // @arg the selected item or null

      this.$emit("update:selectedItem", this.selectedItem);
    },
    rowClasses: function rowClasses(item) {
      var selected = this.itemIsSelected(item); //this.idForItem(item) === this.selectedId;

      return {
        "fdv-virtualized-list-item": true,
        "fd-has-background-color-background-selected": selected
      };
    }
  },
  data: function data() {
    return {
      afterSlotVisible: false,
      state: "default",
      selectedId: null
    };
  }
};

/* script */
var __vue_script__$2l = script$2l;
/* template */

var __vue_render__$27 = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c(_vm.dynamicScrollerComponent, {
    tag: "component",
    staticClass: "fdv-virtualized-list",
    staticStyle: {
      "height": "100%"
    },
    attrs: {
      "key-field": _vm.keyField,
      "min-item-size": _vm.minItemSize,
      "items": _vm.items
    },
    scopedSlots: _vm._u([{
      key: "after",
      fn: function fn() {
        return [_c('div', {
          directives: [{
            name: "observe-visibility",
            rawName: "v-observe-visibility",
            value: _vm.afterVisibilityChanged,
            expression: "afterVisibilityChanged"
          }],
          ref: "after",
          staticStyle: {
            "height": "10px"
          }
        }, [_vm.isLoading ? [_vm._t("loading", [_vm.isLoading ? _c('fd-spinner') : _vm._e()])] : _vm._e()], 2)];
      },
      proxy: true
    }, {
      key: "default",
      fn: function fn(ref) {
        var item = ref.item;
        var index = ref.index;
        var active = ref.active;
        return [_c(_vm.dynamicScrollerItemComponent, {
          tag: "component",
          class: _vm.rowClasses(item),
          attrs: {
            "item": item,
            "active": active,
            "data-index": index,
            "data-fdv-virtualized-item-selected": String(_vm.itemIsSelected(item)),
            "data-active": active,
            "size-dependencies": _vm.sizeDependencies
          },
          nativeOn: {
            "click": function click($event) {
              return _vm.selectItem(item);
            }
          }
        }, [_vm._t("item", null, null, {
          item: item,
          index: index,
          active: active
        })], 2)];
      }
    }], null, true)
  });
};

var __vue_staticRenderFns__$27 = [];
/* style */

var __vue_inject_styles__$2l = undefined;
/* scoped */

var __vue_scope_id__$2l = undefined;
/* module identifier */

var __vue_module_identifier__$2l = undefined;
/* functional template */

var __vue_is_functional_template__$2l = false;
/* style inject */

/* style inject SSR */

var VirtualizedList = normalizeComponent_1({
  render: __vue_render__$27,
  staticRenderFns: __vue_staticRenderFns__$27
}, __vue_inject_styles__$2l, __vue_script__$2l, __vue_scope_id__$2l, __vue_is_functional_template__$2l, __vue_module_identifier__$2l, undefined, undefined);

var VirtualizedList$1 = pluginify(VirtualizedList);

var plugin = {
  install: function install(vue, options) {
    var plugins = [$Support, ActionBar$1, Alert$1, Badge$1, Breadcrumb$1, BreadcrumbItem$1, Button$1, ButtonGroup$1, Calendar, Combobox$1, Container, Col, ComboboxMenu$1, Counter$1, ContextMenu$1, ContextButton$1, DatePicker$1, DatePickerCalendar$1, DatePickerInput$1, DateInput$1, Dropdown$1, DropdownControl$1, Form$1, FormLabel$2, Icon$1, Identifier, Image$1, InputGroup, InlineHelp$1, Label$1, Layout, Link$1, ListGroup$1, Menu, MenuPopover, Modal, ModalOverlay, Pagination$1, Panel$1, Popover, SearchInput$1, Section, SideNav$1, Spinner, Status$1, SplitButton$1, SplitButtonAuxiliary$1, SplitButtonAction$1, Table, Tabs$1, Tile$1, TileActions$1, TileMedia$1, TileTitle$1, TileContent$1, TileGrid$1, TimePicker$1, Token$1, Tree$1, VirtualizedList$1];
    plugins.forEach(function (plugin) {
      return vue.use(plugin, options);
    });
  }
};

var update$1 = function update(_ref, _ref2) {
  var classList = _ref.classList;
  var oldValue = _ref2.oldValue,
      value = _ref2.value;

  if (oldValue != null) {
    var oldClass = backgroundColorClassName(oldValue);

    if (classList.contains(oldClass)) {
      classList.remove(oldClass);
    }
  }

  if (value != null) {
    var newClass = backgroundColorClassName(value);

    if (!classList.add(newClass)) {
      classList.add(newClass);
    }
  }
};

var bg = {
  bind: function bind(_ref3, _ref4) {
    var classList = _ref3.classList;
    var arg = _ref4.arg,
        value = _ref4.value;
    var color = arg || value;

    if (color == null) {
      return;
    }

    var colorClass = backgroundColorClassName(color);

    if (!classList.contains(colorClass)) {
      classList.add(colorClass);
    }
  },
  update: update$1
};

var HANDLER = "__fundamentalvue_clickout_handler__";
/** @type {import("vue").DirectiveFunction} */

var unbind = function unbind(el, _ref) {
  var modifiers = _ref.modifiers;
  document.documentElement.removeEventListener("click", el[HANDLER], modifiers.capture);
  delete el[HANDLER];
};
/** @type {import("vue").DirectiveFunction} */


var bind = function bind(el, binding, _ref2) {
  var vm = _ref2.context;
  unbind(el, binding);
  var expression = binding.expression,
      name = binding.name,
      modifiers = binding.modifiers,
      callback = binding.value;

  if (typeof callback !== "function") {

    return;
  }

  var initialMacrotaskEnded = false;
  setTimeout(function () {
    return initialMacrotaskEnded = true;
  });

  el[HANDLER] = function (ev) {
    var path = ev.path || (ev.composedPath ? ev.composedPath() : undefined);

    if (initialMacrotaskEnded && (path ? path.indexOf(el) < 0 : !el.contains(ev.target))) {
      if (modifiers.stop) {
        ev.stopPropagation();
      }

      return callback.call(vm, ev);
    }
  };

  document.documentElement.addEventListener("click", el[HANDLER], modifiers.capture);
};

var clickOut = {
  bind: bind,
  unbind: unbind,
  update: function update(el, binding, vnode) {
    if (binding.value === binding.oldValue) {
      return;
    }

    bind(el, binding, vnode);
  }
}; // Adopted from https://github.com/mrastiak/vue-clickout
// Below is the original license in order to give proper credits. Thanks man.
// The MIT License (MIT)
// Copyright (c) 2015 Denis Karabaza
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// @ts-check

/** @type {import("vue").DirectiveOptions} */
var directive = {
  bind: function bind(el, _ref, vnode) {
    var arg = _ref.arg;

    var onClick = function onClick(event) {
      var vm = vnode.context;

      if (vm == null) {
        return;
      }

      var modal = vm.$refs[arg];

      if (modal == null) {

        return;
      } // eslint-disable-next-line no-undef


      modal.open.call(modal, event);
    };

    el.addEventListener("click", onClick, false);

    var removeListener = function removeListener() {
      el.removeEventListener("click", onClick, false);
    };

    el["__fdRemoveModalClickListener__"] = removeListener;
  },
  unbind: function unbind(el) {
    var removeListener = el["__fdRemoveModalClickListener__"];

    if (removeListener != null) {
      removeListener();
      delete el["__fdRemoveModalClickListener__"];
    }
  }
};

var Directives = {
  install: function install(Vue) {
    Vue.directive("fd-bg", bg);
    Vue.directive("fd-background-color", bg);
    Vue.directive("fd-icon", icon);
    Vue.directive("fd-padding", padding);
    Vue.directive("fd-type", type);
    Vue.directive("fd-margin", margin);
    Vue.directive("fd-font-weight", fontWeight);
    Vue.directive("fd-font-family", fontFamily);
    Vue.directive("fd-click-out", clickOut);
    Vue.directive("fd-open-modal", directive);
  }
};

var FD_AUTO_INSTALL_DISABLED_KEY = "__FD_AUTO_INSTALL_DISABLED_KEY__";

var install$1 = function install(vue, options) {
  var normalized = normalizedPluginOptions(options);
  vue.prototype.$fdDefaultPortalId = normalized.defaultPortalId;
  vue.use(Directives, normalized);
  vue.use(plugin, normalized);

  if (normalized.log.welcome) {
    log("%c Welcome to Fundamental Vue %c You are \u2013 yay. %c", "background:#35495e ; padding: 1px; border-radius: 3px 0 0 3px;  color: #fff", "background:#1661be ; padding: 1px; border-radius: 0 3px 3px 0;  color: #fff", "background:transparent");
  }
};

var installIfPossible = function installIfPossible() {
  if ((typeof window === "undefined" ? "undefined" : _typeof(window)) !== undefined && window.Vue) {
    // Check if auto install was disabled
    if (window[FD_AUTO_INSTALL_DISABLED_KEY] === true) {
      return;
    }

    install$1(window.Vue);
  }
};

installIfPossible();

module.exports = install$1;
