(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
	typeof define === 'function' && define.amd ? define(['exports'], factory) :
	(factory((global.funfixCore = {})));
}(this, (function (exports) { 'use strict';

function isValueObject(ref) {
    return !!(ref && typeof ref.equals === "function" && typeof ref.hashCode === "function");
}

function is(lh, rh) {
    if (lh === rh || lh !== lh && rh !== rh) {
        return true;
    }
    if (!lh || !rh) {
        return false;
    }

    if (typeof lh.valueOf === "function" && typeof rh.valueOf === "function") {
        var lh2 = lh.valueOf();
        var rh2 = rh.valueOf();
        if (lh2 === rh2 || lh2 !== lh2 && rh2 !== rh2) {
            return true;
        }
        if (!lh2 || !rh2) {
            return false;
        }
    }

    return !!(isValueObject(lh) && lh.equals(rh));
}

function equals(lh, rh) {
    return is(lh, rh);
}

var universalSetoid = { equals: equals };

function hashCode(ref) {
    if (typeof ref === "number") {
        return ref & ref;
    }

    if (typeof ref.valueOf === "function") {
        var v = ref.valueOf();
        if (v !== ref) return hashCode(v);
    }
    if (isValueObject(ref)) {
        return ref.hashCode();
    }
    return hashCodeOfString(String(ref));
}

function hashCodeOfString(str) {
    var hash = 0;

    if (str == null || str.length === 0) return hash;
    for (var i = 0; i < str.length; i++) {
        var character = str.charCodeAt(i);
        hash = (hash << 5) - hash + character;
        hash = hash & hash;
    }
    return hash;
}

function id(a) {
    return a;
}

function applyMixins(derivedCtor, baseCtors) {
    baseCtors.forEach(function (baseCtor) {
        Object.getOwnPropertyNames(baseCtor.prototype).forEach(function (name) {
            if (!derivedCtor.prototype[name]) derivedCtor.prototype[name] = baseCtor.prototype[name];
        });
    });
}

var classCallCheck = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

var createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);
    if (staticProps) defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();

var inherits = function (subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
};

var possibleConstructorReturn = function (self, call) {
  if (!self) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return call && (typeof call === "object" || typeof call === "function") ? call : self;
};

var CompositeError = function (_Error) {
    inherits(CompositeError, _Error);

    function CompositeError(errors) {
        classCallCheck(this, CompositeError);

        var reasons = "";
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
            for (var _iterator = errors.slice(0, 2)[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                var e = _step.value;

                var message = "";
                if (e instanceof Error) {
                    message = e.name + "(" + e.message + ")";
                } else {
                    message = "" + e;
                }
                reasons += ", " + message;
            }
        } catch (err) {
            _didIteratorError = true;
            _iteratorError = err;
        } finally {
            try {
                if (!_iteratorNormalCompletion && _iterator.return) {
                    _iterator.return();
                }
            } finally {
                if (_didIteratorError) {
                    throw _iteratorError;
                }
            }
        }

        reasons = reasons.slice(2);
        if (errors.length > 2) reasons = reasons + ", ...";

        var _this = possibleConstructorReturn(this, (CompositeError.__proto__ || Object.getPrototypeOf(CompositeError)).call(this, reasons));

        _this.name = "CompositeError";
        _this.errorsRef = errors;

        var self = _this;
        self.constructor = CompositeError;
        self.__proto__ = CompositeError.prototype;
        return _this;
    }

    createClass(CompositeError, [{
        key: "errors",
        value: function errors() {
            return this.errorsRef.slice();
        }
    }]);
    return CompositeError;
}(Error);

var DummyError = function (_Error2) {
    inherits(DummyError, _Error2);

    function DummyError(message) {
        classCallCheck(this, DummyError);

        var _this2 = possibleConstructorReturn(this, (DummyError.__proto__ || Object.getPrototypeOf(DummyError)).call(this, message));

        _this2.name = "DummyError";

        var self = _this2;
        self.constructor = DummyError;
        self.__proto__ = DummyError.prototype;
        return _this2;
    }

    return DummyError;
}(Error);

var NoSuchElementError = function (_Error3) {
    inherits(NoSuchElementError, _Error3);

    function NoSuchElementError(message) {
        classCallCheck(this, NoSuchElementError);

        var _this3 = possibleConstructorReturn(this, (NoSuchElementError.__proto__ || Object.getPrototypeOf(NoSuchElementError)).call(this, message));

        _this3.name = "NoSuchElementError";

        var self = _this3;
        self.constructor = NoSuchElementError;
        self.__proto__ = NoSuchElementError.prototype;
        return _this3;
    }

    return NoSuchElementError;
}(Error);

var IllegalInheritanceError = function (_Error4) {
    inherits(IllegalInheritanceError, _Error4);

    function IllegalInheritanceError(message) {
        classCallCheck(this, IllegalInheritanceError);

        var _this4 = possibleConstructorReturn(this, (IllegalInheritanceError.__proto__ || Object.getPrototypeOf(IllegalInheritanceError)).call(this, message));

        _this4.name = "IllegalInheritanceError";

        var self = _this4;
        self.constructor = IllegalInheritanceError;
        self.__proto__ = IllegalInheritanceError.prototype;
        return _this4;
    }

    return IllegalInheritanceError;
}(Error);

var IllegalStateError = function (_Error5) {
    inherits(IllegalStateError, _Error5);

    function IllegalStateError(message) {
        classCallCheck(this, IllegalStateError);

        var _this5 = possibleConstructorReturn(this, (IllegalStateError.__proto__ || Object.getPrototypeOf(IllegalStateError)).call(this, message));

        _this5.name = "IllegalStateError";

        var self = _this5;
        self.constructor = IllegalStateError;
        self.__proto__ = IllegalStateError.prototype;
        return _this5;
    }

    return IllegalStateError;
}(Error);

var IllegalArgumentError = function (_Error6) {
    inherits(IllegalArgumentError, _Error6);

    function IllegalArgumentError(message) {
        classCallCheck(this, IllegalArgumentError);

        var _this6 = possibleConstructorReturn(this, (IllegalArgumentError.__proto__ || Object.getPrototypeOf(IllegalArgumentError)).call(this, message));

        _this6.name = "IllegalArgumentError";

        var self = _this6;
        self.constructor = IllegalArgumentError;
        self.__proto__ = IllegalArgumentError.prototype;
        return _this6;
    }

    return IllegalArgumentError;
}(Error);

var NotImplementedError = function (_Error7) {
    inherits(NotImplementedError, _Error7);

    function NotImplementedError(message) {
        classCallCheck(this, NotImplementedError);

        var _this7 = possibleConstructorReturn(this, (NotImplementedError.__proto__ || Object.getPrototypeOf(NotImplementedError)).call(this, message));

        _this7.name = "NotImplementedError";

        var self = _this7;
        self.constructor = NotImplementedError;
        self.__proto__ = NotImplementedError.prototype;
        return _this7;
    }

    return NotImplementedError;
}(Error);

var TimeoutError = function (_Error8) {
    inherits(TimeoutError, _Error8);

    function TimeoutError(message) {
        classCallCheck(this, TimeoutError);

        var _this8 = possibleConstructorReturn(this, (TimeoutError.__proto__ || Object.getPrototypeOf(TimeoutError)).call(this, message));

        _this8.name = "TimeoutError";

        var self = _this8;
        self.constructor = TimeoutError;
        self.__proto__ = TimeoutError.prototype;
        return _this8;
    }

    return TimeoutError;
}(Error);

function convertToMethod(f) {
    return function () {
        var args = Array.prototype.slice.call(arguments);
        args.push(this);
        return f.apply(undefined, args);
    };
}

function fantasyLandRegister(cls, monad, setoid) {
    var c = cls;
    var p = c.prototype;
    var fl = "fantasy-land/";
    var equals = "equals";
    var flEquals = fl + equals;
    var map = "map";
    var flMap = fl + map;
    var ap = "ap";
    var flAp = fl + ap;
    var flOf = fl + "of";
    var chain = "chain";
    var flChain = fl + chain;
    var chainRec = "chainRec";
    var flChainRec = fl + chainRec;

    if (p[equals]) {
        p[flEquals] = p[equals];
    } else {
        if (setoid) p[flEquals] = convertToMethod(setoid.equals);
    }

    if (p[map]) {
        p[flMap] = p[map];
    } else {
        if (monad) p[flMap] = convertToMethod(monad.map);
    }

    if (p[ap]) {
        p[flAp] = p[ap];
    } else {
        if (monad) p[flAp] = convertToMethod(monad.ap);
    }

    if (c["pure"]) {
        c[flOf] = c["pure"];
    } else {
        if (monad) c[flOf] = monad.of;
    }

    if (p[chain]) {
        p[flChain] = p[chain];
    } else {
        if (monad) p[flChain] = convertToMethod(monad.chain);
    }

    if (c[chainRec]) {
        c[flChainRec] = c[chainRec];
    } else {
        if (monad) c[flChainRec] = monad.chainRec;
    }
}

var internals = Object.freeze({
	convertToMethod: convertToMethod,
	fantasyLandRegister: fantasyLandRegister
});

var Either = function () {
    function Either(value, tag) {
        classCallCheck(this, Either);

        this._isRight = tag === "right";
        this.value = value;
    }

    createClass(Either, [{
        key: "isLeft",
        value: function isLeft() {
            return !this._isRight;
        }
    }, {
        key: "isRight",
        value: function isRight() {
            return this._isRight;
        }
    }, {
        key: "contains",
        value: function contains(elem) {
            return this._isRight && is(this.value, elem);
        }
    }, {
        key: "exists",
        value: function exists(p) {
            return this._isRight && p(this.value);
        }
    }, {
        key: "filterOrElse",
        value: function filterOrElse(p, zero) {
            return this._isRight ? p(this.value) ? this : Left(zero()) : this;
        }
    }, {
        key: "flatMap",
        value: function flatMap(f) {
            return this._isRight ? f(this.value) : this;
        }
    }, {
        key: "chain",
        value: function chain(f) {
            return this.flatMap(f);
        }
    }, {
        key: "ap",
        value: function ap(ff) {
            var _this = this;

            return ff.flatMap(function (f) {
                return _this.map(f);
            });
        }
    }, {
        key: "fold",
        value: function fold(left, right) {
            return this._isRight ? right(this.value) : left(this.value);
        }
    }, {
        key: "forAll",
        value: function forAll(p) {
            return !this._isRight || p(this.value);
        }
    }, {
        key: "get",
        value: function get$$1() {
            if (this._isRight) return this.value;
            throw new NoSuchElementError("left.get()");
        }
    }, {
        key: "getOrElse",
        value: function getOrElse(fallback) {
            return this._isRight ? this.value : fallback;
        }
    }, {
        key: "getOrElseL",
        value: function getOrElseL(thunk) {
            return this._isRight ? this.value : thunk();
        }
    }, {
        key: "map",
        value: function map(f) {
            return this._isRight ? Right(f(this.value)) : this;
        }
    }, {
        key: "forEach",
        value: function forEach(cb) {
            if (this._isRight) cb(this.value);
        }
    }, {
        key: "swap",
        value: function swap() {
            return this._isRight ? Left(this.value) : Right(this.value);
        }
    }, {
        key: "toOption",
        value: function toOption() {
            return this._isRight ? Some(this.value) : None;
        }
    }, {
        key: "equals",
        value: function equals$$1(that) {
            if (that == null) return false;
            return this._isRight === that._isRight && is(this.value, that.value);
        }
    }, {
        key: "hashCode",
        value: function hashCode$$1() {
            return this._isRight ? hashCode(this.value) << 2 : hashCode(this.value) << 3;
        }
    }], [{
        key: "pure",
        value: function pure(value) {
            return new TRight(value);
        }
    }, {
        key: "left",
        value: function left(value) {
            return Left(value);
        }
    }, {
        key: "right",
        value: function right(value) {
            return Right(value);
        }
    }, {
        key: "map2",
        value: function map2(fa1, fa2, f) {
            if (fa1.isLeft()) return fa1;
            if (fa2.isLeft()) return fa2;
            return Right(f(fa1.value, fa2.value));
        }
    }, {
        key: "map3",
        value: function map3(fa1, fa2, fa3, f) {
            if (fa1.isLeft()) return fa1;
            if (fa2.isLeft()) return fa2;
            if (fa3.isLeft()) return fa3;
            return Right(f(fa1.value, fa2.value, fa3.value));
        }
    }, {
        key: "map4",
        value: function map4(fa1, fa2, fa3, fa4, f) {
            if (fa1.isLeft()) return fa1;
            if (fa2.isLeft()) return fa2;
            if (fa3.isLeft()) return fa3;
            if (fa4.isLeft()) return fa4;
            return Right(f(fa1.value, fa2.value, fa3.value, fa4.value));
        }
    }, {
        key: "map5",
        value: function map5(fa1, fa2, fa3, fa4, fa5, f) {
            if (fa1.isLeft()) return fa1;
            if (fa2.isLeft()) return fa2;
            if (fa3.isLeft()) return fa3;
            if (fa4.isLeft()) return fa4;
            if (fa5.isLeft()) return fa5;
            return Right(f(fa1.value, fa2.value, fa3.value, fa4.value, fa5.value));
        }
    }, {
        key: "map6",
        value: function map6(fa1, fa2, fa3, fa4, fa5, fa6, f) {
            if (fa1.isLeft()) return fa1;
            if (fa2.isLeft()) return fa2;
            if (fa3.isLeft()) return fa3;
            if (fa4.isLeft()) return fa4;
            if (fa5.isLeft()) return fa5;
            if (fa6.isLeft()) return fa6;
            return Right(f(fa1.value, fa2.value, fa3.value, fa4.value, fa5.value, fa6.value));
        }
    }, {
        key: "tailRecM",
        value: function tailRecM(a, f) {
            var cursor = a;
            while (true) {
                var result = f(cursor);
                if (!result.isRight()) return result;
                var some = result.value;
                if (some.isRight()) return Right(some.value);
                cursor = some.value;
            }
        }
    }]);
    return Either;
}();

var TLeft = function (_Either) {
    inherits(TLeft, _Either);

    function TLeft(value) {
        classCallCheck(this, TLeft);
        return possibleConstructorReturn(this, (TLeft.__proto__ || Object.getPrototypeOf(TLeft)).call(this, value, "left"));
    }

    return TLeft;
}(Either);

function Left(value) {
    return new TLeft(value);
}

var TRight = function (_Either2) {
    inherits(TRight, _Either2);

    function TRight(value) {
        classCallCheck(this, TRight);
        return possibleConstructorReturn(this, (TRight.__proto__ || Object.getPrototypeOf(TRight)).call(this, value, "right"));
    }

    return TRight;
}(Either);

function Right(value) {
    return new TRight(value);
}

var EitherModule = {
    equals: function equals$$1(x, y) {
        return x ? x.equals(y) : !y;
    },

    map: function map(f, fa) {
        return fa.map(f);
    },

    ap: function ap(ff, fa) {
        return fa.ap(ff);
    },

    of: Either.pure,

    chain: function chain(f, fa) {
        return fa.flatMap(f);
    },

    chainRec: function chainRec(f, a) {
        return Either.tailRecM(a, function (a) {
            return f(Either.left, Either.right, a);
        });
    }
};

fantasyLandRegister(Either, EitherModule, EitherModule);

var Option = function () {
    function Option(ref, isEmpty) {
        classCallCheck(this, Option);

        this._isEmpty = isEmpty != null ? isEmpty : ref === null || ref === undefined;
        this.value = ref;
    }

    createClass(Option, [{
        key: "get",
        value: function get$$1() {
            if (!this._isEmpty) return this.value;
            throw new NoSuchElementError("Option.get");
        }
    }, {
        key: "getOrElse",
        value: function getOrElse(fallback) {
            if (!this._isEmpty) return this.value;else return fallback;
        }
    }, {
        key: "orNull",
        value: function orNull() {
            return !this._isEmpty ? this.value : null;
        }
    }, {
        key: "orUndefined",
        value: function orUndefined() {
            return !this._isEmpty ? this.value : undefined;
        }
    }, {
        key: "getOrElseL",
        value: function getOrElseL(thunk) {
            if (!this._isEmpty) return this.value;else return thunk();
        }
    }, {
        key: "orElse",
        value: function orElse(fallback) {
            if (!this._isEmpty) return this;else return fallback;
        }
    }, {
        key: "orElseL",
        value: function orElseL(thunk) {
            if (!this._isEmpty) return this;else return thunk();
        }
    }, {
        key: "isEmpty",
        value: function isEmpty() {
            return this._isEmpty;
        }
    }, {
        key: "nonEmpty",
        value: function nonEmpty() {
            return !this._isEmpty;
        }
    }, {
        key: "map",
        value: function map(f) {
            return this._isEmpty ? None : Some(f(this.value));
        }
    }, {
        key: "flatMap",
        value: function flatMap(f) {
            if (this._isEmpty) return None;else return f(this.value);
        }
    }, {
        key: "chain",
        value: function chain(f) {
            return this.flatMap(f);
        }
    }, {
        key: "ap",
        value: function ap(ff) {
            var _this4 = this;

            return ff.flatMap(function (f) {
                return _this4.map(f);
            });
        }
    }, {
        key: "filter",
        value: function filter(p) {
            if (this._isEmpty || !p(this.value)) return None;else return this;
        }
    }, {
        key: "fold",
        value: function fold(fallback, f) {
            if (this._isEmpty) return fallback();
            return f(this.value);
        }
    }, {
        key: "contains",
        value: function contains(elem) {
            return !this._isEmpty && is(this.value, elem);
        }
    }, {
        key: "exists",
        value: function exists(p) {
            return !this._isEmpty && p(this.value);
        }
    }, {
        key: "forAll",
        value: function forAll(p) {
            return this._isEmpty || p(this.value);
        }
    }, {
        key: "forEach",
        value: function forEach(cb) {
            if (!this._isEmpty) cb(this.value);
        }
    }, {
        key: "equals",
        value: function equals$$1(that) {
            if (that == null) return false;
            if (this.nonEmpty() && that.nonEmpty()) {
                return is(this.value, that.value);
            }
            return this.isEmpty() && that.isEmpty();
        }
    }, {
        key: "hashCode",
        value: function hashCode$$1() {
            if (this._isEmpty) return 2433880;else if (this.value == null) return 2433881 << 2;else return hashCode(this.value) << 2;
        }
    }], [{
        key: "of",
        value: function of(value) {
            return value != null ? Some(value) : None;
        }
    }, {
        key: "some",
        value: function some(value) {
            return new Option(value, false);
        }
    }, {
        key: "none",
        value: function none() {
            return None;
        }
    }, {
        key: "empty",
        value: function empty() {
            return None;
        }
    }, {
        key: "pure",
        value: function pure(value) {
            return Some(value);
        }
    }, {
        key: "map2",
        value: function map2(fa1, fa2, f) {
            return fa1.nonEmpty() && fa2.nonEmpty() ? Some(f(fa1.value, fa2.value)) : None;
        }
    }, {
        key: "map3",
        value: function map3(fa1, fa2, fa3, f) {
            return fa1.nonEmpty() && fa2.nonEmpty() && fa3.nonEmpty() ? Some(f(fa1.value, fa2.value, fa3.value)) : None;
        }
    }, {
        key: "map4",
        value: function map4(fa1, fa2, fa3, fa4, f) {
            return fa1.nonEmpty() && fa2.nonEmpty() && fa3.nonEmpty() && fa4.nonEmpty() ? Some(f(fa1.value, fa2.value, fa3.value, fa4.value)) : None;
        }
    }, {
        key: "map5",
        value: function map5(fa1, fa2, fa3, fa4, fa5, f) {
            return fa1.nonEmpty() && fa2.nonEmpty() && fa3.nonEmpty() && fa4.nonEmpty() && fa5.nonEmpty() ? Some(f(fa1.value, fa2.value, fa3.value, fa4.value, fa5.value)) : None;
        }
    }, {
        key: "map6",
        value: function map6(fa1, fa2, fa3, fa4, fa5, fa6, f) {
            return fa1.nonEmpty() && fa2.nonEmpty() && fa3.nonEmpty() && fa4.nonEmpty() && fa5.nonEmpty() && fa6.nonEmpty() ? Some(f(fa1.value, fa2.value, fa3.value, fa4.value, fa5.value, fa6.value)) : None;
        }
    }, {
        key: "tailRecM",
        value: function tailRecM(a, f) {
            var cursor = a;
            while (true) {
                var result = f(cursor);
                if (result.nonEmpty()) {
                    var some = result.value;
                    if (some.isRight()) return Some(some.value);
                    cursor = some.value;
                } else {
                    return None;
                }
            }
        }
    }]);
    return Option;
}();

var TSome = function (_Option) {
    inherits(TSome, _Option);

    function TSome(value) {
        classCallCheck(this, TSome);
        return possibleConstructorReturn(this, (TSome.__proto__ || Object.getPrototypeOf(TSome)).call(this, value, false));
    }

    return TSome;
}(Option);

function Some(value) {
    return new TSome(value);
}

var TNone = function (_Option2) {
    inherits(TNone, _Option2);

    function TNone() {
        classCallCheck(this, TNone);
        return possibleConstructorReturn(this, (TNone.__proto__ || Object.getPrototypeOf(TNone)).call(this, undefined, true));
    }

    return TNone;
}(Option);

var None = new TNone();

var OptionModule = {
    equals: function equals$$1(x, y) {
        return x ? x.equals(y) : !y;
    },

    map: function map(f, fa) {
        return fa.map(f);
    },

    ap: function ap(ff, fa) {
        return fa.ap(ff);
    },

    of: Option.pure,

    chain: function chain(f, fa) {
        return fa.flatMap(f);
    },

    chainRec: function chainRec(f, a) {
        return Option.tailRecM(a, function (a) {
            return f(Either.left, Either.right, a);
        });
    }
};

fantasyLandRegister(Option, OptionModule, OptionModule);

var Try = function () {
    function Try(value, tag) {
        classCallCheck(this, Try);

        this._isSuccess = tag === "success";
        this.value = value;
    }

    createClass(Try, [{
        key: "isSuccess",
        value: function isSuccess() {
            return this._isSuccess;
        }
    }, {
        key: "isFailure",
        value: function isFailure() {
            return !this._isSuccess;
        }
    }, {
        key: "get",
        value: function get$$1() {
            if (!this._isSuccess) throw this.value;
            return this.value;
        }
    }, {
        key: "getOrElse",
        value: function getOrElse(fallback) {
            return this._isSuccess ? this.value : fallback;
        }
    }, {
        key: "getOrElseL",
        value: function getOrElseL(thunk) {
            return this._isSuccess ? this.value : thunk();
        }
    }, {
        key: "orNull",
        value: function orNull() {
            return this._isSuccess ? this.value : null;
        }
    }, {
        key: "orUndefined",
        value: function orUndefined() {
            return this._isSuccess ? this.value : undefined;
        }
    }, {
        key: "orElse",
        value: function orElse(fallback) {
            if (this._isSuccess) return this;
            return fallback;
        }
    }, {
        key: "orElseL",
        value: function orElseL(thunk) {
            if (this._isSuccess) return this;
            return thunk();
        }
    }, {
        key: "failed",
        value: function failed() {
            return this._isSuccess ? Failure(new NoSuchElementError("try.failed()")) : Success(this.value);
        }
    }, {
        key: "fold",
        value: function fold(failure, success) {
            return this._isSuccess ? success(this.value) : failure(this.value);
        }
    }, {
        key: "filter",
        value: function filter(p) {
            if (!this._isSuccess) return this;
            try {
                if (p(this.value)) return this;
                return Failure(new NoSuchElementError("Predicate does not hold for " + this.value));
            } catch (e) {
                return Failure(e);
            }
        }
    }, {
        key: "flatMap",
        value: function flatMap(f) {
            if (!this._isSuccess) return this;
            try {
                return f(this.value);
            } catch (e) {
                return Failure(e);
            }
        }
    }, {
        key: "chain",
        value: function chain(f) {
            return this.flatMap(f);
        }
    }, {
        key: "ap",
        value: function ap(ff) {
            var _this7 = this;

            return ff.flatMap(function (f) {
                return _this7.map(f);
            });
        }
    }, {
        key: "map",
        value: function map(f) {
            var _this8 = this;

            return this._isSuccess ? Try.of(function () {
                return f(_this8.value);
            }) : this;
        }
    }, {
        key: "forEach",
        value: function forEach(cb) {
            if (this._isSuccess) cb(this.value);
        }
    }, {
        key: "recover",
        value: function recover(f) {
            var _this9 = this;

            return this._isSuccess ? this : Try.of(function () {
                return f(_this9.value);
            });
        }
    }, {
        key: "recoverWith",
        value: function recoverWith(f) {
            try {
                return this._isSuccess ? this : f(this.value);
            } catch (e) {
                return Failure(e);
            }
        }
    }, {
        key: "toOption",
        value: function toOption() {
            return this._isSuccess ? Some(this.value) : None;
        }
    }, {
        key: "toEither",
        value: function toEither() {
            return this._isSuccess ? Right(this.value) : Left(this.value);
        }
    }, {
        key: "equals",
        value: function equals$$1(that) {
            if (that == null) return false;
            return this._isSuccess ? that._isSuccess && is(this.value, that.value) : !that._isSuccess && is(this.value, that.value);
        }
    }, {
        key: "hashCode",
        value: function hashCode$$1() {
            return this._isSuccess ? hashCode(this.value) : hashCode(this.value);
        }
    }], [{
        key: "of",
        value: function of(thunk) {
            try {
                return Success(thunk());
            } catch (e) {
                return Failure(e);
            }
        }
    }, {
        key: "pure",
        value: function pure(value) {
            return Try.success(value);
        }
    }, {
        key: "unit",
        value: function unit() {
            return tryUnitRef;
        }
    }, {
        key: "success",
        value: function success(value) {
            return Success(value);
        }
    }, {
        key: "failure",
        value: function failure(e) {
            return Failure(e);
        }
    }, {
        key: "raise",
        value: function raise(e) {
            return Failure(e);
        }
    }, {
        key: "map2",
        value: function map2(fa1, fa2, f) {
            if (fa1.isFailure()) return fa1;
            if (fa2.isFailure()) return fa2;
            try {
                return Success(f(fa1.value, fa2.value));
            } catch (e) {
                return Failure(e);
            }
        }
    }, {
        key: "map3",
        value: function map3(fa1, fa2, fa3, f) {
            if (fa1.isFailure()) return fa1;
            if (fa2.isFailure()) return fa2;
            if (fa3.isFailure()) return fa3;
            try {
                return Success(f(fa1.value, fa2.value, fa3.value));
            } catch (e) {
                return Failure(e);
            }
        }
    }, {
        key: "map4",
        value: function map4(fa1, fa2, fa3, fa4, f) {
            if (fa1.isFailure()) return fa1;
            if (fa2.isFailure()) return fa2;
            if (fa3.isFailure()) return fa3;
            if (fa4.isFailure()) return fa4;
            try {
                return Success(f(fa1.value, fa2.value, fa3.value, fa4.value));
            } catch (e) {
                return Failure(e);
            }
        }
    }, {
        key: "map5",
        value: function map5(fa1, fa2, fa3, fa4, fa5, f) {
            if (fa1.isFailure()) return fa1;
            if (fa2.isFailure()) return fa2;
            if (fa3.isFailure()) return fa3;
            if (fa4.isFailure()) return fa4;
            if (fa5.isFailure()) return fa5;
            try {
                return Success(f(fa1.value, fa2.value, fa3.value, fa4.value, fa5.value));
            } catch (e) {
                return Failure(e);
            }
        }
    }, {
        key: "map6",
        value: function map6(fa1, fa2, fa3, fa4, fa5, fa6, f) {
            if (fa1.isFailure()) return fa1;
            if (fa2.isFailure()) return fa2;
            if (fa3.isFailure()) return fa3;
            if (fa4.isFailure()) return fa4;
            if (fa5.isFailure()) return fa5;
            if (fa6.isFailure()) return fa6;
            try {
                return Success(f(fa1.value, fa2.value, fa3.value, fa4.value, fa5.value, fa6.value));
            } catch (e) {
                return Failure(e);
            }
        }
    }, {
        key: "tailRecM",
        value: function tailRecM(a, f) {
            var cursor = a;
            while (true) {
                try {
                    var result = f(cursor);
                    if (result.isFailure()) return result;
                    var some = result.get();
                    if (some.isRight()) return Success(some.value);
                    cursor = some.value;
                } catch (e) {
                    return Failure(e);
                }
            }
        }
    }]);
    return Try;
}();

var TSuccess = function (_Try) {
    inherits(TSuccess, _Try);

    function TSuccess(value) {
        classCallCheck(this, TSuccess);
        return possibleConstructorReturn(this, (TSuccess.__proto__ || Object.getPrototypeOf(TSuccess)).call(this, value, "success"));
    }

    return TSuccess;
}(Try);

function Success(value) {
    return new TSuccess(value);
}

var TFailure = function (_Try2) {
    inherits(TFailure, _Try2);

    function TFailure(value) {
        classCallCheck(this, TFailure);
        return possibleConstructorReturn(this, (TFailure.__proto__ || Object.getPrototypeOf(TFailure)).call(this, value, "failure"));
    }

    return TFailure;
}(Try);

function Failure(e) {
    return new TFailure(e);
}

var TryModule = {
    equals: function equals$$1(x, y) {
        return x ? x.equals(y) : !y;
    },

    map: function map(f, fa) {
        return fa.map(f);
    },

    ap: function ap(ff, fa) {
        return fa.ap(ff);
    },

    of: Try.pure,

    chain: function chain(f, fa) {
        return fa.flatMap(f);
    },

    chainRec: function chainRec(f, a) {
        return Try.tailRecM(a, function (a) {
            return f(Either.left, Either.right, a);
        });
    }
};

fantasyLandRegister(Try, TryModule, TryModule);

var tryUnitRef = Success(undefined);

exports.coreInternals = internals;
exports.isValueObject = isValueObject;
exports.is = is;
exports.equals = equals;
exports.universalSetoid = universalSetoid;
exports.hashCode = hashCode;
exports.hashCodeOfString = hashCodeOfString;
exports.id = id;
exports.applyMixins = applyMixins;
exports.CompositeError = CompositeError;
exports.DummyError = DummyError;
exports.NoSuchElementError = NoSuchElementError;
exports.IllegalInheritanceError = IllegalInheritanceError;
exports.IllegalStateError = IllegalStateError;
exports.IllegalArgumentError = IllegalArgumentError;
exports.NotImplementedError = NotImplementedError;
exports.TimeoutError = TimeoutError;
exports.Either = Either;
exports.TLeft = TLeft;
exports.Left = Left;
exports.TRight = TRight;
exports.Right = Right;
exports.EitherModule = EitherModule;
exports.Option = Option;
exports.TSome = TSome;
exports.Some = Some;
exports.TNone = TNone;
exports.None = None;
exports.OptionModule = OptionModule;
exports.Try = Try;
exports.TSuccess = TSuccess;
exports.Success = Success;
exports.TFailure = TFailure;
exports.Failure = Failure;
exports.TryModule = TryModule;

Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=umd.js.map
