# Fuse.js

![Node.js CI](https://github.com/krisk/Fuse/workflows/Node.js%20CI/badge.svg)
[![Version](https://img.shields.io/npm/v/fuse.js.svg)](https://www.npmjs.com/package/fuse.js)
[![Downloads](https://img.shields.io/npm/dm/fuse.js.svg)](https://npmcharts.com/compare/fuse.js?minimal=tru)
[![code style: prettier](https://img.shields.io/badge/code_style-prettier-ff69b4.svg?style=flat-square)](https://github.com/prettier/prettier)
[![Contributors](https://img.shields.io/github/contributors/krisk/fuse.svg)](https://github.com/krisk/Fuse/graphs/contributors)
![License](https://img.shields.io/npm/l/fuse.js.svg)

## Supporting Fuse.js

Through contributions, donations, and sponsorship, you allow Fuse.js to thrive. Also, you will be recognized as a beacon of support to open-source developers.

- [Become a backer or sponsor on **GitHub**.](https://github.com/sponsors/krisk)
- [Become a backer or sponsor on **Patreon**.](https://patreon.com/fusejs)
- [One-time donation via **PayPal**.](https://www.paypal.me/kirorisk)

---

## Introduction

Fuse.js is a lightweight fuzzy-search, in JavaScript, with zero dependencies.

### Browser Compatibility

Fuse.js supports all browsers that are ES5-compliant (IE8 and below are not supported).

## Documentation

To checkout out live examples and docs, visit [fusejs.io](https://fusejs.io).

## Installation

**NPM**

```sh
$ npm install --save fuse.js
```

**Yarn**

```sh
$ yarn add fuse.js
```

**CDN**

Available on CDN via [jsDelivr](https://cdn.jsdelivr.net/npm/fuse.js/dist/).

> Note: it takes some time for the CDNs to sync with the latest version

### Explanation of Different Builds

In the [`dist/` directory of the NPM package](https://cdn.jsdelivr.net/npm/fuse.js/dist/) you will find many different builds of Fuse.js. Here's an [overview](dist/README.md) of the difference between them.

## Issues

This repository serves as [the main issue tracker](https://github.com/krisk/Fuse/issues). When creating issues, it's important to follow common guidelines to make them extra clear. Here is a few links to help you achieve that:

- [GitHub Guides: Mastering Issues](https://guides.github.com/features/issues/)
- [Wiredcraft: How We Write Github Issues](https://wiredcraft.com/blog/how-we-write-our-github-issues/)
- [NYC Planning Digital: Writing Useful Github Issues](https://medium.com/nyc-planning-digital/writing-a-proper-github-issue-97427d62a20f)
