/**
 * Fuse.js v5.2.3 - Lightweight fuzzy-search (http://fusejs.io)
 *
 * Copyright (c) 2020 Kiro Risk (http://kiro.me)
 * All Rights Reserved. Apache Software License 2.0
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 */
const t=t=>Array.isArray?Array.isArray(t):"[object Array]"===Object.prototype.toString.call(t),e=t=>"string"==typeof t,s=t=>"number"==typeof t,n=t=>null!=t,i=t=>!t.trim().length;var r={isCaseSensitive:!1,includeScore:!1,keys:[],shouldSort:!0,sortFn:(t,e)=>t.score===e.score?t.idx<e.idx?-1:1:t.score<e.score?-1:1,includeMatches:!1,findAllMatches:!1,minMatchCharLength:1,location:0,threshold:.6,distance:100,...{useExtendedSearch:!1,getFn:function(i,r){let c=[],h=!1;const o=(i,r)=>{if(r){const a=r.indexOf(".");let l=r,u=null;-1!==a&&(l=r.slice(0,a),u=r.slice(a+1));const d=i[l];if(n(d))if(u||!e(d)&&!s(d))if(t(d)){h=!0;for(let t=0,e=d.length;t<e;t+=1)o(d[t],u)}else u&&o(d,u);else c.push((t=>null==t?"":(t=>{if("string"==typeof t)return t;let e=t+"";return"0"==e&&1/t==-1/0?"-0":e})(t))(d))}else c.push(i)};return o(i,r),h?c:c[0]}}};function c(t,{errors:e=0,currentLocation:s=0,expectedLocation:n=0,distance:i=r.distance}={}){const c=e/t.length,h=Math.abs(n-s);return i?c+h/i:h?1:c}function h(t,e,s,{location:n=r.location,distance:i=r.distance,threshold:h=r.threshold,findAllMatches:o=r.findAllMatches,minMatchCharLength:a=r.minMatchCharLength,includeMatches:l=r.includeMatches}={}){if(e.length>32)throw new Error("Pattern length exceeds max of 32.");const u=e.length,d=t.length,g=Math.max(0,Math.min(n,d));let f=h,p=g;const m=[];if(l)for(let t=0;t<d;t+=1)m[t]=0;let M;for(;(M=t.indexOf(e,p))>-1;){let t=c(e,{currentLocation:M,expectedLocation:g,distance:i});if(f=Math.min(t,f),p=M+u,l){let t=0;for(;t<u;)m[M+t]=1,t+=1}}p=-1;let x=[],y=1,k=u+d;const S=1<<(u<=31?u-1:30);for(let n=0;n<u;n+=1){let r=0,h=k;for(;r<h;){c(e,{errors:n,currentLocation:g+h,expectedLocation:g,distance:i})<=f?r=h:k=h,h=Math.floor((k-r)/2+r)}k=h;let a=Math.max(1,g-h+1),M=o?d:Math.min(g+h,d)+u,_=Array(M+2);_[M+1]=(1<<n)-1;for(let r=M;r>=a;r-=1){let h=r-1,o=s[t.charAt(h)];if(o&&l&&(m[h]=1),_[r]=(_[r+1]<<1|1)&o,0!==n&&(_[r]|=(x[r+1]|x[r])<<1|1|x[r+1]),_[r]&S&&(y=c(e,{errors:n,currentLocation:h,expectedLocation:g,distance:i}),y<=f)){if(f=y,p=h,p<=g)break;a=Math.max(1,2*g-p)}}if(c(e,{errors:n+1,currentLocation:g,expectedLocation:g,distance:i})>f)break;x=_}let _={isMatch:p>=0,score:y||.001};return l&&(_.matchedIndices=function(t=[],e=r.minMatchCharLength){let s=[],n=-1,i=-1,c=0;for(let r=t.length;c<r;c+=1){let r=t[c];r&&-1===n?n=c:r||-1===n||(i=c-1,i-n+1>=e&&s.push([n,i]),n=-1)}return t[c-1]&&c-n>=e&&s.push([n,c-1]),s}(m,a)),_}function o(t){let e={},s=t.length;for(let n=0;n<s;n+=1)e[t.charAt(n)]=0;for(let n=0;n<s;n+=1)e[t.charAt(n)]|=1<<s-n-1;return e}class a{constructor(t,{location:e=r.location,threshold:s=r.threshold,distance:n=r.distance,includeMatches:i=r.includeMatches,findAllMatches:c=r.findAllMatches,minMatchCharLength:h=r.minMatchCharLength,isCaseSensitive:a=r.isCaseSensitive}={}){this.options={location:e,threshold:s,distance:n,includeMatches:i,findAllMatches:c,minMatchCharLength:h,isCaseSensitive:a},this.pattern=a?t:t.toLowerCase(),this.chunks=[];let l=0;for(;l<this.pattern.length;){let t=this.pattern.substring(l,l+32);this.chunks.push({pattern:t,alphabet:o(t)}),l+=32}}searchIn(t){let e=t.$;return this.searchInString(e)}searchInString(t){const{isCaseSensitive:e,includeMatches:s}=this.options;if(e||(t=t.toLowerCase()),this.pattern===t){let e={isMatch:!0,score:0};return s&&(e.matchedIndices=[[0,t.length-1]]),e}const{location:n,distance:i,threshold:r,findAllMatches:c,minMatchCharLength:o}=this.options;let a=[],l=0,u=!1;for(let e=0,d=this.chunks.length;e<d;e+=1){let{pattern:d,alphabet:g}=this.chunks[e],f=h(t,d,g,{location:n+32*e,distance:i,threshold:r,findAllMatches:c,minMatchCharLength:o,includeMatches:s});const{isMatch:p,score:m,matchedIndices:M}=f;p&&(u=!0),l+=m,p&&M&&(a=[...a,...M])}let d={isMatch:u,score:u?l/this.chunks.length:1};return u&&s&&(d.matchedIndices=a),d}}class l{constructor(t){this.pattern=t}static isMultiMatch(t){return u(t,this.multiRegex)}static isSingleMatch(t){return u(t,this.singleRegex)}search(){}}function u(t,e){const s=t.match(e);return s?s[1]:null}class d extends l{constructor(t){super(t)}static get type(){return"exact"}static get multiRegex(){return/^'"(.*)"$/}static get singleRegex(){return/^'(.*)$/}search(t){let e,s=0;const n=[],i=this.pattern.length;for(;(e=t.indexOf(this.pattern,s))>-1;)s=e+i,n.push([e,s-1]);const r=!!n.length;return{isMatch:r,score:r?1:0,matchedIndices:n}}}class g extends l{constructor(t,{location:e=r.location,threshold:s=r.threshold,distance:n=r.distance,includeMatches:i=r.includeMatches,findAllMatches:c=r.findAllMatches,minMatchCharLength:h=r.minMatchCharLength,isCaseSensitive:o=r.isCaseSensitive}={}){super(t),this._bitapSearch=new a(t,{location:e,threshold:s,distance:n,includeMatches:i,findAllMatches:c,minMatchCharLength:h,isCaseSensitive:o})}static get type(){return"fuzzy"}static get multiRegex(){return/^"(.*)"$/}static get singleRegex(){return/^(.*)$/}search(t){return this._bitapSearch.searchInString(t)}}const f=[d,class extends l{constructor(t){super(t)}static get type(){return"prefix-exact"}static get multiRegex(){return/^\^"(.*)"$/}static get singleRegex(){return/^\^(.*)$/}search(t){const e=t.startsWith(this.pattern);return{isMatch:e,score:e?0:1,matchedIndices:[0,this.pattern.length-1]}}},class extends l{constructor(t){super(t)}static get type(){return"inverse-prefix-exact"}static get multiRegex(){return/^!\^"(.*)"$/}static get singleRegex(){return/^!\^(.*)$/}search(t){const e=!t.startsWith(this.pattern);return{isMatch:e,score:e?0:1,matchedIndices:[0,t.length-1]}}},class extends l{constructor(t){super(t)}static get type(){return"inverse-suffix-exact"}static get multiRegex(){return/^!"(.*)"\$$/}static get singleRegex(){return/^!(.*)\$$/}search(t){const e=!t.endsWith(this.pattern);return{isMatch:e,score:e?0:1,matchedIndices:[0,t.length-1]}}},class extends l{constructor(t){super(t)}static get type(){return"suffix-exact"}static get multiRegex(){return/^"(.*)"\$$/}static get singleRegex(){return/^(.*)\$$/}search(t){const e=t.endsWith(this.pattern);return{isMatch:e,score:e?0:1,matchedIndices:[t.length-this.pattern.length,t.length-1]}}},class extends l{constructor(t){super(t)}static get type(){return"inverse-exact"}static get multiRegex(){return/^!"(.*)"$/}static get singleRegex(){return/^!(.*)$/}search(t){const e=-1===t.indexOf(this.pattern);return{isMatch:e,score:e?0:1,matchedIndices:[0,t.length-1]}}},g],p=f.length,m=/ +(?=([^\"]*\"[^\"]*\")*[^\"]*$)/;const M=new Set([g.type,d.type]);const x=/[^ ]+/g;function y(s,c,{getFn:h=r.getFn}={}){let o=[];if(e(c[0]))for(let t=0,e=c.length;t<e;t+=1){const e=c[t];if(n(e)&&!i(e)){let s={$:e,idx:t,t:e.match(x).length};o.push(s)}}else{const r=s.length;for(let a=0,l=c.length;a<l;a+=1){let l=c[a],u={idx:a,$:{}};for(let c=0;c<r;c+=1){let r=s[c],o=h(l,r);if(n(o))if(t(o)){let s=[];const c=[{arrayIndex:-1,value:o}];for(;c.length;){const{arrayIndex:r,value:h}=c.pop();if(n(h))if(e(h)&&!i(h)){let t={$:h,idx:r,t:h.match(x).length};s.push(t)}else if(t(h))for(let t=0,e=h.length;t<e;t+=1)c.push({arrayIndex:t,value:h[t]})}u.$[r]=s}else if(!i(o)){let t={$:o,t:o.match(x).length};u.$[r]=t}}o.push(u)}}return o}class k{constructor(t){if(this._keys={},this._keyNames=[],this._length=t.length,t.length&&e(t[0]))for(let e=0;e<this._length;e+=1){const s=t[e];this._keys[s]={weight:1},this._keyNames.push(s)}else{let e=0;for(let s=0;s<this._length;s+=1){const n=t[s];if(!Object.prototype.hasOwnProperty.call(n,"name"))throw new Error('Missing "name" property in key object');const i=n.name;if(this._keyNames.push(i),!Object.prototype.hasOwnProperty.call(n,"weight"))throw new Error('Missing "weight" property in key object');const r=n.weight;if(r<=0||r>=1)throw new Error('"weight" property in key must be in the range of (0, 1)');this._keys[i]={weight:r},e+=r}for(let t=0;t<this._length;t+=1){const s=this._keyNames[t],n=this._keys[s].weight;this._keys[s].weight=n/e}}}get(t,e){return this._keys[t]?this._keys[t][e]:-1}keys(){return this._keyNames}count(){return this._length}toJSON(){return JSON.stringify(this._keys)}}function S(t,e){const s=t.matches;if(e.matches=[],n(s))for(let t=0,i=s.length;t<i;t+=1){let i=s[t];if(!n(i.indices)||0===i.indices.length)continue;let r={indices:i.indices,value:i.value};i.key&&(r.key=i.key),i.idx>-1&&(r.refIndex=i.idx),e.matches.push(r)}}function _(t,e){e.score=t.score}const I=[];class C{constructor(t,e={},s=null){this.options={...r,...e},this._processKeys(this.options.keys),this.setCollection(t,s)}setCollection(t,s=null){this.list=t,this.listIsStringArray=e(t[0]),s?this.setIndex(s):this.setIndex(this._createIndex())}setIndex(t){this._indexedList=t}_processKeys(t){this._keyStore=new k(t)}_createIndex(){return y(this._keyStore.keys(),this.list,{getFn:this.options.getFn})}search(t,e={limit:!1}){if(!(t=t.trim()).length)return[];const{shouldSort:n}=this.options;let i=null;for(let e=0,s=I.length;e<s;e+=1){let s=I[e];if(s.condition(t,this.options)){i=new s(t,this.options);break}}i||(i=new a(t,this.options));let r=this._searchUsing(i);return this._computeScore(r),n&&this._sort(r),e.limit&&s(e.limit)&&(r=r.slice(0,e.limit)),this._format(r)}_searchUsing(e){const s=this._indexedList,i=[],{includeMatches:r}=this.options;if(this.listIsStringArray)for(let t=0,c=s.length;t<c;t+=1){let c=s[t],{$:h,idx:o,t:a}=c;if(!n(h))continue;let l=e.searchIn(c);const{isMatch:u,score:d}=l;if(!u)continue;let g={score:d,value:h,t:a};r&&(g.indices=l.matchedIndices),i.push({item:h,idx:o,matches:[g]})}else{const c=this._keyStore.keys(),h=this._keyStore.count();for(let o=0,a=s.length;o<a;o+=1){let{$:a,idx:l}=s[o];if(!n(a))continue;let u=[];for(let s=0;s<h;s+=1){let i=c[s],h=a[i];if(n(h))if(t(h))for(let t=0,s=h.length;t<s;t+=1){let s=h[t];const{$:c,idx:o,t:a}=s;if(!n(c))continue;let l=e.searchIn(s);const{isMatch:d,score:g}=l;if(!d)continue;let f={score:g,key:i,value:c,idx:o,t:a};r&&(f.indices=l.matchedIndices),u.push(f)}else{const{$:t,t:s}=h;let n=e.searchIn(h);const{isMatch:c,score:o}=n;if(!c)continue;let a={score:o,key:i,value:t,t:s};r&&(a.indices=n.matchedIndices),u.push(a)}}u.length&&i.push({idx:l,item:a,matches:u})}}return i}_computeScore(t){const e=t.length;for(let s=0;s<e;s+=1){const e=t[s],n=e.matches,i=n.length;let r=1;for(let t=0;t<i;t+=1){const e=n[t],{key:s,t:i}=e,c=this._keyStore.get(s,"weight"),h=c>-1?c:1,o=0===e.score&&c>-1?Number.EPSILON:e.score,a=1/Math.sqrt(i);r*=Math.pow(o,h*a)}e.score=r}}_sort(t){t.sort(this.options.sortFn)}_format(t){const e=[],{includeMatches:s,includeScore:n}=this.options;let i=[];s&&i.push(S),n&&i.push(_);for(let s=0,n=t.length;s<n;s+=1){const n=t[s],{idx:r}=n,c={item:this.list[r],refIndex:r};if(i.length)for(let t=0,e=i.length;t<e;t+=1)i[t](n,c);e.push(c)}return e}}!function(...t){I.push(...t)}(class{constructor(t,{isCaseSensitive:e=r.isCaseSensitive,includeMatches:s=r.includeMatches,minMatchCharLength:n=r.minMatchCharLength,findAllMatches:i=r.findAllMatches,location:c=r.location,threshold:h=r.threshold,distance:o=r.distance}={}){this.query=null,this.options={isCaseSensitive:e,includeMatches:s,minMatchCharLength:n,findAllMatches:i,location:c,threshold:h,distance:o},this.pattern=e?t:t.toLowerCase(),this.query=function(t,e={}){return t.split("|").map(t=>{let s=t.trim().split(m).filter(t=>t&&!!t.trim()),n=[];for(let t=0,i=s.length;t<i;t+=1){const i=s[t];let r=!1,c=-1;for(;!r&&++c<p;){const t=f[c];let s=t.isMultiMatch(i);s&&(n.push(new t(s,e)),r=!0)}if(!r)for(c=-1;++c<p;){const t=f[c];let s=t.isSingleMatch(i);if(s){n.push(new t(s,e));break}}}return n})}(this.pattern,this.options)}static condition(t,e){return e.useExtendedSearch}searchIn(t){const e=this.query;if(!e)return{isMatch:!1,score:1};let s=t.$;const{includeMatches:n,isCaseSensitive:i}=this.options;s=i?s:s.toLowerCase();let r=0,c=[],h=0;for(let t=0,i=e.length;t<i;t+=1){const i=e[t];c.length=0,r=0;for(let t=0,e=i.length;t<e;t+=1){const e=i[t],{isMatch:o,matchedIndices:a,score:l}=e.search(s);if(!o){h=0,r=0,c.length=0;break}if(r+=1,h+=l,n){const t=e.constructor.type;M.has(t)?c=[...c,...a]:c.push(a)}}if(r){let t={isMatch:!0,score:h/r};return n&&(t.matchedIndices=c),t}}return{isMatch:!1,score:1}}}),C.version="5.2.3",C.createIndex=y,C.config=r;export default C;