
// http://uk.mathworks.com/matlabcentral/newsreader/view_thread/293481
function toLatLon(datum) {
    var x = this.x, y = this.y, z = this.z;
    var a = datum.a, b = datum.b;

    //var u = atan(Math.sqrt(z/(x*x+y*y)) * (a/b));
    //var tanu = Math.tan(u);
    var tanu = Math.sqrt(z/(x*x+y*y)) * (a/b);

    var cosu = 1/(Math.sqrt(1+tanu*tanu));
    var sinu = tanu/(Math.sqrt(1+tanu*tanu));

    var φ  = Math.atan((z+eSq*b*sinu*sinu*sinu), Math.sqrt(x*x+y*y)-(e2*a*cosu*cosu*cosu));
    var λ  =  Math.atan2(y, x);

    var sinφ = Math.sin(φ), cosφ = Math.cos(φ);
    N_1  =  a / Math.sqrt(1-eSq*sinφ*sinφ);
    H_1  =  Math.sqrt(x*x+y*y)/cosφ - N_1;

    lat = φ.toDegrees();
    lon = λ.toDegrees();
}

g.Astroid = function(x, y) {
    // Solve k^4+2*k^3-(x^2+y^2-1)*k^2-2*y^2*k-y^2 = 0 for positive
    // root k.  This solution is adapted from Geocentric::Reverse.
    var k;
    var
        p = m.sq(x),
        q = m.sq(y),
        r = (p + q - 1) / 6;
    if ( !(q === 0 && r <= 0) ) {
        var
        // Avoid possible division by zero when r = 0 by multiplying
        // equations for s and t by r^3 and r, resp.
            S = p * q / 4,            // S = r^3 * s
            r2 = m.sq(r),
            r3 = r * r2,
        // The discrimant of the quadratic equation for T3.  This is
        // zero on the evolute curve p^(1/3)+q^(1/3) = 1
            disc = S * (S + 2 * r3);
        var u = r;
        if (disc >= 0) {
            var T3 = S + r3;
            // Pick the sign on the sqrt to maximize abs(T3).  This
            // minimizes loss of precision due to cancellation.  The
            // result is unchanged because of the way the T is used
            // in definition of u.
            T3 += T3 < 0 ? -Math.sqrt(disc) :
                Math.sqrt(disc);    // T3 = (r * t)^3
            // N.B. cbrt always returns the real root.  cbrt(-8) = -2.
            var T = m.cbrt(T3);     // T = r * t
            // T can be zero; but then r2 / T -> 0.
            u += T + (T !== 0 ? r2 / T : 0);
        } else {
            // T is complex, but the way u is defined the result is real.
            var ang = Math.atan2(Math.sqrt(-disc), -(S + r3));
            // There are three possible cube roots.  We choose the
            // root which avoids cancellation.  Note that disc < 0
            // implies that r < 0.
            u += 2 * r * Math.cos(ang / 3);
        }
        var
            v = Math.sqrt(m.sq(u) + q),       // guaranteed positive
        // Avoid loss of accuracy when u < 0.
            uv = u < 0 ? q / (v - u) : u + v, // u+v, guaranteed positive
            w = (uv - q) / (2 * v);           // positive?
        // Rearrange expression for k to avoid loss of accuracy due to
        // subtraction.  Division by 0 not possible because uv > 0, w >= 0.
        k = uv / (Math.sqrt(uv + m.sq(w)) + w); // guaranteed positive
    } else {                                  // q == 0 && r <= 0
        // y = 0 with |x| <= 1.  Handle this case directly.
        // for y small, positive root is k = abs(y)/sqrt(1-x^2)
        k = 0;
    }
    return k;
};
