# gfm-code-block-regex [![NPM version](https://badge.fury.io/js/gfm-code-block-regex.png)](http://badge.fury.io/js/gfm-code-block-regex)

> RegExp for gfm (GitHub Flavored Markdown) fenced code blocks.

## Install
#### Install with [npm](npmjs.org)

```bash
npm i gfm-code-block-regex --save
```

## Run tests

```bash
npm test
```

## Usage

```js
var re = require('gfm-code-block-regex')();

var hasCodeBlock = re().test('random text \n```js\nfoo\n```\n more random text');
console.log(RegExp.$1);
//=> 'true'

var block = re().exec('random text \n```js\nfoo\n```\n more random text');
console.log(RegExp.$1);
//=> '```js\nfoo\n```'

var lang = re().exec('random text \n```js\nfoo\n```\n more random text');
console.log(RegExp.$3)
//=> 'js'

var code = re().exec('random text \n```js\nfoo\n```\n more random text');
console.log(RegExp.$4)
//=> '\nfoo\n'
```

## Author

**Jon Schlinkert**
 
+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert) 

## License
Copyright (c) 2014 Jon Schlinkert, contributors.  
Released under the MIT license

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on September 23, 2014._