/// <reference types="lodash" />
import { LitElement, TemplateResult, PropertyValues } from 'lit';
import './portlet-card';
declare const ContentGrid_base: (new (...args: any[]) => import("@mixins/litLoggable").LoggableInterface) & typeof LitElement;
export declare class ContentGrid extends ContentGrid_base {
    messages: never[];
    parentScreenSize: string;
    cardSize: string;
    elementSize: string;
    backgroundColor: string;
    contextApiUrl: string;
    favoriteApiUrl: string;
    layoutApiUrl: string;
    portletApiUrl: string;
    userInfoApiUrl: string;
    cardHoverSrc: string;
    favorites: never[];
    allCategories: string[];
    portlets: Portlet[];
    hideTitle: boolean;
    showFooterCategories: boolean;
    hideAction: boolean;
    useExternalFilter: boolean;
    disableCache: boolean;
    cacheTTL: number;
    debug: boolean;
    portletBackgroundIsDark: boolean;
    _isVisible: boolean;
    _filterValue: string;
    _filterCategory: string;
    _localFavorites: string[] | undefined;
    _localPortlets: Portlet[] | undefined;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    shouldUpdate(changedProperties: Map<string | number | symbol, unknown>): boolean;
    willUpdate(changedProperties: PropertyValues): void;
    loadData(): void;
    fetchPortlets(): Promise<void>;
    fetchFavorites(): Promise<void>;
    reload(): void;
    debounceCalculateSize: import("lodash").DebouncedFunc<() => void>;
    calculateSize(): void;
    calculateCategories(): void;
    filteredPortlets(): Portlet[];
    portletCardSize(): string;
    getRenderPortletUrl(portlet: Portlet): string;
    hasAlternativeMaximizedUrl(portlet: Portlet): string;
    getAlternativeMaximizedTarget(portlet: Portlet): string;
    isFavorite(fname: string): boolean;
    debounceCatFilterChange: import("lodash").DebouncedFunc<(value: any) => void>;
    catFilterChange(e: Event): void;
    debounceValFilterChange: import("lodash").DebouncedFunc<(value: any) => void>;
    valFilterChange(e: Event): void;
    getExternalFilter(e: CustomEvent): void;
    sendExternalFilter(): void;
    sendCategories(): void;
    toggleFavorite(e: CustomEvent): void;
    render(): TemplateResult;
    renderCatFilter(): TemplateResult;
    renderCatFilterFooter(): TemplateResult;
    renderPortlets(): TemplateResult;
    static styles: import("lit").CSSResult;
}
export {};
//# sourceMappingURL=content-grid.d.ts.map