import { LitElement, TemplateResult } from 'lit';
import './content-user';
import './content-favorites';
import './content-grid';
import './header-buttons';
import './lit-spinner';
declare const ContentMenu_base: (new (...args: any[]) => import("@mixins/litLoggable").LoggableInterface) & typeof LitElement;
export declare class ContentMenu extends ContentMenu_base {
    messages: never[];
    favoritesPortletCardSize: string;
    gridPortletCardSize: string;
    defaultOrgLogo: string;
    forceOrgLogo: string;
    contextApiUrl: string;
    favoriteApiUrl: string;
    layoutApiUrl: string;
    portletApiUrl: string;
    organizationApiUrl: string;
    userInfoApiUrl: string;
    signoutUrl: string | undefined;
    userInfoPortletUrl: string;
    switchOrgPortletUrl: string;
    orgAttributeName: string;
    orgLogoUrlAttributeName: string;
    userAllOrgsIdAttributeName: string;
    cardHoverSrc: string;
    hideActionMode: string;
    isHidden: boolean;
    showFavoritesInSlider: boolean;
    disableCache: boolean;
    cacheTTL: number;
    debug: boolean;
    fakeAttribute: boolean;
    _screenSize: string;
    _hideAction: boolean;
    _currentOrg: Organization | null;
    _currentUser: UserInfo | null;
    _currentUserOrgs: OrgInfo | null;
    _portlets: Portlet[] | null;
    _favorites: string[] | null;
    _inError: boolean;
    private _errorMessage;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    shouldUpdate(changedProperties: Map<string | number | symbol, unknown>): boolean;
    updated(changedProperties: Map<string | number | symbol, unknown>): void;
    fetchPortlets(): Promise<void>;
    fetchFavorites(): Promise<void>;
    fetchUserInfo(): Promise<void>;
    calculateSize(): void;
    onClose(e: Event): void;
    isOtherOrgs(): boolean;
    getOrgImage(): string;
    actionToggleFav(e: CustomEvent): void;
    render(): TemplateResult;
    static styles: import("lit").CSSResult[];
    _error(errorMessage: string): void;
}
export {};
//# sourceMappingURL=content-menu.d.ts.map