/// <reference types="lodash" />
import { LitElement, TemplateResult } from 'lit';
import Swiper from 'swiper';
import './portlet-card';
import './content-grid';
declare const ContentFavorites_base: (new (...args: any[]) => import("@mixins/litLoggable").LoggableInterface) & typeof LitElement;
export declare class ContentFavorites extends ContentFavorites_base {
    messages: never[];
    portalBaseUrl: string;
    parentScreenSize: string;
    cardSize: string;
    backgroundColor: string;
    contextApiUrl: string;
    favoriteApiUrl: string;
    portletApiUrl: string;
    userInfoApiUrl: string;
    portlets: Portlet[];
    favorites: string[];
    hide: boolean;
    hideAction: boolean;
    disableSwiper: boolean;
    disableCache: boolean;
    cacheTTL: number;
    debug: boolean;
    _elementSize: string;
    _swiperObj: Swiper | undefined;
    _prevSiperBtnIsAtive: boolean;
    _nextSiperBtnIsAtive: boolean;
    swiper: HTMLElement;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    shouldUpdate(changedProperties: Map<string | number | symbol, unknown>): boolean;
    willUpdate(changedProperties: Map<string | number | symbol, unknown>): void;
    firstUpdated(changedProperties: Map<string | number | symbol, unknown>): void;
    updated(_changedProperties: Map<string | number | symbol, unknown>): void;
    debounceCalculateSize: import("lodash").DebouncedFunc<() => void>;
    calculateSize(): void;
    portletCardSize(): string;
    getRenderPortletUrl(portlet: Portlet): string;
    hasAlternativeMaximizedUrl(portlet: Portlet): boolean;
    getAlternativeMaximizedTarget(portlet: Portlet): string;
    debounceUpdateNavigation: import("lodash").DebouncedFunc<() => void>;
    updateNavigation(): void;
    swipeRight(): void;
    swipeLeft(): void;
    favorited(): Portlet[];
    toggleFavorite(e: CustomEvent): void;
    render(): TemplateResult;
    static styles: import("lit").CSSResult[];
}
export {};
//# sourceMappingURL=content-favorites.d.ts.map