import cachedService from './cachedService';
import { type Response as OIDCResponse } from '@uportal/open-id-connect';
export default class favoritesService extends cachedService {
    static fetch(userInfoApiUrl: string, layoutApiUrl: string, userInfo?: OIDCResponse | null, debug?: boolean): Promise<LayoutContentGroup[] | null>;
    static renew(userInfoApiUrl: string, layoutApiUrl: string, debug: boolean): Promise<LayoutContentGroup[] | null>;
    static add(userInfoApiUrl: string, favoriteApiUrl: string, chanId: string): Promise<boolean>;
    static remove(userInfoApiUrl: string, favoriteApiUrl: string, chanId: string): Promise<boolean>;
    static flattenFavorites(favorites: LayoutContentGroup[] | LayoutContentItem[] | LayoutContentGroup | LayoutContentItem | null): string[];
}
//# sourceMappingURL=favoritesService.d.ts.map