import cachedService from './cachedService';
import { type Response as OIDCResponse } from '@uportal/open-id-connect';
export default class portletService extends cachedService {
    static fetch(userInfoApiUrl: string, portletApiUrl: string, userInfo: OIDCResponse | null | undefined, debug: boolean): Promise<FetchPortletResult | null>;
    /**
     * Combines a array of arrays into a single level array
     * @param {Array<Portlet>} acc - accumulator that combines all the arrays
     * @param {Array<Portlet>} arr - new array to add to the accumulator
     * @return {Array<Portlet>} merged arrays
     */
    private static flatten;
    /**
     * Takes the returned array from treeWalker and removes duplicates
     * based on "fname"
     * @param {Object} registryJson Portlet Registry Tree
     * @return {Array<Portlet>} list of portlets
     */
    static portletRegistryToArray(registryJson: FetchPortletResult): Portlet[];
    /**
     * Walks the portlet registry tree
     * @param {Object} registryJson Portlet Registry Tree
     * @return {Array<Portlet>} list of portlets
     */
    private static treeWalker;
    /**
     * Custom function to remove duplicates portlet on fname, but with merging categories.
     * @param {Array<Portlet>} array - Portlet List with duplicates.
     * @return {Array<Portlet>} Portlet List without duplicates.
     */
    private static customUnique;
    static getAlternativeMaximizedUrl(portlet: Portlet): string;
    static getAlternativeMaximizedTarget(portlet: Portlet): string;
    static getRenderUrl(portlet: Portlet, context: string): string;
    static sortPortlets(a: Portlet, b: Portlet): number;
}
//# sourceMappingURL=portletService.d.ts.map