(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.esupJsTree = {}));
})(this, (function (exports) { 'use strict';

  /**
   * @license
   * Copyright 2019 Google LLC
   * SPDX-License-Identifier: BSD-3-Clause
   */
  const t$2=window,e$3=t$2.ShadowRoot&&(void 0===t$2.ShadyCSS||t$2.ShadyCSS.nativeShadow)&&"adoptedStyleSheets"in Document.prototype&&"replace"in CSSStyleSheet.prototype,s$4=Symbol(),n$4=new WeakMap;class o$5{constructor(t,e,n){if(this._$cssResult$=!0,n!==s$4)throw Error("CSSResult is not constructable. Use `unsafeCSS` or `css` instead.");this.cssText=t,this.t=e;}get styleSheet(){let t=this.o;const s=this.t;if(e$3&&void 0===t){const e=void 0!==s&&1===s.length;e&&(t=n$4.get(s)),void 0===t&&((this.o=t=new CSSStyleSheet).replaceSync(this.cssText),e&&n$4.set(s,t));}return t}toString(){return this.cssText}}const r$3=t=>new o$5("string"==typeof t?t:t+"",void 0,s$4),i$2=(t,...e)=>{const n=1===t.length?t[0]:e.reduce(((e,s,n)=>e+(t=>{if(!0===t._$cssResult$)return t.cssText;if("number"==typeof t)return t;throw Error("Value passed to 'css' function must be a 'css' function result: "+t+". Use 'unsafeCSS' to pass non-literal values, but take care to ensure page security.")})(s)+t[n+1]),t[0]);return new o$5(n,t,s$4)},S$2=(s,n)=>{e$3?s.adoptedStyleSheets=n.map((t=>t instanceof CSSStyleSheet?t:t.styleSheet)):n.forEach((e=>{const n=document.createElement("style"),o=t$2.litNonce;void 0!==o&&n.setAttribute("nonce",o),n.textContent=e.cssText,s.appendChild(n);}));},c$2=e$3?t=>t:t=>t instanceof CSSStyleSheet?(t=>{let e="";for(const s of t.cssRules)e+=s.cssText;return r$3(e)})(t):t;

  /**
   * @license
   * Copyright 2017 Google LLC
   * SPDX-License-Identifier: BSD-3-Clause
   */var s$3;const e$2=window,r$2=e$2.trustedTypes,h$2=r$2?r$2.emptyScript:"",o$4=e$2.reactiveElementPolyfillSupport,n$3={toAttribute(t,i){switch(i){case Boolean:t=t?h$2:null;break;case Object:case Array:t=null==t?t:JSON.stringify(t);}return t},fromAttribute(t,i){let s=t;switch(i){case Boolean:s=null!==t;break;case Number:s=null===t?null:Number(t);break;case Object:case Array:try{s=JSON.parse(t);}catch(t){s=null;}}return s}},a$2=(t,i)=>i!==t&&(i==i||t==t),l$3={attribute:!0,type:String,converter:n$3,reflect:!1,hasChanged:a$2},d$2="finalized";class u$2 extends HTMLElement{constructor(){super(),this._$Ei=new Map,this.isUpdatePending=!1,this.hasUpdated=!1,this._$El=null,this._$Eu();}static addInitializer(t){var i;this.finalize(),(null!==(i=this.h)&&void 0!==i?i:this.h=[]).push(t);}static get observedAttributes(){this.finalize();const t=[];return this.elementProperties.forEach(((i,s)=>{const e=this._$Ep(s,i);void 0!==e&&(this._$Ev.set(e,s),t.push(e));})),t}static createProperty(t,i=l$3){if(i.state&&(i.attribute=!1),this.finalize(),this.elementProperties.set(t,i),!i.noAccessor&&!this.prototype.hasOwnProperty(t)){const s="symbol"==typeof t?Symbol():"__"+t,e=this.getPropertyDescriptor(t,s,i);void 0!==e&&Object.defineProperty(this.prototype,t,e);}}static getPropertyDescriptor(t,i,s){return {get(){return this[i]},set(e){const r=this[t];this[i]=e,this.requestUpdate(t,r,s);},configurable:!0,enumerable:!0}}static getPropertyOptions(t){return this.elementProperties.get(t)||l$3}static finalize(){if(this.hasOwnProperty(d$2))return !1;this[d$2]=!0;const t=Object.getPrototypeOf(this);if(t.finalize(),void 0!==t.h&&(this.h=[...t.h]),this.elementProperties=new Map(t.elementProperties),this._$Ev=new Map,this.hasOwnProperty("properties")){const t=this.properties,i=[...Object.getOwnPropertyNames(t),...Object.getOwnPropertySymbols(t)];for(const s of i)this.createProperty(s,t[s]);}return this.elementStyles=this.finalizeStyles(this.styles),!0}static finalizeStyles(i){const s=[];if(Array.isArray(i)){const e=new Set(i.flat(1/0).reverse());for(const i of e)s.unshift(c$2(i));}else void 0!==i&&s.push(c$2(i));return s}static _$Ep(t,i){const s=i.attribute;return !1===s?void 0:"string"==typeof s?s:"string"==typeof t?t.toLowerCase():void 0}_$Eu(){var t;this._$E_=new Promise((t=>this.enableUpdating=t)),this._$AL=new Map,this._$Eg(),this.requestUpdate(),null===(t=this.constructor.h)||void 0===t||t.forEach((t=>t(this)));}addController(t){var i,s;(null!==(i=this._$ES)&&void 0!==i?i:this._$ES=[]).push(t),void 0!==this.renderRoot&&this.isConnected&&(null===(s=t.hostConnected)||void 0===s||s.call(t));}removeController(t){var i;null===(i=this._$ES)||void 0===i||i.splice(this._$ES.indexOf(t)>>>0,1);}_$Eg(){this.constructor.elementProperties.forEach(((t,i)=>{this.hasOwnProperty(i)&&(this._$Ei.set(i,this[i]),delete this[i]);}));}createRenderRoot(){var t;const s=null!==(t=this.shadowRoot)&&void 0!==t?t:this.attachShadow(this.constructor.shadowRootOptions);return S$2(s,this.constructor.elementStyles),s}connectedCallback(){var t;void 0===this.renderRoot&&(this.renderRoot=this.createRenderRoot()),this.enableUpdating(!0),null===(t=this._$ES)||void 0===t||t.forEach((t=>{var i;return null===(i=t.hostConnected)||void 0===i?void 0:i.call(t)}));}enableUpdating(t){}disconnectedCallback(){var t;null===(t=this._$ES)||void 0===t||t.forEach((t=>{var i;return null===(i=t.hostDisconnected)||void 0===i?void 0:i.call(t)}));}attributeChangedCallback(t,i,s){this._$AK(t,s);}_$EO(t,i,s=l$3){var e;const r=this.constructor._$Ep(t,s);if(void 0!==r&&!0===s.reflect){const h=(void 0!==(null===(e=s.converter)||void 0===e?void 0:e.toAttribute)?s.converter:n$3).toAttribute(i,s.type);this._$El=t,null==h?this.removeAttribute(r):this.setAttribute(r,h),this._$El=null;}}_$AK(t,i){var s;const e=this.constructor,r=e._$Ev.get(t);if(void 0!==r&&this._$El!==r){const t=e.getPropertyOptions(r),h="function"==typeof t.converter?{fromAttribute:t.converter}:void 0!==(null===(s=t.converter)||void 0===s?void 0:s.fromAttribute)?t.converter:n$3;this._$El=r,this[r]=h.fromAttribute(i,t.type),this._$El=null;}}requestUpdate(t,i,s){let e=!0;void 0!==t&&(((s=s||this.constructor.getPropertyOptions(t)).hasChanged||a$2)(this[t],i)?(this._$AL.has(t)||this._$AL.set(t,i),!0===s.reflect&&this._$El!==t&&(void 0===this._$EC&&(this._$EC=new Map),this._$EC.set(t,s))):e=!1),!this.isUpdatePending&&e&&(this._$E_=this._$Ej());}async _$Ej(){this.isUpdatePending=!0;try{await this._$E_;}catch(t){Promise.reject(t);}const t=this.scheduleUpdate();return null!=t&&await t,!this.isUpdatePending}scheduleUpdate(){return this.performUpdate()}performUpdate(){var t;if(!this.isUpdatePending)return;this.hasUpdated,this._$Ei&&(this._$Ei.forEach(((t,i)=>this[i]=t)),this._$Ei=void 0);let i=!1;const s=this._$AL;try{i=this.shouldUpdate(s),i?(this.willUpdate(s),null===(t=this._$ES)||void 0===t||t.forEach((t=>{var i;return null===(i=t.hostUpdate)||void 0===i?void 0:i.call(t)})),this.update(s)):this._$Ek();}catch(t){throw i=!1,this._$Ek(),t}i&&this._$AE(s);}willUpdate(t){}_$AE(t){var i;null===(i=this._$ES)||void 0===i||i.forEach((t=>{var i;return null===(i=t.hostUpdated)||void 0===i?void 0:i.call(t)})),this.hasUpdated||(this.hasUpdated=!0,this.firstUpdated(t)),this.updated(t);}_$Ek(){this._$AL=new Map,this.isUpdatePending=!1;}get updateComplete(){return this.getUpdateComplete()}getUpdateComplete(){return this._$E_}shouldUpdate(t){return !0}update(t){void 0!==this._$EC&&(this._$EC.forEach(((t,i)=>this._$EO(i,this[i],t))),this._$EC=void 0),this._$Ek();}updated(t){}firstUpdated(t){}}u$2[d$2]=!0,u$2.elementProperties=new Map,u$2.elementStyles=[],u$2.shadowRootOptions={mode:"open"},null==o$4||o$4({ReactiveElement:u$2}),(null!==(s$3=e$2.reactiveElementVersions)&&void 0!==s$3?s$3:e$2.reactiveElementVersions=[]).push("1.6.3");

  /**
   * @license
   * Copyright 2017 Google LLC
   * SPDX-License-Identifier: BSD-3-Clause
   */
  var t$1;const i$1=window,s$2=i$1.trustedTypes,e$1=s$2?s$2.createPolicy("lit-html",{createHTML:t=>t}):void 0,o$3="$lit$",n$2=`lit$${(Math.random()+"").slice(9)}$`,l$2="?"+n$2,h$1=`<${l$2}>`,r$1=document,u$1=()=>r$1.createComment(""),d$1=t=>null===t||"object"!=typeof t&&"function"!=typeof t,c$1=Array.isArray,v$1=t=>c$1(t)||"function"==typeof(null==t?void 0:t[Symbol.iterator]),a$1="[ \t\n\f\r]",f$1=/<(?:(!--|\/[^a-zA-Z])|(\/?[a-zA-Z][^>\s]*)|(\/?$))/g,_$1=/-->/g,m$1=/>/g,p$1=RegExp(`>|${a$1}(?:([^\\s"'>=/]+)(${a$1}*=${a$1}*(?:[^ \t\n\f\r"'\`<>=]|("|')|))|$)`,"g"),g$1=/'/g,$$1=/"/g,y=/^(?:script|style|textarea|title)$/i,w$1=t=>(i,...s)=>({_$litType$:t,strings:i,values:s}),x=w$1(1),T$1=Symbol.for("lit-noChange"),A$1=Symbol.for("lit-nothing"),E$1=new WeakMap,C$1=r$1.createTreeWalker(r$1,129,null,!1);function P$1(t,i){if(!Array.isArray(t)||!t.hasOwnProperty("raw"))throw Error("invalid template strings array");return void 0!==e$1?e$1.createHTML(i):i}const V$1=(t,i)=>{const s=t.length-1,e=[];let l,r=2===i?"<svg>":"",u=f$1;for(let i=0;i<s;i++){const s=t[i];let d,c,v=-1,a=0;for(;a<s.length&&(u.lastIndex=a,c=u.exec(s),null!==c);)a=u.lastIndex,u===f$1?"!--"===c[1]?u=_$1:void 0!==c[1]?u=m$1:void 0!==c[2]?(y.test(c[2])&&(l=RegExp("</"+c[2],"g")),u=p$1):void 0!==c[3]&&(u=p$1):u===p$1?">"===c[0]?(u=null!=l?l:f$1,v=-1):void 0===c[1]?v=-2:(v=u.lastIndex-c[2].length,d=c[1],u=void 0===c[3]?p$1:'"'===c[3]?$$1:g$1):u===$$1||u===g$1?u=p$1:u===_$1||u===m$1?u=f$1:(u=p$1,l=void 0);const w=u===p$1&&t[i+1].startsWith("/>")?" ":"";r+=u===f$1?s+h$1:v>=0?(e.push(d),s.slice(0,v)+o$3+s.slice(v)+n$2+w):s+n$2+(-2===v?(e.push(void 0),i):w);}return [P$1(t,r+(t[s]||"<?>")+(2===i?"</svg>":"")),e]};class N$1{constructor({strings:t,_$litType$:i},e){let h;this.parts=[];let r=0,d=0;const c=t.length-1,v=this.parts,[a,f]=V$1(t,i);if(this.el=N$1.createElement(a,e),C$1.currentNode=this.el.content,2===i){const t=this.el.content,i=t.firstChild;i.remove(),t.append(...i.childNodes);}for(;null!==(h=C$1.nextNode())&&v.length<c;){if(1===h.nodeType){if(h.hasAttributes()){const t=[];for(const i of h.getAttributeNames())if(i.endsWith(o$3)||i.startsWith(n$2)){const s=f[d++];if(t.push(i),void 0!==s){const t=h.getAttribute(s.toLowerCase()+o$3).split(n$2),i=/([.?@])?(.*)/.exec(s);v.push({type:1,index:r,name:i[2],strings:t,ctor:"."===i[1]?H$1:"?"===i[1]?L$1:"@"===i[1]?z:k$1});}else v.push({type:6,index:r});}for(const i of t)h.removeAttribute(i);}if(y.test(h.tagName)){const t=h.textContent.split(n$2),i=t.length-1;if(i>0){h.textContent=s$2?s$2.emptyScript:"";for(let s=0;s<i;s++)h.append(t[s],u$1()),C$1.nextNode(),v.push({type:2,index:++r});h.append(t[i],u$1());}}}else if(8===h.nodeType)if(h.data===l$2)v.push({type:2,index:r});else {let t=-1;for(;-1!==(t=h.data.indexOf(n$2,t+1));)v.push({type:7,index:r}),t+=n$2.length-1;}r++;}}static createElement(t,i){const s=r$1.createElement("template");return s.innerHTML=t,s}}function S$1(t,i,s=t,e){var o,n,l,h;if(i===T$1)return i;let r=void 0!==e?null===(o=s._$Co)||void 0===o?void 0:o[e]:s._$Cl;const u=d$1(i)?void 0:i._$litDirective$;return (null==r?void 0:r.constructor)!==u&&(null===(n=null==r?void 0:r._$AO)||void 0===n||n.call(r,!1),void 0===u?r=void 0:(r=new u(t),r._$AT(t,s,e)),void 0!==e?(null!==(l=(h=s)._$Co)&&void 0!==l?l:h._$Co=[])[e]=r:s._$Cl=r),void 0!==r&&(i=S$1(t,r._$AS(t,i.values),r,e)),i}class M$1{constructor(t,i){this._$AV=[],this._$AN=void 0,this._$AD=t,this._$AM=i;}get parentNode(){return this._$AM.parentNode}get _$AU(){return this._$AM._$AU}u(t){var i;const{el:{content:s},parts:e}=this._$AD,o=(null!==(i=null==t?void 0:t.creationScope)&&void 0!==i?i:r$1).importNode(s,!0);C$1.currentNode=o;let n=C$1.nextNode(),l=0,h=0,u=e[0];for(;void 0!==u;){if(l===u.index){let i;2===u.type?i=new R$1(n,n.nextSibling,this,t):1===u.type?i=new u.ctor(n,u.name,u.strings,this,t):6===u.type&&(i=new Z$1(n,this,t)),this._$AV.push(i),u=e[++h];}l!==(null==u?void 0:u.index)&&(n=C$1.nextNode(),l++);}return C$1.currentNode=r$1,o}v(t){let i=0;for(const s of this._$AV)void 0!==s&&(void 0!==s.strings?(s._$AI(t,s,i),i+=s.strings.length-2):s._$AI(t[i])),i++;}}class R$1{constructor(t,i,s,e){var o;this.type=2,this._$AH=A$1,this._$AN=void 0,this._$AA=t,this._$AB=i,this._$AM=s,this.options=e,this._$Cp=null===(o=null==e?void 0:e.isConnected)||void 0===o||o;}get _$AU(){var t,i;return null!==(i=null===(t=this._$AM)||void 0===t?void 0:t._$AU)&&void 0!==i?i:this._$Cp}get parentNode(){let t=this._$AA.parentNode;const i=this._$AM;return void 0!==i&&11===(null==t?void 0:t.nodeType)&&(t=i.parentNode),t}get startNode(){return this._$AA}get endNode(){return this._$AB}_$AI(t,i=this){t=S$1(this,t,i),d$1(t)?t===A$1||null==t||""===t?(this._$AH!==A$1&&this._$AR(),this._$AH=A$1):t!==this._$AH&&t!==T$1&&this._(t):void 0!==t._$litType$?this.g(t):void 0!==t.nodeType?this.$(t):v$1(t)?this.T(t):this._(t);}k(t){return this._$AA.parentNode.insertBefore(t,this._$AB)}$(t){this._$AH!==t&&(this._$AR(),this._$AH=this.k(t));}_(t){this._$AH!==A$1&&d$1(this._$AH)?this._$AA.nextSibling.data=t:this.$(r$1.createTextNode(t)),this._$AH=t;}g(t){var i;const{values:s,_$litType$:e}=t,o="number"==typeof e?this._$AC(t):(void 0===e.el&&(e.el=N$1.createElement(P$1(e.h,e.h[0]),this.options)),e);if((null===(i=this._$AH)||void 0===i?void 0:i._$AD)===o)this._$AH.v(s);else {const t=new M$1(o,this),i=t.u(this.options);t.v(s),this.$(i),this._$AH=t;}}_$AC(t){let i=E$1.get(t.strings);return void 0===i&&E$1.set(t.strings,i=new N$1(t)),i}T(t){c$1(this._$AH)||(this._$AH=[],this._$AR());const i=this._$AH;let s,e=0;for(const o of t)e===i.length?i.push(s=new R$1(this.k(u$1()),this.k(u$1()),this,this.options)):s=i[e],s._$AI(o),e++;e<i.length&&(this._$AR(s&&s._$AB.nextSibling,e),i.length=e);}_$AR(t=this._$AA.nextSibling,i){var s;for(null===(s=this._$AP)||void 0===s||s.call(this,!1,!0,i);t&&t!==this._$AB;){const i=t.nextSibling;t.remove(),t=i;}}setConnected(t){var i;void 0===this._$AM&&(this._$Cp=t,null===(i=this._$AP)||void 0===i||i.call(this,t));}}class k$1{constructor(t,i,s,e,o){this.type=1,this._$AH=A$1,this._$AN=void 0,this.element=t,this.name=i,this._$AM=e,this.options=o,s.length>2||""!==s[0]||""!==s[1]?(this._$AH=Array(s.length-1).fill(new String),this.strings=s):this._$AH=A$1;}get tagName(){return this.element.tagName}get _$AU(){return this._$AM._$AU}_$AI(t,i=this,s,e){const o=this.strings;let n=!1;if(void 0===o)t=S$1(this,t,i,0),n=!d$1(t)||t!==this._$AH&&t!==T$1,n&&(this._$AH=t);else {const e=t;let l,h;for(t=o[0],l=0;l<o.length-1;l++)h=S$1(this,e[s+l],i,l),h===T$1&&(h=this._$AH[l]),n||(n=!d$1(h)||h!==this._$AH[l]),h===A$1?t=A$1:t!==A$1&&(t+=(null!=h?h:"")+o[l+1]),this._$AH[l]=h;}n&&!e&&this.j(t);}j(t){t===A$1?this.element.removeAttribute(this.name):this.element.setAttribute(this.name,null!=t?t:"");}}class H$1 extends k$1{constructor(){super(...arguments),this.type=3;}j(t){this.element[this.name]=t===A$1?void 0:t;}}const I$1=s$2?s$2.emptyScript:"";class L$1 extends k$1{constructor(){super(...arguments),this.type=4;}j(t){t&&t!==A$1?this.element.setAttribute(this.name,I$1):this.element.removeAttribute(this.name);}}class z extends k$1{constructor(t,i,s,e,o){super(t,i,s,e,o),this.type=5;}_$AI(t,i=this){var s;if((t=null!==(s=S$1(this,t,i,0))&&void 0!==s?s:A$1)===T$1)return;const e=this._$AH,o=t===A$1&&e!==A$1||t.capture!==e.capture||t.once!==e.once||t.passive!==e.passive,n=t!==A$1&&(e===A$1||o);o&&this.element.removeEventListener(this.name,this,e),n&&this.element.addEventListener(this.name,this,t),this._$AH=t;}handleEvent(t){var i,s;"function"==typeof this._$AH?this._$AH.call(null!==(s=null===(i=this.options)||void 0===i?void 0:i.host)&&void 0!==s?s:this.element,t):this._$AH.handleEvent(t);}}class Z$1{constructor(t,i,s){this.element=t,this.type=6,this._$AN=void 0,this._$AM=i,this.options=s;}get _$AU(){return this._$AM._$AU}_$AI(t){S$1(this,t);}}const B=i$1.litHtmlPolyfillSupport;null==B||B(N$1,R$1),(null!==(t$1=i$1.litHtmlVersions)&&void 0!==t$1?t$1:i$1.litHtmlVersions=[]).push("2.8.0");const D=(t,i,s)=>{var e,o;const n=null!==(e=null==s?void 0:s.renderBefore)&&void 0!==e?e:i;let l=n._$litPart$;if(void 0===l){const t=null!==(o=null==s?void 0:s.renderBefore)&&void 0!==o?o:null;n._$litPart$=l=new R$1(i.insertBefore(u$1(),t),t,void 0,null!=s?s:{});}return l._$AI(t),l};

  /**
   * @license
   * Copyright 2017 Google LLC
   * SPDX-License-Identifier: BSD-3-Clause
   */var l$1,o$2;class s$1 extends u$2{constructor(){super(...arguments),this.renderOptions={host:this},this._$Do=void 0;}createRenderRoot(){var t,e;const i=super.createRenderRoot();return null!==(t=(e=this.renderOptions).renderBefore)&&void 0!==t||(e.renderBefore=i.firstChild),i}update(t){const i=this.render();this.hasUpdated||(this.renderOptions.isConnected=this.isConnected),super.update(t),this._$Do=D(i,this.renderRoot,this.renderOptions);}connectedCallback(){var t;super.connectedCallback(),null===(t=this._$Do)||void 0===t||t.setConnected(!0);}disconnectedCallback(){var t;super.disconnectedCallback(),null===(t=this._$Do)||void 0===t||t.setConnected(!1);}render(){return T$1}}s$1.finalized=!0,s$1._$litElement$=!0,null===(l$1=globalThis.litElementHydrateSupport)||void 0===l$1||l$1.call(globalThis,{LitElement:s$1});const n$1=globalThis.litElementPolyfillSupport;null==n$1||n$1({LitElement:s$1});(null!==(o$2=globalThis.litElementVersions)&&void 0!==o$2?o$2:globalThis.litElementVersions=[]).push("3.3.3");

  /**
   * @license
   * Copyright 2017 Google LLC
   * SPDX-License-Identifier: BSD-3-Clause
   */
  const t=globalThis,i=t.trustedTypes,s=i?i.createPolicy("lit-html",{createHTML:t=>t}):void 0,e="$lit$",h=`lit$${(Math.random()+"").slice(9)}$`,o$1="?"+h,n=`<${o$1}>`,r=document,l=()=>r.createComment(""),c=t=>null===t||"object"!=typeof t&&"function"!=typeof t,a=Array.isArray,u=t=>a(t)||"function"==typeof t?.[Symbol.iterator],d="[ \t\n\f\r]",f=/<(?:(!--|\/[^a-zA-Z])|(\/?[a-zA-Z][^>\s]*)|(\/?$))/g,v=/-->/g,_=/>/g,m=RegExp(`>|${d}(?:([^\\s"'>=/]+)(${d}*=${d}*(?:[^ \t\n\f\r"'\`<>=]|("|')|))|$)`,"g"),p=/'/g,g=/"/g,$=/^(?:script|style|textarea|title)$/i,w=Symbol.for("lit-noChange"),T=Symbol.for("lit-nothing"),A=new WeakMap,E=r.createTreeWalker(r,129);function C(t,i){if(!Array.isArray(t)||!t.hasOwnProperty("raw"))throw Error("invalid template strings array");return void 0!==s?s.createHTML(i):i}const P=(t,i)=>{const s=t.length-1,o=[];let r,l=2===i?"<svg>":"",c=f;for(let i=0;i<s;i++){const s=t[i];let a,u,d=-1,y=0;for(;y<s.length&&(c.lastIndex=y,u=c.exec(s),null!==u);)y=c.lastIndex,c===f?"!--"===u[1]?c=v:void 0!==u[1]?c=_:void 0!==u[2]?($.test(u[2])&&(r=RegExp("</"+u[2],"g")),c=m):void 0!==u[3]&&(c=m):c===m?">"===u[0]?(c=r??f,d=-1):void 0===u[1]?d=-2:(d=c.lastIndex-u[2].length,a=u[1],c=void 0===u[3]?m:'"'===u[3]?g:p):c===g||c===p?c=m:c===v||c===_?c=f:(c=m,r=void 0);const x=c===m&&t[i+1].startsWith("/>")?" ":"";l+=c===f?s+n:d>=0?(o.push(a),s.slice(0,d)+e+s.slice(d)+h+x):s+h+(-2===d?i:x);}return [C(t,l+(t[s]||"<?>")+(2===i?"</svg>":"")),o]};class V{constructor({strings:t,_$litType$:s},n){let r;this.parts=[];let c=0,a=0;const u=t.length-1,d=this.parts,[f,v]=P(t,s);if(this.el=V.createElement(f,n),E.currentNode=this.el.content,2===s){const t=this.el.content.firstChild;t.replaceWith(...t.childNodes);}for(;null!==(r=E.nextNode())&&d.length<u;){if(1===r.nodeType){if(r.hasAttributes())for(const t of r.getAttributeNames())if(t.endsWith(e)){const i=v[a++],s=r.getAttribute(t).split(h),e=/([.?@])?(.*)/.exec(i);d.push({type:1,index:c,name:e[2],strings:s,ctor:"."===e[1]?k:"?"===e[1]?H:"@"===e[1]?I:R}),r.removeAttribute(t);}else t.startsWith(h)&&(d.push({type:6,index:c}),r.removeAttribute(t));if($.test(r.tagName)){const t=r.textContent.split(h),s=t.length-1;if(s>0){r.textContent=i?i.emptyScript:"";for(let i=0;i<s;i++)r.append(t[i],l()),E.nextNode(),d.push({type:2,index:++c});r.append(t[s],l());}}}else if(8===r.nodeType)if(r.data===o$1)d.push({type:2,index:c});else {let t=-1;for(;-1!==(t=r.data.indexOf(h,t+1));)d.push({type:7,index:c}),t+=h.length-1;}c++;}}static createElement(t,i){const s=r.createElement("template");return s.innerHTML=t,s}}function N(t,i,s=t,e){if(i===w)return i;let h=void 0!==e?s._$Co?.[e]:s._$Cl;const o=c(i)?void 0:i._$litDirective$;return h?.constructor!==o&&(h?._$AO?.(!1),void 0===o?h=void 0:(h=new o(t),h._$AT(t,s,e)),void 0!==e?(s._$Co??=[])[e]=h:s._$Cl=h),void 0!==h&&(i=N(t,h._$AS(t,i.values),h,e)),i}class S{constructor(t,i){this._$AV=[],this._$AN=void 0,this._$AD=t,this._$AM=i;}get parentNode(){return this._$AM.parentNode}get _$AU(){return this._$AM._$AU}u(t){const{el:{content:i},parts:s}=this._$AD,e=(t?.creationScope??r).importNode(i,!0);E.currentNode=e;let h=E.nextNode(),o=0,n=0,l=s[0];for(;void 0!==l;){if(o===l.index){let i;2===l.type?i=new M(h,h.nextSibling,this,t):1===l.type?i=new l.ctor(h,l.name,l.strings,this,t):6===l.type&&(i=new L(h,this,t)),this._$AV.push(i),l=s[++n];}o!==l?.index&&(h=E.nextNode(),o++);}return E.currentNode=r,e}p(t){let i=0;for(const s of this._$AV)void 0!==s&&(void 0!==s.strings?(s._$AI(t,s,i),i+=s.strings.length-2):s._$AI(t[i])),i++;}}class M{get _$AU(){return this._$AM?._$AU??this._$Cv}constructor(t,i,s,e){this.type=2,this._$AH=T,this._$AN=void 0,this._$AA=t,this._$AB=i,this._$AM=s,this.options=e,this._$Cv=e?.isConnected??!0;}get parentNode(){let t=this._$AA.parentNode;const i=this._$AM;return void 0!==i&&11===t?.nodeType&&(t=i.parentNode),t}get startNode(){return this._$AA}get endNode(){return this._$AB}_$AI(t,i=this){t=N(this,t,i),c(t)?t===T||null==t||""===t?(this._$AH!==T&&this._$AR(),this._$AH=T):t!==this._$AH&&t!==w&&this._(t):void 0!==t._$litType$?this.g(t):void 0!==t.nodeType?this.$(t):u(t)?this.T(t):this._(t);}k(t){return this._$AA.parentNode.insertBefore(t,this._$AB)}$(t){this._$AH!==t&&(this._$AR(),this._$AH=this.k(t));}_(t){this._$AH!==T&&c(this._$AH)?this._$AA.nextSibling.data=t:this.$(r.createTextNode(t)),this._$AH=t;}g(t){const{values:i,_$litType$:s}=t,e="number"==typeof s?this._$AC(t):(void 0===s.el&&(s.el=V.createElement(C(s.h,s.h[0]),this.options)),s);if(this._$AH?._$AD===e)this._$AH.p(i);else {const t=new S(e,this),s=t.u(this.options);t.p(i),this.$(s),this._$AH=t;}}_$AC(t){let i=A.get(t.strings);return void 0===i&&A.set(t.strings,i=new V(t)),i}T(t){a(this._$AH)||(this._$AH=[],this._$AR());const i=this._$AH;let s,e=0;for(const h of t)e===i.length?i.push(s=new M(this.k(l()),this.k(l()),this,this.options)):s=i[e],s._$AI(h),e++;e<i.length&&(this._$AR(s&&s._$AB.nextSibling,e),i.length=e);}_$AR(t=this._$AA.nextSibling,i){for(this._$AP?.(!1,!0,i);t&&t!==this._$AB;){const i=t.nextSibling;t.remove(),t=i;}}setConnected(t){void 0===this._$AM&&(this._$Cv=t,this._$AP?.(t));}}class R{get tagName(){return this.element.tagName}get _$AU(){return this._$AM._$AU}constructor(t,i,s,e,h){this.type=1,this._$AH=T,this._$AN=void 0,this.element=t,this.name=i,this._$AM=e,this.options=h,s.length>2||""!==s[0]||""!==s[1]?(this._$AH=Array(s.length-1).fill(new String),this.strings=s):this._$AH=T;}_$AI(t,i=this,s,e){const h=this.strings;let o=!1;if(void 0===h)t=N(this,t,i,0),o=!c(t)||t!==this._$AH&&t!==w,o&&(this._$AH=t);else {const e=t;let n,r;for(t=h[0],n=0;n<h.length-1;n++)r=N(this,e[s+n],i,n),r===w&&(r=this._$AH[n]),o||=!c(r)||r!==this._$AH[n],r===T?t=T:t!==T&&(t+=(r??"")+h[n+1]),this._$AH[n]=r;}o&&!e&&this.O(t);}O(t){t===T?this.element.removeAttribute(this.name):this.element.setAttribute(this.name,t??"");}}class k extends R{constructor(){super(...arguments),this.type=3;}O(t){this.element[this.name]=t===T?void 0:t;}}class H extends R{constructor(){super(...arguments),this.type=4;}O(t){this.element.toggleAttribute(this.name,!!t&&t!==T);}}class I extends R{constructor(t,i,s,e,h){super(t,i,s,e,h),this.type=5;}_$AI(t,i=this){if((t=N(this,t,i,0)??T)===w)return;const s=this._$AH,e=t===T&&s!==T||t.capture!==s.capture||t.once!==s.once||t.passive!==s.passive,h=t!==T&&(s===T||e);e&&this.element.removeEventListener(this.name,this,s),h&&this.element.addEventListener(this.name,this,t),this._$AH=t;}handleEvent(t){"function"==typeof this._$AH?this._$AH.call(this.options?.host??this.element,t):this._$AH.handleEvent(t);}}class L{constructor(t,i,s){this.element=t,this.type=6,this._$AN=void 0,this._$AM=i,this.options=s;}get _$AU(){return this._$AM._$AU}_$AI(t){N(this,t);}}const Z=t.litHtmlPolyfillSupport;Z?.(V,M),(t.litHtmlVersions??=[]).push("3.0.2");

  /**
   * @license
   * Copyright 2018 Google LLC
   * SPDX-License-Identifier: BSD-3-Clause
   */const o=o=>o??T;

  const jsTreeStyle = i$2`
  /* tree */
  .root-tree {
    padding-left: 0;
    margin-left: 1px;
    margin-right: 1px;
    --min-dimension: var(--min-clickable-dimension, 24px);
  }
  .root-tree li {
    list-style-type: none;
  }
  .root-tree .row-data:focus,
  .root-tree .row-data:hover {
    color: var(--hover-text-color, black);
  }
  .root-tree .row-data.jstree-clicked,
  .root-tree .row-data.jstree-clicked span {
    background-color: var(--selected-background-color, transparent);
    color: var(--selected-text-color, black);
  }
  .root-tree .row,
  .root-tree .row-data {
    display: inline-block;
    min-height: var(--min-dimension);
    min-width: var(--min-dimension);
  }
  .root-tree .row-data span {
    margin-right: 3px;
    margin-left: 3px;
  }
  .root-tree .subtree {
    display: none;
  }
  .root-tree .subtree-active {
    display: block;
  }
  .row {
    width: calc(100% - var(--min-dimension));
    cursor: pointer;
    position: relative;
    padding-top: 1px;
    padding-bottom: 1px;
    padding-right: 1px;
    padding-left: var(--min-dimension);
  }
  .align-items-center {
    align-items: center !important;
  }
  .d-flex {
    display: flex !important;
  }
  .icon-indicator {
    left: calc(var(--min-dimension) / 2);
    position: absolute;
    top: 50%;
    transform: translateY(-50%) translateX(-50%);
  }
  .row-data {
    width: 100%;
  }
  i.icon {
    -moz-osx-font-smoothing: grayscale;
    -webkit-font-smoothing: antialiased;
    display: inline-block;
    font-style: normal;
    font-variant: normal;
    text-rendering: auto;
    line-height: 1;
    margin: 0px 2px;
    font-family: var(--icon-font-family, 'Font Awesome 6 Free');
    font-weight: var(--icon-font-weight, 900);
  }
  i.icon:before {
    content: var(--icon-content, '\\f07b');
  }
  .item-subtree > div > .icon-indicator {
    font-family: var(--icon-fold-font-family, 'Font Awesome 6 Free');
    font-weight: var(--icon-fold-font-weight, 900);
  }
  .item-subtree > div > .icon-indicator:before {
    content: var(--icon-fold-content, '\\f0da');
  }
  .item-active > div > .icon-indicator {
    font-family: var(--icon-unfold-font-family, 'Font Awesome 6 Free');
    font-weight: var(--icon-unfold-font-weight, 900);
  }
  .item-active > div > .icon-indicator:before {
    content: var(--icon-unfold-content, '\\f0d7');
  }
  i.icon-0 {
    font-family: var(--icon-0-font-family, 'Font Awesome 6 Free');
    font-weight: var(--icon-0-font-weight, 900);
  }
  i.icon-0:before {
    content: var(--icon-0-content, '\\f07b');
  }
  i.icon-1 {
    font-family: var(--icon-1-font-family, 'Font Awesome 6 Free');
    font-weight: var(--icon-1-font-weight, 900);
  }
  i.icon-1:before {
    content: var(--icon-1-content, '\\f07b');
  }
  i.icon-2 {
    font-family: var(--icon-2-font-family, 'Font Awesome 6 Free');
    font-weight: var(--icon-2-font-weight, 900);
  }
  i.icon-2:before {
    content: var(--icon-2-content, '\\f07b');
  }
  i.icon-3 {
    font-family: var(--icon-3-font-family, 'Font Awesome 6 Free');
    font-weight: var(--icon-3-font-weight, 900);
  }
  i.icon-3:before {
    content: var(--icon-3-content, '\\f07b');
  }
  i.icon-4 {
    font-family: var(--icon-4-font-family, 'Font Awesome 6 Free');
    font-weight: var(--icon-4-font-weight, 900);
  }
  i.icon-4:before {
    content: var(--icon-4-content, '\\f07b');
  }
  i.icon-5 {
    font-family: var(--icon-5-font-family, 'Font Awesome 6 Free');
    font-weight: var(--icon-5-font-weight, 900);
  }
  i.icon-5:before {
    content: var(--icon-5-content, '\\f07b');
  }
  i.icon-6 {
    font-family: var(--icon-6-font-family, 'Font Awesome 6 Free');
    font-weight: var(--icon-6-font-weight, 900);
  }
  i.icon-6:before {
    content: var(--icon-6-content, '\\f07b');
  }
  i.icon-7 {
    font-family: var(--icon-7-font-family, 'Font Awesome 6 Free');
    font-weight: var(--icon-7-font-weight, 900);
  }
  i.icon-7:before {
    content: var(--icon-7-content, '\\f07b');
  }
  i.icon-8 {
    font-family: var(--icon-8-font-family, 'Font Awesome 6 Free');
    font-weight: var(--icon-8-font-weight, 900);
  }
  i.icon-8:before {
    content: var(--icon-8-content, '\\f07b');
  }
  i.icon-9 {
    font-family: var(--icon-9-font-family, 'Font Awesome 6 Free');
    font-weight: var(--icon-9-font-weight, 900);
  }
  i.icon-9:before {
    content: var(--icon-9-content, '\\f07b');
  }
  i.icon-10 {
    font-family: var(--icon-10-font-family, 'Font Awesome 6 Free');
    font-weight: var(--icon-10-font-weight, 900);
  }
  i.icon-10:before {
    content: var(--icon-10-content, '\\f07b');
  }
`;

  /**
   * Js-Tree component.
   */
  class JsTree extends s$1 {
    static get styles() {
      return [jsTreeStyle]
    }

    static get properties() {
      return {
        /**
         * Tableau des valeurs racine de l'arbre.
         * @type {Array}
         */
        datas: { attribute: false },

        /**
         * Configuration de l'arbre.
         * @type {Object}
         */
        config: { attribute: false },

        /**
         * Fonction appelée à la sélection d'un élement de l'arbre.
         * @type {Function}
         */
        onSelection: { attribute: false }
      }
    }

    constructor() {
      super();

      this._datas = [];
      this._initKeyboardNavigation = false;
      this._activeElement = null;
    }

    render() {
      return this._renderTree(this._datas, 0, null)
    }

    willUpdate(changedProperties) {
      super.willUpdate(changedProperties);

      // Si les propriétés datas ou config sont modifiées, on initialise les éléments
      let initDatas = false;
      if (changedProperties) {
        initDatas = changedProperties.has('datas') || changedProperties.has('config');
      }

      if (initDatas) {
        // Initialisation des données
        this._datas = this.datas;
        this._initKeyboardNavigation = false;
        this._initDataList(this._datas, this.config.identifier);

        // Initialisation de la navigation au clavier
        this._activeElement = null;
        if (this._datas && this._datas.length > 0) {
          if (this.config.sort) {
            this._activeElement = this._datas.sort((node1, node2) => node1.text.localeCompare(node2.text))[0];
          } else {
            this._activeElement = this._datas[0];
          }
        }
      }
    }

    updated(changedProperties) {
      super.updated(changedProperties);

      // Cochage des checkbox des éléments sélectionnés
      this.shadowRoot.querySelectorAll('input[type="checkbox"]').forEach(el => {
        const data = this._findDatasByProperty(this._datas, 'idHtml', el.id.replace('-checkbox', ''));
        if (data && data.length === 1) {
          el.checked = data[0].selected;
        }
      });

      // Focus sur l'élément actif
      if (this._initKeyboardNavigation && this._activeElement) {
        this.shadowRoot.querySelectorAll('li').forEach(el => {
          if (el.id === this._activeElement.idHtml) {
            el.focus();
          }
        });
      }
    }

    /**
     * Méthode permettant de sélectionner un noeud à partir de son id.
     *
     * @param {String} id Identifiant du noeud
     */
    selectNode(id) {
      if (id) {
        const data = this._findDatasByProperty(this._datas, 'id', id);
        if (data && data.length > 0 && !data[0].selected) {
          this._onClickItem(null, data[0]);
        }
      }
    }

    /**
     * Méthode permettant de désélectionner tous les noeuds.
     */
    deselectAllNodes() {
      const previousSelectedDatas = this._findDatasByProperty(this._datas, 'selected', true);
      if (previousSelectedDatas && previousSelectedDatas.length > 0) {
        this._unSelectDatas(this._datas);

        this.requestUpdate();

        // Information d'une sélection/désélection
        this._sendSelection();
      }
    }

    /**
     * Méthode permettant d'ajouter un nouveau noeud.
     *
     * @param {String} idParent Identifiant du noeud parent
     * @param {Object} properties Propriétés du nouveau noeud
     */
    addNode(idParent, properties) {
      if (idParent) {
        const parent = this._findDatasByProperty(this._datas, 'id', idParent);
        if (parent && parent.length > 0 && parent[0].areChildrenLoaded) {
          this._initDataList([properties], parent[0].idHtml);
          properties.parent = parent[0];
          parent[0].loadedChildren.push(properties);

          this.requestUpdate();
        }
      } else {
        this._initDataList([properties], this.config.identifier);
        properties.parent = null;
        this._datas.push(properties);

        this.requestUpdate();
      }
    }

    /**
     * Méthode permettant de supprimer un noeud à partir de son id.
     *
     * @param {String} id Identifiant du noeud
     */
    deleteNode(id) {
      if (id) {
        const data = this._findDatasByProperty(this._datas, 'id', id);
        if (data && data.length > 0) {
          const previousSelectedDatas = this._findDatasByProperty(this._datas, 'selected', true);
          if (data[0].parent) {
            data[0].parent.loadedChildren = data[0].parent.loadedChildren.filter(child => child.id !== data[0].id);
          } else {
            this._datas = this._datas.filter(child => child.id !== data[0].id);
          }

          this.requestUpdate();

          const nextSelectedDatas = this._findDatasByProperty(this._datas, 'selected', true);
          if (previousSelectedDatas.length !== nextSelectedDatas.length) {
            // Information d'une désélection
            this._sendSelection();
          }
        }
      }
    }

    /**
     * Méthode permettant de recharger un noeud.
     *
     * @param {String} id Identifiant du noeud
     * @param {Object} properties Nouvelles propriétés du noeud
     * @param {Boolean} refreshChildren Indique s'il faut rafraichir les enfants
     */
    refreshNode(id, properties, refreshChildren = false) {
      if (id) {
        const data = this._findDatasByProperty(this._datas, 'id', id);
        if (data && data.length > 0) {
          const previousSelectedDatas = this._findDatasByProperty(this._datas, 'selected', true);

          this._refreshNodes(data[0], properties, refreshChildren).then(() => {
            this.requestUpdate();

            const nextSelectedDatas = this._findDatasByProperty(this._datas, 'selected', true);
            if (previousSelectedDatas.length !== nextSelectedDatas.length) {
              // Information d'une désélection
              this._sendSelection();
            }
          });
        }
      }
    }

    /**
     * Fonction récursive pour construire un niveau de l'arborescence.
     *
     * @param {Array} datas Tableau des éléments du niveau actuel
     * @param {Number} level Profondeur du niveau actuel
     * @param {Object} parent Elément parent du niveau actuel
     * @returns Code HTML
     */
    _renderTree(datas, level, parent) {
      // Tri des noeuds si demandé
      if (this.config.sort) {
        datas.sort((node1, node2) => node1.text.localeCompare(node2.text));
      }
      // prettier-ignore
      return x`
      <ul id="${parent ? parent.idHtml + '-children' : this.config.identifier}" class="${level === 0 ? 'root-tree' : parent.ulClasses.join(' ')}"
          role="${level === 0 ? 'tree' : 'group'}"
          aria-multiselectable="${o(level === 0 && this.config.isMultipleSelection ? 'true' : undefined)}" tabindex="${level === 0 ? '0' : '-1'}"
          aria-activedescendant="${o(level === 0 && this._activeElement ? this._activeElement.idHtml : undefined)}"
          aria-labelledby="${o(parent ? parent.idHtml + '-text' : undefined)}" @keydown="${(e) => this._onKeyDown(e)}">
        ${(datas || []).map((data) => {
          return x`
            <li id ="${data.idHtml}" class="${data.liClasses.join(' ')}" tabindex="-1" aria-expanded="${data.expanded}" 
                role="treeitem" aria-selected="${data.selected}" aria-owns="${o(data.loadedChildren ? data.idHtml + '-children' : undefined)}">
                <div class="row" @click="${(e) => this._onClickRow(e, data)}">
                  ${this._renderIconIndicator(data)}
                  <div class="row-data d-flex align-items-center ${data.selected ? 'jstree-clicked' : ''}" @click="${(e) => this._onClickItem(e, data)}">
                    ${this._renderCheckbox(data)}
                    <i class="icon ${data.iconIndex !== null ? 'icon-' + data.iconIndex : ''}" aria-hidden="true"></i>
                    <span id="${data.idHtml}-text">${data.text}</span>
                  </div>
                </div>
                ${data.loadedChildren ? this._renderTree(data.loadedChildren, level + 1 , data) : ''}
            </li>`
        })}
      </ul>
    `
    }

    /**
     * Retourne le code HTML de l'icône plié/déplié d'un élement.
     *
     * @param {Object} data Elément
     * @returns Code HTML
     */
    _renderIconIndicator(data) {
      if (data.children && (!data.areChildrenLoaded || (data.loadedChildren && data.loadedChildren.length > 0))) {
        // prettier-ignore
        return  x`<i class="icon icon-indicator"></i>`
      } else {
        return x``
      }
    }

    /**
     * Retourne le code HTML de la checkbox d'un élement.
     *
     * @param {Object} data Elément
     * @returns Code HTML
     */
    _renderCheckbox(data) {
      if (this.config.showCheckbox) {
        // prettier-ignore
        return  x`<input type="checkbox" id ="${data.idHtml}-checkbox"
        tabindex="-1" ?checked="${data.selected}" aria-labelledby="${data.idHtml}-text"
        ?disabled="${this.config.allowDeselection === false && data.selected}">`
      } else {
        return x``
      }
    }

    /**
     * Méthode appelé au clic sur un élément entrainant sa sélection/désélection.
     *
     * @param {Object} event Evènement
     * @param {Object} data Elément cliqué
     */
    _onClickItem(event, data) {
      if (event) {
        event.stopPropagation();
      }
      this._activeElement = data;

      if (this.config.allowDeselection !== false || !data.selected) {
        const oldValue = data.selected;
        // Si sélection simple, on désélectionne les éléments préalablement sélectionnés
        if (!this.config.isMultipleSelection) {
          this._unSelectDatas(this._datas);
        }
        data.selected = !oldValue;

        this.requestUpdate();

        // Information d'une sélection/désélection
        this._sendSelection();
      }
    }

    /**
     * Méthode appelé au clic sur une ligne de l'arborescence entrainant son dépliage/repliage.
     *
     * @param {Object} event Evènement
     * @param {Object} data Elément cliqué
     */
    _onClickRow(event, data) {
      event.stopPropagation();
      this._activeElement = data;
      if (data.children) {
        if (data.expanded) {
          // On replie l'élément
          data.expanded = false;
          if (data.ulClasses.includes('subtree-active')) {
            data.ulClasses.splice(data.ulClasses.indexOf('subtree-active'), 1);
          }
          if (data.liClasses.includes('item-active')) {
            data.liClasses.splice(data.liClasses.indexOf('item-active'), 1);
          }
          this.requestUpdate();
        } else {
          // On déplie l'élément
          if (data.children) {
            data.expanded = true;
            data.ulClasses.push('subtree-active');
            data.liClasses.push('item-active');
            if (!data.areChildrenLoaded) {
              this._loadDataChildren(data, () => this.requestUpdate());
            } else {
              this.requestUpdate();
            }
          }
        }
      }
    }

    /**
     * Méthode appelé à la navigation au clavier dans l'arborescence.
     *
     * @param {Object} event Evènement
     */
    _onKeyDown(event) {
      if (event.keyCode === 13 || event.keyCode === 32) {
        // Touche entrée ou Espace
        this._onClickItem(event, this._activeElement);
      } else if (event.keyCode === 37) {
        // Touche gauche
        // On replie l'élément actif
        if (this._activeElement.expanded) {
          this._activeElement.expanded = false;
          if (this._activeElement.ulClasses.includes('subtree-active')) {
            this._activeElement.ulClasses.splice(this._activeElement.ulClasses.indexOf('subtree-active'), 1);
          }
          if (this._activeElement.liClasses.includes('item-active')) {
            this._activeElement.liClasses.splice(this._activeElement.liClasses.indexOf('item-active'), 1);
          }
        } else if (this._activeElement.parent && this._activeElement.parent.expanded) {
          this._activeElement = this._activeElement.parent;
        }
        event.preventDefault();
        event.stopPropagation();
        this.requestUpdate();
      } else if (event.keyCode === 38) {
        // Touche haut
        // On se déplace sur l'élement au dessus
        const sibbling = this._getUpVisibleSiblingElement(this._activeElement);
        if (sibbling != null) {
          this._activeElement = sibbling;
        }
        event.preventDefault();
        event.stopPropagation();
        this.requestUpdate();
      } else if (event.keyCode === 39) {
        // Touche droite
        // On déplie l'élément actif
        if (this._activeElement.children) {
          if (this._activeElement.expanded) {
            if (this._activeElement.loadedChildren && this._activeElement.loadedChildren.length > 0) {
              this._activeElement = this._activeElement.loadedChildren[0];
            }
            event.preventDefault();
            event.stopPropagation();
            this.requestUpdate();
          } else {
            this._activeElement.expanded = true;
            this._activeElement.ulClasses.push('subtree-active');
            this._activeElement.liClasses.push('item-active');
            if (!this._activeElement.areChildrenLoaded) {
              this._loadDataChildren(this._activeElement, () => {
                event.preventDefault();
                event.stopPropagation();
                this.requestUpdate();
              });
            } else {
              event.preventDefault();
              event.stopPropagation();
              this.requestUpdate();
            }
          }
        } else {
          event.preventDefault();
          event.stopPropagation();
        }
      } else if (event.keyCode === 40) {
        // Touche bas
        // On se déplace sur l'élement en dessus
        if (this._initKeyboardNavigation) {
          if (
            this._activeElement.expanded &&
            this._activeElement.loadedChildren &&
            this._activeElement.loadedChildren.length > 0
          ) {
            this._activeElement = this._activeElement.loadedChildren[0];
          } else {
            const sibbling = this._getDownVisibleSiblingElement(this._activeElement);
            if (sibbling != null) {
              this._activeElement = sibbling;
            }
          }
        }
        event.preventDefault();
        event.stopPropagation();
        this.requestUpdate();
      }
      this._initKeyboardNavigation = true;
    }

    /**
     * Initialisation des données des éléments.
     *
     * @param {Array} datas Tableau des éléments
     * @param {String} parentIdHtml Identifiant HTML du parent des éléments
     */
    _initDataList(datas, parentIdHtml) {
      if (datas && datas.length > 0) {
        datas.forEach(data => {
          data.ulClasses = ['subtree'];
          data.liClasses = [];
          if (data.children) {
            data.liClasses.push('item-subtree');
          }
          data.expanded = false;
          data.parent = null;
          data.idHtml = (parentIdHtml || '') + '-' + data.id;
          data.selected = false;
          data.loadedChildren = null;
          data.areChildrenLoaded = false;
        });
      }
    }

    /**
     * Méthode récursive permettant de désélectionner tous les éléments.
     *
     * @param {Array} datas Tableau des éléments
     */
    _unSelectDatas(datas) {
      datas.forEach(data => {
        data.selected = false;
        if (data.loadedChildren) {
          this._unSelectDatas(data.loadedChildren);
        }
      });
    }

    /**
     * Méthode récursive permettant de recherche des éléments selon une propriété.
     *
     * @param {Array} datas Tableau des éléments
     * @param {String} propertyName Nom de la propriété recherchée
     * @param {String|Number} propertyValue Valeur de la propriété recherchée
     * @returns Tableau des éléments trouvés
     */
    _findDatasByProperty(datas, propertyName, propertyValue) {
      let result = [];
      datas.forEach(data => {
        if (data[propertyName] === propertyValue) {
          result.push(data);
        }
        if (data.children && data.loadedChildren) {
          result = result.concat(this._findDatasByProperty(data.loadedChildren, propertyName, propertyValue));
        }
      });
      return result
    }

    /**
     * Méthode chargeant les enfants d'un élément.
     *
     * @param {Object} data Elément
     * @param {Function} callback Fonction appelé après le chargement des enfants
     */
    _loadDataChildren(data, callback) {
      this._getChildren(data, children => {
        this._initDataList(children, data.idHtml);
        data.loadedChildren = children;
        data.loadedChildren.forEach(child => (child.parent = data));
        data.areChildrenLoaded = true;
        if (callback) {
          callback();
        }
      });
    }

    /**
     * Méthode récupérant les enfants d'un élément.
     *
     * @param {Object} data Elément
     * @param {Function} callback Fonction appelé après la récupération des enfants
     */
    _getChildren(data, callback) {
      if (typeof data.getChildren === 'function') {
        data.getChildren().then(children => {
          callback(children);
        });
      } else if (Array.isArray(data.getChildren) || data.getChildren instanceof Array) {
        callback(data.getChildren);
      }
    }

    /**
     * Méthode récursive permettant de trouver l'élément en dessous d'un élément donné.
     *
     * @param {Object} element Elément
     * @returns Elément en dessous
     */
    _getDownVisibleSiblingElement(element) {
      if (element.parent) {
        for (let i = 0; i < element.parent.loadedChildren.length; i++) {
          if (element.parent.loadedChildren[i].id === element.id) {
            if (i < element.parent.loadedChildren.length - 1) {
              return element.parent.loadedChildren[i + 1]
            } else {
              return this._getDownVisibleSiblingElement(element.parent)
            }
          }
        }
      } else {
        for (let i = 0; i < this._datas.length; i++) {
          if (this._datas[i].id === element.id) {
            if (i < this._datas.length - 1) {
              return this._datas[i + 1]
            }
          }
        }
      }
      return null
    }

    /**
     * Méthode permettant de trouver l'élément au dessus d'un élément donné.
     *
     * @param {Object} element Elément
     * @returns Elément au dessus
     */
    _getUpVisibleSiblingElement(element) {
      if (element.parent) {
        for (let i = 0; i < element.parent.loadedChildren.length; i++) {
          if (element.parent.loadedChildren[i].id === element.id) {
            if (i > 0) {
              return this._getLastVisibleChild(element.parent.loadedChildren[i - 1])
            } else {
              return element.parent
            }
          }
        }
      } else {
        for (let i = 0; i < this._datas.length; i++) {
          if (this._datas[i].id === element.id) {
            if (i > 0) {
              return this._getLastVisibleChild(this._datas[i - 1])
            }
          }
        }
      }
      return null
    }

    /**
     * Méthode récursive permettant de trouver l'élément enfant le plus bas d'un élément donné.
     *
     * @param {Object} element Elément
     * @returns Elément le plus bas
     */
    _getLastVisibleChild(element) {
      if (element.expanded && element.loadedChildren && element.loadedChildren.length > 0) {
        return this._getLastVisibleChild(element.loadedChildren[element.loadedChildren.length - 1])
      } else {
        return element
      }
    }

    /**
     * Méthode pour indiquer qu'une sélection/désélection a été faite.
     */
    _sendSelection() {
      // Appel de la méthode pour informer d'une sélection/désélection
      if (this.onSelection) {
        const selectedDatas = this._findDatasByProperty(this._datas, 'selected', true);
        this.onSelection(selectedDatas);
      }
    }

    /**
     * Méthode permettant de recharger des noeuds.
     *
     * @param {Object} oldNode Anciennes données du noeud
     * @param {Object} newNode Nouvelles données du noeud
     * @param {Boolean} refreshChildren Indique s'il faut rafraichir les enfants du noeud
     */
    _refreshNodes(oldNode, newNode, refreshChildren) {
      return new Promise(resolve => {
        Object.assign(oldNode, newNode);
        if (refreshChildren && oldNode.children && oldNode.areChildrenLoaded) {
          this._getChildren(oldNode, newChildren => {
            // Suppresson des enfants qui ne sont plus là
            const newIds = newChildren.map(c => c.id);
            oldNode.loadedChildren = oldNode.loadedChildren.filter(child => newIds.includes(child.id));
            // Ajout/Mise à jour des enfants
            let index = 0;
            const promises = [];
            newChildren.forEach(newChild => {
              const oldChild = oldNode.loadedChildren.find(c => c.id === newChild.id);
              if (!oldChild) {
                this._initDataList([newChild], oldNode.idHtml);
                newChild.parent = oldNode;
                oldNode.loadedChildren.splice(index, 0, newChild);
              } else {
                promises.push(this._refreshNodes(oldChild, newChild, refreshChildren));
              }
              index++;
            });
            Promise.all(promises).then(() => resolve());
          });
        } else {
          resolve();
        }
      })
    }
  }

  if (!customElements.get('esup-js-tree')) {
    customElements.define('esup-js-tree', JsTree);
  }

  exports.JsTree = JsTree;

  Object.defineProperty(exports, '__esModule', { value: true });

}));
