"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _util = _interopRequireDefault(require("util.promisify"));

var _child_process = _interopRequireDefault(require("child_process"));

var _util2 = require("./util");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const exec = (0, _util.default)(_child_process.default.exec);
/**
 * Checks out a commit given its repo and hash.
 *
 * Returns void. Throws error on failure.
 */

const checkoutCommit = async (pathToRepo, hash, options = {
  force: false
}) => {
  const resolvedPath = (0, _util2.resolveHome)(pathToRepo);

  try {
    (0, _util2.validatePath)(resolvedPath);
  } catch (e) {
    return Promise.reject(e);
  }

  return exec(`git checkout ${hash} ${options.force ? '--force' : ''}`, {
    cwd: resolvedPath
  });
};

var _default = checkoutCommit;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9jaGVja291dF9jb21taXQuanMiXSwibmFtZXMiOlsiZXhlYyIsImNoaWxkUHJvY2VzcyIsImNoZWNrb3V0Q29tbWl0IiwicGF0aFRvUmVwbyIsImhhc2giLCJvcHRpb25zIiwiZm9yY2UiLCJyZXNvbHZlZFBhdGgiLCJlIiwiUHJvbWlzZSIsInJlamVjdCIsImN3ZCJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOztBQUNBOztBQUNBOzs7O0FBRUEsTUFBTUEsSUFBSSxHQUFHLG1CQUFVQyx1QkFBYUQsSUFBdkIsQ0FBYjtBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBQ0EsTUFBTUUsY0FBYyxHQUFHLE9BQU9DLFVBQVAsRUFBbUJDLElBQW5CLEVBQXlCQyxPQUFPLEdBQUc7QUFBQ0MsRUFBQUEsS0FBSyxFQUFFO0FBQVIsQ0FBbkMsS0FBc0Q7QUFDM0UsUUFBTUMsWUFBWSxHQUFHLHdCQUFZSixVQUFaLENBQXJCOztBQUVBLE1BQUk7QUFDRiw2QkFBYUksWUFBYjtBQUNELEdBRkQsQ0FFRSxPQUFPQyxDQUFQLEVBQVU7QUFDVixXQUFPQyxPQUFPLENBQUNDLE1BQVIsQ0FBZUYsQ0FBZixDQUFQO0FBQ0Q7O0FBRUQsU0FBT1IsSUFBSSxDQUFFLGdCQUFlSSxJQUFLLElBQUdDLE9BQU8sQ0FBQ0MsS0FBUixHQUFnQixTQUFoQixHQUE0QixFQUFHLEVBQXhELEVBQTJEO0FBQ3BFSyxJQUFBQSxHQUFHLEVBQUVKO0FBRCtELEdBQTNELENBQVg7QUFHRCxDQVpEOztlQWNlTCxjIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHByb21pc2lmeSBmcm9tICd1dGlsLnByb21pc2lmeSc7XG5pbXBvcnQgY2hpbGRQcm9jZXNzIGZyb20gJ2NoaWxkX3Byb2Nlc3MnO1xuaW1wb3J0IHt2YWxpZGF0ZVBhdGgsIHJlc29sdmVIb21lfSBmcm9tICcuL3V0aWwnO1xuXG5jb25zdCBleGVjID0gcHJvbWlzaWZ5KGNoaWxkUHJvY2Vzcy5leGVjKTtcblxuLyoqXG4gKiBDaGVja3Mgb3V0IGEgY29tbWl0IGdpdmVuIGl0cyByZXBvIGFuZCBoYXNoLlxuICpcbiAqIFJldHVybnMgdm9pZC4gVGhyb3dzIGVycm9yIG9uIGZhaWx1cmUuXG4gKi9cbmNvbnN0IGNoZWNrb3V0Q29tbWl0ID0gYXN5bmMgKHBhdGhUb1JlcG8sIGhhc2gsIG9wdGlvbnMgPSB7Zm9yY2U6IGZhbHNlfSkgPT4ge1xuICBjb25zdCByZXNvbHZlZFBhdGggPSByZXNvbHZlSG9tZShwYXRoVG9SZXBvKTtcblxuICB0cnkge1xuICAgIHZhbGlkYXRlUGF0aChyZXNvbHZlZFBhdGgpO1xuICB9IGNhdGNoIChlKSB7XG4gICAgcmV0dXJuIFByb21pc2UucmVqZWN0KGUpO1xuICB9XG5cbiAgcmV0dXJuIGV4ZWMoYGdpdCBjaGVja291dCAke2hhc2h9ICR7b3B0aW9ucy5mb3JjZSA/ICctLWZvcmNlJyA6ICcnfWAsIHtcbiAgICBjd2Q6IHJlc29sdmVkUGF0aFxuICB9KTtcbn07XG5cbmV4cG9ydCBkZWZhdWx0IGNoZWNrb3V0Q29tbWl0O1xuIl19