"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _util = _interopRequireDefault(require("util.promisify"));

var _child_process = _interopRequireDefault(require("child_process"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const execFile = (0, _util.default)(_child_process.default.execFile);
/**
 * Returns a git diff given a path to the repo, a commit,
 * an optional second commit, and an optional file.
 *
 * Returns the diff as a string.
 */

const gitDiff = (pathToRepo, commit1, commit2 = "", file = "") => {
  const args = ["diff", commit1];
  if (commit2) args.push(commit2);
  args.push("--");
  if (file) args.push(file);
  return execFile("git", args, {
    cwd: pathToRepo,
    encoding: "utf8",
    maxBuffer: 1024 * 1000
  }).then(output => output.stdout);
};

var _default = gitDiff;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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