"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _child_process = _interopRequireDefault(require("child_process"));

var _git_log_format_markers = require("./constants/git_log_format_markers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const gitLogFormatString = `${_git_log_format_markers.gitLogCommitMarker}%n%H%n%an%n%ae%n%aD%n${_git_log_format_markers.gitLogMessageMarker}%n%B%n${_git_log_format_markers.gitLogFileMarker}`;
/*
  Returns a stream of git log data from a git repository
*/

const gitLogStream = (pathToRepo, options = {}) => {
  const sinceCommit = options.sinceCommit ? `${options.sinceCommit}..HEAD` : '';
  const gitParams = ['log', `--pretty=format:${gitLogFormatString}`, '--name-status', sinceCommit, '--', './*', ':!node_modules'].filter(elt => elt !== '');

  const gitProcess = _child_process.default.spawn('git', gitParams, {
    cwd: pathToRepo
  });

  const errorHandlers = [];
  gitProcess.on('error', e => errorHandlers.forEach(handler => handler(e)));
  return {
    stream: gitProcess.stdout,
    addErrorHandler: fn => errorHandlers.push(fn)
  };
};

var _default = gitLogStream;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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