"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _util = _interopRequireDefault(require("util.promisify"));

var _child_process = _interopRequireDefault(require("child_process"));

var _util2 = require("./util");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const exec = (0, _util.default)(_child_process.default.exec);
/**
 * Pulls a repo given its path.
 *
 * Returns void. Throws error on failure.
 */

const gitPull = async pathToRepo => {
  const resolvedPath = (0, _util2.resolveHome)(pathToRepo);

  try {
    (0, _util2.validatePath)(resolvedPath);
  } catch (e) {
    return Promise.reject(e);
  }

  return exec(`git pull`, {
    cwd: resolvedPath
  });
};

var _default = gitPull;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9naXRfcHVsbC5qcyJdLCJuYW1lcyI6WyJleGVjIiwiY2hpbGRQcm9jZXNzIiwiZ2l0UHVsbCIsInBhdGhUb1JlcG8iLCJyZXNvbHZlZFBhdGgiLCJlIiwiUHJvbWlzZSIsInJlamVjdCIsImN3ZCJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOztBQUNBOztBQUNBOzs7O0FBRUEsTUFBTUEsSUFBSSxHQUFHLG1CQUFVQyx1QkFBYUQsSUFBdkIsQ0FBYjtBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBQ0EsTUFBTUUsT0FBTyxHQUFHLE1BQU1DLFVBQU4sSUFBb0I7QUFDbEMsUUFBTUMsWUFBWSxHQUFHLHdCQUFZRCxVQUFaLENBQXJCOztBQUVBLE1BQUk7QUFDRiw2QkFBYUMsWUFBYjtBQUNELEdBRkQsQ0FFRSxPQUFPQyxDQUFQLEVBQVU7QUFDVixXQUFPQyxPQUFPLENBQUNDLE1BQVIsQ0FBZUYsQ0FBZixDQUFQO0FBQ0Q7O0FBRUQsU0FBT0wsSUFBSSxDQUFFLFVBQUYsRUFBYTtBQUFDUSxJQUFBQSxHQUFHLEVBQUVKO0FBQU4sR0FBYixDQUFYO0FBQ0QsQ0FWRDs7ZUFZZUYsTyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBwcm9taXNpZnkgZnJvbSAndXRpbC5wcm9taXNpZnknO1xuaW1wb3J0IGNoaWxkUHJvY2VzcyBmcm9tICdjaGlsZF9wcm9jZXNzJztcbmltcG9ydCB7dmFsaWRhdGVQYXRoLCByZXNvbHZlSG9tZX0gZnJvbSAnLi91dGlsJztcblxuY29uc3QgZXhlYyA9IHByb21pc2lmeShjaGlsZFByb2Nlc3MuZXhlYyk7XG5cbi8qKlxuICogUHVsbHMgYSByZXBvIGdpdmVuIGl0cyBwYXRoLlxuICpcbiAqIFJldHVybnMgdm9pZC4gVGhyb3dzIGVycm9yIG9uIGZhaWx1cmUuXG4gKi9cbmNvbnN0IGdpdFB1bGwgPSBhc3luYyBwYXRoVG9SZXBvID0+IHtcbiAgY29uc3QgcmVzb2x2ZWRQYXRoID0gcmVzb2x2ZUhvbWUocGF0aFRvUmVwbyk7XG5cbiAgdHJ5IHtcbiAgICB2YWxpZGF0ZVBhdGgocmVzb2x2ZWRQYXRoKTtcbiAgfSBjYXRjaCAoZSkge1xuICAgIHJldHVybiBQcm9taXNlLnJlamVjdChlKTtcbiAgfVxuXG4gIHJldHVybiBleGVjKGBnaXQgcHVsbGAsIHtjd2Q6IHJlc29sdmVkUGF0aH0pO1xufTtcblxuZXhwb3J0IGRlZmF1bHQgZ2l0UHVsbDtcbiJdfQ==