"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "checkoutCommit", {
  enumerable: true,
  get: function () {
    return _checkout_commit.default;
  }
});
Object.defineProperty(exports, "gitPull", {
  enumerable: true,
  get: function () {
    return _git_pull.default;
  }
});
Object.defineProperty(exports, "gitDiff", {
  enumerable: true,
  get: function () {
    return _git_diff.default;
  }
});
exports.gitToJs = void 0;

var _util = require("./util");

var _checkout_commit = _interopRequireDefault(require("./checkout_commit"));

var _git_pull = _interopRequireDefault(require("./git_pull"));

var _git_diff = _interopRequireDefault(require("./git_diff"));

var _parse_git_log = _interopRequireDefault(require("./parse_git_log"));

var _git_log_stream = _interopRequireDefault(require("./git_log_stream"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const gitToJs = (repoPath, options = {}) => {
  const resolvedPath = (0, _util.resolveHome)(repoPath);

  try {
    (0, _util.validatePath)(resolvedPath);
  } catch (e) {
    return Promise.reject(e);
  }

  const {
    stream,
    addErrorHandler
  } = (0, _git_log_stream.default)(resolvedPath, options);
  return new Promise((resolve, reject) => {
    addErrorHandler(reject);
    (0, _parse_git_log.default)(stream).then(resolve);
  });
};

exports.gitToJs = gitToJs;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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