"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _git_log_format_markers = require("./constants/git_log_format_markers");

var _parse_commit = _interopRequireDefault(require("./parse_commit"));

var _byline = _interopRequireDefault(require("byline"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const parseGitLog = stream => {
  return new Promise((resolve, reject) => {
    let buffer = [];
    const parsedCommits = [];
    const streamByLine = (0, _byline.default)(stream);
    const commitPattern = _git_log_format_markers.gitLogCommitMarker;
    streamByLine.on('data', line => {
      const lineString = line.toString();

      if (lineString.match(commitPattern)) {
        if (buffer.length) {
          parsedCommits.push((0, _parse_commit.default)(buffer));
          buffer = [];
        }
      } else {
        buffer.push(lineString);
      }
    });
    streamByLine.on('error', e => {
      reject(e);
    });
    streamByLine.on('end', () => {
      if (buffer.length) {
        parsedCommits.push((0, _parse_commit.default)(buffer));
      }

      resolve(parsedCommits);
    });
  });
};

var _default = parseGitLog;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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