// [VexFlow](http://vexflow.com) - Copyright (c) Mohit Muthanna 2010.

import { Vex } from './vex';
import { Flow } from './tables';
import { Element } from './element';
import { Fraction } from './fraction';
import { Renderer } from './renderer';
import { Formatter } from './formatter';
import { Music } from './music';
import { Glyph } from './glyph';
import { Stave } from './stave';
import { StaveNote } from './stavenote';
import { StaveModifier } from './stavemodifier';
import { Voice } from './voice';
import { Accidental } from './accidental';
import { Beam } from './beam';
import { StaveTie } from './stavetie';
import { TabStave } from './tabstave';
import { TabNote } from './tabnote';
import { Bend } from './bend';
import { Vibrato } from './vibrato';
import { VibratoBracket } from './vibratobracket';
import { Note } from './note';
import { ModifierContext } from './modifiercontext';
import { TickContext } from './tickcontext';
import { Articulation } from './articulation';
import { Annotation } from './annotation';
import { Barline } from './stavebarline';
import { NoteHead } from './notehead';
import { StaveConnector } from './staveconnector';
import { ClefNote } from './clefnote';
import { KeySignature } from './keysignature';
import { TimeSignature } from './timesignature';
import { TimeSigNote } from './timesignote';
import { Stem } from './stem';
import { TabTie } from './tabtie';
import { Clef } from './clef';
import { Modifier } from './modifier';
import { TabSlide } from './tabslide';
import { Tuplet } from './tuplet';
import { GraceNote } from './gracenote';
import { GraceTabNote } from './gracetabnote';
import { Tuning } from './tuning';
import { KeyManager } from './keymanager';
import { StaveHairpin } from './stavehairpin';
import { BoundingBox } from './boundingbox';
import { Stroke } from './strokes';
import { TextNote } from './textnote';
import { Curve } from './curve';
import { TextDynamics } from './textdynamics';
import { StaveLine } from './staveline';
import { Ornament } from './ornament';
import { PedalMarking } from './pedalmarking';
import { TextBracket } from './textbracket';
import { FretHandFinger } from './frethandfinger';
import { Repetition } from './staverepetition';
import { BarNote } from './barnote';
import { GhostNote } from './ghostnote';
import { NoteSubGroup } from './notesubgroup';
import { GraceNoteGroup } from './gracenotegroup';
import { Tremolo } from './tremolo';
import { StringNumber } from './stringnumber';
import { Crescendo } from './crescendo';
import { Volta } from './stavevolta';
import { Font } from './fonts/vexflow_font';
import { System } from './system';
import { Factory } from './factory';
import { Parser } from './parser';
import { EasyScore } from './easyscore';
import { Registry } from './registry';

Vex.Flow = Flow;
Vex.Flow.Element = Element;
Vex.Flow.Fraction = Fraction;
Vex.Flow.Renderer = Renderer;
Vex.Flow.Formatter = Formatter;
Vex.Flow.Music = Music;
Vex.Flow.Glyph = Glyph;
Vex.Flow.Stave = Stave;
Vex.Flow.StaveNote = StaveNote;
Vex.Flow.StaveModifier = StaveModifier;
Vex.Flow.Voice = Voice;
Vex.Flow.Accidental = Accidental;
Vex.Flow.Beam = Beam;
Vex.Flow.StaveTie = StaveTie;
Vex.Flow.TabStave = TabStave;
Vex.Flow.TabNote = TabNote;
Vex.Flow.Bend = Bend;
Vex.Flow.Vibrato = Vibrato;
Vex.Flow.VibratoBracket = VibratoBracket;
Vex.Flow.Note = Note;
Vex.Flow.ModifierContext = ModifierContext;
Vex.Flow.TickContext = TickContext;
Vex.Flow.Articulation = Articulation;
Vex.Flow.Annotation = Annotation;
Vex.Flow.Barline = Barline;
Vex.Flow.NoteHead = NoteHead;
Vex.Flow.StaveConnector = StaveConnector;
Vex.Flow.ClefNote = ClefNote;
Vex.Flow.KeySignature = KeySignature;
Vex.Flow.TimeSignature = TimeSignature;
Vex.Flow.TimeSigNote = TimeSigNote;
Vex.Flow.Stem = Stem;
Vex.Flow.TabTie = TabTie;
Vex.Flow.Clef = Clef;
Vex.Flow.Modifier = Modifier;
Vex.Flow.TabSlide = TabSlide;
Vex.Flow.Tuplet = Tuplet;
Vex.Flow.GraceNote = GraceNote;
Vex.Flow.GraceTabNote = GraceTabNote;
Vex.Flow.Tuning = Tuning;
Vex.Flow.KeyManager = KeyManager;
Vex.Flow.StaveHairpin = StaveHairpin;
Vex.Flow.BoundingBox = BoundingBox;
Vex.Flow.Stroke = Stroke;
Vex.Flow.TextNote = TextNote;
Vex.Flow.Curve = Curve;
Vex.Flow.TextDynamics = TextDynamics;
Vex.Flow.StaveLine = StaveLine;
Vex.Flow.Ornament = Ornament;
Vex.Flow.PedalMarking = PedalMarking;
Vex.Flow.TextBracket = TextBracket;
Vex.Flow.FretHandFinger = FretHandFinger;
Vex.Flow.Repetition = Repetition;
Vex.Flow.BarNote = BarNote;
Vex.Flow.GhostNote = GhostNote;
Vex.Flow.NoteSubGroup = NoteSubGroup;
Vex.Flow.GraceNoteGroup = GraceNoteGroup;
Vex.Flow.Tremolo = Tremolo;
Vex.Flow.StringNumber = StringNumber;
Vex.Flow.Crescendo = Crescendo;
Vex.Flow.Volta = Volta;
Vex.Flow.Font = Font;
Vex.Flow.System = System;
Vex.Flow.Factory = Factory;
Vex.Flow.Parser = Parser;
Vex.Flow.EasyScore = EasyScore;
Vex.Flow.Registry = Registry;

export default Vex;
