---
layout: docs
title: Colours
description: You can customise your app’s colour scheme to match your brand colours. Alternatively, you can create an entirely new colour scheme using the Material Design colour palette.
group: material
toc: true
---

Please visit [theming]({{ site.baseurl }}/docs/{{ site.docs_version }}/getting-started/theming/#theme-colours) for detailed information about all Material Design colours and how to customise theme colours.

## Colour scheme

In Material Design, a primary colour refers to a colour that appears most frequently in your app. A secondary colour refers to a colour used to accent key parts of your UI.

### Primary colour

A primary colour is the colour displayed most frequently across your app’s screens and components. To create contrast between elements, you can use lighter or darker tones of your primary colour. The contrast between lighter and darker tones helps show division.

<div class="row">
  <div class="col-md-6 mb-4">
    <div class="bg-primary p-3 text-white-primary">
      <p class="mb-5">
        <strong>Primary</strong>
      </p>
      <div class="d-flex justify-content-between">
        <span class="doc-swatch-text">.bg-primary</span>
        <span class="doc-swatch-text">#9c27b0</span>
      </div>
    </div>
    <div class="bg-primary-dark d-flex justify-content-between p-3 text-white-primary">
      <span class="doc-swatch-text">.bg-primary-dark</span>
      <span class="doc-swatch-text">#7b1fa2</span>
    </div>
    <div class="bg-primary-light d-flex justify-content-between p-3 text-dark-primary">
      <span class="doc-swatch-text">.bg-primary-light</span>
      <span class="doc-swatch-text">#e1bee7</span>
    </div>
  </div>
</div>

### Secondary colour

A secondary colour is used to accent select parts of your UI. It can be analogous or complementary to your primary colour, but it should not simply be a light or dark variation of your primary colour. It should contrast with elements that surround it and be applied sparingly as an accent.

Secondary colours are best used for:

- Buttons and floating action buttons
- Headlines
- Links
- Progress bars
- Selection controls and sliders
- Text fields and text selection

<div class="row">
  <div class="col-md-6 mb-4">
    <div class="bg-secondary p-3 text-white-primary">
      <p class="mb-5">
        <strong>Secondary</strong>
      </p>
      <div class="d-flex justify-content-between">
        <span class="doc-swatch-text">.bg-secondary</span>
        <span class="doc-swatch-text">#ff4081</span>
      </div>
    </div>
    <div class="bg-secondary-dark d-flex justify-content-between p-3 text-white-primary">
      <span class="doc-swatch-text">.bg-secondary-dark</span>
      <span class="doc-swatch-text">#f50057</span>
    </div>
    <div class="bg-secondary-light d-flex justify-content-between p-3 text-dark-primary">
      <span class="doc-swatch-text">.bg-secondary-light</span>
      <span class="doc-swatch-text">#ff80ab</span>
    </div>
  </div>
</div>

## Dark and light theme

Themes let you apply a consistent tone to an app. The theme specifies the darkness of elements. To promote greater consistency between apps, dark and light themes are available to choose from.

<div class="row">
  <div class="col-md-6 mb-4">
    <div class="bg-dark-1 d-flex justify-content-between p-3 text-white-primary">
      <span class="doc-swatch-text">.bg-dark-1</span>
      <span class="doc-swatch-text">#000000</span>
    </div>
    <div class="bg-dark-2 d-flex justify-content-between p-3 text-white-primary">
      <span class="doc-swatch-text">.bg-dark-2</span>
      <span class="doc-swatch-text">#212121</span>
    </div>
    <div class="bg-dark-3 d-flex justify-content-between p-3 text-white-primary">
      <span class="doc-swatch-text">.bg-dark-3</span>
      <span class="doc-swatch-text">#303030</span>
    </div>
    <div class="bg-dark-4 d-flex justify-content-between p-3 text-white-primary">
      <span class="doc-swatch-text">.bg-dark-4</span>
      <span class="doc-swatch-text">#424242</span>
    </div>
  </div>
  <div class="col-md-6 mb-4">
    <div class="bg-light-1 d-flex justify-content-between p-3 text-black-primary">
      <span class="doc-swatch-text">.bg-light-1</span>
      <span class="doc-swatch-text">#e0e0e0</span>
    </div>
    <div class="bg-light-2 d-flex justify-content-between p-3 text-black-primary">
      <span class="doc-swatch-text">.bg-light-2</span>
      <span class="doc-swatch-text">#f5f5f5</span>
    </div>
    <div class="bg-light-3 d-flex justify-content-between p-3 text-black-primary">
      <span class="doc-swatch-text">.bg-light-3</span>
      <span class="doc-swatch-text">#fafafa</span>
    </div>
    <div class="bg-light-4 d-flex justify-content-between p-3 text-black-primary">
      <span class="doc-swatch-text">.bg-light-4</span>
      <span class="doc-swatch-text">#ffffff</span>
    </div>
  </div>
</div>