# Victory Release Roadmap

Release schedule for the Victory ecosystem. Subject to change and reprioritization.

## Feature requests

We'd love :heart: to hear what you think we should build! First, please [search for an existing issue](https://github.com/FormidableLabs/victory/issues) with your feature request, and `+1` it. If nobody has suggested it yet, please [create a new issue](https://github.com/FormidableLabs/victory/issues/new?labels=enhancement)!

## Releases

### Alpha

Released: December 2015 ([`v0.1.0`](https://github.com/FormidableLabs/victory/releases/tag/v0.1.0))

- [victory-animation](https://github.com/FormidableLabs/victory-animation)
- [victory-axis](https://github.com/FormidableLabs/victory-axis)
- [victory-bar](https://github.com/FormidableLabs/victory-bar)
- [victory-chart](https://github.com/FormidableLabs/victory-chart)
- [victory-label](https://github.com/FormidableLabs/victory-label)
- [victory-line](https://github.com/FormidableLabs/victory-line)
- [victory-pie](https://github.com/FormidableLabs/victory-pie)
- [victory-scatter](https://github.com/FormidableLabs/victory-scatter)
- Basic code coverage across all Victory components (#37)

### Alpha 2
Expected release: End of February 2016
- Code reorganization and infrastructure improvements
- [Perf improvements](https://github.com/FormidableLabs/victory/issues/141)
- [Enhancements for victory-label](https://github.com/FormidableLabs/victory-label/issues/35)
- [victory-area](https://github.com/FormidableLabs/victory/issues/40)
- [Support data accessor functions](https://github.com/FormidableLabs/victory/issues/84)
- Interactivity support with data callbacks via an event object
- [Support for custom label components](https://github.com/FormidableLabs/victory-chart/issues/100)
- 75% code coverage across all Victory components

### Alpha 3
Expected release: End of March 2016
- VictoryStack and VictoryGroup component wrappers
- Customizable enter and exit transitions with sensible defaults for VictoryArea,
  VictoryBar, VictoryLine, VictoryPie, and VictoryScatter.
- All rendered components are responsive by default
- Custom data component support for VictoryArea, VictoryBar, VictoryLine, VictoryPie,
  and VictoryScatter.
- Enter and Exit transitions

### Alpha 4
Expected release: End of May 2016
- Shared events between components
- Support for wrapped components
- Proof of concept for React Native support

### Alpha 5
Expected release: End of June 2016
- Above 90% code coverage for all Victory components
- VictoryTooltip
- Automatic enter transition on animating components
- Support for themes
- Fleshed out React Native support

