var tape = require("tape"),
    geometric = require("../");

tape("polygonRegular() returns the expected default", function(test) {
  var p = geometric.polygonRegular();
  
  test.deepEqual(p, [[0, 0], [15.196713713031848, 0], [7.598356856515927, -13.160740129524923]]);
  test.end();
});

tape("polygonRegular() returns some regular polygons", function(test){
  const p3 = geometric.polygonRegular(3, 1000, [100, 100]);
  test.deepEqual(p3, [[75.97188585865246, 113.87263816762606], [124.02811414134754, 113.87263816762606], [100, 72.2547236647479]]);

  const p4 = geometric.polygonRegular(4, 1000, [100, 100]);
  test.deepEqual(p4, [[84.18861169915812, 115.81138830084188], [115.81138830084191, 115.81138830084188], [115.81138830084191, 84.18861169915809], [84.18861169915812, 84.18861169915809]]);

  const p100 = geometric.polygonRegular(100, 200000, [5000, 2000]);
  test.deepEqual(p100, [[4992.0720411147195, 2252.271742189941], [5007.927958885281, 2252.271742189941], [5023.752588624062, 2251.276140875513], [5039.48347774707, 2249.2888674301994], [5055.058543621695, 2246.3177647143884], [5070.416318578501, 2242.374558313132], [5085.4961924960335, 2237.474810260617], [5100.23865200128, 2231.637857623924], [5114.585515341761, 2224.88673618846], [5128.48016200233, 2217.248089546237], [5141.867756160478, 2208.752063945787], [5154.695463098275, 2199.432189318689], [5166.912657716856, 2189.3252469522504], [5178.471124330569, 2178.471124330569], [5189.32524695225, 2166.912657716856], [5199.432189318689, 2154.6954630982746], [5208.752063945787, 2141.867756160478], [5217.248089546238, 2128.4801620023295], [5224.88673618846, 2114.58551534176], [5231.637857623924, 2100.2386520012797], [5237.474810260617, 2085.496192496034], [5242.374558313132, 2070.416318578501], [5246.317764714388, 2055.0585436216948], [5249.288867430199, 2039.4834777470699], [5251.276140875513, 2023.7525886240624], [5252.2717421899415, 2007.927958885281], [5252.2717421899415, 1992.0720411147195], [5251.276140875513, 1976.2474113759383], [5249.288867430199, 1960.5165222529308], [5246.317764714388, 1944.9414563783057], [5242.374558313132, 1929.5836814214995], [5237.474810260617, 1914.503807503967], [5231.637857623924, 1899.7613479987212], [5224.88673618846, 1885.4144846582403], [5217.248089546238, 1871.519837997671], [5208.752063945787, 1858.1322438395223], [5199.432189318689, 1845.3045369017261], [5189.32524695225, 1833.0873422831446], [5178.471124330569, 1821.5288756694315], [5166.912657716856, 1810.6747530477503], [5154.695463098275, 1800.5678106813118], [5141.867756160478, 1791.2479360542136], [5128.48016200233, 1782.751910453763], [5114.585515341761, 1775.1132638115403], [5100.23865200128, 1768.3621423760765], [5085.496192496034, 1762.5251897393834], [5070.416318578501, 1757.6254416868683], [5055.058543621695, 1753.682235285612], [5039.4834777470705, 1750.711132569801], [5023.752588624063, 1748.7238591244868], [5007.927958885281, 1747.728257810059], [4992.0720411147195, 1747.728257810059], [4976.247411375939, 1748.7238591244866], [4960.516522252931, 1750.7111325698006], [4944.941456378306, 1753.6822352856116], [4929.5836814215, 1757.6254416868678], [4914.503807503967, 1762.525189739383], [4899.761347998721, 1768.362142376076], [4885.41448465824, 1775.1132638115396], [4871.519837997671, 1782.7519104537623], [4858.132243839523, 1791.2479360542127], [4845.304536901726, 1800.567810681311], [4833.087342283145, 1810.6747530477492], [4821.528875669432, 1821.5288756694304], [4810.6747530477505, 1833.0873422831432], [4800.567810681312, 1845.304536901725], [4791.247936054214, 1858.132243839521], [4782.751910453763, 1871.5198379976696], [4775.1132638115405, 1885.414484658239], [4768.362142376076, 1899.7613479987197], [4762.525189739384, 1914.5038075039654], [4757.625441686868, 1929.583681421498], [4753.682235285612, 1944.941456378304], [4750.711132569801, 1960.5165222529292], [4748.723859124487, 1976.2474113759367], [4747.7282578100585, 1992.0720411147179], [4747.7282578100585, 2007.9279588852794], [4748.723859124486, 2023.7525886240608], [4750.711132569801, 2039.4834777470683], [4753.682235285612, 2055.0585436216934], [4757.625441686868, 2070.4163185784996], [4762.525189739383, 2085.496192496032], [4768.362142376076, 2100.238652001278], [4775.11326381154, 2114.5855153417588], [4782.751910453762, 2128.480162002328], [4791.247936054213, 2141.867756160477], [4800.567810681311, 2154.6954630982727], [4810.67475304775, 2166.9126577168545], [4821.528875669431, 2178.4711243305674], [4833.087342283144, 2189.3252469522486], [4845.304536901725, 2199.432189318687], [4858.132243839521, 2208.7520639457853], [4871.51983799767, 2217.248089546236], [4885.414484658239, 2224.8867361884586], [4899.76134799872, 2231.637857623922], [4914.503807503966, 2237.474810260615], [4929.583681421499, 2242.3745583131304], [4944.941456378305, 2246.317764714386], [4960.5165222529295, 2249.288867430197], [4976.247411375937, 2251.2761408755114]]);

  test.end();
});