---
layout: post
title: Announcing Leaflet 1.0 beta 1
description: Leaflet 1.0 beta 1 released. It's the biggest Leaflet release ever, with tons of improvements and bugfixes. We're starting a short beta release cycle, and need your help testing the release.
author: Vladimir Agafonkin
authorsite: http://agafonkin.com/en
---

Over the past year, we set out on an ambitious quest to implement pretty much all the features Leaflet users have been asking for years, while heavily focusing on performance, code cleanup and stabilizing the API. It was an extremely challenging road with many bumps, but now we're finally approaching the finish line.

Today, I'm happy and proud to announce the release of *Leaflet 1.0 beta 1*, our first formal release after more than a year of work and a thousand commits by 36 contributors.

### What's new

1.0 will be the best Leaflet release ever, bringing a _huge_ amount of improvements and bugfixes. Highlights of the release include:

- _huge_ performance improvements, especially for vector layers
- flyover animations (zooming and panning in a curve with `map.flyTo`)
- fractional zoom level support (`map.setZoom(12.34)`)
- much nicer tile loading with less flickering
- custom pane management (including multiple vector layer panes)
- better support for non-standard projections
- more accessibility features
- lots of bugfixes and stability improvements

A much more detailed list of changes can be found [in the changelog](https://github.com/Leaflet/Leaflet/blob/main/CHANGELOG.md) (beware, it's a long read).

![](https://camo.githubusercontent.com/07c492b230f1a3762118eaf457f0cc182fb0a98d/68747470733a2f2f662e636c6f75642e6769746875622e636f6d2f6173736574732f32353339352f313936353934392f32613934343166342d383263312d313165332d393836372d6230343033663266643966372e676966)

### Beta cycle and upgrading

The release sports a number of minor breaking API changes, and some of the plugins will have to be updated. To make the upgrade less painful, we're doing a short beta cycle before the final 1.0 to allow users and plugin developers to catch up to the changes while we find and fix remaining issues.

A lot of effort since the last stable release has been put into refactoring. Many changes that we made are not visible to users, but make the source code much simpler and easier to understand and also open up many new possibilities for our wonderful community of plugin developers. Basically, half of Leaflet code was fully rewritten under the hood, and now the codebase is ready for some pretty extreme extensions (who just said "rotation" and "WebGL"?).

We plan to write a comprehensive 1.0 upgrade guide before the release. Meanwhile, if something breaks after you upgrade to 1.0-beta, please look through the changelog. If you can't find the corresponding breaking change, please file a GitHub issue.

The API reference for 1.0 is temporarily [available here](http://mourner.github.io/Leaflet/reference.html). It's built from Leaflet `gh-pages-master` branch &mdash; fixes and additions are welcome!

### Get the new release

Test out the new release on your app, and help us catch remaining issues to bring the final 1.0 close to perfection!

You can use our CDN:

    <link rel="stylesheet" href="http://cdn.leafletjs.com/leaflet-1.0.0-b1/leaflet.css" />
    <script src="http://cdn.leafletjs.com/leaflet-1.0.0-b1/leaflet.js"></script>

The release is also available through NPM, Bower, and [GitHub download](https://github.com/Leaflet/Leaflet/archive/v1.0.0-beta.1.zip).

### Thank you

I'm incredibly thankful to everyone who made this release possible &mdash; by using the library, spreading the word about it, reporting issues and sending your contributions. Your help is invaluable!

Special thanks to [Iván Sánchez](https://github.com/IvanSanchez), [Yohan Boniface](https://github.com/yohanboniface), [John Firebaugh](https://github.com/jfirebaugh), [Dave Leaver](https://github.com/danzel), [Patrick Arlt](https://github.com/patrickarlt), [Per Liedman](https://github.com/perliedman), [Jake Wilson](https://github.com/Jakobud) and [Steve Kashishian](https://github.com/snkashis) for lots of amazing contributions and support throughout the last year. All these people are now a part of the core Leaflet team. Keep'em coming!

![](https://www.reactiongifs.com/r/msy.gif)

Love,<br />
Vladimir.
