---
layout: post
title: Meet Leaflet 1.0.
description: Today marks the final release of Leaflet 1.0. It's a culmination of several years of work and the fastest, most stable and polished Leaflet release ever.
author: Vladimir Agafonkin
authorsite: http://agafonkin.com/en
---

<img alt="This is totally not making fun of the announcements by a company with a fruit logo." src="https://cloud.githubusercontent.com/assets/25395/18873565/c4856f70-84c8-11e6-82b1-48992fc5afe8.png" width="800" />

Today marks the final release of Leaflet 1.0. It's a culmination of several years of work by dozens of contributors from all over the world. This is the fastest, most stable and polished Leaflet release ever.

[The changelog](https://github.com/Leaflet/Leaflet/blob/main/CHANGELOG.md) contains _over 400 changes_ compared to the previous stable, v0.7.7. The highlights include:

- Huge performance improvements in all aspects of the library and vector layers in particular.
- New `L.Tooltip` class for all your dynamic labeling needs.
- Flyover animations (zooming and panning in a curve with `map.flyTo`).
- Fractional zoom level support (`map.setZoom(12.34)`).
- Much better tile loading algorithm with less flickering.
- Custom pane management (including multiple vector layer panes and interleaving vectors and tile layers).
- Better support for non-standard projections.
- More accessibility features.
- Vastly improved documentation.
- _Tons_ of bugfixes and stability improvements.

This release wouldn't be possible without such an amazing, diverse, loving community. We're incredibly proud to be a part of it. Thank you very much for your kind support!

### New release cycle

This release is a way overdue and has taken too long. In part this can be attributed to our initial ambition for 1.0 that required rewriting many parts of the library almost from scratch, in part due to perfectionism (some of the beta/rc releases were already more stable than our last stable release), and in part because we underestimated the cost of introducing big breaking changes in a library used by thousands of developers.

Starting with 1.0, we're switching to a fast release cycle, where a new version will come out every 2–4 weeks. We'll also prefer many small, incremental changes (with releases in between) over ambitious rewriting quests.

### What's next?

In addition to supporting the new release with fixes and improvements, the following areas will now get our close attention:

- A cleaner, more stable plugin ecosystem. We want to make sure that all popular plugins work well with the latest release and are maintained. We'll revise our plugin list page, tighten our review process, take more key plugins under the wing of the Leaflet organization on GitHub and spend more time working on them.
- Tutorials and examples to cover more advanced features of the library, its popular plugins, and integrations with libraries like D3 and React/Angular.
- Explore switching to a more modern JavaScript flavor and module system (ES6, Babel, Rollup).
- Map rotation support.

Please help us test this new release, make sure it works with your favorite plugins, get involved in discussions on GitHub, and don't forget we're always looking for [new contributors](https://github.com/Leaflet/Leaflet/blob/main/CONTRIBUTING.md)!

And of course, let's celebrate!

Love,<br>
The Leaflet team.

![](https://www.reactiongifs.com/wp-content/uploads/2013/06/umad.gif)
